import { r as n, j as e, c as b } from "./app-ISxEiS1S.js";
import k from "./AdminLayout-XOYPXGkG.js";
import "./app-DEV1gfeS.js";
import "./ChangePasswordModal-BWoRzeQs.js";
const _ = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-blue-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z",
      }),
    }),
  L = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-blue-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.828 14.828a4 4 0 01-5.656 0M9 10h1m4 0h1m-6 4h.01M16 14h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z",
      }),
    }),
  M = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-emerald-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13 7h8m0 0v8m0-8l-8 8-4-4-6 6",
      }),
    }),
  C = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-green-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10",
      }),
    }),
  B = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-red-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12",
      }),
    }),
  I = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-cyan-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z",
      }),
    }),
  A = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-yellow-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z",
      }),
    }),
  p = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-6 w-6 text-blue-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.828 14.828a4 4 0 01-5.656 0M9 10h1m4 0h1m-6 4h.01M16 14h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z",
      }),
    }),
  S = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-6 w-6 text-purple-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z",
      }),
    }),
  T = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-6 w-6 text-orange-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z",
      }),
    }),
  W = () =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "h-8 w-8 text-purple-400",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 6l3 1m0 0l-3 9a5.002 5.002 0 006.001 0M6 7l3 9M6 7l6-2m6 2l3-1m-3 1l-3 9a5.002 5.002 0 006.001 0M18 7l3 9m-3-9l-6-2m0-2v2m0 16V5m0 16H9m3 0h3",
      }),
    }),
  z = ({ className: r = "h-4 w-4" }) =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: `${r} text-green-400`,
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7 17l9.2-9.2M17 17V7m0 10H7",
      }),
    }),
  P = ({ className: r = "h-4 w-4" }) =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: `${r} text-red-400`,
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17 7l-9.2 9.2M7 7v10m0-10h10",
      }),
    }),
  j = ({ className: r = "h-4 w-4" }) =>
    e.jsx("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: `${r} text-gray-400`,
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor",
      strokeWidth: 2,
      children: e.jsx("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5 12h14",
      }),
    });
function U({ stats: r = {} }) {
  const a = (s) =>
      new Intl.NumberFormat("pt-BR", {
        style: "currency",
        currency: "BRL",
      }).format(s || 0),
    i = (s) => `${(s || 0).toFixed(1)}%`,
    h = (s, l) => {
      if (!l || l === 0)
        return { text: "N/A", color: "text-gray-400", icon: e.jsx(j, {}) };
      const c = ((s - l) / l) * 100;
      return c > 0
        ? {
            text: `+${c.toFixed(1)}%`,
            color: "text-green-400",
            icon: e.jsx(z, {}),
          }
        : c < 0
        ? {
            text: `${c.toFixed(1)}%`,
            color: "text-red-400",
            icon: e.jsx(P, {}),
          }
        : { text: "0%", color: "text-gray-400", icon: e.jsx(j, {}) };
    },
    t = {
      total_users: 0,
      real_users: 0,
      demo_users: 0,
      total_deposits: 0,
      total_withdrawals: 0,
      active_players: 0,
      today_losses: 0,
      yesterday_losses: 0,
      house_edge: 0,
      win_rate: 0,
      player_win_rate: 0,
      total_bets: 0,
      total_wins: 0,
      total_games: 0,
      this_week_revenue: 0,
      last_week_revenue: 0,
      house_revenue: 0,
      ...r,
    },
    d = h(t.this_week_revenue, t.last_week_revenue),
    o = h(t.today_losses, t.yesterday_losses),
    [u, N] = n.useState([]),
    [R, v] = n.useState(null),
    [x, f] = n.useState({ total: 0, active: 0 }),
    m = n.useRef(null),
    g = async () => {
      try {
        const s = await b.get(route("tenant.admin.live-games"));
        s.data &&
          (console.log("Live games response:", s.data),
          N(s.data.games),
          v(s.data.timestamp),
          f({
            total: s.data.total_games || s.data.games.length,
            active:
              s.data.active_games ||
              s.data.games.filter((l) => l.status === "playing").length,
          }));
      } catch (s) {
        console.error("Erro ao buscar partidas ao vivo:", s);
      }
    };
  n.useEffect(
    () => (
      g(),
      (m.current = setInterval(g, 2e3)),
      () => {
        m.current && clearInterval(m.current);
      }
    ),
    []
  );
  const w = (s) =>
      s.status === "playing"
        ? e.jsxs("span", {
            className:
              "inline-flex items-center px-2 py-1 bg-green-400/20 text-green-400 rounded-full text-xs font-medium",
            children: [
              e.jsx("div", {
                className:
                  "w-1.5 h-1.5 bg-green-400 rounded-full mr-1 animate-pulse",
              }),
              "AO VIVO",
            ],
          })
        : s.status === "finished"
        ? s.win > s.amount
          ? e.jsx("span", {
              className:
                "px-2 py-1 bg-green-400/20 text-green-400 rounded-full text-xs font-medium",
              children: "GANHOU",
            })
          : e.jsx("span", {
              className:
                "px-2 py-1 bg-red-400/20 text-red-400 rounded-full text-xs font-medium",
              children: "PERDEU",
            })
        : e.jsx("span", {
            className:
              "px-2 py-1 bg-gray-400/20 text-gray-400 rounded-full text-xs font-medium",
            children: "CANCELADO",
          }),
    y = (s) => {
      switch (s) {
        case "high":
          return "text-green-400";
        case "medium":
          return "text-yellow-400";
        case "low":
          return "text-red-400";
        default:
          return "text-blue-400";
      }
    };
  return e.jsxs(k, {
    title: "Dashboard",
    children: [
      e.jsxs("div", {
        className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8",
        children: [
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(_, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Total de Usuários",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-white mt-2",
                    children: t.total_users.toLocaleString(),
                  }),
                  e.jsxs("div", {
                    className: "flex items-center space-x-4 mt-2 text-sm",
                    children: [
                      e.jsxs("span", {
                        className: "text-green-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-green-400 mr-1",
                          }),
                          "Real: ",
                          t.real_users,
                        ],
                      }),
                      e.jsxs("span", {
                        className: "text-yellow-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className:
                              "w-2 h-2 rounded-full bg-yellow-400 mr-1",
                          }),
                          "Demo: ",
                          t.demo_users,
                        ],
                      }),
                    ],
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(L, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Jogadores Ativos",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-blue-400 mt-2",
                    children: t.active_players,
                  }),
                  e.jsxs("p", {
                    className: "text-xs text-gray-500 mt-1 flex items-center",
                    children: [
                      e.jsx("div", {
                        className:
                          "w-2 h-2 rounded-full bg-blue-400 mr-1 animate-pulse",
                      }),
                      "Jogando agora",
                    ],
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(M, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Perdas Hoje",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-green-400 mt-2",
                    children: a(t.today_losses),
                  }),
                  e.jsxs("div", {
                    className: "flex items-center mt-1",
                    children: [
                      e.jsx("span", {
                        className: "text-xs text-gray-500",
                        children: "vs ontem: ",
                      }),
                      e.jsxs("div", {
                        className: "flex items-center ml-1",
                        children: [
                          o.icon,
                          e.jsx("span", {
                            className: `text-xs ml-1 ${o.color}`,
                            children: o.text,
                          }),
                        ],
                      }),
                    ],
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(W, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Margem da Casa",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-purple-400 mt-2",
                    children: i(t.house_edge),
                  }),
                  e.jsx("p", {
                    className: "text-xs text-gray-500 mt-1",
                    children: "Todos os tempos",
                  }),
                ],
              }),
            }),
          }),
        ],
      }),
      e.jsxs("div", {
        className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8",
        children: [
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(C, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Total Depósitos",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-green-400 mt-2",
                    children: a(t.total_deposits),
                  }),
                  e.jsx("p", {
                    className: "text-xs text-gray-500 mt-1",
                    children: "Apenas contas reais",
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(B, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Total Saques",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-red-400 mt-2",
                    children: a(t.total_withdrawals),
                  }),
                  e.jsx("p", {
                    className: "text-xs text-gray-500 mt-1",
                    children: "Apenas contas reais",
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(I, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Receita Semanal",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: "text-3xl font-bold text-cyan-400 mt-2",
                    children: a(t.this_week_revenue),
                  }),
                  e.jsxs("div", {
                    className: "flex items-center mt-1",
                    children: [
                      e.jsx("span", {
                        className: "text-xs text-gray-500",
                        children: "vs semana passada: ",
                      }),
                      e.jsxs("div", {
                        className: "flex items-center ml-1",
                        children: [
                          d.icon,
                          e.jsx("span", {
                            className: `text-xs ml-1 ${d.color}`,
                            children: d.text,
                          }),
                        ],
                      }),
                    ],
                  }),
                ],
              }),
            }),
          }),
          e.jsx("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: e.jsx("div", {
              className: "flex items-center justify-between",
              children: e.jsxs("div", {
                className: "flex-1",
                children: [
                  e.jsxs("div", {
                    className: "flex items-center",
                    children: [
                      e.jsx(A, {}),
                      e.jsx("h3", {
                        className: "text-lg font-semibold text-gray-400 ml-3",
                        children: "Saldo Líquido",
                      }),
                    ],
                  }),
                  e.jsx("p", {
                    className: `text-3xl font-bold mt-2 ${
                      t.total_deposits - t.total_withdrawals >= 0
                        ? "text-green-400"
                        : "text-red-400"
                    }`,
                    children: a(t.total_deposits - t.total_withdrawals),
                  }),
                  e.jsx("p", {
                    className: "text-xs text-gray-500 mt-1",
                    children: "Depósitos - Saques",
                  }),
                ],
              }),
            }),
          }),
        ],
      }),
      e.jsxs("div", {
        className: "grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8",
        children: [
          e.jsxs("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: [
              e.jsxs("div", {
                className: "flex items-center mb-4",
                children: [
                  e.jsx(p, {}),
                  e.jsx("h3", {
                    className: "text-lg font-semibold text-white ml-2",
                    children: "Estatísticas de Jogo",
                  }),
                ],
              }),
              e.jsxs("div", {
                className: "space-y-4",
                children: [
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-blue-400 mr-2",
                          }),
                          "Total de Jogos",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-white font-semibold",
                        children: t.total_games.toLocaleString(),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-green-400 mr-2",
                          }),
                          "Taxa de Vitória (Casa)",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-green-400 font-semibold",
                        children: i(t.win_rate),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-red-400 mr-2",
                          }),
                          "Taxa de Vitória (Jogadores)",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-red-400 font-semibold",
                        children: i(t.player_win_rate),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "border-t border-gray-700 pt-3",
                    children: [
                      e.jsxs("div", {
                        className: "flex justify-between items-center",
                        children: [
                          e.jsx("span", {
                            className: "text-gray-400",
                            children: "Total Apostado",
                          }),
                          e.jsx("span", {
                            className: "text-white font-semibold",
                            children: a(t.total_bets),
                          }),
                        ],
                      }),
                      e.jsxs("div", {
                        className: "flex justify-between items-center mt-2",
                        children: [
                          e.jsx("span", {
                            className: "text-gray-400",
                            children: "Total Pago (Prêmios)",
                          }),
                          e.jsx("span", {
                            className: "text-white font-semibold",
                            children: a(t.total_wins),
                          }),
                        ],
                      }),
                      e.jsxs("div", {
                        className: "flex justify-between items-center mt-2",
                        children: [
                          e.jsx("span", {
                            className: "text-gray-400",
                            children: "Lucro da Casa",
                          }),
                          e.jsx("span", {
                            className: "text-green-400 font-semibold",
                            children: a(t.house_revenue),
                          }),
                        ],
                      }),
                    ],
                  }),
                ],
              }),
            ],
          }),
          e.jsxs("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: [
              e.jsxs("div", {
                className: "flex items-center mb-4",
                children: [
                  e.jsx(S, {}),
                  e.jsx("h3", {
                    className: "text-lg font-semibold text-white ml-2",
                    children: "Resumo de Usuários",
                  }),
                ],
              }),
              e.jsxs("div", {
                className: "space-y-3",
                children: [
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-green-400 mr-2",
                          }),
                          "Contas Reais",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-white font-semibold",
                        children: t.real_users,
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className:
                              "w-2 h-2 rounded-full bg-yellow-400 mr-2",
                          }),
                          "Contas Demo",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-white font-semibold",
                        children: t.demo_users,
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className:
                              "w-2 h-2 rounded-full bg-blue-400 mr-2 animate-pulse",
                          }),
                          "Jogadores Ativos",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-blue-400 font-semibold",
                        children: t.active_players,
                      }),
                    ],
                  }),
                  e.jsx("div", {
                    className: "border-t border-gray-700 pt-2",
                    children: e.jsxs("div", {
                      className: "flex justify-between items-center",
                      children: [
                        e.jsx("span", {
                          className: "text-gray-300 font-medium",
                          children: "Total",
                        }),
                        e.jsx("span", {
                          className: "text-white font-bold",
                          children: t.total_users,
                        }),
                      ],
                    }),
                  }),
                ],
              }),
            ],
          }),
          e.jsxs("div", {
            className:
              "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200",
            children: [
              e.jsxs("div", {
                className: "flex items-center mb-4",
                children: [
                  e.jsx(T, {}),
                  e.jsx("h3", {
                    className: "text-lg font-semibold text-white ml-2",
                    children: "Perdas por Período",
                  }),
                ],
              }),
              e.jsxs("div", {
                className: "space-y-3",
                children: [
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-green-400 mr-2",
                          }),
                          "Hoje",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-green-400 font-semibold",
                        children: a(t.today_losses),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-gray-400 mr-2",
                          }),
                          "Ontem",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-gray-300 font-semibold",
                        children: a(t.yesterday_losses),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-cyan-400 mr-2",
                          }),
                          "Esta Semana",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-cyan-400 font-semibold",
                        children: a(t.this_week_revenue),
                      }),
                    ],
                  }),
                  e.jsxs("div", {
                    className: "flex justify-between items-center",
                    children: [
                      e.jsxs("span", {
                        className: "text-gray-400 flex items-center",
                        children: [
                          e.jsx("div", {
                            className: "w-2 h-2 rounded-full bg-gray-400 mr-2",
                          }),
                          "Semana Passada",
                        ],
                      }),
                      e.jsx("span", {
                        className: "text-gray-300 font-semibold",
                        children: a(t.last_week_revenue),
                      }),
                    ],
                  }),
                  e.jsx("div", {
                    className: "border-t border-gray-700 pt-2",
                    children: e.jsxs("div", {
                      className: "flex justify-between items-center",
                      children: [
                        e.jsx("span", {
                          className: "text-gray-300 font-medium",
                          children: "Margem Total",
                        }),
                        e.jsx("span", {
                          className: "text-purple-400 font-bold",
                          children: i(t.house_edge),
                        }),
                      ],
                    }),
                  }),
                ],
              }),
            ],
          }),
        ],
      }),
      e.jsxs("div", {
        className:
          "bg-gray-900/50 border border-gray-800/50 rounded-lg p-6 backdrop-blur-sm hover:bg-gray-900/60 transition-all duration-200 mb-8",
        children: [
          e.jsxs("div", {
            className: "flex items-center justify-between mb-6",
            children: [
              e.jsxs("div", {
                className: "flex items-center",
                children: [
                  e.jsx(p, {}),
                  e.jsx("h3", {
                    className: "text-xl font-semibold text-white ml-2",
                    children: "Partidas ao Vivo",
                  }),
                ],
              }),
              e.jsxs("div", {
                className: "flex items-center text-sm text-gray-400",
                children: [
                  e.jsx("div", {
                    className:
                      "w-2 h-2 bg-green-400 rounded-full mr-2 animate-pulse",
                  }),
                  "Atualizando automaticamente (",
                  x.active,
                  " ao vivo)",
                ],
              }),
            ],
          }),
          e.jsx("div", {
            className: "overflow-x-auto rounded-lg border border-gray-700",
            children: e.jsxs("table", {
              className: "min-w-full bg-gray-800/50",
              children: [
                e.jsx("thead", {
                  className: "bg-gray-800",
                  children: e.jsxs("tr", {
                    children: [
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-left text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "ID",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-left text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Jogador",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-right text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Aposta",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-right text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Ganho",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-center text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Status",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-center text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Baús",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-center text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Bônus",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-center text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "RTP",
                      }),
                      e.jsx("th", {
                        className:
                          "py-4 px-6 text-right text-xs font-medium text-gray-300 uppercase tracking-wider",
                        children: "Horário",
                      }),
                    ],
                  }),
                }),
                e.jsx("tbody", {
                  className: "divide-y divide-gray-700",
                  children: u.map((s) =>
                    e.jsxs(
                      "tr",
                      {
                        className: `hover:bg-gray-700/50 transition-colors duration-150 ${
                          s.status === "playing"
                            ? "bg-green-900/10 border-l-2 border-green-400"
                            : ""
                        }`,
                        children: [
                          e.jsx("td", {
                            className: "py-4 px-6 whitespace-nowrap",
                            children: e.jsxs("div", {
                              className: "flex items-center",
                              children: [
                                s.status === "playing" &&
                                  e.jsx("div", {
                                    className:
                                      "w-2 h-2 bg-green-400 rounded-full mr-2 animate-pulse",
                                  }),
                                e.jsxs("span", {
                                  className: "text-blue-400 font-medium",
                                  children: ["#", s.id],
                                }),
                              ],
                            }),
                          }),
                          e.jsxs("td", {
                            className: "py-4 px-6 whitespace-nowrap",
                            children: [
                              e.jsx("div", {
                                className:
                                  "text-white font-medium truncate max-w-32",
                                title: s.user.email,
                                children: s.user.name,
                              }),
                              e.jsx("div", {
                                className:
                                  "text-xs text-gray-400 truncate max-w-32",
                                title: s.user.email,
                                children: s.user.email,
                              }),
                            ],
                          }),
                          e.jsx("td", {
                            className: "py-4 px-6 whitespace-nowrap text-right",
                            children: e.jsx("span", {
                              className: "text-yellow-400 font-semibold",
                              children: a(s.amount),
                            }),
                          }),
                          e.jsx("td", {
                            className: "py-4 px-6 whitespace-nowrap text-right",
                            children: e.jsx("span", {
                              className: `font-semibold ${
                                (s.status === "playing" && s.current_win > 0) ||
                                s.win > s.amount
                                  ? "text-green-400"
                                  : "text-red-400"
                              }`,
                              children:
                                s.status === "playing" && s.current_win > 0
                                  ? a(s.current_win)
                                  : a(s.win),
                            }),
                          }),
                          e.jsx("td", {
                            className:
                              "py-4 px-6 whitespace-nowrap text-center",
                            children: w(s),
                          }),
                          e.jsx("td", {
                            className:
                              "py-4 px-6 whitespace-nowrap text-center",
                            children: e.jsx("span", {
                              className: "text-purple-400 font-medium",
                              children:
                                s.status === "playing"
                                  ? e.jsxs("span", {
                                      className:
                                        "flex items-center justify-center",
                                      children: [
                                        e.jsx("span", {
                                          className: "text-purple-400",
                                          children: s.chests_opened,
                                        }),
                                        e.jsx("span", {
                                          className: "text-gray-500 mx-1",
                                          children: "/",
                                        }),
                                        e.jsx("span", {
                                          className: "text-gray-400",
                                          children: "9",
                                        }),
                                      ],
                                    })
                                  : e.jsx("span", {
                                      children: s.chests_opened,
                                    }),
                            }),
                          }),
                          e.jsx("td", {
                            className:
                              "py-4 px-6 whitespace-nowrap text-center",
                            children: s.bonus_active
                              ? e.jsxs("span", {
                                  className:
                                    "px-2 py-1 bg-orange-400/20 text-orange-400 rounded-full text-xs font-medium",
                                  children: [s.bonus_multiplier, "x"],
                                })
                              : e.jsx("span", {
                                  className: "text-gray-500",
                                  children: "-",
                                }),
                          }),
                          e.jsx("td", {
                            className:
                              "py-4 px-6 whitespace-nowrap text-center",
                            children: e.jsx("span", {
                              className: `text-xs font-medium ${y(s.rtp_mode)}`,
                              children: s.rtp_mode
                                ? s.rtp_mode.toUpperCase()
                                : "BALANCED",
                            }),
                          }),
                          e.jsx("td", {
                            className: "py-4 px-6 whitespace-nowrap text-right",
                            children: e.jsx("div", {
                              className: "text-gray-400 text-sm",
                              children:
                                s.status === "playing"
                                  ? s.updated_at
                                  : s.created_at,
                            }),
                          }),
                        ],
                      },
                      s.id
                    )
                  ),
                }),
              ],
            }),
          }),
          u.length === 0
            ? e.jsxs("div", {
                className: "text-center py-8",
                children: [
                  e.jsx("div", {
                    className: "text-gray-400 text-lg",
                    children: "Nenhuma partida encontrada",
                  }),
                  e.jsx("div", {
                    className: "text-gray-500 text-sm mt-1",
                    children: "As partidas aparecerão aqui quando iniciadas",
                  }),
                ],
              })
            : x.active === 0
            ? e.jsxs("div", {
                className: "text-center py-4 bg-gray-800/30 rounded-md mt-4",
                children: [
                  e.jsxs("div", {
                    className: "text-gray-400 text-sm",
                    children: [" Exibindo ", x.total, " partidas recentes"],
                  }),
                  e.jsx("div", {
                    className: "text-gray-500 text-xs mt-1",
                    children: "Nenhuma partida ao vivo no momento",
                  }),
                ],
              })
            : null,
        ],
      }),
    ],
  });
}
export { U as default };
