--
-- Table structure for table `actor_director`
--

CREATE TABLE `actor_director` (
  `id` int(11) NOT NULL,
  `ad_type` varchar(255) DEFAULT NULL,
  `ad_name` varchar(60) NOT NULL,
  `ad_bio` text DEFAULT NULL,
  `ad_birthdate` int(11) DEFAULT NULL,
  `ad_place_of_birth` varchar(255) DEFAULT NULL,
  `ad_tmdb_id` varchar(255) DEFAULT NULL,
  `ad_slug` varchar(255) NOT NULL,
  `ad_image` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `actor_director`
--

INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(1, 'actor', 'Marlon Brando', 'Marlon Brando Jr. (April 3, 1924 – July 1, 2004) was an American actor. Considered one of the most influential actors of the 20th century, he received numerous accolades throughout his career which spanned six decades, including two Academy Awards, two Golden Globe Awards, and three British Academy Film Awards. Brando was also an activist for many causes, notably the civil rights movement and various Native American movements. Having studied with Stella Adler in the 1940s, he is credited with being one of the first actors to bring the Stanislavski system of acting and method acting, derived from the Stanislavski system, to mainstream audiences.\n\nHe initially gained acclaim and his first Academy Award nomination for Best Actor in a Leading Role for reprising the role of Stanley Kowalski in the 1951 film adaptation of Tennessee Williams\\\' play A Streetcar Named Desire, a role that he originated successfully on Broadway. He received further praise, and a first Academy Award and Golden Globe Award, for his performance as Terry Malloy in On the Waterfront, and his portrayal of the rebellious motorcycle gang leader Johnny Strabler in The Wild One proved to be a lasting image in popular culture. Brando received Academy Award nominations for playing Emiliano Zapata in Viva Zapata! (1952); Mark Antony in Joseph L. Mankiewicz\\\'s 1953 film adaptation of Shakespeare\\\'s Julius Caesar; and Air Force Major Lloyd Gruver in Sayonara (1957), an adaptation of James A. Michener\\\'s 1954 novel.\n\nThe 1960s saw Brando\\\'s career take a commercial and critical downturn. He directed and starred in the cult western One-Eyed Jacks, a critical and commercial flop, after which he delivered a series of notable box-office failures, beginning with Mutiny on the Bounty (1962). After ten years of underachieving, he agreed to do a screen test as Vito Corleone in Francis Ford Coppola\\\'s The Godfather (1972). He got the part and subsequently won his second Academy Award and Golden Globe Award in a performance critics consider among his greatest. He declined the Academy Award due to alleged mistreatment and misportrayal of Native Americans by Hollywood. The Godfather was one of the most commercially successful films of all time, and alongside his Oscar-nominated performance in Last Tango in Paris (1972), Brando reestablished himself in the ranks of top box-office stars.\n\nAfter a hiatus in the early 1970s, Brando was generally content with being a highly paid character actor in supporting roles, such as Jor-El in Superman (1978), as Colonel Kurtz in Apocalypse Now (1979), and Adam Steiffel in The Formula (1980), before taking a nine-year break from film. According to the Guinness Book of World Records, Brando was paid a record $3.7 million ($16 million in inflation-adjusted dollars) and 11.75% of the gross profits for 13 days\\\' work on Superman.\n\nBrando was ranked by the American Film Institute as the fourth-greatest movie star among male movie stars whose screen debuts occurred in or before 1950. He was one of only six actors named in 1999 by Time magazine in its list of the 100 Most Important People of the Century. In this list, Time also designated Brando as the \\\"Actor of the Century\\\".', -1443657600, 'Omaha, Nebraska, USA', '3084', 'marlon-brando', 'upload/images/fuTEPMsBtV1zE98ujPONbKiYDc2.jpg'),
(2, 'actor', 'Al Pacino', 'Alfredo James Pacino (born April 25, 1940) is an American actor and filmmaker. In a career spanning over five decades, he has received many awards and nominations, including an Academy Award, two Tony Awards, and two Primetime Emmy Awards. He is one of the few performers to have received the Triple Crown of Acting. He has also been honored with the AFI Life Achievement Award, the Cecil B. DeMille Award, and the National Medal of Arts.\n\nA method actor and former student of the HB Studio and the Actors Studio, where he was taught by Charlie Laughton and Lee Strasberg, Pacino\\\'s film debut came at the age of 29 with a minor role in Me, Natalie (1969). He gained favorable notice for his first lead role as a heroin addict in The Panic in Needle Park (1971). Wide acclaim and recognition came with his breakthrough role as Michael Corleone in Francis Ford Coppola\\\'s The Godfather (1972), for which he received his first Oscar nomination, and he would reprise the role in the sequels The Godfather Part II (1974) and The Godfather Part III (1990).\n\nHis portrayal of Michael Corleone is regarded as one of the greatest in film history. Pacino received nominations for the Academy Award for Best Actor for Serpico (1973), The Godfather Part II, Dog Day Afternoon (1975), and ...And Justice for All (1979), ultimately winning it for playing a blind military veteran in Scent of a Woman (1992). For his performances in The Godfather, Dick Tracy (1990), Glengarry Glen Ross (1992), and The Irishman (2019), he earned Best Supporting Actor Oscar nominations.\n\nOther notable portrayals include Tony Montana in Scarface (1983), Carlito Brigante in Carlito\\\'s Way (1993), Benjamin Ruggiero in Donnie Brasco (1997), and Lowell Bergman in The Insider (1999). He has also starred in the thrillers Heat (1995), The Devil\\\'s Advocate (1997), Insomnia (2002), and appeared in Once Upon a Time in Hollywood (2019). On television, Pacino has acted in several productions for HBO, including Angels in America (2003) and the Jack Kevorkian biopic You Don\\\'t Know Jack (2010), winning a Primetime Emmy Award for Outstanding Lead Actor in a Miniseries or a Movie for each. Pacino currently stars in the Amazon Video web television series Hunters (2020–present).\n\nHe has also had an extensive career on stage. He is a two-time Tony Award winner, in 1969 and 1977, for his performances in Does a Tiger Wear a Necktie? and The Basic Training of Pavlo Hummel. Pacino made his filmmaking debut with Looking for Richard (1996), directing and starring in this documentary about Richard III; Pacino had played the lead role on stage in 1977. He has also acted as Shylock in a 2004 feature film adaptation and 2010 stage production of The Merchant of Venice. Pacino directed and starred in Chinese Coffee (2000), Wilde Salomé (2011), and Salomé (2013). Since 1994, he has been the joint president of the Actors Studio.​\n\nFrom Wikipedia, the free encyclopedia', -936835200, 'New York City, New York, USA', '1158', 'al-pacino', 'upload/images/cCECRgy3E1e1jE6y5xtSsThnLid.jpg'),
(3, 'actor', 'James Caan', 'James Edmund Caan (/kɑːn/ KAHN; March 26, 1940 – July 6, 2022) was an American actor who was nominated for several awards, including four Golden Globes, an Emmy, and an Oscar. Caan was awarded a motion pictures star on the Hollywood Walk of Fame in 1978.\n\nAfter early roles in Howard Hawks\\\'s El Dorado (1966), Robert Altman\\\'s Countdown (1967) and Francis Ford Coppola\\\'s The Rain People (1969), he came to prominence for playing his signature role of Sonny Corleone in The Godfather (1972), for which he was nominated for the Academy Award for Best Supporting Actor and the Golden Globe for Best Supporting Actor. He reprised the role of Sonny Corleone in The Godfather Part II (1974) with a cameo appearance at the end.\n\nCaan had significant roles in films such as Brian\\\'s Song (1971), Cinderella Liberty (1973), The Gambler (1974), Rollerball (1975), A Bridge Too Far (1977), and Alan J. Pakula\\\'s Comes a Horseman (1978). He had sporadically worked in film since the 1980s, with his notable performances including roles in Thief (1981), Gardens of Stone (1987), Misery (1990), Dick Tracy (1990), Bottle Rocket (1996), The Yards (2000), Dogville (2003), and Elf (2003).\n\nDescription above from the Wikipedia article James Caan, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -939427200, 'The Bronx, New York, USA', '3085', 'james-caan', 'upload/images/bGyOCCOIgcIyKjOGLoXoyp0XWHf.jpg'),
(4, 'actor', 'Robert Duvall', 'Robert Selden Duvall (born January 5, 1931) is an American actor and filmmaker. He is the recipient of an Academy Award, four Golden Globe Awards, a BAFTA Award, two Primetime Emmy Awards and a Screen Actors Guild Award.\n\nDuvall began appearing in theater in the late 1950s, moving into television and film roles during the early 1960s, playing Boo Radley in To Kill a Mockingbird (1962) and appearing in Captain Newman, M.D. (1963), as Major Frank Burns in the blockbuster comedy M*A*S*H (1970) and the lead role in THX 1138 (1971), as well as Horton Foote\\\'s adaptation of William Faulkner\\\'s Tomorrow (1972), which was developed at The Actors Studio and is his personal favorite. This was followed by a series of critically lauded performances in commercially successful films.\n\nHe has starred in numerous films and television series, including The Twilight Zone (1963), The Outer Limits (1964), The F.B.I. (1966), Bullitt (1968), True Grit (1969), Joe Kidd (1972), The Godfather (1972), The Godfather Part II (1974), The Conversation (1974), Network (1976), Apocalypse Now (1979), The Great Santini (1979), Tender Mercies (1983) (which earned him the Academy Award for Best Actor), The Natural (1984), Colors (1988), Lonesome Dove (1989), The Handmaid\\\'s Tale (1990), Days of Thunder (1990), Rambling Rose (1991), Falling Down (1993), Secondhand Lions (2003), The Judge (2014), and Widows (2018).\n\n​From Wikipedia, the free encyclopedia', -1230422400, 'San Diego, California, USA', '3087', 'robert-duvall', 'upload/images/3tcKxC5Sc3DJ6XPDKKC2EAomEWn.jpg'),
(5, 'actor', 'Richard S. Castellano', '​From Wikipedia, the free encyclopedia.\n\nRichard Salvatore Castellano  (September 4, 1933 – December 10, 1988) was an American actor who is best remembered for his role as Peter Clemenza in The Godfather.\n\nDescription above from the Wikipedia article Richard S. Castellano, licensed under CC-BY-SA, full list of contributors on Wikipedia', -1146355200, 'The Bronx, New York, U.S', '3086', 'richard-s-castellano', 'upload/images/1vr75BdHWret81vuSJ3ugiCBkxw.jpg'),
(6, 'actor', 'Diane Keaton', 'Diane Hall Keaton (born Diane Hall; January 5, 1946) is an American actress. Known for her idiosyncratic personality and fashion style, she has received various accolades throughout her career spanning over six decades, including an Academy Award, a British Academy Film Award, two Golden Globe Awards, and the AFI Life Achievement Award.\n\nKeaton began her career on stage appearing in the original 1968 Broadway production of the musical Hair. The next year, she received a Tony Award for Best Featured Actress in a Play nomination for her performance in Woody Allen\\\'s comic play Play it Again, Sam. She then made her screen debut in a small role in Lovers and Other Strangers (1970). She rose to prominence with her first major film role as Kay Adams-Corleone in Francis Ford Coppola\\\'s The Godfather (1972), a role she reprised in its sequels The Godfather Part II (1974) and The Godfather Part III (1990). The films that most shaped her career were those with director and co-star Woody Allen, beginning with the film adaptation of Play It Again, Sam (1972). Her next two films with Allen, Sleeper (1973) and Love and Death (1975), established her as a comic actor. Her fourth, the romantic comedy Annie Hall (1977), won her the Academy Award for Best Actress.\n\nTo avoid being typecast as her Annie Hall persona, Keaton appeared in several dramatic films, starring in Looking for Mr. Goodbar (1977) and Allen\\\'s Interiors (1978), and received three more Academy Award nominations for playing feminist activist Louise Bryant in Reds (1981), a woman with leukemia in Marvin\\\'s Room (1996), and a dramatist in Something\\\'s Gotta Give (2003). Keaton\\\'s other popular films include Manhattan (1979), Baby Boom (1987), Father of the Bride (1991), Manhattan Murder Mystery (1993), Father of the Bride Part II (1995), The First Wives Club (1996), The Family Stone (2005), Morning Glory (2010), Finding Dory (2016) and Book Club (2018).', -757036800, 'Los Angeles, California, USA', '3092', 'diane-keaton', 'upload/images/mRq2Rxh2hmG3kFPRp4NEGXRaLPB.jpg'),
(7, 'actor', 'Talia Shire', 'Talia Shire, born on April 25, 1946, in Lake Success, New York, is an American actress. She gained widespread recognition for her role as Adrian Pennino, the wife of Rocky Balboa, in the iconic \\\"Rocky\\\" film series. Shire\\\'s portrayal of the timid but resilient Adrian earned her acclaim and a place in cinematic history. Beyond \\\"Rocky,\\\" she also starred as Connie Corleone in \\\"The Godfather\\\" films, further establishing her as a versatile and talented actress. With a career spanning several decades, Shire\\\'s contributions to film have solidified her as a respected figure in Hollywood.', -747532800, 'Lake Success, New York, USA', '3094', 'talia-shire', 'upload/images/RkFJejmEKM80ly6fPSN7octO5c.jpg'),
(8, 'actor', 'Gianni Russo', 'With a singularly nebulous background, which, by his account, included stints as a Las Vegas nightclub emcee, radio personality, and jewelry tycoon, and comparatively little acting experience, Gianni Russo won the role of Carlo Rizzi in The Godfather (1972) on the basis of his screen test. Since then, Russo has remained busy as an actor, mostly playing assorted \\\"wiseguys\\\" and Mafia types. He was appeared again with Marlon Brando in a small role in The Freshman (1990) in which Brando parodied his Don Corleone role to good effect. IMDb Mini Biography By: Bob Sorrentino', -822268800, 'New York City, New York, USA', '3095', 'gianni-russo', 'upload/images/jfeGnQfXMzKXsuSPm9oTxm6FOuz.jpg'),
(9, 'actor', 'Sterling Hayden', 'Sterling Walter Hayden, born Sterling Relyea Walter, was an American actor and author. He didn\\\'t really harbor any aspirations of being an actor, dropped out of high school at the age of 16 and hired on as mate on a schooner. He was a ship\\\'s captain at 22, and in need of cash to buy his own boat, established himself as a model in New York, discovered by Paramount Studios talent scouts and offered a contract.\n\nSterling Hayden, the handsome tall blond actor who played wholesome leading-man movie roles in the 1940\\\'s and 1950\\\'s and later weathered into a rough-hewn solid character actor in films such as \\\'\\\'Dr. Strangelove\\\'\\\', \\\'\\\'The Godfather,\\\'\\\' \\\"Nine to Five\\\" and \\\"King of the Gypsies\\\". He appeared in 71 feature films and tv-productions  from the debut in \\\"Virginia\\\" 1941 to  the tv mini-series \\\"The Blue and the Gray\\\" in 1982.\n\nHe wrote of his obsessive fascination with the sea in a 1963 autobiography, \\\'\\\'Wanderer,\\\'\\\' and in 1970 his 700-page epic novel of the sea, \\\'\\\'Voyage,\\\'\\\' was a main selection of the Book-of-the-Month Club.\n\nSterling Hayden appeared in the German documentary, \\\'\\\'Pharos of Chaos,\\\'\\\' (1983) filmed aboard his barge in Europe, and seemed to be in an alcoholic stupor much of the time, supplementing his wine intake with hashish. On camera he said: \\\'\\\'What confuses me is I ain\\\'t all that unhappy. So why do I drink, I don\\\'t know.\\\'\\\'', -1696809600, 'Upper Montclair, New Jersey, USA', '3088', 'sterling-hayden', 'upload/images/eRKaKeHjMKjNPOuENLccfVuyfVm.jpg'),
(10, 'actor', 'John Marley', 'John Marley (October 17, 1907 – May 22, 1984) was an American actor who was known for his role as Phil Cavalleri in Love Story and as Jack Woltz— the defiant movie mogul who awakens to find the severed head of his prized horse in his bed—in The Godfather (1972). He starred in John Cassavetes\\\' breakthrough feature Faces (1968) and appeared in The Glitter Dome (1984).\n\nDescription above from the Wikipedia article John Marley, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -1963180800, 'New York City, New York, USA', '3142', 'john-marley', 'upload/images/anyn6VxuYreSRn2ggQiGIj2MOsm.jpg'),
(11, 'actor', 'Richard Conte', '​From Wikipedia, the free encyclopedia.\n\nRichard Conte (March 24, 1910 – April 15, 1975) was an American actor. He appeared in numerous films from the 1940s through 1970s, including I\\\'ll Cry Tomorrow and The Godfather.\n\nDescription above from the Wikipedia article Richard Conte, licensed under CC-BY-SA, full list of contributors on Wikipedia', -1886371200, 'Jersey City, New Jersey, USA', '3090', 'richard-conte', 'upload/images/bDegodf4dYGXMejdm4T6XgOJwlr.jpg'),
(12, 'director', 'Francis Ford Coppola', 'James Edmund Caan (/kɑːn/ KAHN; March 26, 1940 – July 6, 2022) was an American actor who was nominated for several awards, including four Golden Globes, an Emmy, and an Oscar. Caan was awarded a motion pictures star on the Hollywood Walk of Fame in 1978.\n\nAfter early roles in Howard Hawks\\\'s El Dorado (1966), Robert Altman\\\'s Countdown (1967) and Francis Ford Coppola\\\'s The Rain People (1969), he came to prominence for playing his signature role of Sonny Corleone in The Godfather (1972), for which he was nominated for the Academy Award for Best Supporting Actor and the Golden Globe for Best Supporting Actor. He reprised the role of Sonny Corleone in The Godfather Part II (1974) with a cameo appearance at the end.\n\nCaan had significant roles in films such as Brian\\\'s Song (1971), Cinderella Liberty (1973), The Gambler (1974), Rollerball (1975), A Bridge Too Far (1977), and Alan J. Pakula\\\'s Comes a Horseman (1978). He had sporadically worked in film since the 1980s, with his notable performances including roles in Thief (1981), Gardens of Stone (1987), Misery (1990), Dick Tracy (1990), Bottle Rocket (1996), The Yards (2000), Dogville (2003), and Elf (2003).\n\nDescription above from the Wikipedia article James Caan, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -939427200, 'The Bronx, New York, USA', '3085', 'francis-ford-coppola', 'upload/images/3Pblihd6KjXliie9vj4iQJwbNPU.jpg'),
(13, 'actor', 'Cillian Murphy', 'Cillian Murphy (born 25 May 1976) is an Irish actor.\n\nHe made his professional debut in Enda Walsh\\\'s 1996 play Disco Pigs, a role he later reprised in the 2001 screen adaptation. His early notable film credits include the horror film 28 Days Later (2002), the dark comedy Intermission (2003), the thriller Red Eye (2005), the Irish war drama The Wind That Shakes the Barley (2006), and the science fiction thriller Sunshine (2007). He played a transgender Irish woman in the comedy-drama Breakfast on Pluto (2005), which earned him a Golden Globe Award nomination.\n\nMurphy began collaborating with filmmaker Christopher Nolan in 2005, playing Dr. Jonathan Crane / Scarecrow in The Dark Knight Trilogy (2005–2012) as well as appearing in Inception (2010) and Dunkirk (2017) and portraying the lead role of J. Robert Oppenheimer in the biographical epic Oppenheimer (2023). By the year 2023, Murphy has already worked with Nolan for around 20 years and six films. He also gained prominence for his role as Tommy Shelby in the BBC period drama series Peaky Blinders (2013–2022) and for starring in the horror sequel A Quiet Place Part II (2020).\n\nIn 2011, Murphy won the Irish Times Theatre Award for Best Actor and Drama Desk Award for Outstanding Solo Performance for the one-man play Misterman. In 2020, The Irish Times named him one of the greatest Irish film actors.', 201830400, 'Douglas, Cork, Ireland', '2037', 'cillian-murphy', 'upload/images/2lKs67r7FI4bPu0AXxMUJZxmUXn.jpg'),
(14, 'actor', 'Emily Blunt', 'Emily Olivia Laura Blunt (born 23 February 1983) is a British actress. She is the recipient of several accolades, including a Golden Globe Award and a Screen Actors Guild Award, in addition to nominations for three British Academy Film Awards. Forbes ranked her as one of the highest-paid actresses in the world in 2020.\n\nBlunt made her acting debut in a 2001 stage production of The Royal Family. She went on to appear in the television film Boudica (2003) and portrayed Queen Catherine Howard in the miniseries Henry VIII (2003). She made her feature film debut in the drama My Summer of Love (2004). Blunt\\\'s breakthrough came in 2006 with her starring roles in the television film Gideon\\\'s Daughter and the comedy-drama film The Devil Wears Prada. The former won her a Golden Globe Award for Best Supporting Actress and the latter earned her a nomination for the BAFTA Award for Best Actress in a Supporting Role.\n\nBlunt\\\'s profile continued to grow with leading roles in the period film The Young Victoria (2009), the romantic comedy Salmon Fishing in the Yemen (2011), the science fiction films The Adjustment Bureau (2011), Looper (2012), and Edge of Tomorrow (2014), and the musical films Into the Woods (2014) and Mary Poppins Returns (2018). She received critical acclaim for playing a principled FBI agent in the crime film Sicario (2015), an alcoholic in the thriller The Girl on the Train (2016), which earned her a nomination for the BAFTA Award for Best Actress in a Leading Role, and a survivalist mother in her husband John Krasinski\\\'s horror film A Quiet Place (2018), for which she won the SAG Award for Best Supporting Actress. She has since starred in the sequel A Quiet Place Part II (2020), Jungle Cruise (2021), the western miniseries The English (2022), Oppenheimer (2023) and Pain Hustlers (2023).', 414806400, 'Wandsworth, London, England, UK', '5081', 'emily-blunt', 'upload/images/xDc01ud6ZtaJFQWg8YfffFlUBdY.jpg'),
(15, 'actor', 'Matt Damon', 'Matthew Paige Damon (born October 8, 1970) is an American actor, film producer, and screenwriter. He is the recipient of various accolades, including an Academy Award from five nominations, and two Golden Globe Awards. He also received three BAFTA Award nominations, seven Primetime Emmy Award nominations, and six Screen Actors Guild Awards.\n\nDamon made his professional acting debut in the film Mystic Pizza (1988). He came to prominence when he and Ben Affleck wrote and starred in Good Will Hunting (1997), which won them the Academy Award for Best Screenplay. He continued to garner praise for his roles in Saving Private Ryan (1998), The Talented Mr. Ripley (1999), the Ocean\\\'s trilogy (2001-2007), the Bourne franchise (2002-2016), The Departed (2006), Invictus (2009), True Grit (2010), Behind The Candelabra (2013), The Martian (2015), Ford v Ferrari (2019), and Air (2023).\n\nDamon has co-written the feature films Good Will Hunting (1997), Gerry (2002), Promised Land (2012) and The Last Duel (2021).\n\nHe has produced the reality series Project Greenlight (2001-2015) as well as multiple films including Manchester by the Sea (2016) and The Last Duel (2021). In 2022, he co-founded the production company Artists Equity.', 24192000, 'Boston, Massachusetts, USA', '1892', 'matt-damon', 'upload/images/At3JgvaNeEN4Z4ESKlhhes85Xo3.jpg'),
(16, 'actor', 'Robert Downey Jr.', 'Robert John Downey Jr. (born April 4, 1966) is an American actor and producer. His career has been characterized by critical and popular success in his youth, followed by a period of substance abuse and legal troubles, before a resurgence of commercial success later in his career. In 2008, Downey was named by Time magazine among the 100 most influential people in the world, and from 2013 to 2015, he was listed by Forbes as Hollywood\\\'s highest-paid actor.\n\nAt the age of five, he made his acting debut in his father Robert Downey Sr.\\\'s film Pound in 1970. He subsequently worked with the Brat Pack in the teen films Weird Science (1985) and Less than Zero (1987). In 1992, Downey portrayed the title character in the biopic Chaplin, for which he was nominated for the Academy Award for Best Actor and won a BAFTA Award. Following a stint at the Corcoran Substance Abuse Treatment Facility on drug charges, he joined the TV series Ally McBeal, for which he won a Golden Globe Award. He was fired from the show in the wake of drug charges in 2000 and 2001. He stayed in a court-ordered drug treatment program and has maintained his sobriety since 2003.\n\nInitially, completion bond companies would not insure Downey, until Mel Gibson paid the insurance bond for the 2003 film The Singing Detective. He went on to star in the black comedy Kiss Kiss Bang Bang (2005), the thriller Zodiac (2007), and the action comedy Tropic Thunder (2008); for the latter, he was nominated for an Academy Award for Best Supporting Actor.\n\nDowney gained global recognition for starring as Tony Stark / Iron Man in ten films within the Marvel Cinematic Universe, beginning with Iron Man (2008), and leading up to Avengers: Endgame (2019). He has also played the title character in Guy Ritchie\\\'s Sherlock Holmes (2009), which earned him his second Golden Globe, and its sequel, Sherlock Holmes: A Game of Shadows (2011).\n\nDescription above from the Wikipedia article Robert Downey Jr., licensed under CC-BY-SA, full list of contributors on Wikipedia.', -149731200, 'New York City, New York, USA', '3223', 'robert-downey-jr', 'upload/images/im9SAqJPZKEbVZGmjXuLI4O7RvM.jpg'),
(17, 'actor', 'Florence Pugh', 'Florence Pugh (born January 3, 1996) is an English actress. She made her acting debut in 2014 in the drama film The Falling. Pugh gained recognition in 2016 for her leading role as a young bride in the independent drama Lady Macbeth, winning a British Independent Film Award, and drew praise for starring in the miniseries The Little Drummer Girl (2018).\n\nPugh\\\'s international breakthrough came in 2019 with her portrayals of professional wrestler Paige in the biographical sports film Fighting with My Family, a despondent American woman in the horror film Midsommar, and Amy March in the period drama Little Women. For the last of these, she received nominations for an Academy Award and a BAFTA Award. Pugh was awarded the Trophée Chopard at the 2019 Cannes Film Festival.\n\nShe has played Yelena Belova in the Marvel Cinematic Universe, beginning with Black Widow (2021) and Hawkeye (2021). She will reprise her role again in Thunderbolts (2024). In the following year, she starred in the thriller Don\\\'t Worry Darling and drama The Wonder, and voiced Goldilocks in the animated film Puss in Boots: The Last Wish. Pugh also portrayed Jean Tatlock in Christopher Nolan\\\'s biographical film Oppenheimer (2023) and Princess Irulan in Denis Villeneuve’s sci-fi epic Dune: Part Two (2024).\n\nDescription above from the Wikipedia article Florence Pugh, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 820627200, 'Oxford, England, UK', '1373737', 'florence-pugh', 'upload/images/4VghWSpWzH3z2PuJVSKUUZ9thFE.jpg'),
(18, 'actor', 'Josh Hartnett', 'Joshua Daniel \\\"Josh\\\" Hartnett (born July 21, 1978) is an American actor and producer.\n\nHe first came to audiences\\\' attention in 1997 as \\\"Michael Fitzgerald\\\" in the television series Cracker. He made his feature film debut in 1998, co-starring with Jamie Lee Curtis in Halloween H20: 20 Years Later. That same year, he received an MTV Movie Award nomination for Best Breakthrough Male Performance. Hartnett gained fame for his role as Cpt Danny Walker in Pearl Harbor, and has starred since then for a variety of well-known directors such as Ridley Scott, Brian De Palma, Robert Rodriguez, Tran Anh Hung and Michael Bay.', 269827200, 'Saint Paul, Minnesota, USA', '2299', 'josh-hartnett', 'upload/images/dCfu2EN7FjISACcjilaJu7evwEc.jpg'),
(19, 'actor', 'Casey Affleck', 'Caleb Casey McGuire Affleck-Boldt (born August 12, 1975) is an American actor and filmmaker. He is the recipient of various accolades, including an Academy Award, a British Academy Film Award, a Golden Globe Award and a Satellite Award. He began his career as a child actor, appearing in the PBS television film Lemon Sky (1988) and the miniseries The Kennedys of Massachusetts (1990). He later appeared in three Gus Van Sant films: To Die For (1995), Good Will Hunting (1997), and Gerry (2002), and in Steven Soderbergh\\\'s comedy heist trilogy Ocean\\\'s Eleven (2001), Ocean\\\'s Twelve (2004), and Ocean\\\'s Thirteen (2007). His first leading role was in Steve Buscemi\\\'s independent comedy-drama Lonesome Jim (2006).\n\nAffleck\\\'s breakthrough came in 2007, when he was nominated for the Academy Award for Best Supporting Actor for his performance in the Western drama The Assassination of Jesse James by the Coward Robert Ford and starred in the crime drama Gone Baby Gone, directed by his brother Ben Affleck. In 2010, he directed the mockumentary I\\\'m Still Here. He then had a string of successful films in the early 2010s, including Tower Heist (2011), ParaNorman (2012) and Interstellar (2014), and received particular praise for his performance as an outlaw in the indie film Ain\\\'t Them Bodies Saints (2013).\n\nIn 2016, Affleck starred in the drama film Manchester by the Sea. For his performance as Lee Chandler, a man grieving the loss of his children and his brother, he received universal acclaim and won the Critics\\\' Choice Movie Award, Golden Globe Award, British Academy Film Award and Academy Award for Best Actor, and received a Screen Actors Guild Award nomination. In 2017, Affleck received critical acclaim for his leading role in the supernatural drama film A Ghost Story.', 177033600, 'Falmouth, Massachusetts, USA', '1893', 'casey-affleck', 'upload/images/vD5MtCjHPHpmU9XNn74EPGMHT7o.jpg'),
(20, 'actor', 'Rami Malek', 'Rami Said Malek (born May 12, 1981) is an American actor from Los Angeles. He won a Critics\\\' Choice Award and the Primetime Emmy Award for Outstanding Lead Actor in a Drama Series for his lead role as Elliot Alderson in the USA Network television series Mr. Robot. He also received Golden Globe Award, Screen Actors Guild Award, and TCA Award nominations. Furthermore, he’s won an Academy Award and a Golden Globe for portraying Freddie Mercury in the biopic Bohemian Rhapsody.\n\nMalek has acted in supporting roles for other film and television series such as Night at the Museum trilogy, Fox comedy series The War at Home (2005–2007), HBO miniseries The Pacific (2010), Larry Crowne (2011), Paul Thomas Anderson\\\'s The Master (2012), The Twilight Saga: Breaking Dawn – Part 2 (2012), the independent film Ain\\\'t Them Bodies Saints (2013) and the dramatic film Short Term 12 (2013). He was also in the videogame Until Dawn (2015) as Joshua \\\"Josh\\\" Washington.\n\nDescription above from the Wikipedia article Rami Malek, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 358473600, 'Torrance, California, USA', '17838', 'rami-malek', 'upload/images/ewr46CGOdsx5NzAJdIzEBz2yIQh.jpg'),
(21, 'actor', 'Kenneth Branagh', 'Sir Kenneth Charles Branagh (born 10 December 1960) is a British actor and filmmaker. Branagh trained at the Royal Academy of Dramatic Art in London; in 2015 he succeeded Richard Attenborough as its president. He has been nominated for five Academy Awards and five Golden Globe Awards. He has won three BAFTAs and two Emmy Awards. He was appointed a Knight Bachelor in the 2012 Birthday Honours and knighted on 9 November 2012.  He was made a Freeman of his native city of Belfast in January 2018. In 2020, he was listed at number 20 on The Irish Times list of Ireland\\\'s greatest film actors.\n\nBranagh has both directed and starred in several film adaptations of William Shakespeare\\\'s plays, including Henry V (1989), Much Ado About Nothing (1993), Othello (1995), Hamlet (1996), Love\\\'s Labour\\\'s Lost (2000), and As You Like It (2006). He was nominated for Academy Awards for Best Actor and Best Director for Henry V and for Best Adapted Screenplay for Hamlet.\n\nHe has also starred in the television series Fortunes of War (1987), Shackleton (2002), and Wallander (2008–2016) and in the films Celebrity (1998), Wild Wild West (1999), The Road to El Dorado (2000), as SS leader Reinhard Heydrich in Conspiracy (2001), Harry Potter and the Chamber of Secrets (2002), Warm Springs (2005), as Major General Henning von Tresckow in Valkyrie (2008), The Boat That Rocked (2009), and as Sir Laurence Olivier in My Week with Marilyn (2011), Dunkirk (2017), and Tenet (2020). He won an International Emmy Award for Wallander and a Primetime Emmy Award for Conspiracy, and was nominated for the Academy Award for Best Supporting Actor for My Week with Marilyn.\n\nBranagh directed and starred in the romantic thriller Dead Again (1991), the horror film Mary Shelley\\\'s Frankenstein (1994), and the action thriller Jack Ryan: Shadow Recruit (2014). He directed and starred as Hercule Poirot in the mystery drama adaptations of Agatha Christie\\\'s Murder on the Orient Express (2017) and Death on the Nile (2022). He also directed such films as Swan Song (1992), which earned an Academy Award nomination for Best Live Action Short Film, The Magic Flute (2006), Sleuth (2007), the Marvel superhero film Thor (2011), and the live-action adaptation of Disney\\\'s Cinderella (2015),\n\nHe narrated numerous documentary series, including Cold War (1998), Walking with Dinosaurs (1999), The Ballad of Big Al (2001), Walking with Beasts (2001), Walking with Monsters (2005), and World War 1 in Colour (2005).', -285897600, 'Belfast, Northern Ireland, UK', '11181', 'kenneth-branagh', 'upload/images/AbCqqFxNi5w3nDUFdQt0DGMFh5H.jpg'),
(22, 'actor', 'Benny Safdie', 'Benjamin \\\"Benny\\\" Safdie (born February 24, 1986 in New York City) is an American director, screenwriter and actor, best known for the New York-set thrillers Good Time (2017) and Uncut Gems (2019). Together with his brother and frequent collaborator Josh Safdie, they are of Syrian-Jewish ancestry and grew up between their European father in Queens and their New Yorker mother in Manhattan. The brothers began making movies when they were kids, inspired by their film-enthusiastic father who translated his love of cinema to Benny and his brother by constantly filming them.', 509587200, 'New York City, New York, USA', '227564', 'benny-safdie', 'upload/images/vrGyNcAW1Cuwkt1nyqAQQOOUQnv.jpg'),
(23, 'actor', 'Jason Clarke', 'An Australian film and television actor. Clarke has appeared in many TV series. He is best known as a TV actor for his role as Tommy Caffee on the television series Brotherhood. He has also appeared in many films, often as an antagonist.', -14515200, 'Winton, Queensland, Australia', '76512', 'jason-clarke', 'upload/images/jGMOmi7LxpSO6842gJOZKt1gs9N.jpg'),
(24, 'director', 'Christopher Nolan', 'Emily Olivia Laura Blunt (born 23 February 1983) is a British actress. She is the recipient of several accolades, including a Golden Globe Award and a Screen Actors Guild Award, in addition to nominations for three British Academy Film Awards. Forbes ranked her as one of the highest-paid actresses in the world in 2020.\n\nBlunt made her acting debut in a 2001 stage production of The Royal Family. She went on to appear in the television film Boudica (2003) and portrayed Queen Catherine Howard in the miniseries Henry VIII (2003). She made her feature film debut in the drama My Summer of Love (2004). Blunt\\\'s breakthrough came in 2006 with her starring roles in the television film Gideon\\\'s Daughter and the comedy-drama film The Devil Wears Prada. The former won her a Golden Globe Award for Best Supporting Actress and the latter earned her a nomination for the BAFTA Award for Best Actress in a Supporting Role.\n\nBlunt\\\'s profile continued to grow with leading roles in the period film The Young Victoria (2009), the romantic comedy Salmon Fishing in the Yemen (2011), the science fiction films The Adjustment Bureau (2011), Looper (2012), and Edge of Tomorrow (2014), and the musical films Into the Woods (2014) and Mary Poppins Returns (2018). She received critical acclaim for playing a principled FBI agent in the crime film Sicario (2015), an alcoholic in the thriller The Girl on the Train (2016), which earned her a nomination for the BAFTA Award for Best Actress in a Leading Role, and a survivalist mother in her husband John Krasinski\\\'s horror film A Quiet Place (2018), for which she won the SAG Award for Best Supporting Actress. She has since starred in the sequel A Quiet Place Part II (2020), Jungle Cruise (2021), the western miniseries The English (2022), Oppenheimer (2023) and Pain Hustlers (2023).', 414806400, 'Wandsworth, London, England, UK', '5081', 'christopher-nolan', 'upload/images/xuAIuYSmsUzKlUMBFGVZaWsY3DZ.jpg'),
(25, 'actor', 'Greta Lee', 'Greta Jiehan Lee (born March 7, 1983) is an American actress who is best known for starring as Maxine in the Netflix comedy-drama series Russian Doll and for her role in the second season of Apple TV+ drama series The Morning Show. She gained wider recognition for her role as Nora in the 2023 film Past Lives and as the A.I. hologram Lyla in the Spider-Verse film series.', 415843200, 'Los Angeles, California, USA', '1260481', 'greta-lee', 'upload/images/6SydTis4XUcovlwIGskT59JowLX.jpg'),
(26, 'actor', 'Teo Yoo', 'Yoo Teo is a Korean actor and director. He began acting when studying at the Lee Strasberg Theater and Film Institute, NY at the age of 20. He later continued his studies in an intensive course at the Royal Academy of Dramatic Art, London. After having acted in various independent films and theater productions in New York and Berlin he moved to Seoul in 2009.', 355795200, 'Cologne, Germany', '1387126', 'teo-yoo', 'upload/images/yaYSLRP41hsb4bdyLlRZSOvBwKu.jpg'),
(27, 'actor', 'John Magaro', 'John Robert Magaro (born February 16, 1983) is an American actor. He starred in the films Not Fade Away and First Cow. He also had supporting roles in Unbroken, The Big Short, Carol, Overlord and the Netflix series Orange Is the New Black and The Umbrella Academy. He made his Broadway debut as Earl Williams, the escaped convict, in the hit revival of The Front Page in 2016.', 414201600, 'Akron, Ohio, U.S.', '37154', 'john-magaro', 'upload/images/hH24Pti8MyMV5Ks9xzuZ02aE5jG.jpg'),
(28, 'actor', 'Moon Seung-ah', '', 0, 'South Korea', '2309873', 'moon-seung-ah', 'upload/images/bqnsM6Ecn89ZtYwzzL2DT9HgjjR.jpg'),
(29, 'actor', 'Yim Seung-min', '', 1199923200, '', '3888559', 'yim-seung-min', 'upload/images/3UtRGgLaH5BQTAlXRHw3n0hl5zl.jpg'),
(30, 'actor', 'Jojo T. Gibbs', 'Jonica \\\'Jojo\\\' T. Gibbs is an American actress and comedian based in Los Angeles. She\\\'s known for her lead role as Hattie on the BET series Twenties.', 0, 'Gaffney, South Carolina, USA', '2135069', 'jojo-t-gibbs', 'upload/images/sIHpG5ux9C14XADUHa11EWOMA6I.jpg'),
(31, 'actor', 'Emily Cass McDonnell', '', 0, '', '1412150', 'emily-cass-mcdonnell', 'upload/images/uPdn2JEaaQPiwAR6wEMUkrnHPbg.jpg'),
(32, 'actor', 'Federico Rodriguez', '', 0, '', '1146865', 'federico-rodriguez', 'upload/images/2v8KQn3PQrmhjTa1vrfAeSouQDi.jpg'),
(33, 'actor', 'Kristen Sieh', '', 0, '', '2296776', 'kristen-sieh', 'upload/images/kBnMjO6vINaxq1OZjSegoRPOkEP.jpg'),
(34, 'actor', 'Yoon Ji-hye', 'Yoon Ji-hye is a South Korean actress. Yoon made her acting debut in the 1998 horror movie Whispering Corridors. Wikipedia', 311040000, 'South Korea', '109646', 'yoon-ji-hye', 'upload/images/7zePMNGe149OzzsyVCdL0Mx1dT2.jpg'),
(35, 'actor', 'Conrad Schott', '', 0, '', '3888568', 'conrad-schott', NULL),
(36, 'actor', 'Leonardo DiCaprio', 'Leonardo Wilhelm DiCaprio (born November 11, 1974) is an American actor and film producer. Known for his work in biopics and period films, DiCaprio is the recipient of numerous accolades, including an Academy Award, a British Academy Film Award, and three Golden Globe Awards. As of 2019, his films have grossed over $7.2 billion worldwide, and he has been placed eight times in annual rankings of the world\\\'s highest-paid actors.\n\nBorn in Los Angeles, DiCaprio began his career in the late 1980s by appearing in television commercials. In the early 1990s, he had recurring roles in various television shows, such as the sitcom Parenthood, and had his first major film part as author Tobias Wolff in This Boy\\\'s Life (1993). At age 19, he received critical acclaim and his first Academy Award and Golden Globe Award nominations for his performance as a developmentally disabled boy in What\\\'s Eating Gilbert Grape (1993). He achieved international stardom with the star-crossed romances Romeo + Juliet (1996) and Titanic (1997).\n\nAfter the latter became the highest-grossing film at the time, he reduced his workload for a few years. In an attempt to shed his image of a romantic hero, DiCaprio sought roles in other genres, including crime drama in Catch Me If You Can (2002) and Gangs of New York (2002); the latter marked the first of his many successful collaborations with director Martin Scorsese. DiCaprio portrayed Howard Hughes in The Aviator (2004) and received acclaim for his performances in the political thriller Blood Diamond (2006), the crime drama The Departed (2006), and the romantic drama Revolutionary Road (2008).\n\nIn the following decade, DiCaprio starred in several high-profile directors\\\' projects, including the science fiction thriller Inception (2010), the western Django Unchained (2012), the biopic The Wolf of Wall Street (2013), the survival drama The Revenant (2015), for which he won an Academy Award and a BAFTA Award for Best Actor in a Leading Role, and the comedy-drama Once Upon a Time in Hollywood (2019), all of which were critical and commercial successes.\n\nDiCaprio is the founder of Appian Way Productions, a production company that has produced some of his films and the documentary series Greensburg (2008–2010), and the Leonardo DiCaprio Foundation, a nonprofit organization devoted to promoting environmental awareness. He regularly supports charitable causes and has produced several documentaries on the environment. In 2005, he was named a Commander of the Ordre des Arts et des Lettres for his contributions to the arts, and in 2016, he appeared in Time magazine\\\'s 100 most influential people in the world.', 153360000, 'Los Angeles, California, USA', '6193', 'leonardo-dicaprio', 'upload/images/5Brc5dLifH3UInk3wUaCuGXpCqy.jpg'),
(37, 'actor', 'Robert De Niro', 'Robert Anthony De Niro (born August 17, 1943) is an American actor. Known for his collaborations with Martin Scorsese, he is considered to be one of the best actors of his generation. De Niro is the recipient of various accolades, including two Academy Awards, a Golden Globe Award, the Cecil B. DeMille Award, and a Screen Actors Guild Life Achievement Award. In 2009, De Niro received the Kennedy Center Honor, and earned a Presidential Medal of Freedom from U.S. President Barack Obama in 2016.\n\nDe Niro studied acting at HB Studio, Stella Adler Conservatory, and Lee Strasberg\\\'s Actors Studio. His first collaboration with Scorsese was with the 1973 film Mean Streets. De Niro earned two Academy Awards, one for Best Supporting Actor for his role as Vito Corleone in Francis Ford Coppola\\\'s The Godfather Part II (1974) and the other for Best Actor portraying Jake LaMotta in Scorsese\\\'s drama Raging Bull (1980). His other Oscar-nominated roles were for Taxi Driver (1976), The Deer Hunter (1978), Awakenings (1990), Cape Fear (1991), and Silver Linings Playbook (2012).\n\nOther notable roles include in 1900 (1976), The King of Comedy (1982), Once Upon a Time in America (1984), Brazil (1985), The Mission (1986), Goodfellas (1990), This Boy\\\'s Life (1993), Mary Shelley’s Frankenstein (1994), Heat (1995), Casino (1995), Jackie Brown (1997), The Good Shepherd (2006), Joker (2019), and The Irishman (2019). He made his directorial film debut with A Bronx Tale (1993). His comedic roles include Midnight Run (1988), Wag the Dog (1997), Analyze This (1999), the Meet the Parents films (2000-2010), and The Intern (2015).\n\nAlso known for his television roles, De Niro portrayed Bernie Madoff in the HBO film The Wizard of Lies (2017), earning a Primetime Emmy Award for Outstanding Lead Actor in a Limited Series or Movie nomination. He received further Emmy Award nominations for producing the Netflix limited series When They See Us (2019), and for portraying Robert Mueller on Saturday Night Live.[1]\n\nDe Niro and producer Jane Rosenthal founded the film and television production company TriBeCa Productions in 1989, which has produced several films alongside his own. Also with Rosenthal, he founded the Tribeca Film Festival in 2002. Six of De Niro\\\'s films have been inducted into the United States National Film Registry by the Library of Congress as \\\"culturally, historically, or aesthetically significant\\\".\n\nFrom Wikipedia, the free encyclopedia.', -832377600, 'Greenwich Village, New York City, New York, USA', '380', 'robert-de-niro', 'upload/images/cT8htcckIuyI1Lqwt1CvD02ynTh.jpg'),
(38, 'actor', 'Lily Gladstone', 'Lily Gladstone (born August 2, 1986) is an American actress of Blackfeet and Nimíipuu heritage. She made her film debut in Jimmy P: Psychotherapy of a Plains Indian (2012), and went on to collaborate with filmmaker Kelly Reichardt in the independent films Certain Women (2016) and First Cow (2019). Her portrayal of a rancher in the former earned her a nomination for the Independent Spirit Award for Best Supporting Female.\n\nGladstone appeared in episodes of HBO\\\'s Room 104 (2017–2020), Showtime\\\'s Billions (2019–2023), and FX\\\'s Reservation Dogs (2021–2023). In 2023, she played a lead role in Martin Scorsese\\\'s drama film Killers of the Flower Moon.', 523324800, 'Kalispell, Montana, USA', '1183917', 'lily-gladstone', 'upload/images/suxRbQOSlPKMXZpgNCcc3UtW9DT.jpg'),
(39, 'actor', 'Jesse Plemons', 'Jesse Plemons (born April 2, 1988) is an American actor. He began his career as a child actor and achieved a breakthrough with his role as Landry Clarke in the NBC drama series Friday Night Lights (2006–2011). He subsequently portrayed Todd Alquist in season 5 of the AMC crime drama series Breaking Bad (2012–2013) and its sequel film El Camino: A Breaking Bad Movie (2019). For his role as Ed Blumquist in season 2 of the FX anthology series Fargo (2015), he received his first Primetime Emmy Award nomination and won a Critics\\\' Choice Television Award. He received a second Emmy nomination for his performance in \\\"USS Callister\\\", an episode of the Netflix anthology series Black Mirror (2017). Plemons received his third Emmy nomination for his supporting role in the HBO miniseries Love & Death (2023).\n\nPlemons has appeared in supporting roles in several films, including The Master (2012), Black Mass, Bridge of Spies (both 2015), Game Night, Vice (both 2018), The Irishman (2019), Judas and the Black Messiah, Jungle Cruise, and The Power of the Dog (all in 2021). He has also starred in the psychological thriller I\\\'m Thinking of Ending Things (2020). He was nominated for the Independent Spirit Award for Best Male Lead for his starring role in Other People (2016), and for his performance in The Power of the Dog, he was nominated for a BAFTA Award for Best Actor in a Supporting Role and the Academy Award for Best Supporting Actor.\n\nDescription above from the Wikipedia article Jesse Plemons, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 575942400, 'Dallas, Texas, USA', '88124', 'jesse-plemons', 'upload/images/bXkAPGVnf4j8fbCZ7DrWGkYOc5S.jpg'),
(40, 'actor', 'Tantoo Cardinal', 'Tantoo Cardinal CM is a Canadian actress of Cree and Métis heritage. With over 130 credits in 50 years, she\\\'s received numerous awards, including the Earle Grey Award, and in 2009, she was made a member of the Order of Canada \\\"for her contributions to the growth and development of Aboriginal performing arts in Canada, as a screen and stage actress, and as a founding member of the Saskatchewan Native Theatre Company.\\\"  She starred in Scorsese\\\'s \\\"Killers of the Flower Moon,\\\" and her upcoming projects include the Marvel Series \\\"Echo\\\" and the animated feature \\\"Wendell and Wild.\\\" Known for her work in Stumptown and 3 Pines, she has a rich history in films like \\\"Legends of the Fall,\\\" \\\"Dances with Wolves,\\\" and \\\"Wind River,\\\" and TV shows such as \\\"SEE,\\\" \\\"Westworld,\\\" and \\\"Frontier.\\\" Tantoo Cardinal has multiple honorary doctorates.', -613872000, 'Fort McMurray, Alberta, Canada', '7863', 'tantoo-cardinal', 'upload/images/rxhjfygJlPwztf36iRI7UDn5dr7.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(41, 'actor', 'John Lithgow', 'John Arthur Lithgow (born October 19, 1945) is an American actor. Prolific in films, television and on stage, Lithgow is the recipient of numerous accolades, including two Golden Globe Awards, six Primetime Emmy Awards, three Screen Actors Guild Awards, two Tony Awards and nominations for two Academy Awards and four Grammy Awards. He was inducted into the American Theater Hall of Fame and has received a star on the Hollywood Walk of Fame.\n\nLithgow studied at Harvard University winning a Fulbright scholarship and getting a chance to attend the London Academy of Music and Dramatic Art. From there he focused his training on the New York stage beginning a distinguished career on Broadway. In 1973, Lithgow received his first Tony Award for his performance in The Changing Room. In 1976 Lithgow acted alongside Meryl Streep in three plays 27 Wagons Full of Cotton, A Memory of Two Mondays and Secret Service. In the 1980s he continued to receive Tony Awards nominations for his performances in Requiem for a Heavyweight (1985) and M. Butterfly (1988). In 2002, Lithgow received his second Tony Award, this time for a musical, The Sweet Smell of Success and another nomination for Dirty Rotten Scoundrels (2005). In 2007, he made his Royal Shakespeare Company debut as Malvolio in Neil Bartlett\\\'s production of Twelfth Night. He has also appeared on Broadway in the acclaimed plays The Columnist (2012) and A Delicate Balance (2014). He portrayed Bill Clinton in Hillary and Clinton (2019) alongside Laurie Metcalf as Hillary Clinton.\n\nLithgow is also known for his television roles such as Dick Solomon in the sitcom 3rd Rock from the Sun (1996–2001) winning three Primetime Emmy Awards for Best Actor in a Comedy Series for his performance. He also played Arthur Mitchell in the drama Dexter (2009) and he won the Primetime Emmy Award for Outstanding Guest Actor in a Drama. In 2004, Lithgow played Blake Edwards in the HBO television movie, The Life and Death of Peter Sellers. He has also appeared on 30 Rock, How I Met Your Mother, Louie and Drunk History. Lithgow won great acclaim for his portrayal of Winston Churchill in Peter Morgan\\\'s historical drama The Crown (2016–2019) on Netflix. For acting in The Crown he won a Primetime Emmy Award and Screen Actors Guild Award. In 2020, he had a recurring role on the HBO period series Perry Mason.\n\nHe is also well known for his film roles. His early screen roles included Bob Fosse\\\'s All That Jazz (1979) and Brian De Palma\\\'s Blow Out (1981). He received his first Academy Award nomination for his breakout performance in The World According to Garp (1982) and received a second Academy Award nomination for Terms of Endearment (1983). He then starred in the films Footloose (1984), Harry and the Hendersons (1987), The Pelican Brief and Cliffhanger (1993), A Civil Action (1998), Rugrats in Paris: The Movie (2000), Shrek (2001), Kinsey (2004), Dreamgirls (2006), Love Is Strange (2014), Miss Sloane (2016) and Beatriz at Dinner (2017). In 2019 he appeared in Mindy Kaling\\\'s comedy Late Night and portrayed Roger Ailes in Bombshell.\n\nDescription above from the Wikipedia article John Lithgow, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -763776000, 'Rochester, New York, USA', '12074', 'john-lithgow', 'upload/images/8Y1sjBdnVR483S8PrnAQzlESwhx.jpg'),
(42, 'actor', 'Brendan Fraser', 'Brendan James Fraser (born December 3, 1968) is a Canadian-American actor. Having graduated from the Cornish College of the Arts in 1990, he made his film debut in Dogfight (1991). Fraser had his breakthrough in 1992 with the comedy Encino Man and the drama School Ties. He gained further prominence for his starring role in George of the Jungle (1997) and emerged a star playing Rick O\\\'Connell in The Mummy trilogy (1999–2008). He took on dramatic roles in Gods and Monsters (1998), The Quiet American (2002), and Crash (2004), and further fantasy roles in Bedazzled (2000) and Journey to the Center of the Earth (2008).\n\nFraser\\\'s film work slowed from the late 2000s to mid 2010s due to various health problems and fallout from a reported 2003 sexual assault by Philip Berk, the then-president of the Hollywood Foreign Press Association. He branched into television with roles in the Showtime drama The Affair (2016–2017), the FX series Trust (2018), and the HBO Max series Doom Patrol (2019–2023). Fraser\\\'s film career was revitalized by appearances in auteur-directed films such as Steven Soderbergh\\\'s No Sudden Move (2021) and Darren Aronofsky\\\'s The Whale (2022). His starring role in the latter won him the Academy Award for Best Actor, becoming the first Canadian winner', -34041600, 'Indianapolis, Indiana, USA', '18269', 'brendan-fraser', 'upload/images/tFj5PaWWQbb8rHBBhu1EHklznph.jpg'),
(43, 'actor', 'Cara Jade Myers', 'A member of the Wichita tribe, Myers was born in Phoenix, Arizona. Influenced by the arts from a young age, her grandfather, Bobby Hill, was a well-known painter who worked under the name White Buffalo and her grandmother was an acclaimed beader whose work has been displayed in the Smithsonian. Myers was raised in Prescott Valley where she had an innate love for bringing characters to life, and in her early twenties began taking acting courses driving over four hours a day to class, which she now says prepared her for the traffic in L.A.\n\nIn 2011 she made the move to southern California, where she began to hone her craft in writing. She was accepted into the 4th Annual Native American Writers Lab, and that same year was a semi-finalist in the ABC/Disney writers program. In 2020 Myers was one of twelve writers selected as a part of A3 Artist Agency\\\'s The Colony program, creating a television pilot which is now in production. She finished the year as a Fellow of the Native American Feature Film Writers\\\' Lab. Recent credits for Myers include roles on NBC\\\'s award-winning series \\\"This Is Us,\\\" and \\\"Rutherford Falls.\\\"\n\nCurrent writing projects include two scripts that are in development, a documentary that is in production and one feature in preproduction. In addition to her work in film and television, Myers is passionate about helping others, and created CRASH Cares whose main focus is to create care packages for the homeless in Hollywood. She currently lives in Los Angeles with her husband Josh and their pup.', 494467200, 'Phoenix, Arizona, United States', '3006897', 'cara-jade-myers', 'upload/images/5oHV0iqIja1qmX5cKyQHWA0eVXB.jpg'),
(44, 'actor', 'JaNae Collins', 'JaNae is a Dakota/Crow actress enrolled in the Fort Peck reservation in Montana. The product of an esteemed Dakota/Lakota clinical psychologist mother and prolific Crow stuntman father, JaNae is an avid scuba diver and lane splitting motorcyclist. Before moving out to L.A. JaNae studied acting at UNM with Paul Ford before booking her first union speaking role on the season one finale episode of Longmire in 2012.', 567993600, 'Helena, Montana, United States', '3006898', 'janae-collins', 'upload/images/kXJ0qGCyfzJt34yQ7o6wtTXIZc3.jpg'),
(45, 'actor', 'Jillian Dion', 'Jillian Dion is a Canadian born actress based in Vancouver, British Columbia. Originally from Alberta, She is of Plains Cree, Metis and French Canadian descent, adopted and raised in a Dene/Metis household learning about and practicing the languages and traditions from an early age. She discovered acting through an open casting call in Albuquerque, NM while attending the Gathering of nations at age 18, first appearing in the mini-series Into the West.', 0, '', '2698946', 'jillian-dion', 'upload/images/uy1lrfPkFOvnrH9pvtA4MYm2JAy.jpg'),
(46, 'actor', 'Jason Isbell', 'Jason Isbell (born February 1, 1979) is an American singer-songwriter and actor. Isbell has won four Grammy Awards.', 286675200, 'Green Hill, Alabama, USA', '1310349', 'jason-isbell', 'upload/images/2SU5ZCaLd82DYR6autpT00QIbmM.jpg'),
(47, 'director', 'Martin Scorsese', 'Tantoo Cardinal CM is a Canadian actress of Cree and Métis heritage. With over 130 credits in 50 years, she\\\'s received numerous awards, including the Earle Grey Award, and in 2009, she was made a member of the Order of Canada \\\"for her contributions to the growth and development of Aboriginal performing arts in Canada, as a screen and stage actress, and as a founding member of the Saskatchewan Native Theatre Company.\\\"  She starred in Scorsese\\\'s \\\"Killers of the Flower Moon,\\\" and her upcoming projects include the Marvel Series \\\"Echo\\\" and the animated feature \\\"Wendell and Wild.\\\" Known for her work in Stumptown and 3 Pines, she has a rich history in films like \\\"Legends of the Fall,\\\" \\\"Dances with Wolves,\\\" and \\\"Wind River,\\\" and TV shows such as \\\"SEE,\\\" \\\"Westworld,\\\" and \\\"Frontier.\\\" Tantoo Cardinal has multiple honorary doctorates.', -613872000, 'Fort McMurray, Alberta, Canada', '7863', 'martin-scorsese', 'upload/images/9U9Y5GQuWX3EZy39B8nkk4NY01S.jpg'),
(48, 'actor', 'Pedro Pascal', 'José Pedro Balmaceda Pascal (born April 2, 1975) is a Chilean-American actor. After nearly two decades of taking small roles in film and television, Pascal rose to prominence for portraying Oberyn Martell during the fourth season of the HBO fantasy series Game of Thrones (2014) and as Javier Peña in the Netflix crime series Narcos (2015–2017). Since 2019, he has starred as the title character in the Disney+ Star Wars series The Mandalorian and reprised his role in the spin-off series The Book of Boba Fett (2021). Since 2023, he has played Joel in the HBO drama series The Last of Us.\n\nHe has appeared in the films The Adjustment Bureau (2011), The Great Wall (2016), Kingsman: The Golden Circle (2017), The Equalizer 2 (2018), Triple Frontier (2019), Wonder Woman 1984 (2020), and The Unbearable Weight of Massive Talent (2022).', 165628800, 'Santiago, Chile', '1253360', 'pedro-pascal', 'upload/images/nms0d0ExYtiOke82oqr3vOb3smF.jpg'),
(49, 'actor', 'Bella Ramsey', 'Isabella May Ramsey (born September 2003) is an English actor. They are known for their breakout role as young noblewoman Lyanna Mormont in the HBO fantasy television series Game of Thrones (2016–2019), and subsequent television roles as Mildred Hubble in the 2017 CBBC series The Worst Witch, the voice of the title character in the Netflix animated series Hilda (2018–present –  as of 2023), and Jane Grey in the 2022 Starz drama Becoming Elizabeth.\n\nThey starred in the 2022 historical comedy film Catherine Called Birdy and currently stars as Ellie in the 2023 HBO drama series The Last of Us.', 1064880000, 'Nottingham, England, UK', '1668004', 'bella-ramsey', 'upload/images/1bKfKw22NRTOULz3ZZlT03ynUgB.jpg'),
(50, 'actor', 'Anna Torv', 'Anna Torv (born 7 June 1979) is an Australian actress. She is known for her roles as Olivia Dunham on the Fox science fiction series Fringe (2008–2013), Wendy Carr in the Netflix crime thriller series Mindhunter (2017–2019), and Tess in the HBO post-apocalyptic drama series The Last of Us (2023). Her performance in Fringe earned her four Saturn Awards for Best Actress on Television and nominations for the Critics\\\' Choice Television Award for Best Actress in a Drama Series.', 297561600, 'Melbourne, Victoria, Australia', '30084', 'anna-torv', 'upload/images/muZIxj33R2EEJhm28c9hBd0AiRk.jpg'),
(51, 'actor', 'Lamar Johnson', 'Lamar Johnson is a Canadian film and television actor, dancer and choreographer, best known from the television series \\\"The Next Step\\\".', 774489600, 'Toronto, Ontario, Canada', '1397605', 'lamar-johnson', 'upload/images/4IEsKiSsyckleKsPsiIVtAh6QDy.jpg'),
(52, 'actor', 'Jeffrey Pierce', 'Jeffrey Pierce (born Jeffrey Plitt; December 13, 1971, in Denver, Colorado, United States, is an American actor, film director and film producer. He is best known for portraying the titular character in the television series Charlie Jade.\n\nHe got his start in acting at the Shakespeare and Company in Lenox, Massachusetts, and at the Beverly Hills Playhouse. He also directed and executive produced a film called All My Sins Remembered.', 61430400, 'Denver, Colorado, USA', '82821', 'jeffrey-pierce', 'upload/images/nTttkQ9Q28WUccRXASMR6ERll3j.jpg'),
(53, 'actor', 'Keivonn Woodard', '', NULL, '', '3907669', 'keivonn-woodard', 'upload/images/w4gTsxfzUxJAaE70lduosYBCKR8.jpg'),
(54, 'actor', 'Samuel Hoeksema', 'Samuel Hoeksema is a Canadian actor.', NULL, 'Calgary, Alberta, Canada', '1151408', 'samuel-hoeksema', 'upload/images/6TEscmA3aFBkdWX2DuozcUhHkBK.jpg'),
(55, 'actor', 'Olivier Ross-Parent', '', NULL, '', '2081561', 'olivier-ross-parent', 'upload/images/9tFTbsfko6zKcrb9ZBXEPG3QIKK.jpg'),
(56, 'actor', 'John Getz', '​John Getz is a stage-trained American actor. Getz dropped out of college to attend the American Conservatory Theater in San Francisco. While working in a winery, he helped found the Theater Company in Napa County, California. His location in the grape-growing Napa Valley led to Getz\\\'s television debut in a made-for-television horror film Killer Bees. Killer Bees starred Gloria Swanson, Craig Stevens, Kate Jackson, and Edward Albert. Getz then moved to New York City, where he became active in local theater while doing an 18-month stint as Neil Johnson on the soap opera Another World.\n\nGetz appeared in The Happy Hooker and followed up with several other roles before starring in the Coen Brothers\\\' neo-noir thriller Blood Simple. He played the doomed lover of a married woman (Frances McDormand) who woefully misinterprets his increasingly complex circumstances.\n\nGetz also appeared in The Fly and The Fly II as Stathis Borans, a science magazine editor who pays a heavy price for his curiosity. Also in 1989, he played a Marine Corps Major in Born on the Fourth of July. In 1991, Getz appeared as the unpleasant boyfriend of professional women in Don\\\'t Tell Mom the Babysitter\\\'s Dead and Curly Sue. In 1990, Getz appeared as a crime boss in the Charlie Sheen and Emilio Estevez spoof Men At Work. In 1994, he appeared in the film Playmaker, starring Colin Firth and Jennifer Rubin.\n\nIn 2007, he had a role in David Fincher\\\'s film Zodiac. Also in 2007, he appeared in Bill Guttentag and Dan Sturman\\\'s documentary film Nanking as George Ashmore Fitch, head of the local YMCA and administrative director of the International Committee for the Nanking Safety Zone. Getz also had a role in Fincher\\\'s film The Social Network, about the founding of Facebook. He appeared in the suspense thriller Elevator as a Wall Street executive trapped in an elevator with a group of strangers, one of whom has a bomb. Written and produced by Marc Rosenberg and directed by Stig Svendsen, Elevator was released in July 2012. He appeared in Trumbo (2015) as director Sam Wood.\n\nThrough the decades, Getz has guest-starred in many television series, including Barney Miller and Three\\\'s Company, where he played Lee Tripper, brother of Jack Tripper. He has guest-starred in How I Met Your Mother, Prison Break, The King of Queens and Private Practice, and had recurring roles in Homeland, Timeless and Bosch.\n\nDescription above from the Wikipedia article John Getz, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -732585600, 'Davenport, Iowa, U.S.', '20211', 'john-getz', 'upload/images/NL52y1nH5SZMlJKfKpPBnofoJk.jpg'),
(57, 'actor', 'Gabriel Luna', 'Gabriel Isaac Luna (born December 5, 1982) is an American actor. He is best known for his leading roles as Tony Bravo on the El Rey Network action drama series Matador (2014) and Paco Contreras on ABC\\\'s crime drama series Wicked City (2015). On film, he has starred in the black comedy Bernie (2011), the sports comedy Balls Out (2014), the drama Freeheld (2015), the horror comedy Gravy (2015), and the thriller Transpecos (2016). In 2016, he joined the cast of Marvel\\\'s Agents of S.H.I.E.L.D. as Robbie Reyes / Ghost Rider.', 407894400, 'Austin, Texas, USA', '111016', 'gabriel-luna', 'upload/images/wZ39o38IaEJIfQglF5ovI7lO3ba.jpg'),
(58, 'actor', 'Merle Dandridge', 'From Wikipedia, the free encyclopedia\n\nMerle Dandridge is a Japanese-American actress who was born in Okinawa, Japan. Dandridge is primarily a stage actress, but has had several roles in television. She has gained a wider audience as the voice of Alyx Vance in the award-winning action game Half-Life 2 and its sequels, Episode One, Episode Two.\n\nHer father was an African-American US serviceman from Memphis and her mother was a local Okinawan of Korean and Japanese descent. As well as Okinawa, Dandridge has lived in Sacramento, California, at Beale Air Force Base, and later at Offutt Air Force Base (home to the then-Strategic Air Command) in Bellevue, Nebraska, where she spent the majority of her childhood. She attended Papillion La Vista High School and participated in the play production class and theater department there.\n\nShe then attended the Theatre Conservatory at Roosevelt University (currently called the Chicago College of Performing Arts) with a scholarship that she earned at the International Thespian Festival.', 170726400, 'Okinawa - Japan', '1253388', 'merle-dandridge', 'upload/images/qoPX7VpSPl4GVuwnBPdfJ39Jt46.jpg'),
(59, 'actor', 'Nico Parker', 'Nico Parker is the youngest daughter of Thandie Newton and Ol Parker and is an actor, known for Dumbo (2019).', 1103068800, '', '2064124', 'nico-parker', 'upload/images/oqUqL0nJiHIpIHXlLdJytliXXmA.jpg'),
(60, 'actor', 'Melanie Lynskey', 'Melanie Jayne Lynskey (born May 16, 1977) is a New Zealand actress. Known for her portrayals of complex women and her command of American dialects, she works predominantly in independent films. Lynskey is the recipient of two Critics\\\' Choice Awards, a HCA Award, a Gracie, a New Zealand Film Award, a Hollywood Film Award, and a Sundance Special Jury Award, as well as Gotham, Satellite, Saturn, Golden Nymph, Independent Spirit, Screen Actors Guild, and Primetime Emmy Award nominations.\n\nDescription above from the Wikipedia article Melanie Lynskey, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 232588800, 'New Plymouth, Taranaki, New Zealand', '15091', 'melanie-lynskey', 'upload/images/4raNiD71caQXKKqIBZS1FDsvtkd.jpg'),
(61, 'actor', 'John Hannah', 'John Hannah (born April 23, 1962) is a Scottish actor of film and television. He has appeared in Stephen Sommers Mummy Series, Richard Curtis Four Weddings and a Funeral and Sliding Doors with Gwyneth Paltrow.\n\nJohn David Hannah was born on April 23, 1962, in East Kilbride, South Lanarkshire, Scotland. Raised in a working-class family, Hannah developed an early interest in acting and the arts. He attended Heathfield Primary School and Claremont High School, where his passion for drama began to flourish.\n\nAfter completing his secondary education, Hannah enrolled at the Royal Scottish Academy of Music and Drama (now known as the Royal Conservatoire of Scotland) in Glasgow. His time at the academy laid the foundation for his acting career, and he graduated with honors.\n\nJohn Hannah\\\'s acting career took off in the late 1980s and early 1990s with notable stage performances, including roles with the Royal Shakespeare Company. His breakthrough on the big screen came with the critically acclaimed film \\\"Four Weddings and a Funeral\\\" (1994), where he played the endearing and scene-stealing character, Matthew. The film\\\'s success catapulted Hannah into international recognition.\n\nFollowing his success in \\\"Four Weddings and a Funeral,\\\" John Hannah continued to build a diverse and impressive filmography. He starred in films such as \\\"Sliding Doors\\\" (1998), \\\"The Mummy\\\" (1999), and its sequel \\\"The Mummy Returns\\\" (2001), gaining popularity for his charismatic and versatile performances. Additionally, he showcased his talent in television, earning praise for his roles in series like \\\"Rebus\\\" and \\\"Spartacus.\\\"\n\nBeyond the screen, John Hannah maintains a private personal life. In 1996, he married actress Joanna Roth, and the couple has two children. Despite his fame, Hannah remains known for his down-to-earth demeanor and commitment to his craft.\n\nJohn Hannah\\\'s career spans across genres, from romantic comedies to action-adventure and dramatic television series. His ability to portray a wide range of characters has solidified his status as a respected and versatile actor in the entertainment industry.', -242784000, 'East Kilbride, Scotland, UK', '10727', 'john-hannah', 'upload/images/8GzJhaZrChZpv84SU4vAsvsR3cl.jpg'),
(62, 'actor', 'Josh Brener', 'Joshua Max Brener is an American actor. He played the roles of Kyle on the IFC series \\\"Maron\\\" and Nelson Big Head Bighetti on the HBO series \\\"Silicon Valley\\\". In animation, he provides the voices of Donatello on \\\"Rise of the Teenage Mutant Ninja Turtles\\\", Neeku Vozo on \\\"Star Wars Resistance\\\" and Dylan Dalmatian on \\\"101 Dalmatian Street.\\\"', 465436800, 'Houston, Texas, USA', '1180979', 'josh-brener', 'upload/images/sIyQYq2imu1V2RxRQ1zp70RSqTi.jpg'),
(63, 'actor', 'Christopher Heyerdahl', 'Christopher Heyerdahl is a Canadian actor.', -198460800, 'British Columbia, Canada', '32887', 'christopher-heyerdahl', 'upload/images/pTPZa3TFIkxRbqM5adXYE51a99s.jpg'),
(64, 'actor', 'Brad Leland', 'Graduated with a Bachelors Degree in Acting and Directing from Texas Tech University. Owns Turnkey Productions II, a full-service production company specializing in events, festivals, and shows of all types. An avid golfer and sports enthusiast, he is loyal to the Plano Wildcats(where he was a member of the State Champion football team in 1972), the Texas Tech Red Raiders, and the Dallas Cowboys. Began performing at the Crazy Horse Saloon in Disneyland in 1959 after returning from Japan with his parents, Bill and Shirley Williams.\n\nBrad is an avid golfer and enjoys supporting the annual \\\"Beyond the Lights\\\" Celebrity Golf Classic held in Austin, Texas, to help those with spinal cord injuries.\n\nWife\\\'s name is Freda, who is also an actor, has two daughters, Thea and Leah.\n\n- IMDb Mini Biography By: Brad Williams', -482716800, 'Lubbock - Texas - USA', '60677', 'brad-leland', 'upload/images/3jWExZ1SpkMvZtZiKnfiH3HCfSp.jpg'),
(65, 'actor', 'Marcia Bennett', '', NULL, 'Evansville, Indiana, USA', '40385', 'marcia-bennett', 'upload/images/va30xYbQLgI9UvNFv5oNuhiORTC.jpg'),
(66, 'actor', 'Brendan Fletcher', 'Brendan Fletcher (born December 15, 1981) is a Canadian actor.', 377222400, 'Comox Valley, British Columbia, Canada', '32205', 'brendan-fletcher', 'upload/images/dSXct01FSuMQmuTt2PuBlV4veTY.jpg'),
(67, 'actor', 'Jerry Wasserman', '', -762566400, 'Cincinnati, Ohio, USA', '21091', 'jerry-wasserman', 'upload/images/sDxJx0ijIuI0Hfwq4KL5kVfAiBN.jpg'),
(68, 'actor', 'Wendy Gorling', '', NULL, '', '3875019', 'wendy-gorling', 'upload/images/bm9kCJzFiOfiA9Tv84eKocvgS97.jpg'),
(69, 'actor', 'Sandra Hüller', 'Sandra Hüller (born 30 April 1978) is a German actress. She gained critical praise for her portrayal of Anneliese Michel in Hans-Christian Schmid\\\'s 2006 drama Requiem, for which she won the Silver Bear for Best Actress at the 2006 Berlin Film Festival, and is best known internationally for her starring role in Maren Ade\\\'s 2016 comedy Toni Erdmann, for which she won the European Film Award for Best Actress. She has received six nominations for the German Film Award and won three times.  Hüller has starred in German, Austrian, American, British and French films.\n\nIn 2023, Hüller starred in two award-winning films that premiered in the main competition of the Cannes Film Festival: the French courtroom drama Anatomy of a Fall by Justine Triet, which won the Palme d’Or, and Jonathan Glazer’s Holocaust drama The Zone of Interest, which won the Grand Prix.\n\nDescription above from the Wikipedia article Sandra Hüller, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 262742400, 'Suhl, Germany', '7152', 'sandra-huller', 'upload/images/t7wGqC2dRwTEnt9Fk5pxQ0uXTqs.jpg'),
(70, 'actor', 'Swann Arlaud', 'Swann Arlaud (born 30 November 1981) is a French actor.\n\nDescription above from the Wikipedia article Swann Arlaud, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 375926400, 'Fontenay-aux-Roses, Hauts-de-Seine, France', '145120', 'swann-arlaud', 'upload/images/AmpQP3gBIhHEluqj9ziTGYxH3l9.jpg'),
(71, 'actor', 'Milo Machado-Graner', '', 0, '', '3302971', 'milo-machado-graner', 'upload/images/wdpeIXaFvSSAJq88dv6Ofzgscd7.jpg'),
(72, 'actor', 'Antoine Reinartz', '', 473385600, 'Nomeny, Meurthe-et-Moselle, France', '1795152', 'antoine-reinartz', 'upload/images/20zZ17vGbtXgWsJV8HGw1GdihVb.jpg'),
(73, 'actor', 'Saadia Bentaïeb', '', 0, 'France', '1613123', 'saadia-bentaieb', 'upload/images/tQXSCqgjJdAC9eXrnjZ4BFJWSr7.jpg'),
(74, 'actor', 'Jehnny Beth', 'Jehnny Beth (born on December 24, 1984) is an actress, singer and composer, known for Ex Machina (2014), Stranger (2023) and An Impossible Love (2018).', 472694400, 'Poitiers, Vienne, France', '1029285', 'jehnny-beth', 'upload/images/lxtqgBjPbTNP3EFZh3bxk3Ox9Pa.jpg'),
(75, 'actor', 'Samuel Theis', '', 279676800, '', '1312061', 'samuel-theis', 'upload/images/5sPD9wpbh4h4iwzlg4XzYrmYxTN.jpg'),
(76, 'actor', 'Camille Rutherford', '', 212025600, 'Paris, France', '1033745', 'camille-rutherford', 'upload/images/8Iq8Gi1YsGNQ3gnxaVptXj68zVY.jpg'),
(77, 'actor', 'Anne Rotger', '', 0, '', '2670733', 'anne-rotger', 'upload/images/9WBVqqyR1k85HOtFIUpJ8ziAqhq.jpg'),
(78, 'actor', 'Sophie Fillières', '', -162950400, 'Paris, France', '233491', 'sophie-fillieres', 'upload/images/qAHHQxhkMQHoKZckVImG3AIYkE0.jpg'),
(79, 'actor', 'Arthur Harari', '', 347155200, 'Paris, France', '1175622', 'arthur-harari', 'upload/images/pVFeMNAp2Hx5zN6KlWuiFhJpdiK.jpg'),
(80, 'director', 'Justine Triet', 'Jehnny Beth (born on December 24, 1984) is an actress, singer and composer, known for Ex Machina (2014), Stranger (2023) and An Impossible Love (2018).', 472694400, 'Poitiers, Vienne, France', '1029285', 'justine-triet', 'upload/images/mOn5lo038i8vw6qqJTwKw35KCL7.jpg'),
(81, 'actor', 'Shameik Moore', 'Shameik Alti Moore (born May 4, 1995) is an American actor, singer, and rapper, of Jamaican descent.\n\nHe started off with bit roles on shows such as Tyler Perry\\\'s House of Payne, Reed Between the Lines, and Joyful Noise. In 2013, he had his first main television role on the sketch-comedy series Incredible Crew, which aired on Cartoon Network before being cancelled after one season.\n\nHe then gained recognition with his portrayal of Malcolm in the 2015 film Dope, which premiered at the 2015 Sundance Film Festival. Indiewire included Moore on its list of \\\"The 12 Major Breakouts of the 2015 Sundance Film Festival\\\" for his performance in the movie.\n\nHe is also one of the five male leads in the Netflix series The Get Down, which premiered in 2016 and was cancelled in 2017 after one half-season. He voiced Miles Morales in the animated film Spider-Man: Into the Spider-Verse from Sony Pictures Animation, which was released in December 2018.', 799545600, 'Atlanta, Georgia, USA', '587506', 'shameik-moore', 'upload/images/uJNaSTsfBOvtFWsPP23zNthknsB.jpg'),
(82, 'actor', 'Hailee Steinfeld', 'Hailee Steinfeld (born December 11, 1996) is an American actress and singer. Known for her acting versatility and musical prowess, she is the recipient of various accolades, including a Peabody Award, a Critics\\\' Choice Movie Award, a Billboard Music Award, and nominations for an Academy Award, a British Academy Film Award, a Golden Globe Award, three Critics\\\' Choice Movie Awards and a Screen Actors Guild Award.\n\nShe had her breakthrough with the western drama film True Grit (2010), which earned her Academy Award and Screen Actors Guild Award nominations for Best Supporting Actress, and a BAFTA Award nomination for Best Actress. Steinfeld then rose to mainstream prominence for her lead roles in Ender\\\'s Game (2013), Romeo & Juliet (2013), Begin Again (2013), and 3 Days to Kill (2014). She received critical acclaim for her roles in the Pitch Perfect film series (2015–2017) and the coming-of-age comedy-drama film The Edge of Seventeen (2016), the latter of which earned her a Golden Globe Award and Critics\\\' Choice Movie Award nomination.\n\nSteinfeld has since provided the voice of Gwen Stacy / Spider-Woman in the animated film Spider-Man: Into the Spider-Verse (2018) and Vi in Netflix\\\'s animated TV series Arcane (2021–present), based on the League of Legends video game franchise. She also starred as Charlie Watson in the Transformers film Bumblebee (2018) and Emily Dickinson in the Apple TV+ comedy-drama series Dickinson (2019–2021). She played Kate Bishop / Hawkeye, appearing in the 2021 Disney+ series Hawkeye, set in the Marvel Cinematic Universe.\n\nSteinfeld gained recognition in music after performing \\\"Flashlight\\\" in Pitch Perfect 2 (2015). She signed with Republic Records soon after and released her debut single, \\\"Love Myself\\\", followed by her debut extended play Haiz (2015). She went on to release a series of successful singles, including \\\"Starving\\\", \\\"Most Girls\\\" and \\\"Let Me Go\\\". In 2020, she released her second extended play, Half Written Story.\n\nDescription above from the Wikipedia article Hailee Steinfeld, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 850262400, 'Tarzana - Los Angeles - California - USA', '130640', 'hailee-steinfeld', 'upload/images/6aBclBl8GMcxbxr6XcwSGg3IBea.jpg'),
(83, 'actor', 'Jason Schwartzman', 'Jason Francesco Schwartzman (born June 26, 1980) is an American actor and musician.\n\nSchwartzman made his film debut in Wes Anderson\\\'s 1998 film Rushmore, and has gone on to appear in seven other Anderson films: The Darjeeling Limited (2007), Fantastic Mr. Fox (2009), Moonrise Kingdom (2012), The Grand Budapest Hotel (2014), Isle of Dogs (2018), The French Dispatch (2021), and Asteroid City (2023). His other film roles include Spun (2003), I Heart Huckabees (2004), Marie Antoinette (2006), Klaus (2019), and Spider-Man: Across the Spider-Verse (2023). Schwartzman starred in the television series Bored to Death (2009–11) and appeared in the fourth season of the FX anthology series Fargo (2020). He was an executive producer on the Amazon Prime show Mozart in the Jungle (2014–18), a series he also acted in.\n\nSchwartzman has released three albums through his solo project Coconut Records, having previously been drummer in the rock band Phantom Planet.', 330825600, 'Los Angeles, California, USA', '17881', 'jason-schwartzman', 'upload/images/gCjMdmW1DiPAClHVl4zHEIffIsE.jpg'),
(84, 'actor', 'Oscar Isaac', 'Óscar Isaac Hernández Estrada (born March 9, 1979) is an American actor. After making his acting debut in the late 1990s, he studied acting at the Juilliard School and played small roles for a majority of the 2000s. For portraying José Ramos-Horta in the Australian film Balibo (2006), Isaac won the AACTA Award for Best Actor in a Supporting Role. Following supporting roles in major films such as Body of Lies (2008), Robin Hood (2010) and Drive (2011), Isaac had his breakthrough with the starring role of a singer in the Coen brothers\\\' black comedy Inside Llewyn Davis (2013), earning a nomination for a Golden Globe Award.\n\nIsaac\\\'s career progressed with leading roles in the crime drama A Most Violent Year (2014), the thriller Ex Machina (2015), and the superhero film X-Men: Apocalypse (2016). He became a global star with his starring role as Poe Dameron in the Star Wars sequel trilogy (2015–2019). He has since starred in the science fiction films Annihilation (2018) and Dune (2021), and the crime drama The Card Counter (2021).\n\nOn television, Isaac has starred in the HBO miniseries Show Me a Hero (2015) and Scenes from a Marriage (2021), winning the Golden Globe Award for Best Actor – Miniseries or Television Film for portraying Nick Wasicsko in the former. In 2022, he began starring as the Marvel Cinematic Universe character Moon Knight in the Disney+ series Moon Knight (2022).\n\nDescription above from the Wikipedia article Oscar Isaac, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 289785600, 'Guatemala City, Guatemala', '25072', 'oscar-isaac', 'upload/images/dW5U5yrIIPmMjRThR9KT2xH6nTz.jpg'),
(85, 'actor', 'Brian Tyree Henry', 'Brian Tyree Henry (born March 31, 1982) is an American actor. He is best known for his role as Alfred \\\"Paper Boi\\\" Miles in the FX comedy-drama series Atlanta (2016–2022), for which he received a Primetime Emmy Award nomination for Outstanding Supporting Actor in a Comedy Series. He is also known for his performances in Boardwalk Empire, How to Get Away with Murder, and This Is Us.\n\nHenry made his film breakthrough in 2018 with starring roles in Steve McQueen\\\'s heist film Widows, Barry Jenkins\\\' romantic drama film If Beale Street Could Talk, and the animated superhero film Spider-Man: Into the Spider-Verse. He\\\'s since appeared in Joker (2019), Godzilla vs. Kong (2021), The Woman in the Window (2021), and Bullet Train (2022). He portrayed Phastos in the Marvel Cinematic Universe film Eternals (2021). In 2022, he starred in Causeway (2022) which earned him a nomination for an Academy Award for Best Supporting Actor.\n\nHe has also appeared on stage, making his debut performance in the Shakespeare in the Park production of Romeo and Juliet (2007), and acting in various plays at the Public Theatre, before appearing in the original Broadway cast of The Book of Mormon (2011). In 2014 he appeared in the off-Broadway musical The Fortress of Solitude. For his performance in the 2018 Broadway revival of Kenneth Lonergan\\\'s play Lobby Hero, he received a Tony Award nomination for Best Featured Actor in a Play.', 386380800, 'Fayetteville, North Carolina, USA', '226366', 'brian-tyree-henry', 'upload/images/1UgDnFt3OteCJQPiUelWzIR5bvT.jpg'),
(86, 'actor', 'Luna Lauren Velez', 'Lauren Vélez (born November 2, 1964) is an American actress of Puerto Rican descent and the twin sister of actress Lorraine Vélez. Her most notable roles are as Maria LaGuerta on Dexter, Detective Nina Moreno on Fox\\\'s New York Undercover, and Dr. Gloria Nathan on HBO\\\'s controversial jail drama, Oz.\n\nDescription above from the Wikipedia article Lauren Vélez, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -162950400, 'Brooklyn, New York City, New York, USA', '141610', 'luna-lauren-velez', 'upload/images/98BvmTJCZHx0jPv0oNcv04Jkmfb.jpg'),
(87, 'actor', 'Jake Johnson', 'Jake Johnson (born May 28, 1978) is an American actor and comedian. He is best known for his role as Nick Miller on the Fox television sitcom New Girl (2011-2018).', 265161600, 'Evanston, Illinois, USA', '543505', 'jake-johnson', 'upload/images/cRguohxju2P3dyfNSsIJjCkpOiV.jpg'),
(88, 'actor', 'Issa Rae', 'Jo-Issa Rae Diop, known as Issa Rae (born January 12, 1985), is an American actress, writer, director, producer, and web series creator. She first garnered attention for her work on the YouTube web series Awkward Black Girl. Since then, she has been known for her roles in the TV show \\\'Insecure\\\' (2016-2021) and films such as \\\'The Hate U Give\\\' (2018) and \\\'Barbie\\\' (2023).\n\nHer father is Senegalese.', 474336000, 'Los Angeles, California, USA', '1455336', 'issa-rae', 'upload/images/1tX1T5ZNCMh2KYP1jMgfg8P26vm.jpg'),
(89, 'actor', 'Karan Soni', 'Born in India, Karan Soni moved to the United States to study business at the University of Southern California. A career in acting instead followed, with Soni achieving prominence for his turn as unstable cab driver Dopinder in the superhero film Deadpool (2016) and its 2018 sequel. He has frequently appeared in comedic roles, including the films Goosebumps (2015), Ghostbusters (2016), Office Christmas Party (2016), Rough Night (2017), Pokémon Detective Pikachu (2019) and Trolls World Tour (2020). On television, he portrayed the lead in Betas and (2013) and Other Space (2015) and currently stars on the anthology series Miracle Workers (2019–present).', 600220800, 'Nuova Delhi, India', '1109702', 'karan-soni', 'upload/images/hkyWd9bcuOqUAUepOJLE47izTWR.jpg'),
(90, 'actor', 'Shea Whigham', 'Franklin Shea Whigham Jr. (born January 5, 1969) is an American actor. He portrayed Elias \\\"Eli\\\" Thompson in the HBO drama series Boardwalk Empire, and had notable supporting roles in films Kong: Skull Island, Death Note, Take Shelter, and the first season of True Detective, the third season of Fargo, and Joker. He appeared as Agent Michael Stasiak in Fast & Furious and Fast & Furious 6.\n\nIn 2020 he was cast as Pete Strickland on HBO\\\'s reimagining of Perry Mason, a role for which he received attention for his moustache.\n\nDescription above from the Wikipedia article Shea Whigham, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -31190400, 'Tallahassee, Florida, USA', '74242', 'shea-whigham', 'upload/images/d3caK3l4UfbnzOxv95wLoFLZzMO.jpg'),
(91, 'director', 'Joaquim Dos Santos', 'Jharrel Jerome is an actor, known for Moonlight (2016), First Match (2018) and Monster (2017).', 876355200, 'The Bronx, New York City, New York, USA', '1664716', 'joaquim-dos-santos', 'upload/images/w45GPb3cW6TqPw4FxB5Hc6zzAwx.jpg'),
(92, 'director', 'Justin K. Thompson', '', 0, '', '932639', 'justin-k-thompson', 'upload/images/mRMi8Q2fmlfbDYkE7A63gzFtGsZ.jpg'),
(93, 'actor', 'Alma Pöysti', 'Alma Pöysti (Finnish: [ˈɑlmɑ ˈpøy̯sti]; born March 16, 1981) is a Swedish-speaking Finnish actor. She is the daughter of director Erik Pöysti and granddaughter of Finnish actors Lasse Pöysti and Birgitta Ulfsson. Pöysti has also lived and worked in Sweden.', 353548800, 'Helsinki, Finland', '1364782', 'alma-poysti', 'upload/images/7sXRLYFR6kuAasqNkw4pEb6R88W.jpg'),
(94, 'actor', 'Jussi Vatanen', 'Jussi Vatanen was born on January 30, 1978 in Sonkajärvi, Finland. He is an actor and writer, known for Lapland Odyssey (2010), The Unknown Soldier (2017) and Downshiftaajat (2015).\n\nMarried to Marika Tuhkala', 254966400, 'Sonkajärvi, Finland', '226030', 'jussi-vatanen', 'upload/images/8y31rq3CLDO0bb1WyrRLEmMIfZ6.jpg'),
(95, 'actor', 'Janne Hyytiäinen', '', -42854400, 'Finland', '16775', 'janne-hyytiainen', 'upload/images/AnM4cw1RntFvCVLzDr0MHE8Xdmt.jpg'),
(96, 'actor', 'Nuppu Koivu', '', 0, '', '1730172', 'nuppu-koivu', 'upload/images/lMmTvf8DNtlGqjDmwtw81SzoVNk.jpg'),
(97, 'actor', 'Alina Tomnikov', '', 583113600, 'Kerava, Finland', '1568234', 'alina-tomnikov', 'upload/images/aQgJpGIqDbWyk6PdSj2N94HtjAI.jpg'),
(98, 'actor', 'Martti Suosalo', '', -235267200, 'Oulu, Finland', '89502', 'martti-suosalo', 'upload/images/tSOpd5cqosrkxleYY5XlXkauPpl.jpg'),
(99, 'actor', 'Matti Onnismaa', 'Matti Kalle Onnismaa (born 21 October 1959) is a Finnish actor. He made his leading performance debut in black comedy film Euthanizer (2017). He has also appeared in films such as The Winter War (1989), The Romanov Stones (1993), Drifting Clouds (1996), Pearls and Pigs (2003), Matti: Hell is for Heroes (2006), Lights in the Dusk (2006), V2: Dead Angel (2007), The Home of Dark Butterflies (2008), Hellsinki (2009), The Other Side of Hope (2017), Rendel (2017) and The Woodcutter Story (2022).', -321840000, 'Nokia, Finland', '89503', 'matti-onnismaa', 'upload/images/lQOLgZZ3Jgtl1ETKYRxy2pnjhAG.jpg'),
(100, 'actor', 'Sakari Kuosmanen', 'Sakari Jyrki Kuosmanen (born 6 September 1956 in Helsinki) is a Finnish singer and actor. He has recorded several solo albums and has also done work with Sleepy Sleepers and Leningrad Cowboys. He appeared as himself on the Finnish television series Aaken ja Sakun kesäkeittiö in 1999.\n\nDescription above from the Wikipedia article Sakari Kuosmanen, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -420336000, 'Helsinki, Finland', '4828', 'sakari-kuosmanen', 'upload/images/syM87lzV2IqFno87Za1PbeAUdMW.jpg'),
(101, 'actor', 'Simon Al-Bazoon', '', 0, '', '1730171', 'simon-al-bazoon', 'upload/images/bLxFuvieoP5AgNTKSF4BL6ui5aS.jpg'),
(102, 'actor', 'Maria Heiskanen', 'From Wikipedia, the free encyclopedia.\n\nMaria Heiskanen (born 1970) is a Finnish actress. She works in cinema, television and theatre.\n\nHeiskanen received her breakthrough role in the 1991 Swedish film Il Capitano: A Swedish Requiem directed by Jan Troell. For her role Heiskanen won the Gold Plaque Award in Chicago International Film Festival for the Best Actress in 1992. Heiskanen lived in Sweden during 1993 - 2003 and worked in movies and theatre. She played in Kungliga Dramatiska Teatern and in Riksteatern where she for example performed role of Masja in Anton Chekhovs The Seagull (2008) directed by Lars Norén.\n\nIn Finland Heiskanen has worked with Aki Kaurismäki in Lights in the Dusk (2006). She also played in Aleksi Salmenperä\\\'s A Man\\\'s Work (2007) and was nominated for Jussi Awards from both performances.\n\nIn 2008, Heiskanen starred in the leading role of Jan Troell\\\'s Everlasting Moments, for which she won the Guldbagge Award for Best Actress and the Best Actress Award from Valladolid International Film Festival. The film won the Guldbagge Award for Best Film and was nominated for Best Foreign Language Film at the 66th Golden Globe Awards. It also made the January shortlist for Best Foreign Language Film at the 81st Academy Awards, but wasn\\\'t selected as one of the final nominees.\n\nDescription above from the Wikipedia article Maria Heiskanen, licensed under CC-BY-SA, full list of contributors on Wikipedia', 20044800, 'Kuopio, Finland', '16776', 'maria-heiskanen', 'upload/images/71h2xPUcxT9cRyzE5hLNHBA3DXx.jpg'),
(103, 'actor', 'Sherwan Haji', '', 0, '', '1730170', 'sherwan-haji', 'upload/images/m7Az1ULDu2D5ap4rzXmC6esnZCl.jpg'),
(104, 'director', 'Aki Kaurismäki', 'Alma Pöysti (Finnish: [ˈɑlmɑ ˈpøy̯sti]; born March 16, 1981) is a Swedish-speaking Finnish actor. She is the daughter of director Erik Pöysti and granddaughter of Finnish actors Lasse Pöysti and Birgitta Ulfsson. Pöysti has also lived and worked in Sweden.', 353548800, 'Helsinki, Finland', '1364782', 'aki-kaurismaki', 'upload/images/kiJErWEOv4Ew7aHOGKg4ljsmppZ.jpg'),
(105, 'actor', 'Deniz Celiloğlu', 'Deniz Celiloğlu (born 1 January 1986) is a Turkish actor.\n\nDeniz Celiloğlu was born on 1 January 1986 in Bulgaria and moved with his family to Turkey at the age of 3. A graduate of Mimar Sinan University, Faculty of State Conservatory, Theater Department, Deniz Celiloğlu took part in many plays. He became known for his role as Commissioner Selim in the Kanal D series Kanıt. He also had leading roles in the movies Ev and Tamam mıyız?', 522115200, 'Bulgaria', '1300135', 'deniz-celiloglu', 'upload/images/atwWBhBwHnJKHFHKDLqRCW1r8b.jpg'),
(106, 'actor', 'Merve Dizdar', 'Merve Dizdar (born 25 June 1986) is a Turkish actress.\n\nShe was born in Izmir, Turkey. She is a graduate of Canakkale Onsekiz Mart University School of Fine Arts with a degree in acting. She received her master\\\'s degree in acting from Kadir Has University. She started her career on stage by joining Semaver Company and continued it at Craft Theatre. Dizdar made her cinematic debut with Bir Ses Böler Geceyi (2011) alongside Cem Davran and pursued a career in television with recurring roles in the series Kavak Yelleri, Genis Aile, Bir Yastikta, Doksanlar, Cilgin Dershane Üniversite, and was first noted with her role in Bes Kardes. She also worked for TRT Children, presenting the programs Arkadasim Bidi and 23 Nisan Senlige Dogru. Dizdar won the Afife Jale Theatre Best Actress Award for her role in the play Yutmak. She then joined the cast of hit series 7 Yüz, Vatanim Sensin, and Mucize Doktor respectively. In 2020, she had a leading role with Uraz Kaygilaroglu in the Gupse Özay\\\'s comedy film Eltilerin Savasi, which as of April 2021 is the 22nd most-watched movie of all time in Turkey according to Box Office Türkiye. She shared the leading role with Serenay Sarikaya, Ezgi Mola, Enis Arikan, Sükrü Ozyildiz in a musical adaptation of Alice\\\'s Adventures in Wonderland. In 2020, she started to play in the series Masumlar Apartmani and won Golden Butterfly Awards Best Actress. She played an actress and her many roles in Cem Yilmaz\\\'s Netflix spin off comedy series Ersan Kuneri. In 2022 she starred in Selcen Ergun\\\'s Kay ve Ayi/Snow and Bear. In 2023, she starred in Nuri Bilge Ceylan\\\'s Kuru Otlar Ustüne /About Dry Grasses , for which she become first Turkish actress at the 76th Cannes Film Festival by winning the Best Actress award for her portrayal of a teacher.', 520041600, 'Izmir, Turkey', '1064167', 'merve-dizdar', 'upload/images/ePDb2NMovrSWV3rdlsm6QJqLgIE.jpg'),
(107, 'actor', 'Musab Ekici', '', 699753600, 'Elazığ, Türkiye', '1670085', 'musab-ekici', 'upload/images/lN6JNh9BNm5s6YdWswj3MRr4fCQ.jpg'),
(108, 'actor', 'Ece Bağcı', 'Ece Bağcı is known for About Dry Grasses (2023).', 1325376000, '', '4067824', 'ece-bagci', 'upload/images/oqHieO4PU9hcBEkL2sSmJUejrvQ.jpg'),
(109, 'actor', 'Erdem Şenocak', 'Erdem Senocak was born in 1979.\n\nHe graduated from ITU Industrial Engineering.\n\nHe is doing his master\\\'s degree in Dramaturgy and Theater Criticism at Istanbul University.\n\nHe started the theater on the stage of Istanbul Technical University.\n\nErdem Senocak, who has been teaching and directing at Bilgi Sahne, continues his artistic life at Seyyar Sahne.\n\nHe founded the Theater Madrasa with Celal Mordeniz in Sirince.\n\n- IMDb Mini Biography By: yusufpiskin', 283996800, 'Istanbul, Turkey', '2193667', 'erdem-senocak', 'upload/images/qg4xNAJCdJK99SAir7Jx2ryInaZ.jpg'),
(110, 'actor', 'Yüksel Aksu', '', -126230400, 'Muğla, Türkiye', '545073', 'yuksel-aksu', 'upload/images/kvwf5tqBsmOLUgKtVPGKgHkywYn.jpg'),
(111, 'actor', 'Münir Can Cindoruk', '', 644025600, 'Adana, Turkey', '2896146', 'munir-can-cindoruk', 'upload/images/Ag7jw1JOXys27WbYgZmNDTkORIn.jpg'),
(112, 'actor', 'Onur Berk Arslanoğlu', '', 410227200, 'Trabzon, Türkiye', '2700688', 'onur-berk-arslanoglu', 'upload/images/4VjHscCxyQkx1CjXeY3Y7MMWxh1.jpg'),
(113, 'actor', 'Yıldırım Gücük', '', 0, '', '1933774', 'yildirim-gucuk', 'upload/images/uePBmNaVeh85k0vjd4NYY7RlWJL.jpg'),
(114, 'actor', 'Cengiz Bozkurt', 'Mehmet Cengiz Bozkurt (born 24 December 1965) is a Turkish actor. He is best known for his role as Erdal Bakkal in the hit surreal comedy series Leyla ile Mecnun.  A graduate of Ankara Atatürk Lisesi, in 1984 he enrolled in Middle East Technical University to study physics but changed his major to stage acting in 1990. He then moved to England, where he lived for 14 years. In 1996, he graduated from Goldsmiths, University of London with a degree in \\\"Media and Communication\\\" studies. He the briefly shot documentaries for some channels and directed short movies. He returned to acting with the encouragement of Mehmet Ergen and worked at Arcola Theatre. Upon returning to Turkey, he continued his career by appearing in various movies and TV series.', -126921600, 'Nevşehir, Turkey', '59752', 'cengiz-bozkurt', 'upload/images/fdxk6BXDPIALDUIpvAjqmBg9M6D.jpg'),
(115, 'actor', 'S. Emrah Özdemir', '', 283996800, 'Sivas, Türkiye', '1291099', 's-emrah-ozdemir', 'upload/images/8d9JkXiodTsQWltd7dpW8Xt2pSA.jpg'),
(116, 'director', 'Nuri Bilge Ceylan', '', 644025600, 'Adana, Turkey', '2896146', 'nuri-bilge-ceylan', 'upload/images/5jH5pWhdE0Xe0renmFjCBdJV9aQ.jpg'),
(117, 'actor', 'Tom Cruise', 'Tom Cruise (born Thomas Cruise Mapother IV; July 3, 1962) is an American actor and producer. One of the world\\\'s highest-paid actors, he has received various accolades, including an Honorary Palme d\\\'Or and three Golden Globe Awards, in addition to nominations for three Academy Awards. His films have grossed over $4 billion in North America and over $11.1 billion worldwide, making him one of the highest-grossing box office stars of all time.\n\nHe began acting in the early 1980s and made his breakthrough with leading roles in the comedy film Risky Business (1983) and action film Top Gun (1986). Critical acclaim came with his roles in the dramas The Color of Money (1986), Rain Man (1988), and Born on the Fourth of July (1989). For his portrayal of Ron Kovic in the latter, he won a Golden Globe Award and received a nomination for the Academy Award for Best Actor.\n\nAs a leading Hollywood star in the 1990s, he starred in several commercially successful films, including the drama A Few Good Men (1992), the thriller The Firm (1993), the horror film Interview with the Vampire (1994), and the romance Jerry Maguire (1996). For the latter, he won a Golden Globe Award for Best Actor and received his second Academy Award nomination. His performance as a motivational speaker in the drama Magnolia (1999) earned him another Golden Globe Award and a nomination for the Academy Award for Best Supporting Actor.\n\nSince then, he has largely starred in science fiction and action films, establishing himself as an action star, often performing his own risky stunts. He has played Ethan Hunt in all six of the Mission: Impossible films from 1996 to 2018. His other notable roles in the genre include Vanilla Sky (2001), Minority Report (2002), The Last Samurai (2003), Collateral (2004), War of the Worlds (2005), Knight and Day (2010), Jack Reacher (2012), Oblivion (2013), Edge of Tomorrow (2014), and Top Gun: Maverick (2022), with Maverick being his highest-grossing film to date.\n\nDescription above from the Wikipedia article Tom Cruise, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -236649600, 'Syracuse, New York, USA', '500', 'tom-cruise', 'upload/images/8qBylBsQf4llkGrWR3qAsOtOU8O.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(118, 'actor', 'Hayley Atwell', 'Hayley Elizabeth Atwell (born 5 April 1982) is a British and American actress. Born and raised in London, Atwell studied acting at the Guildhall School of Music and Drama, and made her stage debut in a 2005 production of James Kerr\\\'s translation of the Ancient Greek tragedy Prometheus Bound. She subsequently appeared in multiple West End productions and on television, and was recognised for her breakthrough role as Lady Elizabeth Foster in The Duchess (2008), for which she was nominated for a British Independent Film Award for Best Supporting Actress. Her leading performance in the miniseries The Pillars of the Earth (2010) earned her a nomination for the Golden Globe Award for Best Actress - Miniseries or Television Film.\n\nAtwell rose to international prominence with her portrayal of Agent Peggy Carter in the Marvel Cinematic Universe superhero film Captain America: The First Avenger (2011), a role she reprised in the short film Agent Carter (2013) and the 2015–2016 television series of the same name in addition to other films and live-action and animated series. She also had roles in the war drama Testament of Youth (2014), the romantic fantasy Cinderella (2015), and the fantasy comedy-drama Christopher Robin (2018).\n\nOn the stage, Atwell has received Laurence Olivier Award nominations for Best Supporting Actress, for her role in A View from the Bridge (2010), and for Best Actress, for her leading performances in The Pride (2013) and Rosmersholm (2020). In 2020, Atwell began hosting the podcast series True Spies, which aims to give an insight into the world of espionage by asking listeners what they would do in real-life spy situations.', 386812800, 'London, England, UK', '39459', 'hayley-atwell', 'upload/images/zM53P3iVyEnRNEeotU4vCCv13II.jpg'),
(119, 'actor', 'Ving Rhames', 'Irving Rameses Rhames (born May 12, 1959) is an American actor. He is known for his supporting roles as IMF Agent Luther Stickell in the Mission: Impossible film series and gang kingpin Marsellus Wallace in Pulp Fiction (1994). He also appeared in Jacob\\\'s Ladder (1990), Dave (1993), Striptease (1996), Con Air (1997), Only in America (1997), Out of Sight (1998), Entrapment (1999), Bringing Out the Dead (1999), Dawn of the Dead (2004), I Now Pronounce You Chuck & Larry (2007), Jamesy Boy (2014). He voiced Cobra Bubbles in the animated films Lilo & Stitch (2002), Stitch! The Movie (2003), and Leroy & Stitch (2006).\n\nDescription above from the Wikipedia article Ving Rhames, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -335836800, 'New York City, New York, USA', '10182', 'ving-rhames', 'upload/images/ohAOsD8E4tu35PI2buzZORpn9Ef.jpg'),
(120, 'actor', 'Simon Pegg', 'Simon John Pegg (born 14 February 1970) is an English actor, comedian, screenwriter, and producer. He came to public prominence in the UK as the co-creator of the Channel 4 sitcom Spaced, directed by Edgar Wright. He went on to co-write and star in the Three Flavours Cornetto film trilogy: Shaun of the Dead (2004), Hot Fuzz (2007), and The World\\\'s End (2013). He and Nick Frost wrote and starred in the sci-fi film Paul (2011).\n\nPegg is one of the few performers to have achieved what Radio Times calls \\\"the Holy Grail of nerd-dom\\\", playing popular supporting characters in Doctor Who (2005), Star Trek as Montgomery \\\"Scotty\\\" Scott (2009–2016), and Star Wars: The Force Awakens (2015). He currently stars as Benji Dunn in the Mission: Impossible film series (2006–present), and he played the Chamberlain in The Dark Crystal: Age of Resistance (2019).', 3801600, 'Brockworth, Gloucestershire, England, UK', '11108', 'simon-pegg', 'upload/images/kIMnWkZciXXHYyD8GxMYvDLD29x.jpg'),
(121, 'actor', 'Rebecca Ferguson', 'Rebecca Louisa Ferguson Sundström (born October 19, 1983) is a Swedish actress. She began her acting career with the Swedish soap opera Nya tider (1999–2000) and went on to star in the slasher film Drowning Ghost (2004). She came to international prominence with her portrayal of Elizabeth Woodville in the British television miniseries The White Queen (2013), for which she was nominated for a Golden Globe for Best Actress in a Miniseries or Television Film. In 2023, she starred in the Apple TV+ science fiction drama series Silo.\n\nFerguson starred as MI6 agent Ilsa Faust in the action spy film Mission: Impossible – Rogue Nation (2015) and its sequels Mission: Impossible – Fallout (2018) and Mission: Impossible – Dead Reckoning Part One (2023). She also played Jenny Lind in the musical film The Greatest Showman (2017) and acted in science fiction horror film Life (2017), starred in the horror film Doctor Sleep (2019), and had supporting parts in the comedy-drama Florence Foster Jenkins (2016), the mystery thriller The Girl on the Train (2016), and the science fiction film Men in Black: International (2019). She portrayed Lady Jessica in the sci-fi epic Dune (2021) and will reprise her role in its sequel Dune: Part Two (2024).', 435369600, 'Stockholm, Sweden', '933238', 'rebecca-ferguson', 'upload/images/lJloTOheuQSirSLXNA3JHsrMNfH.jpg'),
(122, 'actor', 'Vanessa Kirby', 'Vanessa Kirby (born 18 April 1988) is an English actress. She has received several accolades, including a BAFTA TV Award, in addition to nominations for an Academy Award and a Primetime Emmy Award.\n\nBorn in London to urologist Roger Kirby, Kirby studied English literature at the University of Exeter. After graduation, she made her professional acting debut on stage with a production of Arthur Miller\\\'s All My Sons (2010), and followed this with acclaimed performances in the plays A Midsummer Night\\\'s Dream (2010), As You Like It (2010), Women Beware Women (2011), Three Sisters (2012), and as Stella Kowalski in A Streetcar Named Desire (2014).\n\nKirby made her film debut with a minor role in the crime drama The Rise (2012), and rose to international prominence with her portrayal of Princess Margaret in the Netflix drama series The Crown (2016–2017), for which she won the British Academy Television Award for Best Supporting Actress and received a nomination for a Primetime Emmy Award. She took on roles in the action films Mission: Impossible – Fallout (2018) and Hobbs & Shaw (2019). For her performance as a grief-stricken young woman in Pieces of a Woman (2020), she won the Volpi Cup for Best Actress and received a nomination for the Academy Award for Best Actress.\n\nDescription above from the Wikipedia article Vanessa Kirby, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 577324800, 'Wimbledon, London, England, UK', '556356', 'vanessa-kirby', 'upload/images/a8a9U00KL2JJkkekzhNnueIGKKF.jpg'),
(123, 'actor', 'Esai Morales', 'Esai Morales (born October 1, 1962) is an American actor known for his role as Bob Valenzuela in La Bamba. He also appeared in American Family and on Resurrection Blvd. In television, he would perhaps be best known for his roles on NYPD Blue and Caprica.', -228873600, 'Brooklyn, New York City, New York, USA', '65344', 'esai-morales', 'upload/images/kXQW3Uu8MnbIsPBzYNYDxFgDIDg.jpg'),
(124, 'actor', 'Pom Klementieff', 'Pom Alexandra Klementieff (born 3 May 1986) is a French actress. She was trained at the Cours Florent drama school in Paris and appeared in such French films as The Easy Way (2008) and Sleepless Night (2011), before making her American film debut in Oldboy (2013). In 2019, she also made an appearance in Striking Vipers, the first episode of the fifth series of the anthology series Black Mirror.\n\nKlementieff received worldwide recognition for her role as Mantis in the Marvel Cinematic Universe films Guardians of the Galaxy Vol. 2 (2017), Avengers: Infinity War (2018), Avengers: Endgame (2019), Thor: Love and Thunder (2022), the television film The Guardians of the Galaxy Holiday Special (2022), and Guardians of the Galaxy Vol. 3 (2023).\n\nDescription above is from the Wikipedia article Pom Klementieff, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 515462400, 'Québec City, Québec, Canada', '139820', 'pom-klementieff', 'upload/images/hfUKAI2kXTMMWjno0i4sLPJud5N.jpg'),
(125, 'actor', 'Henry Czerny', 'Henry Czerny is a Canadian stage, film and television actor, best known for playing regular character Conrad Grayson in the television series \\\"Revenge\\\". He\\\'s a graduate of the National Theatre School in Montreal, Quebec, Canada.', -343872000, 'Toronto, Ontario, Canada', '15319', 'henry-czerny', 'upload/images/zOWZzRmliKf9032IOOq0a3jXhVv.jpg'),
(126, 'actor', 'Greg Tarzan Davis', 'Gregory Davis, Jr. (born September 25, 1993), better known as Greg Tarzan Davis is an American actor. Born in New Orleans he began in theater, moved to Los Angeles, and starting his acting career. In 2022, he played the role of Javy \\\"Coyote\\\" Machado in the Top Gun: Maverick film. In 2021, he received a recurring role on ABC\\\'s series Grey’s Anatomy. He also had a supporting role in the horror film Tales from the Hood 2 (2018).', 748915200, 'New Orleans, Louisiana, USA', '2080646', 'greg-tarzan-davis', 'upload/images/eN1KOOV3HQSYA58WjQKY05ruoGw.jpg'),
(127, 'director', 'Christopher McQuarrie', 'Simon John Pegg (born 14 February 1970) is an English actor, comedian, screenwriter, and producer. He came to public prominence in the UK as the co-creator of the Channel 4 sitcom Spaced, directed by Edgar Wright. He went on to co-write and star in the Three Flavours Cornetto film trilogy: Shaun of the Dead (2004), Hot Fuzz (2007), and The World\\\'s End (2013). He and Nick Frost wrote and starred in the sci-fi film Paul (2011).\n\nPegg is one of the few performers to have achieved what Radio Times calls \\\"the Holy Grail of nerd-dom\\\", playing popular supporting characters in Doctor Who (2005), Star Trek as Montgomery \\\"Scotty\\\" Scott (2009–2016), and Star Wars: The Force Awakens (2015). He currently stars as Benji Dunn in the Mission: Impossible film series (2006–present), and he played the Chamberlain in The Dark Crystal: Age of Resistance (2019).', 3801600, 'Brockworth, Gloucestershire, England, UK', '11108', 'christopher-mcquarrie', 'upload/images/7FcybX1uFpMKHSI0p15LGPG3O3x.jpg'),
(128, 'actor', 'Chris Pratt', 'Christopher Michael Pratt (born 21 June 1979) is an American actor, known for starring in both television and action films. He rose to prominence for his television roles, particularly in the NBC sitcom Parks and Recreation (2009–2015), for which he received critical acclaim and was nominated for the Critics\\\' Choice Television Award for Best Supporting Actor in a Comedy Series in 2013. He also starred earlier in his career as Bright Abbott in The WB drama series Everwood (2002–2006) and had roles in Wanted (2008), Jennifer\\\'s Body (2009), Moneyball (2011), The Five-Year Engagement (2012), Zero Dark Thirty (2013), Delivery Man (2013), and Her (2013).\n\nPratt achieved leading man status in 2014, starring in two critically and commercially successful films: The Lego Movie as Emmet Brickowski, and Marvel Studios\\\' Guardians of the Galaxy as Star-Lord. He starred in Jurassic World (2015) and Jurassic World: Fallen Kingdom (2018), and he reprised his Marvel role in Guardians of the Galaxy Vol. 2 (2017), Avengers: Infinity War (2018), Avengers: Endgame (2019), and the planned Guardians of the Galaxy Vol. 3. Meanwhile, in 2016 he was part of an ensemble cast in The Magnificent Seven and the male lead in Passengers.\n\nDescription above is from the Wikipedia article Chris Pratt, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 298771200, 'Virginia, Minnesota, USA', '73457', 'chris-pratt', 'upload/images/83o3koL82jt30EJ0rz4Bnzrt2dd.jpg'),
(129, 'actor', 'Zoe Saldaña', 'Zoë Yadira Saldaña-Perego (born June 19, 1978) is an American actress. Known primarily for her work in science fiction film franchises, she has appeared in the three highest-grossing films of all time (Avatar, Avatar: The Way of Water and Avengers: Endgame), a feat not achieved by any other performer. Films she has appeared in have grossed more than $14 billion worldwide and, as of 2023, she is the second-highest-grossing film actress, and the fourth actor overall. Time magazine named her one of the 100 most influential people in the world in 2023.\n\nA trained dancer, Saldaña began her acting career in two 1999 episodes of Law & Order. Her first film role was in Center Stage (2000) in which she played a ballet dancer. She received early recognition for her work opposite Britney Spears in the road film Crossroads (2002). Beginning in 2009, Saldaña achieved a career breakthrough with her roles as Nyota Uhura in the Star Trek film series and Neytiri in James Cameron\\\'s Avatar film series. She portrayed Gamora in the Marvel Cinematic Universe, from Guardians of the Galaxy (2014) to Guardians of the Galaxy Vol. 3 (2023). In addition to franchise work, Saldaña has starred in the science fiction film The Adam Project and the romantic drama miniseries From Scratch, both for Netflix in 2022.', 267062400, 'Passaic, New Jersey, USA', '8691', 'zoe-saldana', 'upload/images/iOVbUH20il632nj2v01NCtYYeSg.jpg'),
(130, 'actor', 'Dave Bautista', 'David Michael Bautista Jr. (born January 18, 1969) is an American actor and retired professional wrestler. He had several stints in WWE between 2002 and 2019. In his acting career, he is most widely known for his portrayal of Drax the Destroyer in the Marvel Cinematic Universe since Guardians of the Galaxy (2014).\n\nBautista began his wrestling career in 1999, and in 2000 signed with the then-World Wrestling Federation (WWF, renamed WWE in 2002). From 2002 to 2010, he gained fame under the ring name Batista and became a six-time world champion by winning the World Heavyweight Championship four times and the WWE Championship twice. His first reign with the World Heavyweight Championship is the longest reign for that title at 282 days. He has also held the World Tag Team Championship three times (twice with Ric Flair and once with John Cena) and the WWE Tag Team Championship once (with Rey Mysterio). He was the winner of the 2005 Royal Rumble match and went on to headline WrestleMania 21, one of the top five highest-grossing pay-per-view events in professional wrestling history. After leaving WWE in 2010, he re-signed in December 2013, making his first appearance back in January 2014 and won that year\\\'s Royal Rumble match. He headlined WrestleMania XXX before again departing that June. In October 2018, Bautista made his second return to WWE and faced Triple H at WrestleMania 35 in April 2019, before retiring from wrestling. Altogether Bautista won a total of eleven championships throughout his wrestling career.\n\nBautista began acting in 2006 and has starred in The Man with the Iron Fists (2012), Riddick (2013), the James Bond film Spectre (2015), Blade Runner 2049 (2017), Army of the Dead (2021), and Dune (2021). He has also appeared in several direct-to-video films since 2009.\n\nIn August 2012, Bautista signed a contract with Classic Entertainment & Sports to fight in mixed martial arts (MMA). He won his lone MMA fight on October 6, 2012, defeating Vince Lucero via technical knockout in the first round.', -30067200, 'Washington, District of Columbia, USA', '543530', 'dave-bautista', 'upload/images/snk6JiXOOoRjPtHU5VMoy6qbd32.jpg'),
(131, 'actor', 'Karen Gillan', 'Karen Gillan (born November 28, 1987) is a Scottish actress, director, and screenwriter from Inverness, Scotland. She played the role of Amy Pond, companion to the Eleventh Doctor, in the BBC One science fiction series Doctor Who (2010–2013). In film, she portrayed Nebula in the Marvel Cinematic Universe films Guardians of the Galaxy (2014) and Guardians of the Galaxy Vol. 2 (2017), Avengers: Infinity War (2018), Avengers: Endgame (2019) and Thor: Love and Thunder (2022), and also played Ruby Roundhouse in the box-office hit Jumanji: Welcome to the Jungle (2017). In 2018, she released her first feature film as writer and director, titled The Party\\\'s Just Beginning.\n\nDescription above from the Wikipedia article Karen Gillan, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 565056000, 'Inverness, Scotland, UK', '543261', 'karen-gillan', 'upload/images/52kqB0Bei1TaTBx2rABrijVhhTG.jpg'),
(132, 'actor', 'Vin Diesel', 'Mark Sinclair (born July 18, 1967), known professionally as Vin Diesel, is an American actor and producer. One of the world\\\'s highest-grossing actors, he is best known for playing Dominic Toretto in the Fast & Furious franchise.\n\nDiesel began his career in 1990, but faced difficulty achieving recognition until he wrote, directed and starred in the short film Multi-Facial (1995) and his debut feature Strays (1997); the films prompted Steven Spielberg to cast Diesel in the war epic Saving Private Ryan (1998). Diesel subsequently voiced the titular character in The Iron Giant (1999) and then gained a reputation as an action star after headlining the Fast & Furious, XXX, and The Chronicles of Riddick franchises. He is slated to appear in the upcoming Avatar films.\n\nDiesel voices Groot and Groot II in the Marvel Cinematic Universe (MCU); he portrayed the characters in six superhero films, beginning with Guardians of the Galaxy (2014). Diesel has reprised his role as Groot for the Disney+ animated shorts series I Am Groot (2022–present), the television special The Guardians of the Galaxy Holiday Special (2022), and the animated film Ralph Breaks the Internet (2018). Diesel achieved commercial success in the comedy The Pacifier (2005) and his portrayal of Jackie DiNorscio in Find Me Guilty (2006) was praised.\n\nHe founded the production company One Race Films, where he has also served as a producer or executive producer for his star vehicles. Diesel also founded the record label Racetrack Records and video game developer Tigon Studios, providing his voice and motion capture for all of Tigon\\\'s releases.\n\nDescription above from the Wikipedia article Vin Diesel, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -77587200, 'Alameda County, California, USA', '12835', 'vin-diesel', 'upload/images/nZdVry7lnUkE24PnXakok9okvL4.jpg'),
(133, 'actor', 'Bradley Cooper', 'Bradley Charles Cooper (born January 5, 1975) is an American actor and filmmaker. He is the recipient of various accolades, including a British Academy Film Award and two Grammy Awards, in addition to nominations for nine Academy Awards, six Golden Globe Awards, and a Tony Award. Cooper appeared on the Forbes Celebrity 100 three times and on Time\\\'s list of the 100 most influential people in the world in 2015. His films have grossed $11 billion worldwide and he has placed four times in annual rankings of the world\\\'s highest-paid actors.\n\nCooper enrolled in the MFA program at the Actors Studio in 2000 after beginning his career in 1999 with a guest role in the television series Sex and the City. He made his film debut in the comedy Wet Hot American Summer (2001). He first gained recognition as Will Tippin in the spy-action television show Alias (2001–2006), and achieved minor success with a supporting part in the comedy film Wedding Crashers (2005). His breakthrough role came in 2009 with The Hangover, a critically and commercially successful comedy, which spawned two sequels in 2011 and 2013. Cooper\\\'s portrayal of a struggling writer in the thriller Limitless (2011) and a rookie police officer in the crime drama The Place Beyond the Pines (2012) drew praise from critics.\n\nCooper found greater success with the romantic comedy Silver Linings Playbook (2012), the black comedy American Hustle (2013), and the war biopic American Sniper (2014), which he also produced. For his work in these films, he was nominated for four Academy Awards, becoming the tenth actor to receive an Oscar nomination in three consecutive years. In 2014, he portrayed Joseph Merrick in a Broadway revival of The Elephant Man, garnering a nomination for the Tony Award for Best Actor in a Play, and began voicing Rocket Raccoon in the Marvel Cinematic Universe. In 2018, Cooper produced, wrote, directed and starred in a remake of the musical romance A Star Is Born. He earned three Oscar nominations for the film, as well as a BAFTA Award and two Grammys for his contributions to its U.S. Billboard 200 number one soundtrack and its chart-topping lead single \\\"Shallow\\\". He gained Academy Award nominations for producing Joker (2019) and Nightmare Alley (2021).\n\nLabeled a sex symbol by the media, Cooper was named People magazine\\\'s \\\"Sexiest Man Alive\\\" in 2011. He supports several charities that help fight cancer. Cooper was briefly married to actress Jennifer Esposito, and has a daughter from his relationship with model Irina Shayk.', 158112000, 'Philadelphia, Pennsylvania, USA', '51329', 'bradley-cooper', 'upload/images/lq68RaE8zK4lNaB49RWOukyorgn.jpg'),
(134, 'actor', 'Sean Gunn', 'Sean Gunn (born May 22, 1974) is an American actor. He is known for his roles as Kirk Gleason on The WB series Gilmore Girls (2000–2007), Kraglin Obfonteri in the Marvel Cinematic Universe films Guardians of the Galaxy (2014), Guardians of the Galaxy Vol. 2 (2017), Avengers: Endgame (2019), Thor: Love and Thunder (2022) and Guardians of the Galaxy Vol. 3 (2023), and Weasel and Calendar Man in the Warner Bros./DCEU film The Suicide Squad (2021).\n\nDescription above from the Wikipedia article Sean Gunn, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 138412800, 'St. Louis, Missouri, USA', '51663', 'sean-gunn', 'upload/images/72EeniY2lnlXLRvL34LnU0skfe5.jpg'),
(135, 'actor', 'Chukwudi Iwuji', 'Chukwudi Iwuji (born 15 October 1975) is a Nigerian-British actor. He is an Associate Artist for the Royal Shakespeare Company.', 182563200, 'Lagos, Nigeria', '105238', 'chukwudi-iwuji', 'upload/images/5JILtFNmAmA8T4gRQrO5sn8krDv.jpg'),
(136, 'actor', 'Will Poulter', 'William Jack Poulter (born January 28, 1993) is an English actor. He first gained recognition for his role as Eustace Scrubb in the fantasy adventure film The Chronicles of Narnia: The Voyage of the Dawn Treader (2010). He received critical praise for his starring role in the comedy film We\\\'re the Millers (2013), for which he won the BAFTA Rising Star Award.\n\nPoulter starred in the dystopian science fiction film The Maze Runner (2014) and the sequel Maze Runner: The Death Cure (2018), the period epic film The Revenant (2015), the crime drama film Detroit (2017), the interactive science fiction film Black Mirror: Bandersnatch (2018), and the folk horror film Midsommar (2019). In 2021, he had a leading role in the Hulu miniseries Dopesick, for which he received an Emmy nomination for Outstanding Supporting Actor in a Limited or Anthology Series or Movie. In 2023, he joined the Marvel Cinematic Universe as Adam Warlock in Guardians of the Galaxy Vol. 3.', 728179200, 'Hammersmith, London, England, UK', '93491', 'will-poulter', 'upload/images/9blYMaj79VGC6BHTLmJp3V5S8r3.jpg'),
(137, 'actor', 'Maria Bakalova', 'Maria Valcheva Bakalova (born 4 June 1996) is a Bulgarian actress. She is best known for her role as Tutar Sagdiyev in the 2020 mockumentary Borat Subsequent Moviefilm. For her performance in the film, she won the Critics\\\' Choice Movie Award for Best Supporting Actress, and received nominations at the Academy Awards, the BAFTA Film Awards, the Golden Globe Awards and the Screen Actors Guild Awards.\n\nBorn and raised in Burgas, Bakalova began her career in Bulgarian cinema by starring in film productions while attending the National Academy for Theatre and Film Arts in Sofia. She appeared in films such as Transgression (2017), The Father (2019), Last Call (2020) and Women Do Cry (2021). Since her international breakthrough in 2020, she has been a part of several American productions including Judd Apatow\\\'s The Bubble (2022) and the A24 horror film Bodies Bodies Bodies (2022).', 833846400, 'Burgas, Bulgaria', '2408703', 'maria-bakalova', 'upload/images/nUivgeC0kyhkI6QOAhw2k5VGhBk.jpg'),
(138, 'director', 'James Gunn', 'Chukwudi Iwuji (born 15 October 1975) is a Nigerian-British actor. He is an Associate Artist for the Royal Shakespeare Company.', 182563200, 'Lagos, Nigeria', '105238', 'james-gunn', 'upload/images/2kFzvqCGeYBrgbuuvvyGE75d9gM.jpg'),
(139, 'actor', 'Chris Pine', 'Chris Pine (born August 26, 1980) is an American actor. Pine made his feature film debut as Lord Devereaux in The Princess Diaries 2: Royal Engagement (2004). He is best known for his roles as James T. Kirk in the Star Trek reboot film series (2009–2016), Will Colson in Unstoppable (2010), Cinderella\\\'s Prince in Into the Woods (2014), Jack Ryan in Jack Ryan: Shadow Recruit (2014), Toby Howard in Hell or High Water (2016), Bernie Webber in The Finest Hours (2016), Steve Trevor in Wonder Woman (2017) and Wonder Woman 1984 (2020), Dr. Alexander Murry in A Wrinkle in Time (2018), and Robert the Bruce in Outlaw King (2018). Pine also voiced Jack Frost in Rise of the Guardians (2012).', 336096000, 'Los Angeles, California, USA', '62064', 'chris-pine', 'upload/images/mi00EsvrAebidnEYK7LZxgbKYyH.jpg'),
(140, 'actor', 'Michelle Rodriguez', 'Mayte Michelle Rodríguez (born July 12, 1978), known professionally as Michelle Rodriguez, is an American actress, screenwriter, and DJ. She got her breakout role as a troubled boxer in the independent film Girlfight (2000), which was met with critical acclaim and earned her several awards, including the Independent Spirit Award and Gotham Award for Best Debut Performance. The following year, she starred as Letty Ortiz in the blockbuster film The Fast and the Furious (2001), reprising her role in its sequels Fast & Furious (2009), Fast & Furious 6 (2013), and Furious 7 (2015).\n\nDuring her career, Rodriguez has played tough, independent women in a number of successful action films, such as Blue Crush, S.W.A.T., Battle: Los Angeles, and Avatar. She is also known for her roles as Shé in the action comedy films Machete and Machete Kills, and Rain Ocampo in the science fiction films Resident Evil and Resident Evil: Retribution.\n\nRodriguez also branched into television, playing Ana Lucia Cortez in the second season of the series Lost as part of the main cast, before making numerous guest appearances before the series ended. She has also done voice work in video games such as Call of Duty and Halo, and lent her voice for the 3D animated film Turbo and the television series IGPX.\n\nWith her films grossing over $5 billion collectively, a 2013 Entertainment Weekly article described Rodriguez as \\\"arguably the most iconic actress in the action genre, as well as one of the most visible Latinas in Hollywood\\\".', 269049600, 'Bexar County, Texas, USA', '17647', 'michelle-rodriguez', 'upload/images/xSvkVrLz6xas1mCeOR9i4QtmhnQ.jpg'),
(141, 'actor', 'Justice Smith', 'Justice Elio Smith (born August 9, 1995) is an American actor. He is best known for his roles in the films Jurassic World: Fallen Kingdom, Pokémon: Detective Pikachu, and All the Bright Places.\n\nDescription above from the Wikipedia article Justice Smith, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 807926400, 'Los Angeles, California, USA', '1029934', 'justice-smith', 'upload/images/8DUlAGwKoitrHqrDicIMoi1cYtA.jpg'),
(142, 'actor', 'Sophia Lillis', 'Sophia Lillis (born February 13, 2002), is an American actress. She is known for her role as Beverly Marsh in the horror films It (2017) and It: Chapter Two (2019) and for her starring role as a teenager with telekinetic abilities in the Netflix drama series I Am Not Okay with This (2020). Lillis has also appeared in the HBO psychological thriller miniseries Sharp Objects (2018), in which she portrayed the younger version of Amy Adams\\\' character in flashbacks.', 1013558400, 'Crown Heights, Brooklyn, New York City, New York, USA', '1481238', 'sophia-lillis', 'upload/images/ohIY9Ye2xwOWUsTc3D18zCI2RO6.jpg'),
(143, 'actor', 'Hugh Grant', 'Hugh John Mungo Grant (born 9 September 1960) is an English actor and film producer. He has received a Golden Globe Award, a BAFTA, and an Honorary César. His movies have also earned more than $2.4 billion from 25 theatrical releases worldwide. Grant achieved international stardom after appearing in Richard Curtis\\\'s sleeper hit Four Weddings and a Funeral (1994). He used this breakthrough role as a frequent cinematic persona during the 1990s to deliver comic performances in mainstream films like Mickey Blue Eyes (1999) and Notting Hill (1999). By the turn of the century, he had established himself as a leading man skilled with a satirical comic talent. Since the 2000s, Grant has expanded his oeuvre with critically acclaimed turns as a cad in Bridget Jones\\\'s Diary (2001), About A Boy (2002), Love Actually (2003), and American Dreamz (2006).\n\nWithin the film industry, Grant is cited as an anti-movie star who approaches his roles like a character actor, with the ability to make acting look effortless. Hallmarks of his comic skills include a nonchalant touch of irony/sarcasm and studied physical mannerisms as well as his precisely-timed dialogue delivery and facial expressions. The entertainment media\\\'s coverage of Grant\\\'s life off the big screen has often overshadowed his work as a thespian. He has been vocal about his disrespect for the profession of acting, his disdain towards the culture of celebrity, and hostility towards the media. In a career spanning 20 years, Grant has repeatedly claimed that acting is not a true calling but just a job he fell into.\n\nDescription above from the Wikipedia article Hugh Grant, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -293846400, 'London, England, UK', '3291', 'hugh-grant', 'upload/images/tUHkXYdwm405DjBm2IpPxGjYkjj.jpg'),
(144, 'actor', 'Regé-Jean Page', 'Regererai \\\"Regé-Jean\\\" Page (born 27 April 1988) is an English-Zimbabwean actor. He appeared in several television series such as Waterloo Road (2015) on BBC One, Roots (2016) on History, and For the People (2018–2019) on ABC before rising to prominence for his role in the first season of the Netflix period drama Bridgerton (2020). He then appeared in the action film The Gray Man (2022), also on Netflix.', 0, 'Harare, Zimbabwe', '1628687', 'rege-jean-page', 'upload/images/2NYvHjBlfVeY0gDJLaQXnw4Lfxm.jpg'),
(145, 'actor', 'Chloe Coleman', 'Chloe Coleman (born December 11, 2008) is an American actress. She made her acting debut at the age of 5 in an episode of the Fox television series Glee in 2013. She has African-American descent through her father, and Czech and English descent through her mother.', 1228953600, 'Los Angeles, California, USA', '1696016', 'chloe-coleman', 'upload/images/w4C3VBjmVFeMimbIeJm41fuPY9b.jpg'),
(146, 'actor', 'Daisy Head', 'Daisy May Head (born 7 March 1991) is an English actress. She played Grace in the American drama series Guilt, Amy Stevenson in BBC One\\\'s drama The Syndicate, Kate Bottomley in the third season of Hulu series Harlots and Genya Safin in the Netflix show Shadow and Bone.', 668304000, 'Fulham, London, England', '1070886', 'daisy-head', 'upload/images/5DcAwmYWDC7mvxMoceZIzcnpT2L.jpg'),
(147, 'actor', 'Kyle Hixon', 'Kyle Hixon is an Irish actor. He is known for Dungeons & Dragons: Honor Among Thieves (2023), The Last Duel (2021) and Crosshair (2022).', 0, 'Dublin, Ireland', '3655420', 'kyle-hixon', 'upload/images/jtAaYjNrqdvtXoXSpTuz9gDmEV.jpg'),
(148, 'actor', 'Spencer Wilding', 'Spencer Lee Wilding (born 26 July 1972) is a Welsh actor and special creature performer in the UK. He is from Meliden in Denbighshire, North Wales. He has also had some success as a professional kickboxer and professional cruiser weight boxer. He was trained by former three-time world champion Russ Williams.', 80956800, 'Saint Asaph, United Kingdom', '25451', 'spencer-wilding', 'upload/images/4NMcve4Nckpi653znyYOnoS4Mci.jpg'),
(149, 'actor', 'Will Irvine', '', 0, '', '1945374', 'will-irvine', NULL),
(150, 'director', 'John Francis Daley', 'Kyle Hixon is an Irish actor. He is known for Dungeons & Dragons: Honor Among Thieves (2023), The Last Duel (2021) and Crosshair (2022).', 0, 'Dublin, Ireland', '3655420', 'john-francis-daley', 'upload/images/rKZL3e8gI2tQD6Kv0QojXK5sG4u.jpg'),
(151, 'director', 'Jonathan Goldstein', '', 0, '', '1137972', 'jonathan-goldstein', 'upload/images/s1fwSaxlYvw3KdmRvT1ZSYhsEkJ.jpg'),
(152, 'actor', 'Shah Rukh Khan', 'Shah Rukh Khan (born November 2, 1965) is a prominent Bollywood actor and producer. He made his film debut in Deewana (1992). In 2005, the Government of India honoured him with the Padma Shri for his contributions towards Indian Cinema.\n\nIn 2003, he founded the motion picture production company Red Chillies Entertainment together with his wife Gauri Khan.', -131414400, 'New Delhi, Delhi, India', '35742', 'shah-rukh-khan', 'upload/images/d8jQehnCiGuLhZbs1DyB2uDu5BA.jpg'),
(153, 'actor', 'Taapsee Pannu', 'Taapsee Pannu is an Indian model and actress, who mainly works in the South Indian film industry, though she has also appeared in Bollywood  films. Taapsee worked as a software professional and also pursued a  career in modelling before becoming an actress. During her modelling  career, she appeared in a number of commercials and won titles such as  \\\"Pantaloons Femina Miss Fresh Face\\\" and \\\"Safi Femina Miss Beautiful  Skin\\\" in 2008.\n\nAfter a short stint with modelling, Taapsee made her acting debut with the 2010 Telugu film Jhummandi Naadam directed by Raghavendra Rao. Since then, she has appeared in a number of critically acclaimed films such as Aadukalam, Vastadu Naa Raju and Mr. Perfect. Her Tamil film Aadukalam won six National Film Awards at the 58th National Film Awards. She has also worked in a Malayalam film and has been signed on for three Telugu films and a Hindi film. She was awarded Most Enthusiastic Performer-Female Award at the 2014 Edison Awards for her performance in Tamil film Arrambam (2013). In 2015, she starred in the critically and commercially successful film Baby.', 554774400, 'Delhi, India', '550167', 'taapsee-pannu', 'upload/images/u9Gwg3J0bdczTPunP8qoWK2Vhu4.jpg'),
(154, 'actor', 'Vikram Kochhar', '', 0, '', '1715408', 'vikram-kochhar', 'upload/images/qzwC8ebdicpuoVjfsM3KQSG6J9O.jpg'),
(155, 'actor', 'Anil Grover', '', 0, '', '2258829', 'anil-grover', 'upload/images/6ZN0Y3j0oQrkqckYWRC5ixwieZ5.jpg'),
(156, 'actor', 'Boman Irani', 'Boman Irani (born 2 December 1959 in Mumbai, Maharashtra) is an Indian film and theatre actor and photographer. Irani began his acting career in theatre and moved to film in 2000 at the age of 44 with a role in Josh. Irani gained attention for his role in the 2003 comedy Munna Bhai M.B.B.S. He later appeared in Lage Raho Munna Bhai for which he received several IIFA award nominations and in 3 Idiots opposite Aamir Khan which earned him a Filmfare Award and a Star Screen Award for Best Actor in a Villainous Role. He is the host of Bollywood Ka Boss.\n\nDescription above from the Wikipedia article Boman Irani licensed under CC-BY-SA, full list of contributors on Wikipedia.', -318211200, 'Mumbai, Maharashtra, India', '35779', 'boman-irani', 'upload/images/u71heG3Xw9IAwNpuufoelfjyYLG.jpg'),
(157, 'actor', 'Vicky Kaushal', 'Vicky Kaushal is an Indian actor who works in Hindi films. Born to the action director Sham Kaushal, he pursued an engineering degree from the Rajiv Gandhi Institute of Technology. Aspiring to a career in film, Kaushal assisted Anurag Kashyap in the crime drama Gangs of Wasseypur (2012) and went on to play minor roles in two of Kashyap\\\'s productions. His first leading role was in the independent drama Masaan (2015), which earned him the IIFA and Screen Awards for Best Male Debut.\n\nFollowing the leading role of an unhinged cop in Kashyap\\\'s psychological thriller Raman Raghav 2.0 (2016), Kaushal rose to prominence in 2018 with supporting roles in Raazi and Sanju, two of the highest-grossing Hindi films of the year.', 579744000, 'Mumbai, Maharashtra, India', '1469935', 'vicky-kaushal', 'upload/images/fik5AjdZRVborbztOBb6tENbtUk.jpg'),
(158, 'actor', 'Deven Bhojani', 'Deven Bhojani (born 25 November 1969) is an Indian TV serial actor/director. He is a theatre actor who is best known for his Gujarati and Sindhi plays and dramas. While he is usually associated with comic roles, he is also known to portray supporting characters to a certain extent. He has won three best director awards for Sarabhai vs Sarabhai; the ITA Award, the Indian Telly Award and The Apsara Award.', -3196800, '', '110292', 'deven-bhojani', 'upload/images/4gKlQ8QD6BtfachIRAXOxB5vidB.jpg'),
(159, 'actor', 'Sapna Sand', '', 0, '', '3316221', 'sapna-sand', 'upload/images/1FWOLemBx7Wu4JF3r5hozlfs7pE.jpg'),
(160, 'actor', 'Komal Sachdeva', '', 0, '', '4442107', 'komal-sachdeva', NULL),
(161, 'actor', 'Diwanshu Gambhir', '', 0, '', '4442105', 'diwanshu-gambhir', NULL),
(162, 'actor', 'Vishnu Kaushal', '', 0, '', '3654517', 'vishnu-kaushal', NULL),
(163, 'director', 'Rajkumar Hirani', '', 0, '', '2258829', 'rajkumar-hirani', 'upload/images/xwpN5swbmjmlaN0B8Eac5jyN4JQ.jpg'),
(164, 'actor', 'Nayanthara', 'Nayanthara, is an Indian film actress who predominantly appears in Tamil, Telugu, and Malayalam films.  Nayanthara made her acting debut in the 2003 Malayalam film Manassinakkare and followed with Vismayathumbathu (2004) before foraying into Tamil and Telugu cinema. She made her debut in Tamil cinema in 2005 with Ayya and a year later in Telugu with Lakshmi, after which she was the female lead in numerous commercially successful Tamil and Telugu films.\n\nHer portrayal of Sita in Sri Rama Rajyam (2011) earned her the Filmfare Award for Best Telugu Actress and the Nandi Award for Best Actress. She won the Filmfare Award for Best Tamil Actress for her performance in Raja Rani (2013). Kochi Times listed her in the \\\"List of 15 Most Desirable Women in 2014\\\".', 469584000, 'Bengaluru, Karnataka, India', '91548', 'nayanthara', 'upload/images/5KubBeb2DkNXoU4lzzBdWzqzzlM.jpg'),
(165, 'actor', 'Vijay Sethupathi', 'Vijaya Gurunatha Sethupathi Kalimuthu known professionally as Vijay Sethupathi, is an Indian film actor, producer, lyricist, and dialogue writer. Sethupathi works predominantly in Tamil besides few Telugu, Malayalam, and Hindi productions. Often referred to by fans and media as \\\"Makkal Selvan\\\" meaning \\\"People\\\'s Treasure\\\", he is one of the most talented and versatile actors of his generation.', 253756800, 'Rajapalayam, Tamil Nadu, India', '1123766', 'vijay-sethupathi', 'upload/images/a3HWdfCAbplrvoMNEJCjnkbqqOo.jpg'),
(166, 'actor', 'Priyamani', 'Priyamani is an Indian multilingual film actress who works in Malayalam, Kannada, Tamil, Telugu and Hindi. She started her film career with her debut film in Kollywood called Kangalal Kaithu Sei alongside actor Vaseegaran. The film was a flop at the box-office and she moved on to Malayalam and Telugu films owing to a lack of offers in Tamil films. Priyamani has made her Tamil comeback with the internationally acclaimed Tamil film Paruthiveera and gained widespread recognition for her role as village girl Muththazhagu, receiving National Film Award for Best Actress and Tamil Nadu State Film Award for Best Actress for her performance.', 455155200, 'Bangalore, Karnataka, India', '1107197', 'priyamani', 'upload/images/i1sZtQcphZWJij3LoR9M6QY9i4z.jpg'),
(167, 'actor', 'Sanya Malhotra', 'Sanya Malhotra is an Indian actress who works in Hindi films. After making her film debut with the role of Babita Kumari in the biographical sports film Dangal, she starred in the comedy-drama Badhaai Ho, both of which rank among the highest-grossing Indian films.', 698976000, 'Delhi, India', '1756851', 'sanya-malhotra', 'upload/images/sQ0VIqGLecfpwYayO05Z7NC32yN.jpg'),
(168, 'actor', 'Girija Oak', '', 567561600, 'Nagpur, Maharashtra, India', '897996', 'girija-oak', 'upload/images/f10HPTExCVQ8mZXShctpWPsxxaw.jpg'),
(169, 'actor', 'Lehar Khan', '', 0, '', '1128415', 'lehar-khan', NULL),
(170, 'actor', 'Sanjeeta Bhattacharya', '', 832636800, 'New Delhi, India', '3136041', 'sanjeeta-bhattacharya', 'upload/images/5R43ctB6aRYvXEpS5DkiAxkfnkW.jpg'),
(171, 'actor', 'Aaliyah Qureishi', '', 0, '', '3472624', 'aaliyah-qureishi', NULL),
(172, 'actor', 'Sunil Grover', '', 239414400, '', '1485723', 'sunil-grover', 'upload/images/ing2HJHnpvl7uzEQpv5M7NP4XK8.jpg'),
(173, 'actor', 'Ridhi Dogra', 'Ridhi Dogra is an Indian Web and Television actress known for her portrayal of Nusrat in Indian web series Asur(voot), Astha in Indian web series The Married Woman (Alt Balaji), Priya in Maryada: Lekin Kab Tak? and participating in Fear Factor: Khatron Ke Khiladi 6.\n\nDogra was born on 22 September 1984 in Delhi. She studied at Apeejay School, Sheikh Sarai, New Delhi and graduated in Psychology (Honours) from Kamala Nehru College.', 464659200, 'Delhi, India', '1252084', 'ridhi-dogra', 'upload/images/7uSK4fvDDPtpKcTBfR0ogKhl3DN.jpg'),
(174, 'director', 'Atlee', 'Yogi Babu is an Indian film actor, who has appeared in Tamil language films. He rose to fame following his performances in Maan Karate (2014) and Yaamirukka Bayamey (2014), before becoming a regular cast member in Tamil comedy films.', 480211200, 'Chennai, Tamil Nadu, India', '1540764', 'atlee', 'upload/images/rySt5J2RBOqQutRFXc2kmqQ1i0K.jpg'),
(175, 'actor', 'Deepika Padukone', 'Deepika Padukone is an Indian film actress. She is one of the highest-paid actresses in the world and is cited in the media as one of the nation\\\'s most popular and attractive personalities. Padukone has established a career in Hindi films, and is the recipient of several awards, including three Filmfare Awards. Padukone, the daughter of the badminton player Prakash Padukone, was born in Copenhagen and raised in Bangalore. As a teenager she played badminton in national level championships, but left her career in the sport to become a fashion model. She soon received offers for film roles, and made her acting debut in 2006 as the title character of the Kannada film Aishwarya. Padukone then played a dual role in her first Bollywood release —the 2007 blockbuster Om Shanti Om— and won a Filmfare Award for Best Female Debut. The 2012 box office hit Cocktail marked a turning point in Padukone\\\'s career, earning her praise and Best Actress nominations at several award ceremonies. She rose to prominence with starring roles in the comedies Yeh Jawaani Hai Deewani (2013), Chennai Express (2013), and Happy New Year (2014), and the historical romance Bajirao Mastani (2015), all of which rank among the highest-grossing Bollywood films. Padukone\\\'s acclaimed portrayal of a character based on Juliet in the tragic romance Goliyon Ki Raasleela Ram-Leela (2013) and a headstrong architect in the comedy-drama Piku (2015) won her two Best Actress awards at Filmfare. Alongside her acting career, Padukone participates in stage shows, has written columns for an Indian newspaper, is a prominent celebrity endorser for brands and products, and is vocal about issues such as feminism and depression. She has designed her own line of clothing for women and is the founder of The Live Love Laugh Foundation, which creates awareness on mental health in India.', 505267200, 'Copenhagen, Denmark', '53975', 'deepika-padukone', 'upload/images/sXgEh0z6NzyvmEeBeLPK1ON7NBY.jpg'),
(176, 'actor', 'John Abraham', 'John Abraham (born December 17, 1972) is an Indian film actor, producer and a former model who appears in Hindi films.\n\nAfter modelling for numerous advertisements and companies, Abraham made his film debut with Jism (2003), which earned him a Filmfare Best Debut Award nomination. This was followed by his first commercial success, Dhoom (2004). He received two Filmfare Award nominations, for his negative roles in Dhoom, and in Zinda (2006). He later appeared in the major critical success Water (2005). He was nominated for a Filmfare Award for Best Supporting Actor for the film Baabul (2006). Since then, Abraham has starred in many critically and commercially successful films including Dostana (2008), New York (2009), Force (2011), Shootout at Wadala (2013), Madras Cafe (2013) and Welcome Back (2015).\n\nHis second film as a producer was Madras Cafe, which garnered critical acclaim. His athletic and muscular physique has contributed to his status as one of the most influential sex symbols in Bollywood. He is the co-owner of the Indian Super League football team NorthEast United FC. Apart from acting, Abraham has often performed many dangerous stunts in his films.', 93398400, 'Kochi, Kerala, India', '52971', 'john-abraham', 'upload/images/2ITVYVFou0dh3QVcJlhNJVzrA2p.jpg'),
(177, 'actor', 'Dimple Kapadia', 'Dimple Kapadia (born 8 June 1957) is an Indian film actress who predominantly appears in Hindi films. She was launched by Raj Kapoor at age 16, playing the title role in his teen romance Bobby (1973). In that same year she married Indian actor Rajesh Khanna and retired from acting. Kapadia returned to the film industry in 1984, following her separation from Khanna. One of her films of that period was the drama Saagar (1985). Both Bobby and Saagar won her the Filmfare Award for Best Actress. She went on to establish herself as one of the leading actresses of Hindi cinema in the 1980s.\n\nInitially recognized as a national sex symbol, Kapadia was keen to avoid being stereotyped and expand her range of acting roles. She subsequently took on more serious parts in a range of film genres, from mainstream to parallel cinema, and received acclaim for her performances in such films as Kaash (1987), Drishti (1990), Lekin... (1990), and Rudaali (1993), which earned her a National Film Award for Best Actress and a Filmfare Critics Award for Best Actress. She followed with supporting roles in Gardish (1993) and Krantiveer (1994), the latter of which garnered her a fourth Filmfare Award.\n\nKapadia continued working infrequently through the 1990s and the 2000s. She played a minor part in Dil Chahta Hai (2001) and was noted for her portrayal of the title role in the American production Leela (2002). Some of her later film credits include leading roles in Hum Kaun Hai? (2004), Pyaar Mein Twist (2005), Phir Kabhi (2008) and Tum Milo Toh Sahi (2010), and supporting roles in Being Cyrus (2005), Luck by Chance (2009), Dabangg (2010), Cocktail (2012) and Finding Fanny (2014). Kapadia is the mother of Twinkle Khanna and Rinke Khanna, both former actresses.', -396576000, 'Mumbai, India', '78921', 'dimple-kapadia', 'upload/images/rrISOX9TnetEAiZ5zCosTkmFdh2.jpg'),
(178, 'actor', 'Ashutosh Rana', 'Ashutosh Rana Ramnarayan Neekhra, known professionally as Ashutosh Rana, is an Indian actor, has been working in Marathi, Telugu, Kannada, Tamil & Hindi films for more than 20 years.He started his career with the television serial Swabhimaan, followed by serials like Farz, Sazish, Jax Kabhi, Waris and anchoring the TV show, Baazi Kiski. Later, in 2010, he had acted in a Star Plus show Kaali- Ek Agnipariksha, where he played an extremely powerful negative role as Thakral. He had also played lead role in famous TV serial of Doordarshan, named Apradhi Koun.\n\nHe became known in Indian Cinema after his movie Dushman, where he played a cold blooded psychopathic killer. He is mostly given roles of antagonists in movies, particularly that of a killer.He has acted in South Indian films. He played the role of Alia Bhatt\\\'s father in Karan Johar\\\'s Humpty Sharma Ki Dulhania.He has acted in many Kannada films like Vishnu Vijaya, starring Akshay Kumar.', -67651200, 'Gadarwara', '86508', 'ashutosh-rana', 'upload/images/jFlhAoEP3KGEXO3SXCA4YLM2Goc.jpg'),
(179, 'actor', 'Salman Khan', 'Salman Khan ( born Abdul Rashid Salim Salman Khan on 27 December 1965)  is an Indian film actor. He has starred in more than eighty Hindi films.\n\nKhan, who made his acting debut with a minor role in the drama Biwi Ho To Aisi (1988), had his first commercial success with the blockbuster Maine Pyar Kiya (1989), for which he won a Filmfare Award for Best Male Debut. He went on to star in some of Hindi cinema\\\'s most successful films of those times, such as Saajan (1991), Hum Aapke Hain Kaun (1994), Karan Arjun (1995), Judwaa (1997), Pyar Kiya To Darna Kya (1998) and Biwi No.1 (1999), having appeared in the highest earning films of seven separate years during his career. He is the only Indian actor to have 4 all-time blockbusters in his filmography, more than any other Indian actor in history, which was confirmed by a list of all-time blockbusters published by Box Office India.  In 1999, Khan won a Filmfare Award for Best Supporting Actor for his extended appearance in Kuch Kuch Hota Hai (1998), and since then has starred in several critical and commercial successes, including Hum Dil De Chuke Sanam (1999), Tere Naam (2003), Mujhse Shaadi Karogi (2004), No Entry (2005), Partner (2007), Wanted (2009) and Dabangg (2010), which has become the second highest-grossing Bollywood film of all-time. Khan has thus established himself as one of the most prominent, leading, and successful actors of Hindi cinema.\n\nDescription above from the Wikipedia article Salman Khan, licensed under CC-BY-SA,full list of contributors on Wikipedia.', -126662400, 'Indore, Madhya Pradesh, India', '42802', 'salman-khan', 'upload/images/gxKwCCcs777HzsXRpdGsBV87pXn.jpg'),
(180, 'actor', 'Akash Bhatija', '', 0, '', '230416', 'akash-bhatija', 'upload/images/oB6bkmmbqRKbPzt8gQbT0gqmWnE.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(181, 'actor', 'Prakash Belawadi', 'Prakash Belawadi is an Indian theater, film, television and media personality, an activist and a journalist from Bangalore. He co-founded the Centre for Film and Drama and launched the Suchitra School of Cinema and Dramatic Arts, both in Bangalore, the latter in 2012.', 0, 'Bangalore, Karnataka, India', '1543146', 'prakash-belawadi', 'upload/images/bECb7W5XUSFVOgN0z9Ob1ludIha.jpg'),
(182, 'actor', 'Viraf Patel', '', 329616000, 'Pune, Maharashtra, India', '2229209', 'viraf-patel', 'upload/images/PPmfooP4eUBA2GzpBZHOLE2m70.jpg'),
(183, 'actor', 'Shaji Choudhary', '', 0, '', '2176503', 'shaji-choudhary', NULL),
(184, 'actor', 'Diganta Hazarika', 'Diganta Hazarika is an Indian actor and model. He made his Bollywood debut in the epic adventure film, Mohenjo Daro, directed by Ashutosh Gowariker. He has acted in Assamese and Hindi films.', 464745600, 'Assam, India', '2140634', 'diganta-hazarika', 'upload/images/geDCjtz79oJcTaMq2tapbZiBgn7.jpg'),
(185, 'director', 'Siddharth Anand', 'Deepika Padukone is an Indian film actress. She is one of the highest-paid actresses in the world and is cited in the media as one of the nation\\\'s most popular and attractive personalities. Padukone has established a career in Hindi films, and is the recipient of several awards, including three Filmfare Awards. Padukone, the daughter of the badminton player Prakash Padukone, was born in Copenhagen and raised in Bangalore. As a teenager she played badminton in national level championships, but left her career in the sport to become a fashion model. She soon received offers for film roles, and made her acting debut in 2006 as the title character of the Kannada film Aishwarya. Padukone then played a dual role in her first Bollywood release —the 2007 blockbuster Om Shanti Om— and won a Filmfare Award for Best Female Debut. The 2012 box office hit Cocktail marked a turning point in Padukone\\\'s career, earning her praise and Best Actress nominations at several award ceremonies. She rose to prominence with starring roles in the comedies Yeh Jawaani Hai Deewani (2013), Chennai Express (2013), and Happy New Year (2014), and the historical romance Bajirao Mastani (2015), all of which rank among the highest-grossing Bollywood films. Padukone\\\'s acclaimed portrayal of a character based on Juliet in the tragic romance Goliyon Ki Raasleela Ram-Leela (2013) and a headstrong architect in the comedy-drama Piku (2015) won her two Best Actress awards at Filmfare. Alongside her acting career, Padukone participates in stage shows, has written columns for an Indian newspaper, is a prominent celebrity endorser for brands and products, and is vocal about issues such as feminism and depression. She has designed her own line of clothing for women and is the founder of The Live Love Laugh Foundation, which creates awareness on mental health in India.', 505267200, 'Copenhagen, Denmark', '53975', 'siddharth-anand', 'upload/images/9hQ4sX2XgOWvfJFv39z4uYrisqs.jpg'),
(186, 'actor', 'Ranbir Kapoor', 'Ranbir Kapoor is an Indian actor who appears in Bollywood movies. He first appeared in the 2007 film Saawariya for which he won a Filmfare Best Male Debut Award.\n\nBorn to actors Rishi Kapoor and Neetu Singh, Kapoor is the great grandson of Prithviraj Kapoor and the grandson of actor and filmmaker Raj Kapoor. He is the brother of Riddhima Kapoor and his uncles are Randhir Kapoor and Rajiv Kapoor. Other notable family members include his cousins Karisma Kapoor, Kareena Kapoor and Nikhil Nanda. As a child, Kapoor studied at Bombay Scottish School in Mahim, Mumbai, and went on to pursue method acting at The Lee Strasberg Theatre and Film Institute in New York.\n\nKapoor currently lives with his parents in Pali Hill in Mumbai, Maharashtra. He announced that he was dating Bollywood actress Deepika Padukone in an interview in February 2008. The couple later broke up in October 2009.', 402019200, 'Mumbai, Maharashtra, India', '85034', 'ranbir-kapoor', 'upload/images/ymYNHV9luwgyrw17NXHqbOWTQkg.jpg'),
(187, 'actor', 'Rashmika Mandanna', 'Rashmika Mandanna is an Indian Kannada language model and actress, who acts in south Indian Films mostly. Starting her career as a model, she made her debut in films in 2016', 828662400, 'Virajpet, Karnataka, India', '1752056', 'rashmika-mandanna', 'upload/images/scSz5mo0G0jTdT97otM3yIcsTZF.jpg'),
(188, 'actor', 'Anil Kapoor', 'Living in a Chawl in Tilak Nagar, Punjabi-speaking Anil was born in 1959 to Surinder and Nirmal aka Suchitra Kapoor. He has an elder brother, Boney, a sister, Reena, and a younger brother, Sanjay. His dad used to be Shammi Kapoor\\\'s Secretary.\n\nA loner, without many friends, he studied in the nearby O.L.P.S. (Our Lady of Perpetual Succor) School, and was an ardent fan of Bollywood flicks that were telecast during the Ganesh Maha Utsav every year. He was a fan of Raj Kapoor, and it was this that influenced his acting, and people saw him as a mimic of the legendary showman. He landed a role as a child artiste with Shashi Kapoor in the lead, but the movie (Tu Payal Main Geet) was never released.\n\nAfter school, he went to study in St. Xaviers College. He commuted by bus and train from Chembur to Bombay V.T., and the walked the rest of the way. It was here that he met Mazhar Khan. A distracted Anil was kicked out of College in the second year due to his lack of presence. His attempts to join the Pune Film Institute were in vain, as he failed in the written examination. He then decided to join Roshan Taneja\\\'s Acting school.\n\nHe first appeared on the silver screen in Hamhare Tumhare in a character role. His first lead role was in \\\'Woh 7 Din\\\' and from thence on there has been no looking back. He has acted in close to a 100 movies, and has 5 in production. He has produced two movies (Gandhi My Father & Badhaai Ho Badhaai), as well as been a Casting Director/Outdoor In charge for \\\'Hum Paanch\\\'.\n\nKapoor\\\'s first role in an international film was in Danny Boyle\\\'s 2008 Academy Award-winning film Slumdog Millionaire, for which he shared the Screen Actors Guild Award for Outstanding Performance by a Cast in a Motion Picture. His performance in the eighth season of the action series 24 generated rave reviews from the American press Globally, Anil Kapoor is one of the most recognized Indian actors.\n\nAnil met wealthy and chic model, Sindhi-speaking Sunita Bhambhani, and married her in 1984. Since then they have given birth to 3 children, kapoor has two daughters and a son Harshwardhan Kapoor.Kapoor\\\'s elder daughter is actress Sonam Kapoor. Rhea Kapoor attended school in New York and is now a producer in Mumbai.', -410918400, 'Mumbai, Maharashtra, India', '72118', 'anil-kapoor', 'upload/images/dwvnpiwg9m2zj0VHzlgzEotFl0G.jpg'),
(189, 'actor', 'Bobby Deol', 'Bobby Deol (born January 27, 1969) is an Indian film actor who works in Hindi films. In a career spanning more than two decades, he has appeared in over forty films and is the recipient of a Filmfare Award and a Filmfare Best Actor Award nomination. He is the son of Dharmendra and the brother of Sunny Deol, also a successful actor in the Indian Film Industry. He is particularly noted for acting in several thriller films, often playing antiheroic characters who are forced to commit crimes to avenge the deaths of loved ones and his films commonly involve themes of jealousy, deceit, revenge and romantic thrillers often involving him caught in love triangles.\n\nDeol briefly appeared as a child actor in the film Dharam Veer in 1977 and made his acting debut as an adult in Barsaat (1995) which garnered him the Filmfare Best Debut Award.  In addition to acting in films, Deol is involved with several humanitarian causes and has participated in concert tours and stage shows.', -29289600, 'Mumbai, Maharashtra, India', '77235', 'bobby-deol', 'upload/images/2npVa3PduichY8e7qBiE54m9VVP.jpg'),
(190, 'actor', 'Tripti Dimri', 'Tripti Dimri is an Indian actress whose talent was discovered by Sajid Ali which gave her, her breakthrough role with the classic love story ‘Laila Majnu’ (2018) where she plays the role of “Laila.” Tripti was fascinated by the glamorous life since the start and thus, started her career as a model. Let’s dig into some facts relating to Tripti’s personal and professional life.', 761961600, 'Rudraprayag, Uttarakhand, India', '2100209', 'tripti-dimri', NULL),
(191, 'actor', 'Prem Chopra', '', -1081641600, '', '86088', 'prem-chopra', 'upload/images/4hLAhScWZA6utfg8VCivwVH6FHy.jpg'),
(192, 'actor', 'Suresh Oberoi', 'From IMDB\n\nSuresh Oberoi was born on December 17, 1946 in Quetta, Baluchistan, British India as Vishal Kumar Oberoi. He is an actor, known for Namak Halaal (1982), Mirch Masala (1987) and Kanoon Kya Karega (1984).', -727142400, 'Quetta, Pakistan', '109173', 'suresh-oberoi', 'upload/images/eU19xoD28bzCImBXNpOQCIbhUZG.jpg'),
(193, 'actor', 'Shakti Kapoor', '', -357523200, '', '86017', 'shakti-kapoor', 'upload/images/a7LjjoGOhUXXXLsVZlSjjAx8BoW.jpg'),
(194, 'actor', 'Upendra Limaye', '', 0, '', '142335', 'upendra-limaye', 'upload/images/vFELR5TiBfc6LkLvI5kC5lpEnHv.jpg'),
(195, 'actor', 'Babloo Prithiveeraj', 'Babloo Prithiveeraj is an Indian film actor, who has appeared in Tamil, Telugu and Kannada language films. He has also featured extensively on Tamil television serials throughout the 1990s and 2000s.', -109123200, 'Bangalore, Karnataka, India', '584878', 'babloo-prithiveeraj', 'upload/images/lnRXcRebSmfJaSaRqTt91o1vkhE.jpg'),
(196, 'actor', 'Saurabh Sachdeva', '', 0, '', '2353414', 'saurabh-sachdeva', 'upload/images/pY8enRjOQIUlESZjtnZYEyR7ymI.jpg'),
(197, 'director', 'Sandeep Reddy Vanga', '', 820454400, '', '4412296', 'sandeep-reddy-vanga', 'upload/images/z8r0OaemVOQCOP2h3DeWYdVkD8G.jpg'),
(198, 'actor', 'Katrina Kaif', 'Katrina Kaif is a British Indian actress and former model who appears in Indian films, mainly in the Hindi-language film industry. She has also appeared in Telugu and Malayalam films. She was voted the sexiest Asian woman in the world by Eastern Eye in the years 2008, 2009 and 2010. Being a British citizen, she works in India on an employment visa. Kaif made her acting debut with Kaizad Gustad\\\'s box office failure Boom. She tasted success in 2007 with Vipul Shah\\\'s Namastey London and Anees Bazmee\\\'s Welcome. She has since appeared in films like New York (2009) and Rajneeti (2010). While the former earned Kaif her first Filmfare Award for Best Actress nomination, the latter emerged as her biggest commercial success so far. She got married to Vicky Kaushal, her colleague, in December 2021 in Rajasthan.\n\nDescription above from the Wikipedia article Katrina Kaif, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 458784000, 'Hong Kong', '81869', 'katrina-kaif', 'upload/images/sGxjQQ2ymrrplbRqFjwiJiUdc5w.jpg'),
(199, 'actor', 'Emraan Hashmi', 'Emraan Anwar Hashmi is an Indian film actor who appears in Hindi films. Through his career, Hashmi has received three Filmfare Award nominations.\n\nHe worked as an assistant director for the 2002 horror film Raaz before pursuing a career in acting. By 2004, Hashmi had established himself as one of the leading actors of Hindi cinema with roles in the successful Murder (2004), Zeher (2005), Aashiq Banaya Aapne (2005) and Gangster (2006).', 291081600, 'Mumbai, Maharashtra, India', '85969', 'emraan-hashmi', 'upload/images/kflgvFCFZnpTRbKmJWn5T0G5EKI.jpg'),
(200, 'actor', 'Simran', 'Simran Bagga is an Indian actress who has predominantly appeared in Tamil, Telugu and few Malayalam films. She debuted in Bollywood and acted in several Hindi films, before starring in her first Tamil film V.I.P and her first Telugu film Abbai Gari Pelli in 1997. After some highly successful films, she went on establish herself as the most successful actress in Tamil and Telugu film industries. She started her career with glamour roles initially, by the mid 1998 she reinvented herself through playing powerful characters and off beat roles.', 197424000, 'Mumbai, Maharashtra, India', '141705', 'simran', 'upload/images/BRsVC78sFbFy0NQhaUkGkuUUOL.jpg'),
(201, 'actor', 'Revathi', 'Revathy is an Indian actress and film director. She has acted in Tamil, Malayalam, Kannada, Telugu and Hindi films, directed several feature-length films, and has acted in and produced multiple television programs, totaling over twenty years of experience in the entertainment industry and over a hundred films to her credit. She has won several accolades, including three National Film Awards, in three different categories, and six Filmfare Awards South.', -109987200, 'Kochi, Kerala, India', '584324', 'revathi', 'upload/images/sXS4erG255VJlP7XYAduNBNPyDL.jpg'),
(202, 'actor', 'Sartaaj Kakkar', '', 1252022400, 'Gurgaon, Haryana, India', '4078961', 'sartaaj-kakkar', 'upload/images/fGsALORJKBh9I3xlg33hEt7Opbf.jpg'),
(203, 'actor', 'Kumud Mishra', 'Kumud Mishra is an Indian actor who works in Hindi-language films. One of his earliest roles was in the 1995 Doordarshan drama Swabhimaan where he played the role of Eknath, a trade union leader. Following an appearance as the younger version of Rishi Kapoor\\\'s character in the 2011 drama Patiala House, his career took an upswing after he starred as Khatana alongside Rishi\\\'s son Ranbir Kapoor in Rockstar the same year.', 0, '', '1179628', 'kumud-mishra', 'upload/images/pM4eD7eIEPk2Lx0c5C1K201qnp6.jpg'),
(204, 'actor', 'Anant Vidhaat Sharma', '', 0, 'Gwalior, Madhya Pradesh, India', '2294407', 'anant-vidhaat-sharma', 'upload/images/fNyw53r3AcuL1zvwOhtcErNBjG3.jpg'),
(205, 'actor', 'Chandrachoor Rai', 'Chandrachoor Rai is an Indian film Actor, who has worked predominantly in Bollywood.', 0, '', '2432761', 'chandrachoor-rai', 'upload/images/exEN1xA5RWYv50oDxR7APb7eAk2.jpg'),
(206, 'actor', 'Gavie Chahal', '', 279590400, 'Mansa, India', '1254791', 'gavie-chahal', 'upload/images/r7cH2wLoWNlDYLsx1qhUoEcvJuH.jpg'),
(207, 'actor', 'Danish Bhatt', '', 0, '', '2220179', 'danish-bhatt', 'upload/images/oFbSO96VL3naxp64h9tx2LwY3DO.jpg'),
(208, 'director', 'Maneesh Sharma', '', 0, 'Gwalior, Madhya Pradesh, India', '2294407', 'maneesh-sharma', NULL),
(209, 'actor', 'Vikrant Massey', 'Vikrant Massey is an Indian actor. He is noted for his leading roles in TV series, Dharam Veer (2008), Balika Vadhu (2009), Baba Aiso Varr Dhoondo (2010), V The Serial (2012) and Qubool Hai (2013) and in Bollywood movies Lootera and Dil Dhadakne Do. He has played the main role in the critically acclaimed 2017 Konkona Sen movie A Death in the Gunj.', 544406400, 'Mumbai, India', '1208682', 'vikrant-massey', 'upload/images/cxPopndw8aClOhs29z3ERldnjlX.jpg'),
(210, 'actor', 'Medha Shankar', 'Medha is a Bollywood actress. She is a trained Hindustani classical singer and completed her master\\\'s degree in Fashion Management from National Institute of Fashion Technology, Delhi.', 0, 'Mumbai, Maharashtra', '3112841', 'medha-shankar', 'upload/images/uVejNPonC1JTYNM5924fYISsUDC.jpg'),
(211, 'actor', 'Anant Joshi', '', 0, '', '2039294', 'anant-joshi', 'upload/images/tF5SAJErub0YQUnJe2IN6ttF7TB.jpg'),
(212, 'actor', 'Anshumaan Pushkar', '', 0, '', '3063739', 'anshumaan-pushkar', 'upload/images/lIFM0hc0y9SCHS1OVpzX3maQMVc.jpg'),
(213, 'actor', 'Geeta Agrawal Sharma', '', 0, '', '1197127', 'geeta-agrawal-sharma', 'upload/images/5Jrwb9zWG2Hjmf8PQLuDmCKnMHG.jpg'),
(214, 'actor', 'Priyanshu Chatterjee', 'Priyanshu Chatterjee is an Indian actor and former model known for his works in Bollywood, and Bengali cinema. He made his Hindi film debut in the box-office big success Tum Bin in 2001. He will next be seen in the Bengali film, Mayamrigaya (2022), as Rabindranath Tagore.', 98928000, 'New Delhi, India', '86622', 'priyanshu-chatterjee', 'upload/images/fPAIAZcdGD2UBMwBluqiYi5pXHb.jpg'),
(215, 'actor', 'Rakul Preet Singh', 'Rakul Preet Singh is an Indian film actress and model who predominantly works in Telugu film industry. She has also appeared in a few Tamil, Hindi and Kannada films.\n\nRakul started a modelling career while in college, during which she also made her acting debut in the Kannada film Gilli (2009). In 2011, she participated in the Femina Miss India pageant in which she was placed fifth and won five pageant titles, including \\\'Miss India People’s Choice\\\'. She subsequently opted to become a full-time actress, making her Telugu debut in Keratam the same year and her Tamil debut in Thadaiyara Thaakka, the following year. In 2014 she also made her Bollywood debut in Yaariyan in which her performance was better received.', 687052800, 'New Delhi, India', '1143308', 'rakul-preet-singh', 'upload/images/4n4MmOFNyxKc4qMfzyapglvDDlF.jpg'),
(216, 'actor', 'Sumeet Vyas', 'Sumeet Vyas is an Indian actor and writer known for his role as Mikesh in the popular web series Permanent Roommates. He has acted in some Bollywood films in supporting roles, though he calls himself more of a theatre artist.', 428112000, 'Jodhpur, Rajasthan, India', '1430638', 'sumeet-vyas', 'upload/images/qGwWWHQsMU4V9ZMZnqNxdnXpYo2.jpg'),
(217, 'actor', 'Satish Kaushik', 'Satish Kaushik is an Indian film director and actor in Hindi films and theatre. As a film actor his most remembered for his role as \\\'Calendar\\\' in Mr. India, and as \\\'Chanu Ahmed\\\' in Sarah Gavron\\\'s English film Brick Lane (2007). He also won Filmfare Best Comedian Award twice in 1990 for film Ram Lakhan and 1997 for Saajan Chale Sasural.\n\nAs theatre actor his most known role is that of \\\'Willy Loman\\\' in Hindi play \\\'Salesman Ramlal, an adaptation of Arthur Miller’s Death of a Salesman.\n\nAs a dialogue writer he wrote dialogues for Kundan Shah\\\'s comedy classic Jaane Bhi Do Yaaron (1983).\n\nHis film Teree Sang starring Ruslaan Mumtaz and Sheena Shahabadi is based on teen pregnancy.\n\nHis latest film Milenge Milenge, starring Shahid Kapoor and Kareena Kapoor once again which has been delayed a few times.\n\nDescription above from the Wikipedia article Satish Kaushik, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -432950400, 'Mohindergarh, Patiala and East Punjab States Union, India', '93290', 'satish-kaushik', 'upload/images/lnqVTsUKVxJYPWN3KRBhRlGP1Z0.jpg'),
(218, 'actor', 'Prachee Shah', 'Prachee Shah Paandya, also known as Prachi Shah, is an Indian actress and Kathak dancer who appears in Hindi films and television. She is known for her roles in television shows like Kyunki Saas Bhi Kabhi Bahu Thi and Ek Shringaar-Swabhiman.', 313718400, '', '1239665', 'prachee-shah', 'upload/images/nCiNfb8VCtQ0PcYzIzzdVI5GlRl.jpg'),
(219, 'actor', 'Rajesh Tailang', '', 0, '', '1197124', 'rajesh-tailang', 'upload/images/ou1zcrNfhXBKcpnPgtKs64SRGXm.jpg'),
(220, 'actor', 'Riva Arora', '', 0, '', '2785475', 'riva-arora', 'upload/images/1dPTZNZYwxuDlLmlcZ78tyGoNzk.jpg'),
(221, 'actor', 'Dolly Ahluwalia', 'Dolly Ahluwalia is an Indian actress and costume designer who was awarded the Sangeet Natak Akademi Award in 2001 for costume design. She has won the National Film Award thrice, twice for Best Costume Design for Bandit Queen (1993) and Haider (2014), and then as Best Supporting Actress for Vicky Donor (2012), which is also her best known role as an actor.', 0, '', '85877', 'dolly-ahluwalia', 'upload/images/cZDDdr59pQGrjHrRH5THBJkbzp1.jpg'),
(222, 'actor', 'Rakesh Bedi', 'Rakesh Bedi is an Indian film, stage and television actor. He is most known for his comedy roles in films such as Chashme Buddoor (1981), the television series, Yeh Jo Hai Zindagi (1984), Shrimaan Shrimati (1995) and Yes Boss (1999–2009).\n\nBedi started his film career as a supporting actor in the 1979 film Hamare Tumhare, starring Sanjeev Kumar, and then went on to act in over 150 films and several TV serials. Some of his most memorable roles were in the 1981 film Chashme Buddoor with Farooq Shaikh, Ek Duuje Ke Liye and Ravi Baswani and in the TV sitcoms Shrimaan Shrimati (1995), Yes Boss and Yeh Jo Hai Zindagi (1984), written by Sharad Joshi and directed by Kundan Shah. He had a minor role in Gulzar\\\'s Mere Apne, and has acted in a number of Punjabi movies, including Main Tu Assi Tussi.', -476064000, 'New Delhi, India', '110200', 'rakesh-bedi', 'upload/images/dWLCiA3rqnaFPn9s0bk2MiSq5Mt.jpg'),
(223, 'actor', 'Pankaj Tripathi', 'Pankaj Tripathi is an Indian actor who appears predominantly in Hindi films. Famous for his natural acting, he debuted in 2004 with a minor role in Run and Omkara and has since worked in more than 40 films and 60 television shows. Tripathi\\\'s breakthrough came in 2012 for his supporting role in the Gangs of Wasseypur film series. He has since received critical appraisal for multiple films, including Fukrey (2013), Masaan (2015), Nil Battey Sannata (2016), Bareilly Ki Barfi (2017), Newton (2017), Fukrey Returns (2017) and Stree (2018). For Newton, Tripathi earned several awards including a National Film Award – Special Mention.', 210729600, 'Belsand, Bihar, India', '1179460', 'pankaj-tripathi', 'upload/images/f3Vxz0QB7PHeyPcXrfJX14Xkxnu.jpg'),
(224, 'actor', 'Akshay Kumar', '​Akshay Kumar is an Indian film actor, producer and martial artist who has appeared in over a hundred Hindi films. When he began his acting career in the 1990s, he primarily starred in action films and was particularly known for his appearances in feature films commonly called the \\\"Khiladi series\\\", which included Khiladi (1992), Sabse Bada Khiladi (1995), Khiladiyon Ka Khiladi (1996), and Khiladi 420 (2000), as well as other action films such as Mohra (1994). As a stunt actor, he often performed many dangerous stunts in his films, which earned him a reputation as the \\\"Indian Jackie Chan\\\". He later gained more fame for his drama, romance and comedy roles. He started becoming known for his performances in romance films like Yeh Dillagi (1994) and Dhadkan (2000) as well as drama films such as Ek Rishtaa (2001). His comic performances in comedy films such as Hera Pheri (2000), Mujhse Shaadi Karogi (2004), Garam Masala (2005) and Waqt: The Race Against Time (2005) met with acclaim. His success further rose in 2007, when he starred in four consecutive commercial hits. In 2008, the University of Windsor in Ontario, Canada conferred an Honorary Doctorate of Law on Kumar in recognition of his contribution to Indian cinema. In 2009, he was awarded the Padma Shri by the Government of India. He has thus established himself as one of the leading actors in Hindi cinema. In 2009, Kumar founded the Hari Om Entertainment production company.', -73008000, 'Amritsar, Punjab, India', '35070', 'akshay-kumar', 'upload/images/gaINfJtR19rNTIsI2cF3KFjyAB7.jpg'),
(225, 'actor', 'Yami Gautam', 'Yami Gautam is an Indian film and television actress. Her initial appearances were on Indian television commercials and soap operas like Chand Ke Paar Chalo and Yeh Pyar Na Hoga Kam.   In 2010, she made her cinematic debut with Kannada film Ullasa Utsaha, co-starring Ganesh. In 2012, Gautam made her Bollywood debut in Shoojit Sircar\\\'s romantic comedy Vicky Donor, which touched on the topic of sperm donation. Upon release, the film was a critical and commercial success, and Gautam gained positive reviews for her performance.', 0, 'Bilaspur, Himachal Pradesh, India', '1115720', 'yami-gautam', 'upload/images/wQwYuofypdW7JnglmyFbeWKu33j.jpg'),
(226, 'actor', 'Pavan Malhotra', '', 0, '', '53379', 'pavan-malhotra', 'upload/images/aqTzRvGsujDgxoLbVEvVEZVTyNr.jpg'),
(227, 'actor', 'Arun Govil', '', 0, '', '1228593', 'arun-govil', 'upload/images/xgefRNWurCiwyLSlpnDGgfMIF7H.jpg'),
(228, 'actor', 'Govind Namdeo', '', 0, '', '85659', 'govind-namdeo', 'upload/images/4PYvzEHjEXScVjYuiQxVpNpvQ18.jpg'),
(229, 'actor', 'Aarush Varma', '', 0, '', '4223729', 'aarush-varma', NULL),
(230, 'actor', 'Brijendra Kala', 'Brijendra Kala is an Indian actor who works in Bollywood films. He is known for his subtle portrayals of characters rooted in reality. He gained attention for his small roles in mainstream Hindi cinema.', 0, '', '230440', 'brijendra-kala', 'upload/images/wogG1hX0EHzAhnfnGpN3tY3Ch6n.jpg'),
(231, 'actor', 'Shreedhar Dubey', '', 0, '', '2503023', 'shreedhar-dubey', NULL),
(232, 'actor', 'Hemant Choudhary', '', 0, '', '4223741', 'hemant-choudhary', NULL),
(233, 'director', 'Amit Rai', 'Yami Gautam is an Indian film and television actress. Her initial appearances were on Indian television commercials and soap operas like Chand Ke Paar Chalo and Yeh Pyar Na Hoga Kam.   In 2010, she made her cinematic debut with Kannada film Ullasa Utsaha, co-starring Ganesh. In 2012, Gautam made her Bollywood debut in Shoojit Sircar\\\'s romantic comedy Vicky Donor, which touched on the topic of sperm donation. Upon release, the film was a critical and commercial success, and Gautam gained positive reviews for her performance.', 0, 'Bilaspur, Himachal Pradesh, India', '1115720', 'amit-rai', NULL),
(234, 'actor', 'Parineeti Chopra', 'Chopra initially aspired to pursue a career in investment banking, but after obtaining a triple honors degree (in business, finance and also economics) from Manchester Business School she returned to India during the 2009 economic recession and joined Yash Raj Films as a public relations consultant. Later, she signed a three-film deal with the company as an actress.', 593481600, 'Haryana, India', '1034471', 'parineeti-chopra', 'upload/images/w2WTsdqs9t0OzQ9sxkntXKf5NAN.jpg'),
(235, 'actor', 'Dibyendu Bhattacharya', 'Dibyendu Bhattacharya is an Indian actor known for his work in Hindi and Bengali cinema. Born in Behala, he made his acting debut in 2001 with \\\"Monsoon Wedding,\\\" alongside Naseeruddin Shah.  He holds a Bachelor of Arts degree from Vivekananda College and is an alumnus of the National School of Drama.\n\nNotable for performances in \\\"Dev D.,\\\" \\\"Chittagong,\\\" \\\"Black Friday,\\\" and \\\"Dhan Dhana Dhan Goal,\\\" Dibyendu\\\'s filmography includes hits like \\\"Ab Tak Chhappan\\\" and \\\"Lootera.\\\"  Beyond films, Dibyendu made a mark on television with \\\"24\\\" (2013) and featured in web series like \\\"Sacred Games,\\\" \\\"Mirzapur\\\" Season 2, and \\\"Ray\\\" (2021). His 2022 portrayal of Prof. Mehdi Raza in \\\"Rocket Boys\\\" showcased his versatility.', 184896000, 'Kolkata, West Bengal, India', '101823', 'dibyendu-bhattacharya', 'upload/images/uLlGKCL9y5CFBwcAafTDQhupz5h.jpg'),
(236, 'actor', 'Ravi Kishan', 'Ravi Kishan, is an Indian actor, politician, film producer, and television personality. He currently serves as a Member of Parliament, Lok Sabha from Gorakhpur. His film works are predominantly in Bhojpuri and Hindi cinema, as well as Telugu cinema. He has also appeared in a few Kannada and Tamil films.', -14515200, 'Janpur, Uttar Pradesh, India', '85882', 'ravi-kishan', 'upload/images/kuwKd2WM64gJqwNoqv89DHuds5g.jpg'),
(237, 'actor', 'Rajesh Sharma', 'A prominent face in Bollywood, Rajesh Sharma is an Indian actor who is mostly seen as the villain or in comic roles. The actor who made his debut on the silver screen in 1996 with the super hit movie, Maachis is also a renowned personality in the Bengali film industry. During the 2000s the actor appeared only in Bengali movies before eventually making a comeback to Bollywood in 2005 with the critically acclaimed film Parineeta directed by Pradeep Sarkar. The actor has worked with several renowned filmmakers and actors from both Bengali and Hindi film industry like Salman Khan, Vidya Balan, Naseeruddin Shah, Rani Mukerji, Dibakar Bandopadhyay, Aparna Sen, and Haranath Chakraborty. Born in a typical middle-class Punjabi family in Ludhiana, Punjab, Rajesh Sharma is the son of Late Gurucharan Sharma and Amarjit Sharma. After completing his schooling from Bhawanipur Adarsh Hindi High School in Kolkata, the actor went to pursue his graduation from the NSD (National School of Drama) in New Delhi. The actor who has established himself as one of the prominent actors in the Bengali film industry learned Bengali from his neighbors as well as by watching several Bengali dramas at Muktangon.\n\nAt the age of 17, Rajesh Sharma joined a drama academy where he got a chance to feature in several plays like Gudia Ki Ghar and Rangakarmi. After gaining substantial acting experience on stage, the actor moved to acting in TV serials and films. The actor made his acting debut on the silver screen with the critically acclaimed film, Maachis directed by Gulzar and co-starring, Chandrachur Singh, Jimmy Shergill, Raj Zutshi, Tabu and Om Puri. The film based on the aftermath of the assassination of the Prime Minister of India, Indira Gandhi and the subsequent Anti-Sikh riots in 1984 was a huge commercial hit and won the National Film Award for Best Popular Film Providing Wholesome Entertainment. Following his debut movie, the actor took a sabbatical for four years and made his comeback in 2000 with a Bengali film titled Paromitar Ek Din, written and directed by Aparna Sen. The film starring, Rituparna Sengupta, Aparna Sen, and Soumitra Chatterjee won several national and international awards including the National Film Award for Best Feature Film in Bengali, Ecumenical Jury Award the 35th International Film Festival of Karlovy Vary, one of the oldest in the world and Central and Eastern Europe\\\'s leading film event.', 55641600, 'Ludhiana, Punjab, India', '648087', 'rajesh-sharma', 'upload/images/cBmZY1EICMD1q16Fx7GqpHkc6A1.jpg'),
(238, 'actor', 'Jameel Khan', '', 0, '', '113686', 'jameel-khan', 'upload/images/cyezX9i1wLduoixoTIi6VID8lGA.jpg'),
(239, 'actor', 'Varun Badola', '', 0, '', '122498', 'varun-badola', 'upload/images/dzSBwofeP4dh3bP8TG6VxkHSjLy.jpg'),
(240, 'actor', 'Shishir Sharma', 'Shishir Sharma is an Indian film and television actor. He played in Zee TV\\\'s show Ghar Ki Lakshmi Betiyann. He is known for played the role of Jagmohan Prasad in Yahaaan Main Ghar Ghar Kheli.', 0, '', '239728', 'shishir-sharma', 'upload/images/fNyJckJRkWhMassWL6YlkPMFfvK.jpg'),
(241, 'actor', 'Ananth Narayan Mahadevan', '', 0, '', '86062', 'ananth-narayan-mahadevan', 'upload/images/pATgqyeAeVxAYckHtH87cSmVkMS.jpg'),
(242, 'director', 'Tinu Suresh Desai', 'Ravi Kishan, is an Indian actor, politician, film producer, and television personality. He currently serves as a Member of Parliament, Lok Sabha from Gorakhpur. His film works are predominantly in Bhojpuri and Hindi cinema, as well as Telugu cinema. He has also appeared in a few Kannada and Tamil films.', -14515200, 'Janpur, Uttar Pradesh, India', '85882', 'tinu-suresh-desai', NULL),
(243, 'actor', 'Ranveer Singh', 'Ranveer Singh Bhavnani is an Indian film actor who appears in Hindi films. After completing a bachelor\\\'s degree from Indiana University, Bloomington, Singh returned to India to pursue a career in film. He made his acting debut in 2010 with a leading role in Yash Raj Films\\\' romantic comedy Band Baaja Baaraat. The film emerged as a critical and commercial success, earning Singh a Filmfare Award in the Best Male Debut category.\n\nSingh went on to star in the romantic drama Lootera (2013), Sanjay Leela Bhansali\\\'s tragic romance Goliyon Ki Raasleela Ram-Leela (2013), his biggest commercial successes to that point, and in the action-drama Gunday (2014). In 2015, he starred in the ensemble comedy-drama Dil Dhadakne Do (2015), and portrayed Bajirao in the historical romance Bajirao Mastani, one of the highest-grossing Bollywood films, for which he garnered critical acclaim and won the Filmfare Award for Best Actor.', 489456000, 'Mumbai, Maharashtra, India', '224223', 'ranveer-singh', 'upload/images/sRiwLmhduFghJo8U2coUafnDD4C.jpg'),
(244, 'actor', 'Alia Bhatt', 'Alia Bhatt is an Indian actress who appears in Bollywood films.​ She is the daughter of director, producer, and screenwriter Mahesh Bhatt and Soni Razdan, a film actress and director. She has one sister Shaheen Bhatt, a half sister Pooja Bhatt, and a half brother Rahul Bhatt. Actor Emraan Hashmi and director Mohit Suri are her cousins and producer Mukesh Bhatt is her uncle. Alia has completed high-school from Jamnabai Narsee School IB in May 2011.', 732153600, 'Mumbai, Maharashtra, India', '1108120', 'alia-bhatt', 'upload/images/RBnTJPegPFLBS4VPsNLbf6iAoD.jpg'),
(245, 'actor', 'Dharmendra', 'Dharmendra Singh Deol known as Dharmendra, is an award-winning Legendary Hindi film star who has appeared in more than 200 Hindi-language films. In 1997 he received the Filmfare Lifetime Achievement Award for his contribution to Hindi cinema. He is regarded as the Undisputed \\\"Action King\\\" of Hindi cinema having starred in numerous action blockbusters and is greatly considered a Living legend. He is father of notable actors Sunny Deol, Bobby Deol and Esha Deol. He was the Main lead of the all-time Blockbuster film, Sholay and also went on to star in numerous successful Bollywood films cutting across four remarkable decades. Dharmendra has thus established himself as one of the most prominent figures of the Hindi film industry', -1075075200, 'Ludhiana, Punjab, India', '85655', 'dharmendra', 'upload/images/qRT0nOpxt14osa76nTrNduawX0l.jpg'),
(246, 'actor', 'Shabana Azmi', 'Shabana Azmi is an Indian actress of film, television and theatre. She\\\'s an alumna of the Film and Television Institute of India of Pune. After her film debut in 1974 she soon became one of the leading actresses of parallel cinema, an Indian New Wave movement known for its serious content and neo-realism.', -608688000, 'New Delhi, India', '85672', 'shabana-azmi', 'upload/images/oZIL1OPo7163tOpyRUapyRDejT1.jpg'),
(247, 'actor', 'Jaya Bachchan', '', -685756800, '', '35743', 'jaya-bachchan', 'upload/images/gXmIdkOhJN7pa8XDR7KQJXgtXni.jpg'),
(248, 'actor', 'Aamir Bashir', 'Aamir Bashir  is an Indian actor and director.His acting career began with a very small role on television, Bhanwar TV series, and acted in several TV advertisements, this led to film debut, Split Wide Open (1999) and the telefilm, Doordarshan Srinagar. He made his film debut in the 2003 film Armaan. Acclaim came his way in 2008, with thriller, A Wednesday, where he essayed the role of a police inspector; the film also won him a Screen Awards nomination for Best Actor in a Supporting Role.\n\nIn 2010 Bashir\\\'s directorial debut Harud premiered at the Toronto International Film Festival. The film stars Reza Naji and Shahnawaz Bhat and takes place in Kashmir.\n\nDescription above from the Wikipedia article Aamir Bashir,  licensed under CC-BY-SA, full list of contributors on Wikipedia.', 0, 'Kashmir, India', '123228', 'aamir-bashir', 'upload/images/jWvHNzlDwbTyJaShBeXfIKl2QHU.jpg'),
(249, 'actor', 'Tota Roy Chowdhury', 'Tota Roy Chowdhury was born on July 9, 1976 in Calcutta, West Bengal, India as Pushparag Roy Choudhury. He is an actor and director, known for Kaththi (2014), Kahaani 2 (2016) and Choker Bali: A Passion Play (2003).', 205718400, 'Kolkata, West Bengal, India', '1280400', 'tota-roy-chowdhury', 'upload/images/wrNQH7bl48uBYWxlRdrRLbGVZs4.jpg'),
(250, 'actor', 'Churni Ganguly', 'Churni Ganguly is an Indian TV and film actress who mainly works in Bengali cinema and TV series. The actress who spent most of her childhood in Kolkata started acting while she was studying at the Jadavpur University; she joined a local theater group and after gaining experience in acting, she later moved to Mumbai to pursue a full-time career in acting. She started her journey with her roles in TV serials like Debi, a Bengali series, Chhoti Si Asha and Umeed, Hindi series, which was aired on Zee TV. She got her first break on the silver screen in 2004 as she was roped in by spouse and director Kaushik Ganguly to play one of the lead roles in Waarish. After her debut, she eventually starred in films like Shunyo E Buke (2005), Sakaler Rang (2009), Laptop (2012), Shabdo (2013), Chaya O Chobi (2017), and Lokkhi Chhele (2022). Apart from acting, the actress has also directed a couple films titled Nirabshito (2014) and Tarikh (2019). Her 2023 release includes Ardhangini and Kaberi Antardhan.', 0, '', '1588795', 'churni-ganguly', 'upload/images/u7LVmZQEZ28zNqgJdzxh99fzpWq.jpg'),
(251, 'actor', 'Kshitee Jog', '', 0, '', '1247026', 'kshitee-jog', 'upload/images/iUnbW9eujjZXmn9Rd68lylIwjJl.jpg'),
(252, 'actor', 'Anjali Anand', '', 0, '', '1835261', 'anjali-anand', 'upload/images/x35BaUKgC5kHYQtMxazfL07gGoO.jpg'),
(253, 'actor', 'Namit Das', '', 0, '', '86883', 'namit-das', 'upload/images/8Wm6DHg6OapLLTQA7I2b8nLksr7.jpg'),
(254, 'director', 'Karan Johar', 'Alia Bhatt is an Indian actress who appears in Bollywood films.​ She is the daughter of director, producer, and screenwriter Mahesh Bhatt and Soni Razdan, a film actress and director. She has one sister Shaheen Bhatt, a half sister Pooja Bhatt, and a half brother Rahul Bhatt. Actor Emraan Hashmi and director Mohit Suri are her cousins and producer Mukesh Bhatt is her uncle. Alia has completed high-school from Jamnabai Narsee School IB in May 2011.', 732153600, 'Mumbai, Maharashtra, India', '1108120', 'karan-johar', 'upload/images/zip1x7OXOBxXxcdYvKOgw6MnAWm.jpg'),
(255, 'actor', 'Sidharth Malhotra', 'Sidharth Malhotra is an Indian actor and former model who appears in Hindi films. Malhotra began a career as a model at the age of 18. Dissatisfied by the profession, he went on to work as an assistant director to Karan Johar in the 2010 film My Name Is Khan. He made his acting debut with a leading role in Johar\\\'s comedy-drama Student of the Year (2012), for which he received a Filmfare Award for Best Male Debut nomination.\n\nMalhotra played an aspiring businessman in the critically praised comedy-drama Hasee Toh Phasee in 2014, following which he starred as a hardened criminal in the romantic thriller Ek Villain (2014) and an aspiring author in the family drama Kapoor & Sons (2016). The latter two rank among Malhotra\\\'s highest-grossing films, with a worldwide gross of over ₹1 billion (US$15 million) each.', 474681600, 'Delhi, India', '1108117', 'sidharth-malhotra', 'upload/images/4lpSudJC7VVZOvUrLX94qvdc0nC.jpg'),
(256, 'actor', 'Sharib Hashmi', 'Sharib Hashmi (born 25 January 1976) is an Indian actor, writer, producer and director who works in the Hindi cinema. He is best known for portraying J.K. Talpade in the Amazon Prime Video series The Family Man (2019-2021) and Sunny in Filmistaan.\n\nFrom Wikipedia, the free encyclopedia', 191376000, 'Malad, Mumbai, India', '1326933', 'sharib-hashmi', 'upload/images/S3J1QbSDE7wqvlQjVKVF5jLHT.jpg'),
(257, 'actor', 'Parmeet Sethi', 'Parmeet Sethi is an Indian actor, director, producer and writer. He is best known for portraying Kuljeet Singh in Aditya Chopra\\\'s directorial debut Dilwale Dulhania Le Jayenge (1995)', -96508800, 'New Delhi, Delhi, India', '85696', 'parmeet-sethi', 'upload/images/paTrHCbnwMxBZREfoGcfY5TlvyY.jpg'),
(258, 'actor', 'Rajit Kapoor', '', 0, '', '226769', 'rajit-kapoor', 'upload/images/mATIzHiXTeW6xB8IoJVLTD5NDMn.jpg'),
(259, 'actor', 'Mir Sarwar', 'Mir Sarwar is an Indian film actor, who has appeared in Hindi language films and television serials.', 0, 'Srinagar, Jammu and Kashmir, India', '1423932', 'mir-sarwar', 'upload/images/vyyRELWNWFOWKq9ubWIqWpF6KCj.jpg'),
(260, 'actor', 'Manoj Bakshi', '', 0, '', '1724113', 'manoj-bakshi', 'upload/images/9ieo5XUm9Z173NwphJfSSTs2s7S.jpg'),
(261, 'actor', 'Ashwath Bhatt', '', 0, '  Kashmir, India', '1278968', 'ashwath-bhatt', 'upload/images/hSJyFIy8Mvj59YQlcluhd9Xf97F.jpg'),
(262, 'actor', 'Zakir Hussain', 'Zakir Hussain is an Indian film actor who is known for his negative and comic roles. His best-known performances include those of Rashid in Ramgopal Varma\\\'s 2005 film Sarkar, and Shardul in Sriram Raghavan\\\'s 2007 film Johnny Gaddaar. Prakash Rao in Singham Returns [Rohit Shetty] and many more.', 0, 'Meerut, Uttar Pradesh, India', '85656', 'zakir-hussain', 'upload/images/etiL0ANjzBhTiyvUblZl6vwIog9.jpg'),
(263, 'actor', 'Vikram', 'Vikram (born as Kennedy John Victor) is an Indian film actor who predominantly appears in Tamil language films and has won seven Filmfare Awards as well as one National Film Award and Tamil Nadu State Film Award amongst other recognitions and was awarded an Honorary Doctorate by the People\\\'s University of Milan in May 2011.\n\nHe made his debut in the 1990 film En Kadhal Kanmani, which was followed by a series of small-budget Tamil, Malayalam and Telugu films in the 1990s, many of which went unnoticed. However the success of Bala\\\'s tragedy film Sethu (1999), in which Vikram appeared as a rogue turned lover, started Vikram\\\'s successful career as an actor.  Vikram has promoted various social causes and appeared as the Youth Envoy for the United Nations Human Settlements Programme  in 2011. He has been a brand ambassador of Sanjeevani Trust and a  school for special children, Vidya Sudha, which he stayed at during the  making of Deiva Thirumagal as well as having long-term  associations with the Kasi Eye Care and running his own welfare  association through the Vikram Foundation. In 2016, he produced and directed the video to the flood relief anthem, Spirit of Chennai, as a tribute to the city\\\'s volunteers following the 2015 South Indian floods.', -117072000, 'Chennai, Tamil Nadu, India', '93191', 'vikram', 'upload/images/c171LQMyHtULZC0RmuIHiiFDOjv.jpg'),
(264, 'actor', 'Aishwarya Rai Bachchan', 'Aishwarya Rai Bachchan is an Indian actress and former Miss World. Before starting her acting career, she worked as a model and ultimately won the Miss World title in 1994. Rai has acted in over 40 movies in Hindi, English, Tamil and Bengali, which include few international productions. Often cited by the media as the most beautiful woman in the world, Rai made her movie debut in Mani Ratnam\\\'s Tamil film Iruvar (1997) and had her first commercial success in the Tamil movie Jeans (1998). She gained the attention of Bollywood through the film Hum Dil De Chuke Sanam (1999), directed by Sanjay Leela Bhansali. Her performance in the film won her the Filmfare Best Actress Award. In 2002 she appeared in Bhansali\\\'s Devdas, for which she won her second Filmfare Best Actress Award. After a setback in her career during 2003–2005, she appeared in Dhoom 2 (2006), which turned out to be her biggest commercial success in bollywood. She later appeared in films like Guru (2007), Jodhaa Akbar (2008), and Enthiran (2010) which were commercially successful and critically acclaimed. Rai, thus established herself as one of the leading actresses in Bollywood.\n\nIn 2009, she was honored with the Padma Shri by the Government of India.', 120960000, 'Mangalore, Karnataka, India', '87773', 'aishwarya-rai-bachchan', 'upload/images/31L3uTQSeLS5g3EgALNdVbZT1W.jpg'),
(265, 'actor', 'Jayam Ravi', 'Ravi was born to Tamil parents, editor Mohan and Varalakshmi Mohan. He has two siblings, his elder brother M. Raja is a noted film director, with most of his films featuring Ravi in the lead role, while his sister, Roja Mohan, is a dentist. He completed his schooling at Jawahar Vidyalaya in Ashok Nagar, Chennai. He studied dancing under the bharatnatyam dancer Nalini Balakrishnan and performed his arangetram at the age of 12. After completing his degree in Visual communication from Loyola College, Chennai, he decided to get into the film industry. He has also undergone training in acting at the Kishore Namit Kapur Institute in Mumbai.', 337392000, 'Chennai, Tamil Nadu, India', '237966', 'jayam-ravi', 'upload/images/wKZNz2kOYPYbSrVDIdHZHtQqHs1.jpg'),
(266, 'actor', 'Karthi', 'Karthi is a Indian film actor who works in the Tamil film industry. Son of veteran actor Sivakumar and younger brother of Surya Sivakumar, he made his acting debut in 2007 with the top-grossing film Paruthiveeran, receiving critical acclaim and the Filmfare Award for Best Actor for his performance as the titular character. He went on to appear in commercially successful ventures such as Aayirathil Oruvan, Paiyaa, Naan Mahaan Alla and Siruthaiwhich established him in the Tamil film industry', 233366400, 'Chennai, Tamil Nadu, India', '123066', 'karthi', 'upload/images/zDedofqLD0OQtRVbxr04KPytr2R.jpg'),
(267, 'actor', 'Trisha Krishnan', '​Trisha Krishnan is an Indian film actress and model. After her first appearance in the 1999 Tamil film Jodi, in a supporting role, she won a Filmfare Award for Best Female Debut for her first lead role in the 2002 film Mounam Pesiyadhe. She later rose to fame starring in the successful films, Saamy (2003) and Ghilli(2004) in Tamil cinema and Varsham (2004) in Telugu cinema, for which she secured her first South Filmfare Best Actress Award. She made her Bollywood debut in the 2010 film Khatta Meetha opposite Akshay Kumar.', 420854400, 'Chennai, Tamil Nadu, India', '116925', 'trisha-krishnan', 'upload/images/jfeAV0VeAQhKONzIv1UEYbklJGn.jpg'),
(268, 'actor', 'Prakash Raj', 'Prakash Raj is a polyglot Indian film actor, film director, producer, thespian and television presenter who is known for his works in the South Indian film industry. Apart from his mother tongue Kannada, Prakash\\\'s fluency in Tamil, Telugu, Malayalam, Marathi, Hindi and English has placed him among the most sought after actors in Indian cinema. He has played a variety of roles, most notably as the antagonist and, of late, as a character actor. Prakash, as an actor has won a National Film Award for Best Supporting Actor in 1998 for Mani Ratnam\\\'s Iruvar and a National Film Award for Best Actor in 2009 for his role in Kanchivaram, a Tamil film directed by Priyadarshan, and as a producer has won a National Film Award for Best Feature Film in Kannada for Puttakkana Highway.', -150508800, 'Bengaluru, Karnataka, India', '89153', 'prakash-raj', 'upload/images/QbWfctGpZFmnZySUGYIq2sq5sj.jpg'),
(269, 'actor', 'R. Sarathkumar', 'Ramanathan Sarathkumar is an Indian film actor, journalist, politician, the former president of the South Indian Film Artistes\\\' Association and former body builder. Sarathkumar has acted in more than 130 Tamil, Malayalam, Telugu and Kannada films. He can speak Tamil, Telugu, Malayalam, Kannada and English fluently.\n\nIn 1986, Sarathkumar started his acting career in the Telugu film Samajamlo Sthree. He first acted in negative roles, and later played minor roles before establishing himself as a lead actor in the subsequent years earning him the title Supreme Star in Tamil cinema. He has won two Tamil Nadu State Film Awards and three Filmfare Awards South.\n\nIn 2007, he launched a new political party All India Samathuva Makkal Katchi (AISMK) in Tamil Nadu claiming to carry out the ideals of K. Kamaraj. He is the former Member of Legislative Assembly of Tenkasi constituency. He served as the president of the Nadigar Sangam from 2006 to 2015 for three consecutive terms.', -488160000, 'New Delhi, India', '237683', 'r-sarathkumar', 'upload/images/x2Bx2mxOvgvRzaLFlpKNGmKYkK2.jpg'),
(270, 'actor', 'R. Parthiban', 'Radhakrishnan Parthiban (earlier credited in films as Ra Parthiepan) is an Indian film actor, director, producer and writer who works mainly in Tamil cinema. He has worked in more 50 films and has directed nearly 10 films. Parthiepan is known for having directed critically acclaimed films like Pudhiya Paadhai and Housefull and for his performances in films like Bharathi Kannamma, Vetri Kodi Kattu, Azhagi, Melvilasom and Aayirathil Oruvan.\n\nHis movies Housefull (1999) and Pudhea Paadhai (1989) won the National Film Award for Best Feature Film in Tamil.\n\nAfter graduating in 1979, he briefly had a career writing short stories under the pen name of \\\"Bharathi\\\" in Tamil Magazines before in 1984- he became K.Bhagyaraj\\\'s personal assistant and later Assistant Director. The Bhagyaraj-Parthiban duo worked in over 40 films from 1984 to 1991. Parthiban also had small roles in several Bhagyaraj films.\n\nHis acting debut was in 1992 with \\\"Puthiya Padai\\\" alon with Actress Seetha whom he would later go on to marry. His commercial song \\\"Ae Kala Kala Kan Adicha Kalakala\\\" from the film \\\"Devathiyin Paadhangal\\\" made him a known name. However it was only the superhit film Bharathi Kanamma (1996) which made him a star. This was followed by a National Awardwinning performance in Housefull and a number of popular films such as Thooku Sandhu, Tirupuram, Kannata Kaanadhavan and James Pandu in the late 90\\\'s-early 2000\\\'s. He also moved to comedy and had memorable funny scenes with Vadivel beginning with Bharathi Kanamma.', -382838400, 'Chennai, Tamil Nadu, India', '584718', 'r-parthiban', 'upload/images/kmghnL3LAQJaBXsA7yoh8cE2gRd.jpg'),
(271, 'actor', 'Jayaram', 'Jayaram Subramaniam (born 10 December 1965), commonly known as Jayaram, is an Indian film actor who predominantly works in Malayalam films, and at times in Tamil films. He is also a chenda percussionist and mimic artist. He has starred in over 200 films.  In 2011, he was awarded the Padma Shri by the Government of India for his contribution towards the arts.', -128131200, 'Perumbavoor, Kerala, India', '141704', 'jayaram', 'upload/images/cc1SfVFctuYH353NgxXNBoAFX2d.jpg'),
(272, 'actor', 'Vikram Prabhu', 'Vikram Prabhu is an Indian film actor working in Tamil language films who made his debut in Prabhu Solomon\\\'s Kumki (2012). He is the son of actor Prabhu Ganesan and grandson of the actor Sivaji Ganesan.', 536457600, 'Chennai, Tamil Nadu, India', '1124440', 'vikram-prabhu', 'upload/images/hjmWQSqvbv2BAGPE6yOPtdNYQqt.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(273, 'actor', 'Rahman', 'Rahman (born Rashin Rahman) is an Indian film actor who has starred in over a 150 films, primarily Malayalam, Tamil, and Telugu films. In Telugu cinema, he is known by the stage name Raghu.\n\nRahman made his debut in Koodevide (1983), for which he won his first Kerala State Award for Best Supporting Actor. He was a popular teen idol in Malayalam cinema during the 1980s, later on he became a lead actor in Tamil cinema during the late 1980s and early 1990s. He eventually shifted to Tamil and Telugu  films during the 1990s. He did make a comeback in Malayalam films since  2004 and has been acting in leading and supporting roles in Tamil and  Telugu films post-2000s.', -82425600, 'Abu Dhabi, United Arab Emirates', '148361', 'rahman', 'upload/images/3heEOBLha0ImREOUmzWm5nVKUt.jpg'),
(274, 'director', 'Mani Ratnam', 'Karthi is a Indian film actor who works in the Tamil film industry. Son of veteran actor Sivakumar and younger brother of Surya Sivakumar, he made his acting debut in 2007 with the top-grossing film Paruthiveeran, receiving critical acclaim and the Filmfare Award for Best Actor for his performance as the titular character. He went on to appear in commercially successful ventures such as Aayirathil Oruvan, Paiyaa, Naan Mahaan Alla and Siruthaiwhich established him in the Tamil film industry', 233366400, 'Chennai, Tamil Nadu, India', '123066', 'mani-ratnam', 'upload/images/iXRdku91Hp8nHSL3uWxnInxN6TH.jpg'),
(275, 'actor', 'Rajinikanth', 'Shivaji Rao Gaekwad, known by his mononymous stage name Rajinikanth, is an immensely popular actor in Tamil film industry of South India. He received the coveted Padma Vibhushan Award in 2016.  At the 45th International Film Festival of India (2014), he was conferred with the \\\"Centenary Award for Indian Film Personality of the Year\\\". At the 50th edition of the International Film Festival of India (2019), he was honoured with the Icon of Global Jubilee award. At the 67th National Film Awards, he was awarded the Dadasaheb Phalke Award.', -601344000, 'Bangalore, Karnataka, India', '91555', 'rajinikanth', 'upload/images/cQBcrXqcQPfXOQfNfgO3slJM2xi.jpg'),
(276, 'actor', 'Vinayakan', '', 660873600, '', '1429047', 'vinayakan', 'upload/images/rUjCPYP3BtgO6MKNquikzLHLzym.jpg'),
(277, 'actor', 'Vasanth Ravi', 'Vasantha Kumar R, professionally acknowledged as Vasanth Ravi, is an emerging Indian actor born in Chennai on April 18, 1990. He embarked on his artistic journey in the Indian film industry in 2017 with a brilliant debut in a super hit and critically acclaimed movie \\\"Taramani.\\\" Vasanth Ravi boasts a diverse academic background, holding both MBBS and Healthcare Management (Masters) degrees. This distinctive educational combination enriches his approach to the art of acting.\n\nWith his captivating on-screen presence, Vasanth Ravi has skillfully portrayed a spectrum of characters that deeply resonate with audiences. Notable roles include Rocky in \\\"Rocky,\\\" Arjun in \\\"Asvins,\\\" and Arjun Muthuvel Pandian in \\\"Jailer.\\\" Each character he embodies reflects his unwavering commitment to authenticity and his profound connection with the audience.\n\nCurrently enthralling viewers with his performances in \\\"Asvins\\\" and \\\"Jailer,\\\" Vasanth Ravi is poised to add another milestone to his career with the highly anticipated film \\\"Weapon.\\\" His journey in the Indian film industry underscores his dedication, resilience, and unrelenting passion for storytelling.\n\nAs an aspiring artist on the ascent, Vasanth Ravi continues to captivate hearts, leaving an indelible mark on the canvas of Indian cinema. Through his work, he aims to inspire, entertain, and make a lasting impact on the hearts and minds of his audience.', 640396800, 'Chennai, Tamil Nadu, India', '1337212', 'vasanth-ravi', 'upload/images/90LonpRhF8cgkoERITH9WDKv39x.jpg'),
(278, 'actor', 'Yogi Babu', 'Yogi Babu is an Indian film actor, who has appeared in Tamil language films. He rose to fame following his performances in Maan Karate (2014) and Yaamirukka Bayamey (2014), before becoming a regular cast member in Tamil comedy films.', 480211200, 'Chennai, Tamil Nadu, India', '1540764', 'yogi-babu', 'upload/images/lTNb5POaftGHXzgN9aIegcehh89.jpg'),
(279, 'actor', 'Ramya Krishnan', 'Ramya Krishnan is an Indian film actress. She has acted in over 200 films in five languages: Tamil, Telugu, Kannada, Malayalam and Hindi. Predominantly, she acted in almost 100 Telugu and 60 Tamil movies.', 22204800, 'Chennai, Tamil Nadu, India', '141701', 'ramya-krishnan', 'upload/images/7Ex7OHhtotLXOAza1VOcUplPb7O.jpg'),
(280, 'actor', 'Mirnaa', 'Mirnaa, is an Indian film actress who works predominantly in the Tamil film industry.', 724377600, 'Kerala, India', '1251828', 'mirnaa', 'upload/images/kUSiqbfOwYtmGYyCShtTY2Sycpo.jpg'),
(281, 'actor', 'Rithvik', '', 0, '', '3590962', 'rithvik', NULL),
(282, 'actor', 'G. Marimuthu', 'G. Marimuthu is an Indian film director and actor, who has worked in the Tamil film industry.', -65318400, 'Tamilnadu, India', '1292322', 'g-marimuthu', 'upload/images/gDBqLLiwYqYtKdhHowX7ppCmko8.jpg'),
(283, 'actor', 'Harshad', '', 0, '', '1769899', 'harshad', NULL),
(284, 'actor', 'Jaffer Sadiq', '', 0, '', '2902858', 'jaffer-sadiq', NULL),
(285, 'actor', 'Sunil Varma', 'Sunil Varma is an Indian actor, who works in the Telugu Film Industry. His roles usually are to provide comic relief to the audience.', 131241600, 'Bhimavaram, Andhra Pradesh, India', '213428', 'sunil-varma', 'upload/images/2ueRNLlbB8jaivO6yb7zfIlFhh7.jpg'),
(286, 'director', 'Nelson Dilipkumar', 'Ramya Krishnan is an Indian film actress. She has acted in over 200 films in five languages: Tamil, Telugu, Kannada, Malayalam and Hindi. Predominantly, she acted in almost 100 Telugu and 60 Tamil movies.', 22204800, 'Chennai, Tamil Nadu, India', '141701', 'nelson-dilipkumar', 'upload/images/n0T7BQnWXPr4yhezpVzoqklxwTe.jpg'),
(287, 'actor', 'Varun Dhawan', 'Varun Dhawan is an Indian actor working in Bollywood films. The son of film director David Dhawan, he studied Business Management in England, after which he worked as an assistant director to Karan Johar on the 2010 drama My Name Is Khan. Dhawan made his acting debut with Johar\\\'s 2012 romantic comedy Student of the Year, a box office success, for which he received a Filmfare nomination for Best Male Debut. In 2014, he starred as the protagonist of two commercially successful comedies— Main Tera Hero and Humpty Sharma Ki Dulhania.', 546220800, 'Mumbai, Maharashtra, India', '1108119', 'varun-dhawan', 'upload/images/gvvXYTpvO0Tu7naCDLL3tInyN2R.jpg'),
(288, 'actor', 'Janhvi Kapoor', 'Janhvi Kapoor is an Indian actress who works in Hindi-language films. She is daughter of  Actress Sridevi and Producer Boney Kapoor,', 857606400, 'Mumbai, Maharashtra, India', '1974970', 'janhvi-kapoor', 'upload/images/rOluBJFuw1wlloBZz4T2kxuydru.jpg'),
(289, 'actor', 'Manoj Pahwa', 'Manoj Pahwa is an Indian film and television actor who is noted for his role as Bhatia in the comedy series Office Office (2001).', -199929600, 'Delhi, India', '85874', 'manoj-pahwa', 'upload/images/p7sufhnro3CM04au3L4KubTx43B.jpg'),
(290, 'actor', 'Anjuman Saxena', 'Anjuman Saxena is known for Batla House (2019), Hello Mini (2019) and Yeh Kaali Kaali Ankhein (2022).', 8640000, '', '2541600', 'anjuman-saxena', 'upload/images/lRlbH3fMAejg9wJlIFI2f0nbg17.jpg'),
(291, 'actor', 'Prateek Pachori', '', 0, '', '2281457', 'prateek-pachori', NULL),
(292, 'actor', 'Varun Tamta', '', 0, '', '4173298', 'varun-tamta', NULL),
(293, 'actor', 'Aparna Ghoshal', 'Aparna Ghoshal is an Indian film and television actress, known for her role as Nilufer Khan in Rajshri Productions \\\"Pyaar Ka Dard Hai Meetha Meetha Pyaara Pyaara\\\" on Star Plus channel. Earlier, she has been part of the drama serial, \\\"Ruk Jaana Nahin\\\" on the same channel and played as Phulleshwari on BIG Magic’s Beta Hi Chahiye in 2013.\n\nShe also played as the mother of Vividha (played by Shivani Surve) on Star Plus’ Jana Nai Dilse Door. Recently, she bags the role of Avanti’s (played by Sharmin Kazi) mother on Channel V’s Million Dollar Girl; a show that was previously entitled as Banarasi Bebe.\n\nIn 2013, Aparna was seen in the blockbuster heist comedy thriller film, Special 26. This film was directed by Neeraj Pandey and stars . She played as Shammi in the romantic comedy film, Wedding Pullav in 2015.', 0, '', '3167415', 'aparna-ghoshal', 'upload/images/7JwEbS4ICYFtfrmD1De3DDL50Mm.jpg'),
(294, 'actor', 'Shashie Verma', '', 0, '', '3906888', 'shashie-verma', NULL),
(295, 'actor', 'Agrim Mittal', '', 0, '', '3316153', 'agrim-mittal', NULL),
(296, 'actor', 'Gunjan Joshi', '', 0, '', '4173303', 'gunjan-joshi', NULL),
(297, 'actor', 'Mukesh Tiwari', 'Mukesh Tiwari is an Indian film actor known for playing negative and comic roles in Bollywood and several other Indian language films. He began his acting career with the Hindi film China Gate, in which he played Jageera.', -11232000, 'Sagar, Madhya Pradesh, India', '86064', 'mukesh-tiwari', 'upload/images/37GTjltEJHpi1lQmLmHKJYTpxjj.jpg'),
(298, 'director', 'Nitesh Tiwari', 'Anjuman Saxena is known for Batla House (2019), Hello Mini (2019) and Yeh Kaali Kaali Ankhein (2022).', 8640000, '', '2541600', 'nitesh-tiwari', 'upload/images/xtSCxbc4Wp0Cwanqrj7YhD5CQRl.jpg'),
(299, 'actor', 'Prabhas', 'Uppalapati Venkata Satyanarayana Prabhas Raju known mononymously as Prabhas, is an Indian actor who works predominantly in Telugu films along with Hindi and Tamil films. Prabhas made his screen debut with the 2002 Telugu action drama film Eeswar. He has garnered the state Nandi Award for Best Actor, for his role in Mirchi. Prabhas is the first south Indian actor to have his wax sculpture at Madame Tussaud\\\'s wax museum.', 309484800, 'Chennai, Tamil Nadu, India', '237045', 'prabhas', 'upload/images/6naZ3oybdCtfggc5pTrcBDxOXrP.jpg'),
(300, 'actor', 'Prithviraj Sukumaran', 'Prithviraj Sukumaran (born October 16, 1982) is a versatile Indian actor, director, producer, and playback singer primarily active in Malayalam cinema, with notable contributions to Tamil, Hindi, and Telugu films. His extensive career spans over 100 films, earning him accolades such as a National Film Award, three Kerala State Film Awards, a Tamil Nadu State Film Award, and a South Filmfare Award.\n\nPrithviraj marked his acting debut with the commercially successful Nandanam (2002) and rose to prominence as a leading Malayalam actor with Classmates (2006), the highest-grossing Malayalam film that year. His role in Vaasthavam earned him the Kerala State Film Award for Best Actor, making him the youngest recipient at 24. Exploring diverse roles, he portrayed a musician in the Tamil romantic comedy Mozhi (2007) and delved into playback singing with Puthiya Mukham (2009). He secured his second Kerala State Film Award for Best Actor for his performances in the medical drama Ayalum Njanum Thammil and the biographical film Celluloid.\n\nIn 2010, Prithviraj joined August Cinema, co-producing and headlining Urumi and Indian Rupee (both 2011). The latter won the National Film Award for Best Feature Film in Malayalam and the Kerala State Film Award for Best Film. He earned the Tamil Nadu State Film Award for Best Villain for Kaaviya Thalaivan (2014) and starred in impactful films like Ennu Ninte Moideen (2015) and Ezra (2017). After parting ways with August Cinema in 2017, he independently launched Prithviraj Productions, which backed 9 (2019). Making his directorial debut with Lucifer (2019), the film became the highest-grossing Malayalam film until June 2023. Subsequently, he featured in notable films such as Driving License (2019), Ayyappanum Koshiyum (2020), Jana Gana Mana (2022), Kaduva (2022), and Prashanth Neel’s Salaar: Part 1 – Ceasefire (2023) alongside Prabhas.', 403574400, 'Trivandrum, Kerala, India', '117690', 'prithviraj-sukumaran', 'upload/images/a9f9Tkc4gEFq7OdYEN7UEOwln0T.jpg'),
(301, 'actor', 'Shruti Haasan', 'Shruti Haasan is an Indian actress, singer and music composer who has worked in South Indian film industry and Bollywood. Her parents are noted actors, Kamal Haasan and Sarika. As a child artist, she sang in films and appeared in a guest role, before making her adult acting debut in the 2009 action drama, Luck. She later went on to win critical acclaim for her role in the Walt Disney fantasy film, Anaganaga O Dheerudu, Oh My Friend and 7aam Arivu. In 2012, she starred in Gabbar Singh, Telugu remake of Dabangg.  She has also continued her stint in music through work as a singer in Indian languages, a career in music direction beginning with her father\\\'s production Unnaipol Oruvan and her own music band and album', 507254400, 'Chennai, Tamil Nadu, India', '85883', 'shruti-haasan', 'upload/images/1zYJuSccSA45VVBdgozpRcL99Rd.jpg'),
(302, 'actor', 'Easwari Rao', 'Easwari Rao is an Indian actress, who has worked in Tamil, Telugu, Kannada and Malayalam film industries, predominantly in the 1990s.\n\nEeswari is originally from Rajahmundry but she is settled in Chennai. She is married to director L.Raja. Easwari Rao\\\'s debut project was Kavithai Paadum Alaigal (1990) an obscure early 90\\\'s Tamil Film which never got released in theatres. She got her first major break in Raman Abdullah (1997), directed by Balu Mahendra. Offers poured in for the actress though she became selective and notably opted out of a project title Koottaali, as she felt the role was too glamorous. She went on to appear in Manoj Kumar\\\'s film, Guru Paarvai (1998) alongside Prakash Raj, Kushboo and Anju Aravind. Eeshwari also bagged a role in Bharathiraja\\\'s Siragugal Murivadhilai with Napoleon, although the film subsequently was shelved after pre-production. In Appu (2000) Tamil film she portrayed as Prasanth\\\'s Sister. Now she is into character artist roles in Telugu movies.Her role in 2018 Tamil film Kaala make her strong comeback to Tamil Cinema in which she played character called Selvi as Rajinikanth\\\'s wife.', 108777600, 'East Godavari, Andhra Pradesh, India', '1275608', 'easwari-rao', 'upload/images/fjyvQ45YZcovy2Egj2eux8UiuHU.jpg'),
(303, 'actor', 'Jagapati Babu', 'Jagapati Babu is an Indian film actor known for his works in Telugu cinema, few Tamil films and in a Kannada film. He has received seven Andhra Pradesh state Nandi Awards.', -248832000, 'Machilipatnam, Andhra Pradesh, India', '465273', 'jagapati-babu', 'upload/images/bm72k6FmDxhxtZsl1xvxoz88Hkm.jpg'),
(304, 'actor', 'Bobby Simha', 'Bobby Simha is an Indian film actor who has appeared in Tamil, Telugu and Malayalam language films. After making brief appearances in the films Kadhalil Sodhappuvadhu Yeppadi and Pizza (2012), he portrayed a kidnapper in Nalan Kumarasamy\\\'s Soodhu Kavvum and a comic villain in Alphonse Putharen\\\'s Neram. Simha\\\'s subsequent performance as the Madurai gangster Sethu in Karthik Subbaraj\\\'s Jigarthanda (2014) won him positive reviews from critics and the National Film Award for Best Supporting Actor.', 436924800, 'Kodaikanal, Tamil Nadu, India', '1187399', 'bobby-simha', 'upload/images/4luN7NwlKvenAkSDwjzZeWpWuoP.jpg'),
(305, 'actor', 'Sriya Reddy', 'Sriya Reddy is an Indian film actress who mainly appears in Tamil language films, anchor and former VJ. Born to former Indian test cricketer Bharath Reddy, Sriya worked as successful VJ at SS Music before pursuing an acting career as well.', 438825600, 'Hyderabad, Andhra Pradesh, India', '574772', 'sriya-reddy', 'upload/images/6AwGUf0uj7Dr6cwZkC53KNihPdj.jpg'),
(306, 'actor', 'Ramachandra Raju', 'Ramachandra Raju aka Garuda Rama is an Indian film actor who appears predominantly in South Indian Language films.', 322790400, 'Bangalore, Karnataka, India', '2262423', 'ramachandra-raju', 'upload/images/kU1a4H8o1IQA25Lyq3cW70aufhT.jpg'),
(307, 'actor', 'Mime Gopi', 'Prior to his entrance into the film industry, Mime Gopi was a  renowned mime actor in Chennai and headed G Mime Studio, a studio which  exhibited the art form. In his role, he worked closely with children  with special needs to help them adapt miming skills. He had set up the studio in 1994 and had worked to expand the art across Chennai.  Mime Gopi made a breakthrough as a film actor after appearing as the local rogue, Perumal in Madras (2014). He has since appeared as the antagonist in films such as Maari (2015) and Kathakali (2016)', 0, '', '1511161', 'mime-gopi', 'upload/images/gglNAjJMlCb0p7ig3OVpgsXMkMD.jpg'),
(308, 'actor', 'Tinnu Anand', 'Tinnu Anand is an Indian actor and director belonging to the Bollywood industry. His most famous directorial outings were Kaalia (1981), Shahenshah (1988), Main Azaad Hoon (1989) and Major Saab (1998). He then went on to perform roles in several movies such as Chhupa Rustam (2001), Paisa Vasool (2004), Bluffmaster! (2005), Laaga Chunari Mein Daag (2007), Ghajini (2008), Dabangg (2010), Rabba Main Kya Karoon (2013) Phata Poster Nikhla Hero (2013), Aisa Yeh Jahaan (2015) and Santa Banta Pvt Ltd (2016). His 2022 release includes Janhit Mein Jaari.', 0, '', '85733', 'tinnu-anand', 'upload/images/6fkEiZKNp6jnOQmfQKEjVinhUeL.jpg'),
(309, 'actor', 'Pramod Panju', 'Pramod Panju is an Indian actor, media personality, television artist who established his career in the Kannada film and television industry.', 0, 'Mandya, Karnataka, India', '3205334', 'pramod-panju', 'upload/images/2URHh4gn72VYlgrrZrNaEyXjpPh.jpg'),
(310, 'director', 'Prashanth Neel', 'Prithviraj Sukumaran (born October 16, 1982) is a versatile Indian actor, director, producer, and playback singer primarily active in Malayalam cinema, with notable contributions to Tamil, Hindi, and Telugu films. His extensive career spans over 100 films, earning him accolades such as a National Film Award, three Kerala State Film Awards, a Tamil Nadu State Film Award, and a South Filmfare Award.\n\nPrithviraj marked his acting debut with the commercially successful Nandanam (2002) and rose to prominence as a leading Malayalam actor with Classmates (2006), the highest-grossing Malayalam film that year. His role in Vaasthavam earned him the Kerala State Film Award for Best Actor, making him the youngest recipient at 24. Exploring diverse roles, he portrayed a musician in the Tamil romantic comedy Mozhi (2007) and delved into playback singing with Puthiya Mukham (2009). He secured his second Kerala State Film Award for Best Actor for his performances in the medical drama Ayalum Njanum Thammil and the biographical film Celluloid.\n\nIn 2010, Prithviraj joined August Cinema, co-producing and headlining Urumi and Indian Rupee (both 2011). The latter won the National Film Award for Best Feature Film in Malayalam and the Kerala State Film Award for Best Film. He earned the Tamil Nadu State Film Award for Best Villain for Kaaviya Thalaivan (2014) and starred in impactful films like Ennu Ninte Moideen (2015) and Ezra (2017). After parting ways with August Cinema in 2017, he independently launched Prithviraj Productions, which backed 9 (2019). Making his directorial debut with Lucifer (2019), the film became the highest-grossing Malayalam film until June 2023. Subsequently, he featured in notable films such as Driving License (2019), Ayyappanum Koshiyum (2020), Jana Gana Mana (2022), Kaduva (2022), and Prashanth Neel’s Salaar: Part 1 – Ceasefire (2023) alongside Prabhas.', 403574400, 'Trivandrum, Kerala, India', '117690', 'prashanth-neel', 'upload/images/oq6ydaurgC4NueXuo64R5QoFnfp.jpg'),
(311, 'director', 'Ali Abbasi', 'Ali Abbasi (Persian: علی عباسی, born 1981, Tehran) is an Iranian-Danish filmmaker. He attended Tehran Polytechnic until 2002, when he emigrated to Europe to study architecture at the Royal Academy of Sciences in Stockholm. After earning his Bachelor of Arts in 2007, he enrolled at the National Film School of Denmark, earning his degree in 2011 with the short film M for Markus. He lives in Copenhagen but continues to hold an Iranian passport.', 347155200, 'Tehran, Iran', '1574550', 'ali-abbasi', 'upload/images/1mwdpvwjAG1NkvUwpdBMEMJnjK2.jpg'),
(312, 'director', 'Jeremy Webb', '', NULL, '', '175311', 'jeremy-webb', 'upload/images/hJcVQ62yQTBP5lLbhsIFpeHK2hD.jpg'),
(313, 'director', 'Craig Mazin', 'Craig Mazin is an American screenwriter and film director. He is known for writing Identity Thief, The Hangover Part II, The Hangover Part III, and The Huntsman: Winter\\\'s War, as well as the five-part miniseries for HBO and Sky based on the Chernobyl disaster. Mazin co-hosts the Scriptnotes podcast alongside fellow screenwriter John August.', 39916800, 'Brooklyn, New York City, New York, USA', '35796', 'craig-mazin', 'upload/images/uEhna6qcMuyU5TP7irpTUZ2ZsZc.jpg'),
(314, 'director', 'Neil Druckmann', 'Neil Druckmann‎; born December 5th 1978 is an Israeli-American writer, creative director, and programmer, and Vice President of Naughty Dog, known for his work in the video games The Last of Us and Uncharted Series. He was born and raised until the age of 10 in Israel, where his experiences with entertainment would later influence his storytelling techniques. He studied computer science at Carnegie Mellon University, before searching for work in the video game industry.', 281664000, 'Israel', '1295692', 'neil-druckmann', 'upload/images/bVUsM4aYiHbeSYE1xAw2H5Z1ANU.jpg'),
(315, 'director', 'Jasmila Žbanić', 'Jasmila Žbanić is a film writer and director from Bosnia and Herzegovina, best known for winning the Golden Bear at the International Filmfestival Berlin in 2006 for her feature film \\\"Grbavica\\\". She\\\'s a graduate of the Department for Theater and Film Directing at the Academy of Performing Arts, Sarajevo.', 156643200, 'Sarajevo, Bosnia and Herzegovina, Yugoslavia [now Sarajevo, Bosnia and Herzegovina]', '4634', 'jasmila-zbanic', 'upload/images/kDNpD0wHILT2Vm8TqWPlxJRrbX5.jpg'),
(316, 'director', 'Liza Johnson', 'Liza Johnson (born December 13, 1970) is an American film director, producer, and writer. Along with her collection of short films, Johnson has directed four feature films, including Return (2011), Hateship, Loveship (2013), and Elvis & Nixon (2016).', 29894400, 'Portsmouth, Ohio, USA', '916958', 'liza-johnson', 'upload/images/y7as9fauoSzDo3J8xN9h4RZ6h7M.jpg'),
(317, 'director', 'Peter Hoar', '', NULL, '', '208453', 'peter-hoar', 'upload/images/qfLft2v4stmVdXYEdanJhasYC5J.jpg'),
(318, 'actor', 'Sanjay Dutt', 'Sanjay Dutt (born 29 July 1959) is an Indian Hindi film actor and politician. Dutt is the son of Hindi film stars Sunil and Nargis Dutt. He made his debut in 1981.\n\nDescription above from the Wikipedia article Sanjay Dutt, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -329097600, 'Mumbai, Maharashtra, India', '85881', 'sanjay-dutt', 'upload/images/zhYAdzlDMbhWr8ZBVDK02nrwnOJ.jpg'),
(319, 'actor', 'Vaani Kapoor', 'Vaani Kapoor  is an Indian actress and model. Born in Delhi, Kapoor obtained a bachelor\\\'s degree in Tourism studies from the Indira Gandhi National Open University, she took an internship with the Oberoi Hotels & Resorts. After the end of the internship, she worked as a model under the Elite Model Management. During her modeling career, she successfully auditioned for the 2009 Sony TV television series Specials @ 10—where she played the protagonist in one of the series segment Rajuben. Later, she signed a three-film deal with the Yash Raj Films as an actress.\n\nKapoor made her film debut with a supporting role in the 2013 romantic comedy Shuddh Desi Romance, a critical and commercial success. She garnered wide appreciation for her performance and earned her several awards and nominations, including the Best Female Debut at the 59th Filmfare Awards. In 2014, she ventured into the South Indian film industry with the Tamil and Telugu language romantic comedy Aaha Kalyanam, that proved to be a moderate box-office success and her portrayal of the lead female character was praised. In 2021 she starred as a trans woman in Chandigarh Kare Aashiqui.', 588211200, 'Delhi, India', '1192903', 'vaani-kapoor', 'upload/images/u39OAXWXiOCQhbtLTIRBMjdaZwT.jpg'),
(320, 'actor', 'Iravati Harshe', 'Iravati Harshe is an Indian television and film actor and dubbing artist. Harshe has worked in many television serials. She is a trained Bharatanatyam dancer.', 402883200, 'Mumbai, Maharashtra, India', '1047713', 'iravati-harshe', 'upload/images/zVDkFwUN8pj3jpEuQRWQa3sUSzp.jpg'),
(321, 'actor', 'Ronit Roy', 'Ronit Roy (born Ronit Bose Roy) is an Indian television and Bollywood actor, known for the roles of Dharamraj Mahiyavanshi, Rishabh Bajaj, Mihir Virani and Aparajit Deb.', -133315200, 'Nagpur, Maharashtra, India', '85676', 'ronit-roy', 'upload/images/4ki1I9lH2TU0W5ZPMG5T90It9pc.jpg'),
(322, 'actor', 'Saurabh Shukla', 'From Wikipedia, the free encyclopedia\n\nSaurabh Shukla is an Indian film and television actor, director and screenwriter.\n\nDescription above from the Wikipedia article Saurabh Shukla, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -215481600, 'Gorakhpur, India', '76789', 'saurabh-shukla', 'upload/images/uFGVBmRIHLAQkYYSI2lSXOxMi4f.jpg'),
(323, 'actor', 'Mahesh Balraj', '', 0, '', '1305459', 'mahesh-balraj', 'upload/images/6ENpFuSiqbqcx00c3UWParUDTLf.jpg'),
(324, 'actor', 'Rudra Soni', '', 0, '', '2192843', 'rudra-soni', 'upload/images/e2AYfiOkxGUCGHrRToKpVFuG4P6.jpg'),
(325, 'actor', 'Mazel Vyas', '', 0, '', '2785678', 'mazel-vyas', 'upload/images/yHC2BUD17dQowk0c53TIk4wNo6g.jpg'),
(326, 'actor', 'Prakhar Saxena', '', 0, '', '2326882', 'prakhar-saxena', NULL),
(327, 'actor', 'Nagesh Salvan', '', 0, '', '3673242', 'nagesh-salvan', NULL),
(328, 'director', 'Karan Malhotra', '', 0, '', '3673245', 'karan-malhotra', NULL),
(329, 'actor', 'Jim Sarbh', 'Jim Sarbh is an Indian film and stage actor. Best known for his supporting work in the Hindi Film Industry, he is the recipient of a Screen Award, an International Indian Film Academy Award and two Filmfare Award nominations. Additionally, Sarbh has directed and acted in numerous theater productions in India.', 557020800, 'Mumbai, India', '1744502', 'jim-sarbh', 'upload/images/lJPX2ehRqqtrJOqx5PS9dkSAw7.jpg'),
(330, 'actor', 'Ishwak Singh', '', NULL, '', '1424750', 'ishwak-singh', 'upload/images/iN1QUGzN7c4qBps3xpuWYVzpMag.jpg'),
(331, 'actor', 'Regina Cassandra', 'Regina Cassandra is an Indian film actress appearing in Telugu, Tamil and Kannada films. She started anchoring when she was nine for Splash, a kids\\\' channel and then moved on to work in commercials.', 597974400, 'Chennai, Tamil Nadu, India', '1166967', 'regina-cassandra', 'upload/images/aWFogAoGomUDAXMD8kp7dlZJrlA.jpg'),
(332, 'actor', 'Saba Azad', '', NULL, '', '1514871', 'saba-azad', 'upload/images/ggpfAbnADJ9PpdTZJiJwJ5pEoC7.jpg'),
(333, 'actor', 'Arjun Radhakrishnan', '', NULL, '', '2190786', 'arjun-radhakrishnan', 'upload/images/xcxu1R28Hl7bzLQagFdeUsTiHjg.jpg'),
(334, 'actor', 'K.C. Shankar', '', NULL, '', '2365591', 'kc-shankar', 'upload/images/fbxJMM6YZGl3OLHhnqISzPjbSpB.jpg'),
(335, 'actor', 'T.M. Karthik', 'T. M. Karthik is a stage and film actor who acted in stage plays and feature films. He made his acting debut in films with Guru (2007).', NULL, '', '1271650', 'tm-karthik', 'upload/images/1YKFSleIDEQv96san3xRwc8p6WE.jpg'),
(336, 'director', 'Abhay Pannu', '', NULL, '', '2447774', 'abhay-pannu', NULL),
(337, 'actor', 'Naveen Kasturia', 'Naveen Kasturia is an Indian actor known for his work in TVF drama series - Pitchers. He started his career working as an assistant director in the film Jashnn and then assisted Dibakar Banerjee in Shanghai. He also appeared as the lead actor in the critically acclaimed film Sulemani Keeda.', NULL, '', '1309096', 'naveen-kasturia', 'upload/images/arV1swe5vg4e4webYl61h6Zwx4e.jpg'),
(338, 'actor', 'Shivankit Singh Parihar', '', NULL, '', '1963342', 'shivankit-singh-parihar', 'upload/images/2trIa00z7dWn1FSUIzVAXVH5wXE.jpg'),
(339, 'actor', 'Abhilash Thapliyal', '', NULL, '', '3079717', 'abhilash-thapliyal', 'upload/images/ioiEmkDWfPIdIuRD68zG6bJgHpq.jpg'),
(340, 'actor', 'Sunny Hinduja', '', 659491200, '', '928530', 'sunny-hinduja', 'upload/images/8x08qf2ESUpU5aVh1m4PfLdqBkG.jpg'),
(341, 'actor', 'Namita Dubey', '', NULL, 'Lucknow, Uttar Pradesh, India', '3079719', 'namita-dubey', NULL),
(342, 'actor', 'Kuljeet Singh', '', NULL, '', '3167336', 'kuljeet-singh', NULL),
(343, 'actor', 'Abhishek Sonpaliya', '', NULL, '', '3634789', 'abhishek-sonpaliya', NULL),
(344, 'actor', 'Tengam Celine', '', NULL, '', '4341351', 'tengam-celine', NULL),
(345, 'actor', 'Neeta Jhanjhi', '', NULL, '', '4306871', 'neeta-jhanjhi', NULL),
(346, 'actor', 'Bijou Thaangjam', 'Bijou Thaangjam is a multifaceted personality known as a chef and actor. He is also known as lyricist, Entrepreneur and an art director who hails from Imphal, Manipur. He was a contestant of popular cooking show MasterChef India season 2. Bijou also play noted character roles in Bollywood films and TV shows. He is best known for playing the brief role of Naobi in the biopic -Mary Kom starring Priyanka Chopra. After this film, he got numerous offers from movies and television, and now a series of movies are lined up for release. His full name is Thangjam Biju Singh. He was born of 24th March 1986 in Imphal, Manipur. Bijou has two younger siblings. He schooled from Tiny Tot\\\'s Unique School, Imphal and completed his graduation from Bangalore University. Since young he has been interested in cooking and acting, later he excelled in both these forms of art. He appeared in MasterChef India season 2, where he finished as one of the top 50 contestants. He also appeared in the reality show UTVStars Superstar Santa. He moved to Mumbai in 2012 to pursue a career in acting. In 2014 he bagged his first Bollywood film, Mary Kom. Later many other more films like Shivaay, Jagga Jasoos, Paltan, Happy Phir Bhaag Jayegi, Vodka Diaries and III Smoking Barrels. Now he was seen in a few more films - Robinhood Ke Pote, Penalty, Karma Cafe, Rocketry- The Nambi Effect, Jamun, om The Battle Within and others. He played a supporting role of Karma Wangchuk\\\'s brother in youth oriented series on Channel V - Dil Dosti Dance. He essayed a brief role of Joseph in MTV\\\'s show- Traffic. He was also seen in- Code Red aired on Colors TV. He was seen on many OTT Webseries like Altbalaji original series- The Test Case, playing a role of Indian Army as Tej Bahadur Thapa- a Jawan from 3GR, TVF\\\'s Original Aspirant, as Pema. He is the owner of the Natural, Organic and Vegan Personal Care brand \\\"MadhabiGi®\\\". Recently he announced his maiden production house \\\"Cicada Film Production\\\" which he ventures to produce contents related from and within Northeast India. He collaborated with EaseMyTrip on his maiden project \\\"Roll The Dice\\\" Featuring Naveen Jagbir Sandhu. Projects like Lembi Leima & Bewafa are doing round the film festivals around the globe winning multiple awards. He won Best Supporting Actor for his role in Lembi Leima at many international Film Festivals. He was last seen in Zee5 Original series Mukhbir - The Story Of a Spy playing a junior officer. He will be seen next In Victor Mukherjee\\\'s Lakkadbaggha.', NULL, 'Imphal, Manipur, India', '2118200', 'bijou-thaangjam', 'upload/images/zlvbSyfcEgYyULQVdnMrWY6oIXK.jpg'),
(347, 'actor', 'Mallika Prasad Sinha', '', NULL, '', '3994174', 'mallika-prasad-sinha', NULL),
(348, 'actor', 'Nupur Nagpal', '', NULL, '', '2414886', 'nupur-nagpal', 'upload/images/lQaphttzusbfmlo0W0g5OsxsizE.jpg'),
(349, 'actor', 'Shivam Kakar', '', NULL, '', '2434965', 'shivam-kakar', 'upload/images/vJ45vBAAR9fJ8ixqvmvDUk1tA2j.jpg'),
(350, 'actor', 'Preeti Agarwal Mehta', '', NULL, '', '2746527', 'preeti-agarwal-mehta', NULL),
(351, 'director', 'Apoorv Singh Karki', '', NULL, '', '2408480', 'apoorv-singh-karki', NULL),
(352, 'actor', 'Anya Taylor-Joy', 'Anya-Josephine Marie Taylor-Joy (born 16 April 1996) is a British-American actress and model. She left school at age sixteen and began to pursue an acting career. After small television roles, she made her film debut with the lead role of Thomasin in the horror film The Witch (2015). She went on to star in the horror film Split and the black comedy Thoroughbreds (both 2017). She also appeared in the drama miniseries The Miniaturist (2017), the fifth and sixth series of Peaky Blinders (2019–2022) and The Dark Crystal: Age of Resistance (2019), and the superhero film Glass (2019), reprising her role from Split. Taylor-Joy will voice Princess Peach in the upcoming Mario film (2022) and portray the title character in Furiosa (2024).', 829612800, 'Miami, Florida, USA', '1397778', 'anya-taylor-joy', 'upload/images/jxAbDJWvz4p1hoFpJYG5vY2dQmq.jpg'),
(353, 'actor', 'Chloe Pirrie', 'Chloe Pirrie (born August 25, 1987) is a Scottish actress. She has played main roles in the 2014 miniseries The Game, the 2012 film Shell, and the 2015 television film An Inspector Calls. She has also appeared in the 2016 miniseries War & Peace, the 2015 film Youth, the 2015 film Blood Cells and a 2013 episode of Black Mirror. In 2015 she also co-starred in the Academy Award winner for Best Live Action Short Film, Stutterer.\n\nPirrie was raised in Stockbridge, Edinburgh, and attended the Mary Erskine School. She began acting in school and decided to pursue it as a career after being cast in a school production of The Cherry Orchard. She moved to London at the age of 18 to attend the Guildhall School of Music and Drama and graduated in 2009. Pirrie\\\'s professional acting career began in 2009. She made her debut at the Royal National Theatre in a 2010 production of Men Should Weep alongside numerous other Scottish actors. Shortly afterwards, she appeared in Solstice, a short film released in 2010. Her first role in a feature film was in Shell (2012), a Scottish drama in which Pirrie played the eponymous main character. For this performance she won Most Promising Newcomer at the British Independent Film Awards 2013 and was nominated for Best British Newcomer at the 2012 BFI London Film Festival Awards. In 2013, she played a politician in \\\"The Waldo Moment\\\", an episode of the anthology series Black Mirror. In the same year she was named as one of BAFTA\\\'s \\\"Breakthrough Brits\\\" and Screen International\\\'s \\\"UK Stars of Tomorrow\\\".\n\nIn 2014, Pirrie starred in the BBC miniseries The Game, a Cold War spy thriller in which she played an MI5 secretary. The following year she appeared as Sheila Birling in Helen Edmundson\\\'s BBC One adaptation of J. B. Priestley\\\'s An Inspector Calls, in the miniseries The Last Panthers, the British independent film Burn Burn Burn, and the Italian film Youth.\n\nIn 2015, she starred as Ellie in the Academy Award winner for Best Live Action Short Film, Stutterer. Ellie is the love interest for Greenwood (played by Matthew Needham). Greenwood has a major stuttering problem and can\\\'t speak effectively, causing him to panic when Ellie suggests they take what had only been an online relationship, offline to meet in person. After finally giving in, Greenwood learns a secret about Ellie that changes everything.\n\nShe played Julie Karagina in the 2016 BBC miniseries War & Peace and was cast as Emily Brontë in To Walk Invisible, a BBC drama about the Brontë family created by Sally Wainwright. She also starred in the Death In Paradise episode \\\'In The Footsteps Of A Killer\\\' as Grace Matlock, an employee at the Saint Marie Times.\n\nShe also plays Lara in the 2016 BBC thriller series, The Living and the Dead. In 2017, she starred in the Netflix series, The Crown for its second season, playing Eileen Parker. In 2018, she appeared in the BBC/Netflix miniseries Troy: Fall of a City.', 556848000, 'Edinburgh, Scotland, UK', '1125581', 'chloe-pirrie', 'upload/images/pRzxx0kE662i31L6O0flUNjmGuC.jpg'),
(354, 'actor', 'Marcin Dorociński', 'Marcin Dorociński (Polish pronunciation: [ˈmart͡ɕin dɔrɔt͡ɕij̃skʲi]; born June 22, 1973) is a Polish film, television and stage actor. He is widely regarded as one of the most talented and respected Polish actors and is well known for his portrayals of conflicted, troubled characters as well as for his debonair leading man roles, handsome, virile, charismatic and charming. Dorociński is also renowned for his association with independent movies. He gained critical acclaim in the early 2000s, culminating in his Zbyszek Cybulski\\\'s Award for Best Young Polish Actor (2005), and Polish Eagles nomination for Best Actor (2008), followed by Golden Lions Award as best supporting actor for ‘Reverse’, and best actor in a leading role for ‘Rose’. In 2020, he joined the cast of the Netflix drama miniseries ‘The Queen\\\'s Gambit’ starring Anya Taylor-Joy. Dorociński played Vasily Borgov, a Russian chess master who faces the challenge of playing against the series\\\' protagonist.\n\nDorociński keeps low profile, focusing on his family: wife and three children. He is an avid U2 and Red Hot Chili Peppers fan, enjoys triathlon, car and motor racing, and walking his dog. He also actively works to protect the environment and fights for animal rights.', 109555200, 'Milanówek, Poland', '591295', 'marcin-dorociński', 'upload/images/u1UL7rvC3ZJJvHOk31jk212QTXz.jpg'),
(355, 'actor', 'Matthew Dennis Lewis', '', NULL, '', '1855149', 'matthew-dennis-lewis', 'upload/images/e9n1gwjTgezUwvdJ3rfguukcSaY.jpg'),
(356, 'actor', 'Russell Dennis Lewis', '', NULL, '', '1267379', 'russell-dennis-lewis', 'upload/images/rqu1qPn26APEi02CJJJ2mEDHyks.jpg'),
(357, 'actor', 'Dolores Carbonari', '', NULL, 'United Kingdom United Kingdom', '2854179', 'dolores-carbonari', 'upload/images/5RHzizKFX7SZmCTVg0g7MsD1UtW.jpg'),
(358, 'actor', 'Janina Elkin', '', 409190400, '', '1124361', 'janina-elkin', 'upload/images/qIr7wSTTawDM8KaPWJ9yMIShwQ5.jpg'),
(359, 'actor', 'Harry Melling', 'Harry Edward Melling (born March 17, 1989) is an English actor known for playing Dudley Dursley in five Harry Potter films and for his role as Harry Beltik in The Queen\\\'s Gambit. His grandfather was actor Patrick Troughton', 606096000, 'London, England, UK', '10982', 'harry-melling', 'upload/images/b0pHwi2MeqxEpeWnF4Llihu53aJ.jpg'),
(360, 'actor', 'Isla Johnston', 'Isla Johnston is an actress, known for Invasion (2021), The Queen\\\'s Gambit (2020) and Unmourned.', NULL, '', '1967058', 'isla-johnston', 'upload/images/nieq22akK7JWtcnxkJdALNYgnWn.jpg'),
(361, 'actor', 'Bill Camp', 'Bill Camp is an American actor. He is best known for playing Detective Dennis Box in the HBO limited television series The Night Of, for which he was nominated for the Primetime Emmy Award for Outstanding Supporting Actor in a Limited Series or Movie.', NULL, 'Massachusetts, USA', '121718', 'bill-camp', 'upload/images/yZFata0EVr7TbIAz8vZFyiDKDts.jpg'),
(362, 'actor', 'Moses Ingram', 'Moses Ingram (born February 6, 1994) is an American actress and writer, known for The Tragedy of Macbeth (2021), The Queen\\\'s Gambit (2020), Day 74. (2020) and Obi-Wan Kenobi (2022).', 760492800, 'Baltimore, Maryland, USA', '2042908', 'moses-ingram', 'upload/images/u7I5f4Bgz7CI8G7fUOJDbFtd0qf.jpg'),
(363, 'actor', 'Thomas Brodie-Sangster', 'Thomas Brodie-Sangster (born 16 May 1990), is an English actor. He is known for playing Sam in Love Actually (2003), Simon in Nanny McPhee (2005), Ferb in Phineas and Ferb (2007–2015), Jojen Reed in Game of Thrones (2013–2014), Newt in the Maze Runner film series (2014–2018), and Benny Watts in the Netflix miniseries The Queen\\\'s Gambit (2020), for which he was nominated for the Primetime Emmy Award for Outstanding Supporting Actor in a Limited Series or Movie.\n\nBrodie-Sangster also grew in popularity for starring in critically acclaimed cult films such as Death of a Superhero (2011), Bright Star (2009), and as Paul McCartney in Nowhere Boy (2009). He played Jake Murray in the series Accused (2010–2012). He also had a cameo as an officer of the First Order in Star Wars: The Force Awakens (2015), a role as Whitey Winn in the Netflix miniseries Godless (2017) and voiced John Tracy in Thunderbirds Are Go (2015–2020).', 642816000, 'Southwark, London, England, UK', '25663', 'thomas-brodie-sangster', 'upload/images/ovfgjgaE7aAXKYaemABX6pJFwRk.jpg'),
(364, 'actor', 'Sergio Di Zio', 'Sergio Di Zio is a Canadian actor.', 85795200, 'Toronto, Ontario, Canada', '54193', 'sergio-di-zio', 'upload/images/e5sQM8rEXQW1UiVgzYM5C4GHScF.jpg'),
(365, 'actor', 'Annabeth Kelly', '', NULL, '', '2873705', 'annabeth-kelly', NULL),
(366, 'actor', 'Patrick Kennedy', 'Patrick Kennedy (born 28 August 1977) is an English actor. He is an Oxford graduate. His largest role to date is in the BBC\\\'s Bleak House as Richard Carstone. He again appeared in a BBC drama having been chosen for a role in the 2008 re-make of The 39 Steps and also appeared in the BBC drama Einstein and Eddington.\n\nHe has also appeared in Cambridge Spies and had minor roles in Spooks, Mrs Henderson Presents, A Good Year and Munich. He appeared in Joe Wright\\\'s film of Ian McEwan\\\'s Atonement in 2007. He is due to star in the upcoming movie War Horse as Lt. Waverley, alongside Emily Watson, Peter Mullan, Tom Hiddleston, and Benedict Cumberbatch.\n\nDescription above from the Wikipedia article Patrick Kennedy (British actor), licensed under CC-BY-SA, full list of contributors on Wikipedia.\n\n​From Wikipedia, the free encyclopedia', 241401600, 'London, England, UK', '14432', 'patrick-kennedy', 'upload/images/Aj7lwhi4rYfzP5OZJiem5w72re8.jpg'),
(367, 'actor', 'Christiane Seidel', '', 576028800, 'Wichita Falls, Texas, USA', '1294534', 'christiane-seidel', 'upload/images/vMPBbQacujdF7miUn7LNzCbvlpj.jpg'),
(368, 'actor', 'Akemnji Ndifornyen', '', NULL, '', '550396', 'akemnji-ndifornyen', 'upload/images/7X7JQocNSAXJgewhpPIUd6Igo1I.jpg'),
(369, 'actor', 'Andruscha Hilscher', '', NULL, '', '2214184', 'andruscha-hilscher', NULL),
(370, 'actor', 'Iskander Madjitov', '', NULL, '', '3022224', 'iskander-madjitov', 'upload/images/kGMeEUQhkv6ub8b7EF9AJ6TvG9L.jpg'),
(371, 'actor', 'Zoé Höche', '', NULL, '', '3022226', 'zoé-höche', NULL),
(372, 'actor', 'Marielle Heller', 'Marielle Stiles Heller (born October 1, 1979) is an American director, screenwriter and actress. She is best known for directing the films The Diary of a Teenage Girl (2015), Can You Ever Forgive Me? (2018), and A Beautiful Day in the Neighborhood (2019).', 307584000, 'Marin County, California, USA', '177532', 'marielle-heller', 'upload/images/3YMRpIF6fPH1RDNOG4Do1Yqq4l5.jpg'),
(373, 'director', 'Scott Frank', 'Scott Frank, born on March 10, 1960, is a multi-talented American filmmaker. With his expertise in directing, producing, screenwriting, and even writing books, Frank has made a significant impact in the film industry. His exceptional skills have earned him two Academy Award nominations for Best Adapted Screenplay, thanks to his remarkable work on movies like Out of Sight (1998) and Logan (2017). Throughout his career, Frank has contributed to numerous films, both in credited and uncredited roles. Recently, he has collaborated with Netflix, showcasing his talent in creating captivating television miniseries. One of his notable achievements includes co-creating the highly acclaimed series, The Queen\\\'s Gambit, alongside Allan Scott.', -309657600, 'Fort Walton Beach, Florida, USA', '2199', 'scott-frank', 'upload/images/xU7fTHyCuWg8cQYyYmZi7Ism5U2.jpg'),
(374, 'actor', 'Ajay Devgn', 'Ajay Devgan is an Indian film actor, director and producer. He is widely considered as one of the most popular actors of Hindi cinema who has appeared in over a hundred Hindi films. \n\nHe has won numerous awards, including two National Film Awards and four Filmfare Awards. In 2016, he was honoured by the Government of India with the Padma Shri, the fourth highest civilian honour of the country.\n\nDevgan began his professional career with Phool Aur Kaante in 1991 and received a Filmfare Award for Best Male Debut for his performance.  In 1998, he appeared in a critically acclaimed performance in Mahesh Bhatt\\\'s drama Zakhm and he received his first National Film Award for Best Actor for his role in the movie. In 1999, his most-talked-about film was Hum Dil De Chuke Sanam in which he played Vanraj, a man who tries to unite his wife with her lover. He has starred in more than hundred Hindi films. Having done so, he established himself as one of the leading actors of Hindi cinema.\n\nIn addition, Devgn owns a production company Ajay Devgn FFilms which was established in 2000. In 2008 he debuted as a film director with U Me Aur Hum. He is married to film actress, Kajol since 1999 and the couple have two children. In August 2009, Devgn changed his surname from Devgan to Devgn on the request of his family.', -23673600, 'New Delhi, India', '42803', 'ajay-devgn', 'upload/images/vnHQQFzTjJ0sv14DGMIoKa3qTxN.jpg'),
(375, 'actor', 'Gajraj Rao', 'Born 1971, Gajraj Rao is an Indian actor who appears predominantly in Hindi films. He is known most for his award-winning performance in Badhaai Ho. He debuted in 1994 with a minor role in Shekhar Kapur\\\'s Bandit Queen and has since worked in many films and web-series.', 0, 'Dungarpur, India', '101827', 'gajraj-rao', 'upload/images/pomm4rYhIDqoEHtzKucbEOoJp7n.jpg'),
(376, 'actor', 'Rudranil Ghosh', 'Rudranil Ghosh was born on January 6, 1973 in Howrah, West Bengal, India. He is an actor and writer, known for Hawa Bodol (2013), Chaplin (2011) and The Japanese Wife (2010).', 95126400, 'Howra, West Bengal, India', '1106316', 'rudranil-ghosh', 'upload/images/iwDM4gz1gLutxlMnAKyJqZUwAbv.jpg'),
(377, 'director', 'Amit Sharma', 'Rudranil Ghosh was born on January 6, 1973 in Howrah, West Bengal, India. He is an actor and writer, known for Hawa Bodol (2013), Chaplin (2011) and The Japanese Wife (2010).', 95126400, 'Howra, West Bengal, India', '1106316', 'amit-sharma', NULL),
(378, 'actor', 'Arshad Warsi', 'Arshad Warsi is an Indian actor, producer, dancer, television personality, choreographer, and playback singer who appears in Hindi films. He is the recipient of several awards including a Filmfare Award from five nominations and is noted for acting in varied film genres.\n\nBefore making his acting debut, also served as an assistant director to Mahesh Bhatt in Kaash (1987) and also choreographed a song in Roop Ki Rani Choron Ka Raja (1993). Warsi made his acting debut in 1996 with Tere Mere Sapne, which was a box office success. His portrayal of Circuit in the comedy film Munna Bhai M.B.B.S. (2003), and its sequel Lage Raho Munna Bhai (2006) for which he won the Filmfare Award for Best Performance in a Comic Role marked a turning point in his career. He featured in several commercially successful comedy films including Hogi Pyaar Ki Jeet (1999), Hulchul (2004), Maine Pyaar Kyun Kiya? (2005), Salaam Namaste (2005), Golmaal: Fun Unlimited (2006), Dhamaal (2007), Krazzy 4 (2008), Golmaal Returns (2008), Ishqiya (2010), Golmaal 3 (2010), F.A.L.T.U (2011), Double Dhamaal (2011), Jolly LLB (2013), Golmaal Again (2017) and Total Dhamaal (2019), and received critical recognition for his work in films including Sehar (2005), Kabul Express (2006), Dedh Ishqiya (2014) and Guddu Rangeela (2015). He is widely regarded by many as one of the most underrated actors in the Hindi film industry.', -53740800, 'Mumbai, Maharashtra, India', '85889', 'arshad-warsi', 'upload/images/1Hv35hhpfwNXNm0DqJxpfNJt1q.jpg'),
(379, 'actor', 'Shreyas Talpade', 'From Wikipedia, the free encyclopedia\n\nShreyas Talpade (born 27 January 1976) is an Indian actor who appears in Marathi and Bollywood films.\n\nDescription above from the Wikipedia article Shreyas Talpade, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 191548800, 'Mumbai, Maharashtra, India', '53974', 'shreyas-talpade', 'upload/images/rKORFoIrI4GlcIfzzyVwCQNL9no.jpg'),
(380, 'actor', 'Tusshar Kapoor', 'Tusshar Kapoor (born 20 November 1976 in Mumbai, Maharashtra, India) is an Indian actor. He is the son of Bollywood actor Jeetendra and Shobha Kapoor and brother of Ekta Kapoor. He studied at the University of Michigan and graduated with a MBA from the Stephen M. Ross School of Business.\n\nTushar made his debut with Mujhe Kucch Kehna Hai alongside Kareena Kapoor in 2001. The next two years followed with a list of box office flops, although he was noted for acting alongside his father in the teen slasher film Kucch To Hai (2003). He was recognized for his role as a shy boy who gains the ability to become invisible in Gayab (2004).[2] Kapoor appeared in comic roles in Golmaal (2006) and Golmaal Returns (2008) and Golmaal 3 (2010).\n\nDescription above from the Wikipedia article Tusshar Kapoor, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 217296000, 'Mumbai, Maharashtra, India', '85891', 'tusshar-kapoor', 'upload/images/5ApUsEt56R0SVQMu11fbmUSHCIi.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(381, 'director', 'Rohit Shetty', 'Ajay Devgan is an Indian film actor, director and producer. He is widely considered as one of the most popular actors of Hindi cinema who has appeared in over a hundred Hindi films. \n\nHe has won numerous awards, including two National Film Awards and four Filmfare Awards. In 2016, he was honoured by the Government of India with the Padma Shri, the fourth highest civilian honour of the country.\n\nDevgan began his professional career with Phool Aur Kaante in 1991 and received a Filmfare Award for Best Male Debut for his performance.  In 1998, he appeared in a critically acclaimed performance in Mahesh Bhatt\\\'s drama Zakhm and he received his first National Film Award for Best Actor for his role in the movie. In 1999, his most-talked-about film was Hum Dil De Chuke Sanam in which he played Vanraj, a man who tries to unite his wife with her lover. He has starred in more than hundred Hindi films. Having done so, he established himself as one of the leading actors of Hindi cinema.\n\nIn addition, Devgn owns a production company Ajay Devgn FFilms which was established in 2000. In 2008 he debuted as a film director with U Me Aur Hum. He is married to film actress, Kajol since 1999 and the couple have two children. In August 2009, Devgn changed his surname from Devgan to Devgn on the request of his family.', -23673600, 'New Delhi, India', '42803', 'rohit-shetty', 'upload/images/ke8kvmtlSa67EYVo8a42US18ok2.jpg'),
(382, 'actor', 'Hrithik Roshan', 'Hrithik Roshan is an Indian actor who appears in Bollywood films.  After having appeared in films as a child actor in the 1980s, Roshan made his film debut in a leading role in Kaho Naa... Pyaar Hai (2000) for which Roshan earned his Filmfare Awards for Best Actor and Best Male Debut. In 2001, he went on to appear in the melodrama Kabhi Khushi Kabhie Gham..., which became India\\\'s highest-grossing film in the overseas market and his biggest commercial success to date.\n\nFollowing through with several unnoticed performances from 2002–03, he starred in the commercially successful Koi... Mil Gaya and its sequel Krrish, both of which won him numerous Best Actor awards.Roshan received his third Filmfare Award for Best Actor in 2006 for his performance in the action film Dhoom 2. He later received critical acclaim for his performance in Jodhaa Akbar, for which he received his first international award at the Golden Minbar International Film Festival. These accomplishments have established him as a leading contemporary actor of Hindi cinema.', 127008000, 'Mumbai, Maharashtra, India', '78749', 'hrithik-roshan', 'upload/images/upKrdABAMK7jZevWAoPYI24iKlR.jpg'),
(383, 'actor', 'Akshay Oberoi', 'Akshay Oberoi is an Indian film and television actor.', 473385600, 'Lucknow, Uttar Pradesh, India', '1342538', 'akshay-oberoi', 'upload/images/dsFqDJzSzUiKZpicmj05Iv1YbOs.jpg'),
(384, 'actor', 'Karan Singh Grover', 'Karan Singh Grover (born 23 February 1982)is an Indian model and actor known for his work in Indian television series such as Dill Mill Gayye and Qubool Hai. He has also starred in the Indian films Alone and Hate Story 3.', 383270400, 'New Delhi, India', '1241304', 'karan-singh-grover', 'upload/images/uiNUOzdEi1jZcD5FIUse7qi0VPE.jpg'),
(385, 'actor', 'Sanjeeda Sheikh', 'Sanjeeda Sheikh is an Indian television actress.Sheikh has played various roles on television soap operas. She appeared in the lead role of Nimmo in 2005 TV show Kyaa Hoga Nimmo Kaa and a vamp in 2007 Star Plus series Kayamath. She also appeared playing the role of Durga Thakur as a revenge seeking woman in the thriller series Ek Hasina Thi. Along with Aamir Ali she participated in the dancing competition show Nach Baliye 3 and won the competition. She married her longtime boyfriend Aamir Ali on 2 March 2012.', 472348800, 'Kuwait', '1235179', 'sanjeeda-sheikh', 'upload/images/rz92hLtWoj1OCCchAZLtZvPwp0o.jpg'),
(386, 'actor', 'Mahesh Shetty', '', 0, '', '2377493', 'mahesh-shetty', 'upload/images/rGxhEDfDwBffOOiUyyIlTJztO0X.jpg'),
(387, 'actor', 'Samvedna Suwalka', '', 0, '', '2291068', 'samvedna-suwalka', 'upload/images/rWjPUFehWY5NFiEnrI1ZzpVDVmN.jpg'),
(388, 'actor', 'Akarsh Alagh', '', 0, '', '4329603', 'akarsh-alagh', NULL),
(389, 'actor', 'Sanjiv Chopra', '', 0, '', '230633', 'sanjiv-chopra', NULL),
(390, 'actor', 'Birol Tarkan Yıldız', '', 105494400, '', '212749', 'birol-tarkan-yıldız', 'upload/images/dfgtqEQ3nEB3NGRgegDuykga7hE.jpg'),
(391, 'actor', 'Ashok Selvan', 'Ashok Selvan is a Tamil film actor. He made his breakthrough playing one of the lead roles in Soodhu Kavvum (2013), before gaining critical acclaim for his performances in C. V. Kumar\\\'s productions Pizza 2: The Villa and Thegidi (2014).', 626486400, 'Erode, Tamil Nadu, India', '1187398', 'ashok-selvan', 'upload/images/qA8w8hRmyw7IWxIuM64s7aPwqbe.jpg'),
(392, 'actor', 'Shanthanu Bhagyaraj', 'Shanthanu Bhagyaraj is an Indian film actor who has work predominantly on Tamil language films. The son of actors K. Bhagyaraj and Poornima Bhagyaraj, Shanthanu appeared as a child artist in his father\\\'s Vettiya Madichu Kattu (1998), before making his debut as a lead actor in the romantic comedy Sakkarakatti (2008).', 525225600, 'Chennai, Tamil Nadu, India', '1053909', 'shanthanu-bhagyaraj', 'upload/images/sbNZuxJr7XCCXPxx9lcXMPKVvVF.jpg'),
(393, 'actor', 'Keerthi Pandian', 'Keerthi Pandian is an Indian film Actress, who has works predominantly in Tamil movie industry .', 666835200, 'Chennai, Tamil Nadu, India', '2268255', 'keerthi-pandian', 'upload/images/kCfamS8gjyzCq7puqkO4Gt9Aj7U.jpg'),
(394, 'actor', 'Prithvi Pandiarajan', 'Prithvi Rajan is a Tamil film actor, who has appeared in leading roles. He is the 2nd son of the veteran actor, Pandiarajan.', 622598400, 'Chennai, Tamilnadu,  India', '1325660', 'prithvi-pandiarajan', NULL),
(395, 'actor', 'Bagavathi Perumal', 'Bagavathi Perumal is an Indian actor, who has worked in Tamil films.', 270000000, '', '1128068', 'bagavathi-perumal', 'upload/images/ixK5bTpLOIXc8oJVE1IVMzcJrB2.jpg'),
(396, 'actor', 'Elango Kumaravel', 'Elango Kumaravel is an Indian actor and script writer. He is also a co-founder of the Chennai based theatre group \\\"Magic Lantern\\\". He is an alumnus of Pondicherry University\\\'s Sankaradas Swamigal School of Performing Arts and the Chennai based theatre workshop koothuppattarai. He has also worked as a casting assistant for the 2007 film Loins of Punjab Presents and wrote the script for the 2008 film Kattradhu Kalavu. He was involved in the production of \\\"Ey Aa O!\\\" a musical fusion work of collaboration between Indian folk and classical musicians.', -137203200, 'Tamil Nadu, India', '1425004', 'elango-kumaravel', 'upload/images/8LtXDdacaCA7Gk4B8ACxTs430EO.jpg'),
(397, 'actor', 'Lizzie Antony', 'Lizzie Antony is an Indian film actress working in the Tamil film industry, mostly as a supporting actress.', 0, 'Chennai, Tamil Nadu, India', '1995921', 'lizzie-antony', 'upload/images/ixHVL81eCUTr1iy3C8d1EwScukK.jpg'),
(398, 'actor', 'Dhivya Dhuraisamy', '', 823478400, 'Chennai, Tamil Nadu, India', '3051221', 'dhivya-dhuraisamy', 'upload/images/jUgj54j5SoBGuE3KpdVP0fjkUwc.jpg'),
(399, 'actor', 'Arun Balaji', '', 0, '', '1065794', 'arun-balaji', NULL),
(400, 'actor', 'Balaji Prasad', '', 0, '', '4477384', 'balaji-prasad', NULL),
(401, 'actor', 'Jeyachandran', '', 0, '', '4477385', 'jeyachandran', NULL),
(402, 'actor', 'Diganth Manchale', 'Diganth Manchale, known as Diganth, is an Indian film actor and a former model.', 441417600, 'Benguluru, India', '1210124', 'diganth-manchale', 'upload/images/o5T3X15zNomtDt5CumYBVZ3FIdI.jpg'),
(403, 'actor', 'Achyuth Kumar', 'Achyuth Kumar is an Indian actor who predominantly works in Kannada cinema.', -120528000, 'Tumkur, Karnataka, India', '1333834', 'achyuth-kumar', 'upload/images/zO1MoCgaz0RxILjga8VYXguROMp.jpg'),
(404, 'actor', 'Siri Ravikumar', '', 0, '', '3037219', 'siri-ravikumar', 'upload/images/xOg7MB3786pTOEfmXzPvzQbBbQn.jpg'),
(405, 'actor', 'Achara Kirk', 'Achara Kirk. Actress | Cinematographer | Producer. Achara Kirk was born on May 10, 1984 in Bangkok, Thailand. She is an actress and cinematographer, known for Fringe (2008), Stalker (2017) and Moments.', 452995200, 'Bangkok, Thailand', '1648414', 'achara-kirk', 'upload/images/l4cL7zwokRdq7D0IZuRLOuOsPdU.jpg'),
(406, 'actor', 'Prakash Tuminadu', '', 0, '', '1906565', 'prakash-tuminadu', NULL),
(407, 'actor', 'Yogesh', 'Yogesh, also known as Yogi, is an Indian actor working predominantly in the Kannada film industry. He debuted in the film Duniya (2007) where he portrayed the character of \\\"Loose Maada\\\".', 0, 'Bangalore, Karnataka, India', '1355428', 'yogesh', 'upload/images/eyx3zbykfltL2Ca4Ws4beWsKwf1.jpg'),
(408, 'actor', 'Balaji Manohar', '', 0, '', '101865', 'balaji-manohar', 'upload/images/7lHQhTKtoOM1GeEmRqOqj8jOyMe.jpg'),
(409, 'director', 'Abhijit Mahesh', 'Achyuth Kumar is an Indian actor who predominantly works in Kannada cinema.', -120528000, 'Tumkur, Karnataka, India', '1333834', 'abhijit-mahesh', NULL),
(410, 'actor', 'Virginia Gardner', 'Virginia Gardner (born April 18, 1995) is an American actress from Sacramento, California. She is best known for playing Christina Raskin in the found footage film Project Almanac and Karolina Dean in the web television series Marvel\\\'s Runaways.', 798163200, 'Sacramento, California, USA', '1279279', 'virginia-gardner', 'upload/images/ltAmh88GkDs2E4tXErFhFAPmv9X.jpg'),
(411, 'actor', 'Dylan Sprouse', 'Dylan Thomas Sprouse (born August 4, 1992) is an American actor and the twin brother of Cole Sprouse. He is known for his role as Zack Martin on the Disney Channel series The Suite Life of Zack & Cody and its spin-off, The Suite Life on Deck.\n\nDescription above from the Wikipedia article Dylan Sprouse, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 712886400, 'Arezzo, Tuscany, Italy', '95686', 'dylan-sprouse', 'upload/images/1kAWq60C8NpEkDsUMz4dVUo5YTH.jpg'),
(412, 'actor', 'Libe Barer', 'Libe Alexandra Barer (born December 19, 1991) is an American actress best known for playing the role Carly Bowman in the Amazon Prime original series Sneaky Pete.\n\nHer younger sibling is Ariela Barer. Their parents are both Mexican-born and Jewish.\n\nBarer attended the Los Angeles County High School for the Arts (nicknamed \\\"Fame High\\\") where she received an LACHSA Moondance Film Festival Award for her screenplay \\\"On Top Of The World.\\\"\n\nIn addition to her role on Sneaky Pete, Barer starred in the short film Disfluency, had a role on the shows Those Who Can\\\'t and Parenthood, and was featured in a commercial for Subway.', 693100800, 'Los Angeles, California, USA', '1524899', 'libe-barer', 'upload/images/peA4FQ9y8vImDrjEPrq6XlqYY5P.jpg'),
(413, 'actor', 'Rob Estes', 'Robert Alan Estes (born July 22, 1963) is an American  actor. He is best known for his roles as Harry Wilson on the teen drama  90210, as Sgt. Chris Lorenzo on the crime drama Silk Stalkings, and as Kyle McBride on the primetime soap opera Melrose Place.\n\nFrom Wikipedia, the free encyclopedia.', -203472000, 'Norfolk, Virginia, USA', '20960', 'rob-estes', 'upload/images/uRex9dyCv4mt7V4mxUzZ9NmVxjH.jpg'),
(414, 'actor', 'Austin North', 'Austin North was born on July 30, 1996 in Cincinnati, Ohio, USA. He is an actor, known for I Didn\\\'t Do It (2014), Jessie (2011) and Kickin\\\' It (2011).', 838684800, 'Cincinnati, Ohio, USA', '1449393', 'austin-north', 'upload/images/AuamGbm12flhZ0K95hhdyhYAbBS.jpg'),
(415, 'actor', 'Jack Hesketh', '', 0, '', '3888806', 'jack-hesketh', 'upload/images/qTuXX750tfsMa2uKG7KHyYt2Szy.jpg'),
(416, 'actor', 'Declan Michael Laird', '', 0, '', '1264908', 'declan-michael-laird', 'upload/images/bCo8DZIeQfbEolIJ4RpUt61GdO2.jpg'),
(417, 'actor', 'Trevor Van Uden', '', 0, '', '2589498', 'trevor-van-uden', 'upload/images/a0QiACO7QM2JhxWw4etsXOzl6KF.jpg'),
(418, 'actor', 'Neil Bishop', '', 0, '', '1792454', 'neil-bishop', 'upload/images/z9bXADEqpoaxszD2wp3fzSIYac0.jpg'),
(419, 'actor', 'Micky Dartford', '', 0, '', '3216457', 'micky-dartford', 'upload/images/pLHa0x9CXJHfoUYtBE47SUrWKY3.jpg'),
(420, 'actor', 'Alex Aiono', 'Alex Aiono was born on February 16, 1996 in Phoenix, Arizona, USA as Martin Alexander Aiono. He is an actor, known for The Lego Batman Movie (2017), Office Christmas Party (2016) and A Lot of Nothing.', 824428800, 'Phoenix, Arizona, USA', '2921201', 'alex-aiono', 'upload/images/nzbr9cXhfoy7cAAQtSS1W4iLBlM.jpg'),
(421, 'director', 'Roger Kumble', 'Dylan Thomas Sprouse (born August 4, 1992) is an American actor and the twin brother of Cole Sprouse. He is known for his role as Zack Martin on the Disney Channel series The Suite Life of Zack & Cody and its spin-off, The Suite Life on Deck.\n\nDescription above from the Wikipedia article Dylan Sprouse, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 712886400, 'Arezzo, Tuscany, Italy', '95686', 'roger-kumble', 'upload/images/njVOmV33aCFRUlBxxLXzLbrmAUS.jpg'),
(422, 'actor', 'Laksh Chadalavada', '', 0, '', '2581872', 'laksh-chadalavada', NULL),
(423, 'actor', 'Soniya Bansal', '', 0, '', '3735648', 'soniya-bansal', NULL),
(424, 'actor', 'Bobby Bedii', '', 0, '', '2285268', 'bobby-bedii', NULL),
(425, 'actor', 'Neha Pathan', '', 0, '', '3735689', 'neha-pathan', NULL),
(426, 'actor', 'Mirchi Kiran', '', 0, '', '2527551', 'mirchi-kiran', 'upload/images/qT0Gf5pQsHCohCGvGeUggTxgiWU.jpg'),
(427, 'actor', 'Bharani Shankar', 'Bharani Shankar is an Indian actor who known for his works in Telugu television industry.', 0, '', '2375168', 'bharani-shankar', NULL),
(428, 'actor', 'Viva Raghav', '', 0, '', '3735690', 'viva-raghav', NULL),
(429, 'actor', 'Naveen Neni', '', 0, '', '2478017', 'naveen-neni', NULL),
(430, 'actor', 'Himaja', 'Himaja is an Indian film actress who works primarily in the Telugu cinema.', 720662400, 'Vijayawada, Andhra Pradesh, India', '1350824', 'himaja', 'upload/images/9aowz0YD4c2tWs0FC1VxF4RqbES.jpg'),
(431, 'actor', 'Samrat Reddy', '', 0, '', '2049761', 'samrat-reddy', 'upload/images/wrdaXOFeuXILALVByYKLZOtPLvL.jpg'),
(432, 'actor', 'Chinmay Mandlekar', '', 0, '', '582492', 'chinmay-mandlekar', 'upload/images/56MoFlRq5yZvBIYfqRxC1WeImA3.jpg'),
(433, 'actor', 'Sameer Dharmadhikari', '', 0, '', '125931', 'sameer-dharmadhikari', 'upload/images/1Mwd5xW7jFyfiGK3Zg4AfAuMbWI.jpg'),
(434, 'actor', 'Dipti Ketkar', '', 0, '', '3429097', 'dipti-ketkar', 'upload/images/rXVg8feDsWabJUXDqbFPI9LdeB2.jpg'),
(435, 'actor', 'Neha Joshi', 'Neha Joshi is an Indian actress who was born and brought up in Pune. Her work includes Zenda and Poshter Boyz. Joshi plays B. R. Ambedkar\\\'s mother Bhimabai in the Ek Mahanayak - Dr.B.R. Ambedkar series on & TV', 534211200, '', '582494', 'neha-joshi', 'upload/images/dILuR3RU863sD6GnroCO7opx91s.jpg'),
(436, 'actor', 'Sunil Jadhav', '', 0, '', '4473417', 'sunil-jadhav', NULL),
(437, 'actor', 'Nakshatra Medhekar', '', 0, '', '4260098', 'nakshatra-medhekar', NULL),
(438, 'actor', 'Henry Cavill', 'Henry William Dalgliesh Cavill (born 5 May 1983) is a British actor. He is known for his portrayal of Charles Brandon in Showtime\\\'s The Tudors (2007–2010), DC Comics character Superman in the DC Extended Universe, Geralt of Rivia in the Netflix fantasy series The Witcher (2019–present), as well as Sherlock Holmes in the Netflix film Enola Holmes (2020).\n\nCavill began his career with roles in the feature adaptations of The Count of Monte Cristo (2002) and I Capture the Castle (2003). He later portrayed supporting roles in several television series, including BBC\\\'s The Inspector Lynley Mysteries, ITV\\\'s Midsomer Murders, and Showtime\\\'s The Tudors. He has since appeared in numerous major studio films, such as Tristan & Isolde (2006), Stardust (2007), Blood Creek (2009), Immortals (2011), The Cold Light of Day (2012), Sand Castle (2017) and Night Hunter (2018). Cavill gained international recognition with his role as Superman in the DC Extended Universe superhero films Man of Steel (2013), Batman v Superman: Dawn of Justice (2016) and Justice League (2017). He also starred in the action spy films The Man from U.N.C.L.E. (2015) and Mission: Impossible – Fallout (2018).\n\nDescription above from the Wikipedia article Henry Cavill, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 420940800, 'St. Helier, Jersey, Channel Islands', '73968', 'henry-cavill', 'upload/images/iWdKjMry5Pt7vmxU7bmOQsIUyHa.jpg'),
(439, 'actor', 'Anya Chalotra', 'Anya Chalotra is an actress who has appeared in Wanderlust (2018) and The ABC Murders (2018). Anya trained at Guildhall School of Music and Drama.\n\nHer talent was developed as a pupil at St Dominic’s Brewood, which in 2017 became St Dominic’s Grammar School and has introduced the 11-plus exam for its preparatory pupils. She worked with Carol Molin, the school’s head of expressive arts, and starred on stage in many of the school’s productions. After leaving St Dominic’s sixth form, with Theatre Studies among her three A Levels, Anya trained first at the London Academy of Music and Dramatic Art and then at The Guildhall School of Music and Drama.', 837907200, 'Wolverhampton, Staffordshire, England, UK', '2146944', 'anya-chalotra', 'upload/images/uF7OzuFm0TEYP8MkaBiQBLjuxUv.jpg'),
(440, 'actor', 'Freya Allan', 'Freya Allan (born 6 September 2001) is an English actress, known for her role as Princess Cirilla of Cintra in the Netflix series The Witcher.', 999734400, 'Oxfordshire, England, UK', '2146942', 'freya-allan', 'upload/images/xq33JCqUjBzPz3drN48N2N7ySKI.jpg'),
(441, 'actor', 'Eamon Farren', 'Eamon Farren is an Australian actor. After appearing as the lead in Jennifer Lynch\\\'s psychological thriller Chained (2012), he came to prominence when her father David cast him in the 2017 revival of the cult television series Twin Peaks. He currently appears on the Netflix series The Witcher (2019–present) as army commander Cahir Mawr Dyffryn aep Ceallach.', 485308800, 'North Queensland, Australia', '110425', 'eamon-farren', 'upload/images/80VSnsS2HRVeJR62QtSwrHvtzjx.jpg'),
(442, 'actor', 'Mimî M. Khayisa', '', 683596800, 'Guildford, Surrey, England, UK', '1503072', 'mimî-m-khayisa', 'upload/images/kfwWaxcovzkahqDDhhJwPrGbnny.jpg'),
(443, 'actor', 'MyAnna Buring', 'MyAnna Buring is a Swedish-born British actress, known for her roles in The Descent, The Twilight Saga: Breaking Dawn – Part 1 and Part 2, Ripper Street and Downton Abbey.', 306806400, 'Sundsvall, Västernorrlands län, Sweden', '57578', 'myanna-buring', 'upload/images/boC5LKewKpz8zhtUmPScHfkSAlV.jpg'),
(444, 'actor', 'Joey Batey', '', 599616000, 'Newcastle upon Tyne, England, UK', '1353920', 'joey-batey', 'upload/images/4uo4JPaK6KpdN7v8C1pbwKpNVJU.jpg'),
(445, 'actor', 'Anna Shaffer', '', 700617600, 'London, England, UK', '234929', 'anna-shaffer', 'upload/images/exFFZev9XwyyPlJmHDma4fUSeFy.jpg'),
(446, 'actor', 'Wilson Mbomio', '', NULL, '', '2200173', 'wilson-mbomio', 'upload/images/oWEC9KBCbZe2mwsw7Yr9R2zIOCE.jpg'),
(447, 'actor', 'Mecia Simson', '', 630892800, '', '1949684', 'mecia-simson', 'upload/images/s6Sw1MjfQb0ElsHOFxZHJDZnCVx.jpg'),
(448, 'actor', 'Tom Canton', '', NULL, '', '1417081', 'tom-canton', 'upload/images/zzoJu7FvlJ1cf4cuuhDkhwloY1i.jpg'),
(449, 'actor', 'Mahesh Jadu', '', 404438400, 'Carlton, Melbourne, Victoria, Australia', '1386458', 'mahesh-jadu', 'upload/images/o8m6Z0U1tV9TMgSvvsAvclWtiXu.jpg'),
(450, 'actor', 'Royce Pierreson', '', 607392000, 'Saltash, Regno Unito', '1266313', 'royce-pierreson', 'upload/images/oybeyUuA9zx1zo6RcJsMWt3lsip.jpg'),
(451, 'actor', 'Graham McTavish', 'Graham McTavish (born 1961) is a Scottish television actor. He has played the character Warden Ackerman in Red Dwarf in five episodes of series 8. McTavish has also had many supporting roles in British dramas and films such as Casualty, Jekyll, The Bill, Taggart and Sisterhood. He also played the ill-tempered Mercenary Commander Lewis in Rambo, had a role as Desmond\\\'s drill sergeant in the fourth season of Lost, starred in Ali G Indahouse as a Customs Officer and played a Russian pirate in NCIS. He played Ferguson in 4 episodes of season 4 of Prison Break. He has also starred in the film Green Street 2 which was released on 23rd March 2009. McTavish provided the voice and motion capture work for the evil psychopath war criminal Zoran Lazarevic in Uncharted 2: Among Thieves, the voice of the main protagonist Dante Alighieri in Dante\\\'s Inferno, Restoration leader Commander Lucius in the Shadow Complex video game, and the Decepticon Thundercracker in Transformers: War for Cybertron. He played Russian Foreign Minister Mikhail Novakovich in the eighth season of 24, and did voice work as the Marvel Comics villain Loki in Hulk Vs. Thor and The Avengers: Earth\\\'s Mightiest Heroes.\n\nMcTavish has also been cast in upcoming film The Wicker Tree, Robin Hardy\\\'s much anticipated sequel to 1973\\\'s The Wicker Man, and as Dwalin in the much anticipated The Hobbit.\n\nDescription above from the Wikipedia article Graham McTavish, licensed under CC-BY-SA, full list of contributors on Wikipedia​', -283737600, 'Glasgow, Scotland', '95047', 'graham-mctavish', 'upload/images/9IjPwv7Vb4QygA1cPSX179oqjsT.jpg'),
(452, 'actor', 'Lars Mikkelsen', 'Lars Dittmann Mikkelsen is a Danish actor.', -178502400, 'Gladsaxe, Copenhagen, Denmark', '71158', 'lars-mikkelsen', 'upload/images/uUBFJk4IB4EsY63f69dP3im6FkE.jpg'),
(453, 'actor', 'Therica Wilson-Read', '', NULL, '', '1725141', 'therica-wilson-read', 'upload/images/7Q03ooAeqdDk1vOS0yFY5aCBvM3.jpg'),
(454, 'actor', 'Cassie Clare', '', NULL, 'London, England, UK', '1700995', 'cassie-clare', 'upload/images/bn18nRKMVGJ2EgUg82aXugtyZz9.jpg'),
(455, 'actor', 'Terence Maynard', 'Terence Maynard is an English actor who is best known for appearing in the series Coronation Street. He portrayed the role of “Tony Stewart” in the show and appeared in it for more than a decade. Similarly, he has also featured in the most recent Netflix supernatural drama series, Cursed. He plays as “Brother Salt” in the show alongside Katherine Langford.', -31017600, 'Liverpool, England, UK', '67205', 'terence-maynard', 'upload/images/5KQ4MOCw5fdGaaOQD4VCOfp44ww.jpg'),
(456, 'actor', 'Bart Edwards', 'Bart Edwards was born in 1989 in Guildford, Surrey, England. He is an actor, known for The Witcher (2019), UnREAL (2015) and Lykkeland (2018).', NULL, 'Guildford, Surrey, England, UK', '1573807', 'bart-edwards', 'upload/images/d3pRjRWJMr6pTdFTpxuv0NXd42z.jpg'),
(457, 'actor', 'Hugh Skinner', 'Hugh Skinner (born January 6, 1985) is an English actor best known for playing Joly in the 2012 film Les Miserables, Will Humphries in W1A (2017), Wills in The Windsors (2019), Harry in Fleabag (2016), Unwin Trevaunance in series 2 of Poldark (2016), Sir George Howard in series 1 of Harlots (2017), Young Harry in Mamma Mia! Here We Go Again (2018), Simon Burrows in episode 8 of The Romanoffs (2018), Hugo in Little Birds (2020), Max in Falling for Figaro (2021).', 473817600, ' London, England, UK', '1206337', 'hugh-skinner', 'upload/images/8EKiF1rBmpQxi73ryXdcYH7FZpp.jpg'),
(458, 'actor', 'Kim Bodnia', 'Kim Bodnia (born 12 April 1965) is a Danish actor, writer, and director. He became widely known for his role as police detective Martin Rohde in the Scandinavian crime drama series The Bridge. He became internationally known for his lead role as drug dealer Frank in Nicolas Winding Refn\\\'s 1996 directorial debut Pusher. Today he is best known as Konstantin in Phoebe Waller-Bridge\\\'s 2018 BBC America spy thriller TV series Killing Eve.\n\nIn 2009, Bodnia won the 62nd Bodil Award for Best Actor in a Supporting Role, and in 2014 he won the Monte-Carlo Television Festival Award for Outstanding Actor in a Drama Series. In 2019 he earned a British Academy Television Award for Best Supporting Actor for his role in Killing Eve.', -149040000, 'Frederiksberg, Denmark', '3398', 'kim-bodnia', 'upload/images/koWU6vb82cuCDLeYE1erqnQ39cW.jpg'),
(459, 'director', 'Stephen Surjik', '​From Wikipedia, the free encyclopedia.\n\nStephen Surjik is a Canadian film and television director mostly working in television. Surjik was nominated three times for Gemini Awards for best direction, for Little Criminals, Tripping the Wire: A Stephen Tree Mystery, Intelligence, and received four Emmy Award nominations for Weapons of Mass Distraction.\n\nDescription above from the Wikipedia article Stephen Surjik , licensed under CC-BY-SA, full list of contributors on Wikipedia', -315619200, 'Regina, Saskatchewan, Canada', '56155', 'stephen-surjik', 'upload/images/xZAl5XQqf51Yz4maYtLc6HSG62z.jpg'),
(460, 'director', 'Alik Sakharov', 'Alik Sakharov was born on May 17, 1959. He is a cinematographer and director.', -335404800, 'Tashkent - USSR', '1318704', 'alik-sakharov', NULL),
(461, 'director', 'Alex Garcia Lopez', '', NULL, '', '1420294', 'alex-garcia-lopez', NULL),
(462, 'director', 'Sarah O\\\'Gorman', '', NULL, '', '1371826', 'sarah-ogorman', 'upload/images/c6lZ0bedS2KYFzxDly4HCiNEzU0.jpg'),
(463, 'director', 'Loni Peristere', 'Loni Peristere is an American television director, producer, and former visual effects supervisor. He is well known for his work on the Starz drama Banshee; and for the FX anthology series American Horror Story.  He began his career as a visual effects coordinator for the 1997 Tommy Lee Jones starrer Volcano. He worked in the department on future films, such as Cinderella, Serenity, Beyond, and One Day Like Rain. He worked in special effects for TV series Buffy the Vampire Slayer, Angel, Firefly, and Drive.\n\nIn 2014, Peristere segued into direction. Helming and producing multiple episodes of Starz\\\'s Banshee. That same year he began directing for FX\\\'s American Horror Story.  He is the co-founder of visual effects studio Zoic.', 41040000, 'Boston, Massachusetts, USA', '1452715', 'loni-peristere', 'upload/images/cIkrcxjOSLyDvDbsaZBnij8e4X3.jpg'),
(464, 'director', 'Charlotte Brändström', '', -334281600, 'Paris, France', '138756', 'charlotte-brändström', 'upload/images/nfUx9MJVZzpRAHvimfYC1faIlX3.jpg'),
(465, 'director', 'Louise Hooper', '', NULL, '', '992768', 'louise-hooper', NULL),
(466, 'director', 'Edward Bazalgette', '', NULL, '', '213107', 'edward-bazalgette', 'upload/images/1gfOa6od3pMYvfH8GRhY2QU0nLp.jpg'),
(467, 'director', 'Bola Ogun', '', NULL, '', '1982845', 'bola-ogun', NULL),
(468, 'director', 'Gandja Monteiro', '', NULL, '', '2292161', 'gandja-monteiro', 'upload/images/lvgCZICzxtw7DufFfVgIDrKpJ5H.jpg'),
(469, 'director', 'Marc Jobst', '', -277257600, 'Harare, Zimbabwe', '1515079', 'marc-jobst', NULL),
(470, 'actor', 'Martin Freeman', 'Martin John Christopher Freeman is an English actor. Among other accolades, he has won an Emmy Award, a BAFTA Award and a Screen Actors Guild Award, and has been nominated for a Golden Globe Award.\n\nFreeman\\\'s most notable roles are that of Tim Canterbury in the mockumentary series The Office (2001–2003), Dr. John Watson in the British crime drama series Sherlock (2010–2017), Bilbo Baggins in The Hobbit film trilogy (2012–2014), and Lester Nygaard in the first season of the dark comedy-crime drama series Fargo (2014).\n\nHe has also appeared in films including the romantic comedy Love Actually (2003), the horror comedy Shaun of the Dead (2004), the sci-fi comedy The Hitchhiker\\\'s Guide to the Galaxy (2005), the action comedy Hot Fuzz (2007), the semi-improvised comedy Nativity! (2009), the sci-fi comedy The World\\\'s End (2013).\n\nFor the last few years he has been playing Everett K. Ross in the Marvel Cinematic Universe superhero films Captain America: Civil War (2016), Black Panther (2018), and Black Panther: Wakanda Forever (2022). He will reprise the role in the upcoming Disney+ series Secret Invasion (2023).', 53136000, 'Aldershot, Hampshire, England, UK', '7060', 'martin-freeman', 'upload/images/vhs7quOGDG2mtFHvL7Lu7rU2dED.jpg'),
(471, 'actor', 'Jenna Ortega', 'Jenna Marie Ortega (born September 27, 2002) is an American actress. She began her career as a child actress, receiving recognition for her role as young Jane on The CW comedy-drama series Jane the Virgin (2014–2019). She had her breakthrough for starring as Harley Diaz on the Disney Channel series Stuck in the Middle (2016–2018), for which she won an Imagen Award. She played Ellie Alves in the second season of the Netflix thriller series You in 2019 and starred in the Netflix family film Yes Day (2021).\n\nOrtega received critical praise for her performance in the teen drama The Fallout (2021), and went on to star in the slasher films X (2022), Scream (2022) and its sequel Scream VI (2023), establishing herself as a scream queen. She starred as Wednesday Addams in the Netflix horror comedy series Wednesday (2022), for which she received nominations for a Primetime Emmy Award, a Golden Globe Award and a SAG Award.\n\nDescription above from the Wikipedia article Jenna Ortega, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 1033084800, 'Coachella Valley, Palm Desert, California, USA', '974169', 'jenna-ortega', 'upload/images/q1NRzyZQlYkxLY07GO9NVPkQnu8.jpg'),
(472, 'actor', 'Gideon Adlon', 'Gideon Adlon is an American actress. She is best known for her starring roles in the comedy film Blockers, the drama film The Mustang, and the horror film The Craft: Legacy. Adlon also starred in the Netflix drama series The Society.', 859680000, 'Los Angeles, USA', '1803286', 'gideon-adlon', 'upload/images/l8BSlg87Mn75n28P2aXzot6G0pi.jpg'),
(473, 'actor', 'Bashir Salahuddin', '', 204940800, 'Chicago, Illinois, USA', '1241330', 'bashir-salahuddin', 'upload/images/ZL5MRzjd6kWkvQXqh5mgPY1CKP.jpg'),
(474, 'actor', 'Dagmara Domińczyk', 'Dagmara Domińczyk (doh-MEEN-chik, born July 17, 1976) is a Polish-American actress and author. She\\\'s best known for her roles as Mercedès Iguanada in The Count of Monte Cristo (2002), Tania Asher in Rock Star (2001), Agnes Gebhard in Kinsey (2004), Marguerite in The Five People You Meet in Heaven (2004), Katrina on WB\\\'s The Bedford Diaries, Suzanne in Running with Scissors (2006), Belva in The Immigrant (2013), Elizabeth Taylor in Big Stone Gap (2013), Stacy in Let\\\'s Kill Ward\\\'s Wife (2014), Karolina Novotney on HBO\\\'s Succession, Ellen in The Assistant (2020), Erika Jensen on HBO\\\'s We Own This City (2022), and Elle Sellwyn on AppleTV\\\'s Hello Tomorrow! (2023).\n\nIn 2013, she released her novel The Lullaby of Polish Girls.\n\nShe has been married to actor Patrick Wilson since 2005 and they have two sons. Her sisters are actress Marika Domińczyk and actress Veronika Domińczyk.', 206409600, 'Kielce, Swietokrzyskie, Poland', '52776', 'dagmara-domińczyk', 'upload/images/v6UPrlXz0ZMuip4rjETCfnfxGjE.jpg'),
(475, 'actor', 'Christine Adams', 'Film and television actress Christine Adams was born in London, United Kingdom.\n\nShe starred on several British and American films and television series since early 2000s.\n\nOn television, she is known for roles as \\\"Katherine Williams Osgood\\\" on the British miniseries, NY-LON (2004); \\\"Simone Hundin\\\" on the American comedy-drama series, Pushing Daisies (2007) (2007-2009); as \\\"Lena Boudreaux\\\" on the short-lived ABC legal drama series, The Whole Truth (2010); and as \\\"Mira\\\" in FOX\\\'s science-fiction drama series, Terra Nova (2011).\n\nIn 2012, she starred, opposite Anthony LaPaglia, on the ABC drama series, Americana (2012). Adams appeared on several films, such as Submerged (2005), Batman Begins (2005), Eye of the Dolphin (2006), Green Flash (2008), Beneath the Blue (2010), TRON: Legacy (2010) and The Girl with the Dragon Tattoo (2011). She resides in Los Angeles with her husband and daughter.', 145756800, 'London, England, UK', '87194', 'christine-adams', 'upload/images/yUMJguEggbkNzUZnvRCYgebU0Ck.jpg'),
(476, 'director', 'Jade Halley Bartlett', 'Jenna Marie Ortega (born September 27, 2002) is an American actress. She began her career as a child actress, receiving recognition for her role as young Jane on The CW comedy-drama series Jane the Virgin (2014–2019). She had her breakthrough for starring as Harley Diaz on the Disney Channel series Stuck in the Middle (2016–2018), for which she won an Imagen Award. She played Ellie Alves in the second season of the Netflix thriller series You in 2019 and starred in the Netflix family film Yes Day (2021).\n\nOrtega received critical praise for her performance in the teen drama The Fallout (2021), and went on to star in the slasher films X (2022), Scream (2022) and its sequel Scream VI (2023), establishing herself as a scream queen. She starred as Wednesday Addams in the Netflix horror comedy series Wednesday (2022), for which she received nominations for a Primetime Emmy Award, a Golden Globe Award and a SAG Award.\n\nDescription above from the Wikipedia article Jenna Ortega, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 1033084800, 'Coachella Valley, Palm Desert, California, USA', '974169', 'jade-halley-bartlett', 'upload/images/OyjXqT1eJBepgY6poqHNBbayfh.jpg'),
(477, 'actor', 'Ian McShane', 'Ian David McShane (born September 29, 1942) is an English actor. Although he has appeared in numerous films, it is by his television roles that he is generally known, starting with the BBC\\\'s Lovejoy (1986–94) and particularly in the HBO Western drama Deadwood (2004–06). He starred as King Silas Benjamin in NBC series Kings and as Blackbeard in Pirates of the Caribbean: On Stranger Tides.\n\nDescription above from the Wikipedia article Ian McShane, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -860198400, 'Blackburn, Lancashire, England, UK', '6972', 'ian-mcshane', 'upload/images/rteBJYNgD1yGsHg2HGZAIrYHz1t.jpg'),
(478, 'actor', 'Nora Arnezeder', 'Nora Arnezeder is a French actress and singer.\n\nArnezeder was born in Paris, France. Her father, Wolfgang, is Austrian and Catholic, and her mother, Piera, is an Egyptian Jew.\n\nAt the age of two, she left Paris with her parents for Aix-en-Provence. When she was fourteen, she moved to Bali for a year and, once back in Paris, studied dancing and singing.\n\nHer first major role was in 2008, in Paris 36 (French: Faubourg 36), which was directed by Christophe Barratier. In this film, Nora Arnezeder sang \\\"Loin de Paname\\\", which was nominated for Best Original Song at the 82nd Academy Awards. In 2009, she was the face of Guerlain\\\'s fragrance \\\"L\\\'Idylle\\\". In 2012, Arnezeder appeared in the films Safe House, with Ryan Reynolds, and, as Celia, in The Words, opposite Ben Barnes.\n\nArnezeder also starred in the horror slasher film Maniac alongside Elijah Wood.', 610588800, 'Paris, France', '453272', 'nora-arnezeder', 'upload/images/6I1x7HVeUtHKXNSLikIOhBWqViG.jpg'),
(479, 'actor', 'Adam Nagaitis', 'From Wikipedia, the free encyclopedia.\n\nAdam Matthew Nagaitis, born 7 June 1985) is a British actor best known for his roles as Caulker\\\'s Mate Cornelius Hickey in the AMC television series The Terror and firefighter Vasily Ignatenko in the HBO miniseries Chernobyl. Nagaitis is a graduate of the Stella Adler Conservatory and the Royal Academy of Dramatic Art.', 486950400, 'Chorley, Lancashire, England, UK', '1435230', 'adam-nagaitis', 'upload/images/e05YxtScfLCI723ZFU6WOzLiJ6u.jpg'),
(480, 'actor', 'Thomas Kretschmann', 'Thomas Kretschmann (born September 8, 1962) is a German actor best known for playing Leutnant Hans Von Witzland in the 1993 film Stalingrad, Hauptmann Wilm Hosenfeld in The Pianist, Hermann Fegelein in Der Untergang, and Captain Englehorn in the 2005 remake of King Kong.\n\nDescription above from the Wikipedia article Thomas Kretschmann, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -230860800, 'Dessau, Germany', '3491', 'thomas-kretschmann', 'upload/images/kBnPu1KREhckuPpnAUppm24kkVX.jpg'),
(481, 'actor', 'Fanny Ardant', 'Fanny Marguerite Judith Ardant (born 22 March 1949) is a French actress and filmmaker. She is the recipient of numerous accolades, including two César Awards and a Lumières Award.\n\nDescription above from the Wikipedia article Fanny Ardant, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -655776000, 'Saumur, Maine-et-Loire, France', '20234', 'fanny-ardant', 'upload/images/q8Hj88E3ME5z795haGMqVDwFDjp.jpg'),
(482, 'actor', 'Andrés Gertrúdix', '', 223862400, '', '51905', 'andrés-gertrúdix', 'upload/images/qR9EyorWi9Z8WnoFcY5AskYBW4B.jpg'),
(483, 'actor', 'Oscar Coleman', '', 1410739200, '', '3492820', 'oscar-coleman', 'upload/images/bx9kzUmhKjZreA3EcGFAiElnbkz.jpg'),
(484, 'actor', 'Sabela Arán', '', 0, '', '1019691', 'sabela-arán', 'upload/images/n0sA6fgGSEG7mqtyd8RcFLme4hg.jpg'),
(485, 'actor', 'Pedro Alberto Galindo', '', 0, '', '4239432', 'pedro-alberto-galindo', NULL),
(486, 'director', 'Gonzalo López-Gallego', 'Thomas Kretschmann (born September 8, 1962) is a German actor best known for playing Leutnant Hans Von Witzland in the 1993 film Stalingrad, Hauptmann Wilm Hosenfeld in The Pianist, Hermann Fegelein in Der Untergang, and Captain Englehorn in the 2005 remake of King Kong.\n\nDescription above from the Wikipedia article Thomas Kretschmann, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -230860800, 'Dessau, Germany', '3491', 'gonzalo-lópez-gallego', 'upload/images/2IeZ2WkOGxcsFt85eQ4A1iPeyc7.jpg'),
(487, 'actor', 'Daisy Ridley', 'Daisy Jazz Isobel Ridley (born 10 April 1992) is an English actress, who rose to prominence for her role as Rey in the Star Wars sequel trilogy: The Force Awakens (2015), The Last Jedi (2017), and The Rise of Skywalker (2019).\n\nShe also appeared in the mystery film Murder on the Orient Express (2017), played the title character of the romantic drama Ophelia (2018), and has done occasional voice acting, notably the live-action/animated film Peter Rabbit (2018) and video games such as 12 Minutes.\n\nDescription above from the Wikipedia article Daisy Ridley, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 702864000, 'Westminster, London, England, UK', '1315036', 'daisy-ridley', 'upload/images/iVboQmgPC3tYFjezBjrVECJRS8n.jpg'),
(488, 'actor', 'Dave Merheje', 'Dave Merheje is a Canadian stand-up comedian. He is known for his roles in Mr. D and Ramy, as well as his 2019 comedy album Good Friend Bad Grammar, which earned him the Juno Award for Comedy Album of the Year at the 2019 Juno Awards.', 0, 'Windsor, Ontario, Canada', '1976610', 'dave-merheje', 'upload/images/sAuGYTUjwQdrvECKIh48uQjCmaP.jpg'),
(489, 'actor', 'Parvesh Cheena', 'From Wikipedia, the free encyclopedia.  Parvesh Singh Cheena (born July 22, 1979 in Elk Grove, Illinois) is an American character actor. He currently plays Gupta in the NBC Universal TV series Outsourced. Cheena grew up in Naperville, Illinois, a suburb of Chicago, and went to Waubonsie Valley High School. He studied musical theatre at the Chicago College of Performing Arts. He currently resides in Los Angeles, California.  Description above from the Wikipedia article Parvesh Cheena, licensed under CC-BY-SA,full list of contributors on Wikipedia.', 301449600, 'Elk Grove, Illinois', '98392', 'parvesh-cheena', 'upload/images/8N9EwDfLezI8b3v7ELW4aTCSixV.jpg'),
(490, 'actor', 'Marcia DeBonis', '', -302227200, 'USA', '116691', 'marcia-debonis', 'upload/images/eZe5MaHdSP4YFNqKznG1eWYVBGc.jpg'),
(491, 'actor', 'Megan Stalter', 'Megan Stalter (born September 15, 1990) is an American comedian and actress. In her videos, Stalter specializes in desperate, deluded characters who are prone to theatricality, frequent mispronunciations, and botched suicide attempts. \\\"I feel like all my characters are people whose lives didn\\\'t turn out a certain way, but they\\\'re still trying to pretend like it did,\\\" Stalter has said. In 2019, she joined the cast and writing staff of the reboot of The National Lampoon Radio Hour. She is also the host of the webseries The Megan Stalter Show and the Forever Dog podcast Confronting Demons with Megan Stalter.', 653356800, 'Cleveland, Ohio, USA', '3104487', 'megan-stalter', 'upload/images/ohGvsy7IlJgKs33x3TTQIEL168v.jpg'),
(492, 'actor', 'Brittany O\\\'Grady', 'Brittany O\\\'Grady has been performing professionally since the age of 4. She has TV, commercial, print, theater, dancing, and singing experience. Recent work includes a 2014 guest star appearance on ABC-TV\\\'s Trophy Wife and Investigation Discovery\\\'s Tabloid.\n\nBrittany has been cast with several Washington area theaters including the Tony-Award winning Signature Theatre, historic Ford\\\'s Theatre, critically-acclaimed movement-based Synetic Theater, the Little Theatre of Alexandria, and Encore Stage and Studio. Brittany has also performed at the White House and the Kennedy Center.\n\nHer commercial work includes national and regional ad campaigns, PSAs, and as the face of the national Food Stamp Program. Brittany has also appeared as the spokesperson for an internet campaign, in an America\\\'s Most Wanted reenactment, and in numerous industrial projects. Brittany is an Actors Equity Candidate and is SAG eligible.', 707443200, 'Arlington, Virginia', '1695070', 'brittany-ogrady', 'upload/images/bNuz4XvSbvYw229j9gkO24qzsQm.jpg'),
(493, 'actor', 'Bree Elrod', 'Bree Elrod is an actress, known for Red Rocket (2021) and Shutter Island (2010).', 0, '  United States', '2971460', 'bree-elrod', 'upload/images/njtlCj5ZsC6gacKc24HCWZpfqhM.jpg'),
(494, 'actor', 'Lauren Beveridge', '', 0, '', '3026331', 'lauren-beveridge', NULL),
(495, 'actor', 'Ayanna Berkshire', 'Ayanna Berkshire is an American stage and screen actress, a resident artist of Artists Repertory Theatre (Portland, Oregon) and a 2020 recipient of the TCG and Fox Fellowship Foundation Resident Actor Fellowship, recognized for distinguished achievement. She is best known for her role as Cora in the first of the Twilight Saga films. Originally from a remote island chain in Washington State, Ayanna was just three years old when she began performing for audiences as a young dancer and actress. She had her first agent at 13 years old and has been working professionally since the age of 20. Ayanna splits her time between Portland, Oregon and Los Angeles, California.', 222307200, 'San Juan Islands, Washington, USA', '23897', 'ayanna-berkshire', 'upload/images/igRDVEcfojqWdyiYZOTbfQPiGax.jpg'),
(496, 'actor', 'Sean Tarjyoto', '', 353030400, '', '1209877', 'sean-tarjyoto', 'upload/images/3LsOu8dFj5LDgoGgos6BlEMsOqS.jpg'),
(497, 'actor', 'Jeb Berrier', '', 0, '', '1001968', 'jeb-berrier', 'upload/images/nMzXzir5K1rY5kYZsOBzh9B0Tdb.jpg'),
(498, 'director', 'Rachel Lambert', 'Brittany O\\\'Grady has been performing professionally since the age of 4. She has TV, commercial, print, theater, dancing, and singing experience. Recent work includes a 2014 guest star appearance on ABC-TV\\\'s Trophy Wife and Investigation Discovery\\\'s Tabloid.\n\nBrittany has been cast with several Washington area theaters including the Tony-Award winning Signature Theatre, historic Ford\\\'s Theatre, critically-acclaimed movement-based Synetic Theater, the Little Theatre of Alexandria, and Encore Stage and Studio. Brittany has also performed at the White House and the Kennedy Center.\n\nHer commercial work includes national and regional ad campaigns, PSAs, and as the face of the national Food Stamp Program. Brittany has also appeared as the spokesperson for an internet campaign, in an America\\\'s Most Wanted reenactment, and in numerous industrial projects. Brittany is an Actors Equity Candidate and is SAG eligible.', 707443200, 'Arlington, Virginia', '1695070', 'rachel-lambert', NULL),
(499, 'actor', 'Mads Mikkelsen', 'Mads Dittmann Mikkelsen (born November 22, 1965) is a Danish actor. Originally a gymnast and dancer, he rose to fame in Denmark as an actor for his roles such as Tonny in the first two films of the Pusher film trilogy (1996, 2004), Detective Sergeant Allan Fischer in the television series Rejseholdet (2000–2004), Niels in Open Hearts (2002), Svend in The Green Butchers (2003), Ivan in Adam\\\'s Apples (2005) and Jacob Petersen in After the Wedding (2006).\n\nMikkelsen achieved worldwide recognition for playing the main antagonist Le Chiffre in the twenty-first James Bond film, Casino Royale (2006). His other roles include Igor Stravinsky in Coco Chanel & Igor Stravinsky (2008), Johann Friedrich Struensee in A Royal Affair (2012), his Cannes Film Festival Best Actor Award-winning performance as Lucas in the Danish film The Hunt (2012), Dr. Hannibal Lecter in the television series Hannibal (2013–2015), Kaecilius in Marvel\\\'s Doctor Strange (2016), Galen Erso in Lucasfilm\\\'s Rogue One (2016), Cliff Unger in Hideo Kojima\\\'s video game Death Stranding (2019), his BAFTA-nominated role as Martin in Another Round (2020) and Gellert Grindelwald in Fantastic Beasts: The Secrets of Dumbledore (2022).\n\nA. O. Scott of The New York Times remarked that in the Hollywood scene, Mikkelsen has \\\"become a reliable character actor with an intriguing mug\\\" but stated that on the domestic front \\\"he is something else: a star, an axiom, a face of the resurgent Danish cinema\\\".', -129686400, 'Copenhagen, Denmark', '1019', 'mads-mikkelsen', 'upload/images/ntwPvV4GKGGHO3I7LcHMwhXfsw9.jpg'),
(500, 'actor', 'Amanda Collin', 'Amanda Collin was born on March 4, 1986 in Rungsted, Denmark. Amanda is an actress, known for A Horrible Woman (2017), Department Q: A Conspiracy of Faith (2016) and Splitting Up Together (2016). From 2015-16, Collin was part of the Mungo Park Theatre ensemble, where she played in Hans Christian Andersen\\\'s fairytales, Boys Don\\\'t Cry and Hamlet. In 2017, Collin was nominated for the Danish equivalent of the Academy Award, the Robert Award, for her supporting role of Rakel, the religious mother of two kidnapped children in the Danish box office hit Department Q: A Conspiracy of Faith directed by Hans Petter Moland.\n\nCollin played the leading role of Marie in the film A Horrible Woman, and won both the Robert Award and the Bodil Award for Best Actress in a Leading Role in 2018.\n\nIn 2019 Collin appeared in Daniel Borgman\\\'s Resin for which she was nominated for a Robert Award for Best Actress in a Supporting Role. She currently stars in Aaron Guzikowski’s sci-fi drama series Raised by Wolves from HBO Max.', 510278400, 'Denmark', '1602451', 'amanda-collin', 'upload/images/bFm5zt8vxD09Ez6irsJItmPigjq.jpg'),
(501, 'actor', 'Simon Bennebjerg', '', 623548800, 'Copenhagen, Denmark', '1616206', 'simon-bennebjerg', 'upload/images/ouJMjUBLhIlZA8GzdZSteJOdCWS.jpg'),
(502, 'actor', 'Kristine Kujath Thorp', 'Kristine Kujath Thorp is a Norwegian actress, author and set designer, born in Oslo and living in Copenhagen.', 703987200, 'Oslo, Norway', '2079854', 'kristine-kujath-thorp', 'upload/images/9a5zbunwwS6EP1ZDIzf3AdsoFnL.jpg'),
(503, 'actor', 'Gustav Lindh', 'Gustav Lindh was born on June 4, 1995 in Västerås, Sweden. He is an actor, known for Queen of Hearts (2019), Love Me (2019) and Riders of Justice (2020).', 802224000, 'Västerås, Västmanlands län, Sweden', '1428295', 'gustav-lindh', 'upload/images/nrDYmssLbWpwvGKmhMFxgaGgzBp.jpg'),
(504, 'actor', 'Jacob Ulrik Lohmann', '', 129168000, 'Copenhagen, Denmark', '1433475', 'jacob-ulrik-lohmann', 'upload/images/iOtISPGzgM7vTKfR3ZQIyYb7uWQ.jpg'),
(505, 'actor', 'Morten Hee Andersen', '', 674870400, 'Roskilde, Denmark', '1921846', 'morten-hee-andersen', 'upload/images/8UCISBZEPIFr0GpL0r4QVIOLjPN.jpg'),
(506, 'actor', 'Magnus Krepper', 'Rolf Magnus Krepper is a Swedish actor, dancer, singer and magician. He is a member of Moderna Illusionisters Cirkel. In 2006 Krepper received the Guldbagge Award for his best male role in the 2005 film Mun mot mun.', -93916800, 'Norrköping, Östergötlands län, Sweden', '143391', 'magnus-krepper', 'upload/images/xFN9sb8S2fjcUtbWvzTxoLH4QUJ.jpg'),
(507, 'actor', 'Søren Malling', '', -186537600, 'Kjellerup, Denmark', '82537', 'søren-malling', 'upload/images/5jmNDae49UgMGMOKTdjIqb8klUg.jpg'),
(508, 'actor', 'Morten Buus', 'Morten Buus was born on 8 January 1980 in Esbjerg, Denmark. He is an actor, known for Bastarden (2023).', 316137600, 'Esbjerg, Denmark', '4437405', 'morten-buus', 'upload/images/daqYqn36sL1Tq1NabFcKy6tCXs1.jpg'),
(509, 'actor', 'Morten Burian', 'Morten Burian was born on 8 September 1974 in Denmark. He is an actor, known for Speak No Evil (2022), Deadline (2022) and Loving Adults (2022).', 147830400, 'Denmark', '2361843', 'morten-burian', 'upload/images/xKOXtYYt4LqRapSzYjIuxheSLyS.jpg'),
(510, 'director', 'Nikolaj Arcel', 'Rolf Magnus Krepper is a Swedish actor, dancer, singer and magician. He is a member of Moderna Illusionisters Cirkel. In 2006 Krepper received the Guldbagge Award for his best male role in the 2005 film Mun mot mun.', -93916800, 'Norrköping, Östergötlands län, Sweden', '143391', 'nikolaj-arcel', 'upload/images/79JljyWnfjqE87UyTo7xgFQa5fy.jpg'),
(511, 'actor', 'Paul Borne', '', 0, '', '1446164', 'paul-borne', 'upload/images/vjhn44K5M5A3eSdqslscrNCtBSY.jpg'),
(512, 'actor', 'Gauthier Battoue', '', 679190400, 'Bordeaux, Gironde, France', '1309535', 'gauthier-battoue', 'upload/images/3PooWwDmyJMF5wP8LLajgWs4lwB.jpg'),
(513, 'actor', 'Philippe Bozo', '', 0, '', '1783134', 'philippe-bozo', 'upload/images/jVDra7JVGhFFTrIlNDcHvJ3T73I.jpg'),
(514, 'actor', 'Matt Rife', 'Matthew Steven Rife (born September 10, 1995) is an American comedian and actor from North Lewisburg, Ohio, best known for his self-produced comedy specials, Only Fans (2021) and Matthew Steven Rife (2023), as well as his appearance on the comedy competition series Bring the Funny.', 810691200, 'Columbus, Ohio, USA', '1946119', 'matt-rife', 'upload/images/htkMef7qxya47Fbei9t9t1k5l7O.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(515, 'actor', 'Clare Grant', 'Clare Grant is a Memphis born actress who grew up heavily involved in the local theater scene. Upon graduating from the University of Memphis for Theater Performance, she had a short modeling career overseas before she began acting professionally after booking a small but pivotal role in Walk the Line, after which, she moved to LA to pursue acting full time.\n\nWhile in Memphis, Clare met local director, Craig Brewer, who cast her in several independent films before casting her in his first studio film Black Snake Moan &amp; then later in his MTV series $5 Cover. Since then, Clare has found luck in LA, booking leading roles in the Emmy award winning Showtime series Masters of Horror as well as several other films and television shows, including voicing characters on Robot Chicken.\n\nAs a producer, Clare created &amp; starred in the short film Saber, which won two awards in the LucasFilm Star Wars Fan Film Awards. With her creative partners, Team Unicorn, she has helped to create and produce viral sensations such as G33K &amp; G4M3R Girls, A Very Zombie Holiday and Super Harmony.', 304214400, 'Memphis, Tennessee, USA', '53266', 'clare-grant', 'upload/images/uCPsHBUYuDAdOyTpDYDften00El.jpg'),
(516, 'actor', 'Elliot', '', 0, '', '4375736', 'elliot', NULL),
(517, 'actor', 'Denzel Whitaker', 'Denzel Dominique Whitaker (born June 15, 1990) is an American actor, playing key roles in the films The Great Debaters and Training Day, as well as TV shows ER, Brothers & Sisters and The War At Home. He later went on to be a featured cast member during the tenth and final season of the Nickelodeon sketch-comedy series All That. He was also in the Disney Channel Original Movie, Dadnapped. He also appeared on The Suite Life of Zack and Cody, as a player on Zack and Cody\\\'s basketball team, and in Werner Herzog\\\'s Bad Lieutenant: Port of Call New Orleans.\n\nWhitaker was born in Torrance, California, the son of Younalanda and Dale Whitaker. He was named after Denzel Washington, a fact he disputed on The Oprah Winfrey Show while promoting the movie The Great Debaters, only to learn later from his father that, in fact, Washington was his namesake.\n\n​From Wikipedia, the free encyclopedia', 645408000, 'Torrance, California, USA', '77278', 'denzel-whitaker', 'upload/images/8l5y5UDtkKJ13WQybqRXUEma7nm.jpg'),
(518, 'actor', 'Eric Roberts', 'An American actor. His career began with a well-received performance in King of the Gypsies (1978), for which he earned his first Golden Globe Award nomination. His second Golden Globe nomination came for his portrayal of Paul Snider in Star 80 (1983), followed by Globe and Academy Award nominations for his supporting role in Runaway Train (1985). In a career spanning almost forty years, Roberts has performed in over 200 films, including Raggedy Man (1981), The Pope of Greenwich Village (1984), The Specialist (1994), Cecil B. Demented (2000), National Security (2003), The Dark Knight (2008), The Expendables (2010) and Inherent Vice (2014). His equally varied television work includes three seasons with the sitcom Less than Perfect, as well as recurring roles on the NBC drama Heroes and the CBS soap opera The Young and the Restless. His sisters Julia Roberts and Lisa Roberts Gillan, and daughter Emma Roberts, also have acting careers.', -432518400, 'Biloxi, Mississippi, USA', '21315', 'eric-roberts', 'upload/images/NiWg1TaUcal7xn1ZQeyA2dLd5F.jpg'),
(519, 'actor', 'Lexy Panterra', '', 611798400, 'Santa Rosa, California, USA', '1569981', 'lexy-panterra', 'upload/images/rR3wO5n5M8uvaY6hc1YkaPsadeR.jpg'),
(520, 'actor', 'Eugenia Kuzmina', 'Eugenia Kuzmina is a Russian-American actress', 567302400, 'Moscow, Russia', '1333845', 'eugenia-kuzmina', NULL),
(521, 'actor', 'Tim Dougherty', 'Tim Dougherty is known for his work on The Santa Clause 3: The Escape Clause (2006), Rebel in the Rye (2017) and NCIS: New Orleans (2014).', 0, '', '2441694', 'tim-dougherty', 'upload/images/psVjKGwMeMeor5MwnxttPVAHnqO.jpg'),
(522, 'actor', 'Jock McKissic', '', 0, '', '1704659', 'jock-mckissic', 'upload/images/wdBhUtdo11JmSbYlWgkTxRJZDTF.jpg'),
(523, 'actor', 'Petri Hawkins-Byrd', '', -381542400, 'Brooklyn, New York, USA', '1462565', 'petri-hawkins-byrd', 'upload/images/zb4iHe3L1dhkoMLFKKj7n5TDDge.jpg'),
(524, 'actor', 'Erik Griffin', 'Erik Griffin is an American stand-up comedian, writer, and actor best known for playing Montez Walker on Comedy Central\\\'s Workaholics. He is also known for such television series and films such as Mike and Dave Need Wedding Dates, I\\\'m Dying Up Here, and Blunt Talk.', 195436800, 'Los Angeles, California, USA', '1254002', 'erik-griffin', 'upload/images/1YxirENyYn87iteQDQNiIZvkT.jpg'),
(525, 'director', 'Jack Cook', 'Denzel Dominique Whitaker (born June 15, 1990) is an American actor, playing key roles in the films The Great Debaters and Training Day, as well as TV shows ER, Brothers & Sisters and The War At Home. He later went on to be a featured cast member during the tenth and final season of the Nickelodeon sketch-comedy series All That. He was also in the Disney Channel Original Movie, Dadnapped. He also appeared on The Suite Life of Zack and Cody, as a player on Zack and Cody\\\'s basketball team, and in Werner Herzog\\\'s Bad Lieutenant: Port of Call New Orleans.\n\nWhitaker was born in Torrance, California, the son of Younalanda and Dale Whitaker. He was named after Denzel Washington, a fact he disputed on The Oprah Winfrey Show while promoting the movie The Great Debaters, only to learn later from his father that, in fact, Washington was his namesake.\n\n​From Wikipedia, the free encyclopedia', 645408000, 'Torrance, California, USA', '77278', 'jack-cook', NULL),
(526, 'actor', 'Miles Jonn-Dalton', '', 0, '', '2320919', 'miles-jonn-dalton', 'upload/images/2at4PI1oIsvqhkAHF3Y6V01wDrG.jpg'),
(527, 'actor', 'Pia Bertucci', 'Pia Bertuccis is an American actress and model.', 0, '', '2555093', 'pia-bertucci', NULL),
(528, 'actor', 'Reneé Domenz', 'Renee Domenz is an actress and producer, known for Dual Mania (2018), Diamond Dew (2014), The Judas Run (2016) and Fallen Souls (2010).', 0, '	Chicago, Illinois', '1753734', 'reneé-domenz', 'upload/images/8dlRYyW2D9dwNHFYFR0izwAe5U2.jpg'),
(529, 'actor', 'Libby Amato', '', 0, '', '1352808', 'libby-amato', NULL),
(530, 'actor', 'Marissa De Los Rios', '', 0, '', '2555094', 'marissa-de-los-rios', NULL),
(531, 'actor', 'Edyta Drobinski', '', 0, '', '2555095', 'edyta-drobinski', NULL),
(532, 'actor', 'Thomas Fournelle', '', 0, '', '2555096', 'thomas-fournelle', NULL),
(533, 'actor', 'Justin Faire', '', 0, '', '2555098', 'justin-faire', NULL),
(534, 'actor', 'Mikayla Wilder', '', 0, '', '2555100', 'mikayla-wilder', NULL),
(535, 'actor', 'Colleen DuVall', '', 0, '', '2555103', 'colleen-duvall', NULL),
(536, 'director', 'Nikolai Malden', '', 0, '', '2555098', 'nikolai-malden', NULL),
(537, 'actor', 'Dakota Johnson', 'Dakota Mayi Johnson (born October 4, 1989) is an American actress. The daughter of actors Don Johnson and Melanie Griffith, she made her film debut at age ten with a minor role in the dark comedy film Crazy in Alabama (1999) with her mother. After graduating high school, she began auditioning for roles in Los Angeles and was cast in a minor part in The Social Network (2010). Johnson had her breakthrough playing Anastasia Steele in the erotic romantic drama film series Fifty Shades (2015–2018), and received a BAFTA Rising Star Award nomination in 2016.\n\nJohnson appeared in films such as the crime drama Black Mass (2015), Luca Guadagnino\\\'s drama A Bigger Splash (2015), the romantic comedy How to Be Single (2016), the supernatural horror film Suspiria (2018), the thriller Bad Times at the El Royale (2018), the coming-of-age film The Peanut Butter Falcon (2019), Maggie Gyllenhaal\\\'s psychological drama The Lost Daughter (2021), and Cooper Raiff\\\'s Cha Cha Real Smooth (2022).\n\nShe has received various awards and nominations, including a People\\\'s Choice Award, and nominations for a BAFTA Award and two MTV Movie & TV Awards. She was also featured in Forbes 30 Under 30 list in 2016.', 623462400, 'Austin, Texas, USA', '118545', 'dakota-johnson', 'upload/images/8eJeDm5ILi5W25X2uatVRtWMDg2.jpg'),
(538, 'actor', 'Sydney Sweeney', 'Sydney Bernice Sweeney is an American actress. She gained mainstream attention in the Netflix series Everything Sucks! (2018) for her role as Emaline and has portrayed Eden in the Hulu series The Handmaid\\\'s Tale (2018) and Alice in the HBO miniseries Sharp Objects (2018). Since 2019, she has starred as Cassie Howard in the HBO teen drama series Euphoria and as Olivia Mossbacher in The White Lotus. In film, she had a role in Quentin Tarantino\\\'s 2019 comedy-drama Once Upon a Time in Hollywood, portraying Snake, a member of the Manson Family.', 874022400, 'Spokane, Washington, USA', '115440', 'sydney-sweeney', 'upload/images/yO356gXWSr6fgMw4UH1eYuhdOHI.jpg'),
(539, 'actor', 'Isabela Merced', 'Isabela Yolanda Moner (born July 10, 2001), known professionally as Isabela Merced since 2019, is an American actress and singer. She played the lead role of CJ Martin on the Nickelodeon television series 100 Things to Do Before High School (2014–2016) and voiced Kate in Nickelodeon\\\'s animated spinoff series Dora and Friends: Into the City! (2014–2017). In film, she has played Izabella in Transformers: The Last Knight (2017), Lizzy in Instant Family (2018), Isabel in Sicario: Day of the Soldado (2018), the titular character in Dora and the Lost City of Gold (2019), and Rachel Cooper in the Netflix film Sweet Girl (2021).\n\nDescription above from the Wikipedia article Isabela Merced, licensed under CC-BY-SA, full list of contributors on Wikipedia', 994723200, 'Cleveland, Ohio, USA', '1428070', 'isabela-merced', 'upload/images/wQI29qROxoyV1eIbCIx9fW0D7HW.jpg'),
(540, 'actor', 'Celeste O\\\'Connor', 'Celeste O\\\'Connor was born in Nairobi, Kenya and raised in Baltimore, MD for the majority of their life. They live in Baltimore with their mother, father, and younger brother. They attend college, studying Public Health, Islamic Studies and Pre-Medicine. Celeste began their career as an actor with their first independent film, Wetlands (2017).', 912556800, 'Nairobi, Kenya', '1972881', 'celeste-oconnor', 'upload/images/jI3pNOhj9Gr7ym9cUcv8vsI0lCF.jpg'),
(541, 'actor', 'Tahar Rahim', 'Tahar Rahim (born 4 July 1981) is a French actor. His breakthrough performance was in the 2009 French film A Prophet, for which he won the César Award for Best Actor and Most Promising Actor. He has since starred as FBI agent Ali Soufan in the miniseries The Looming Tower and Judas in the film Mary Magdalene (both 2018).\n\nRahim garnered critical acclaim and nominations for the Golden Globe Award and the BAFTA Award for Best Actor in a Leading Role for portraying Mohamedou Ould Salahi in The Mauritanian (2021). He received another Golden Globe Award nomination for portraying Charles Sobhraj in the miniseries The Serpent (2021).\n\nDescription above from the Wikipedia article Tahar Rahim, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 363052800, 'Belfort, Territoire de Belfort, France', '81051', 'tahar-rahim', 'upload/images/cM5S6jdTnurZjSLwm61rqtsliI4.jpg'),
(542, 'actor', 'Mike Epps', 'From Wikipedia, the free encyclopedia.\n\nMichael Elliot \\\"Mike\\\" Epps (born November 18, 1970) is an American stand-up comedian, actor, film producer, writer, singer, musician, and rapper, best known for playing Day-Day Jones in Next Friday and the sequel-to-the-sequel, Friday After Next, and also starring alongside Ice Cube in All About The Benjamins. He is known as the new voice of Boog in Open Season 2 and Open Season 3.\n\nAs of 2010, Epps was the executive producer on a documentary about the life story of a former member of Tupac Shakur\\\'s Outlawz, Napoleon: Life Of An Outlaw.\n\nDescription above from the Wikipedia article Mike Epps, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 27734400, 'Indianapolis, Indiana, USA', '51944', 'mike-epps', 'upload/images/kDI4E3ALm2rVkF38GwhWwXmDq0a.jpg'),
(543, 'actor', 'Emma Roberts', 'Emma Rose Roberts (born February 10, 1991) is an American actress and singer. She is the daughter of actor Eric Roberts and niece of actress Julia Roberts. After making her acting debut in the crime film Blow (2001), she gained recognition for her lead role as Addie Singer on the Nickelodeon television teen sitcom Unfabulous (2004–2007). For the series, she released her debut soundtrack album, Unfabulous and More, in 2005. She went on to appear in numerous films, including Aquamarine (2006), Nancy Drew (2007), Wild Child (2008), Hotel for Dogs (2009), Valentine\\\'s Day (2010), It\\\'s Kind of a Funny Story (2010), and The Art of Getting By (2011).\n\nLooking for more mature roles, she obtained starring roles in the films Lymelife (2008), 4.3.2.1. (2010), Scream 4 (2011), Adult World (2013), We\\\'re the Millers (2013), Palo Alto (2013), The Blackcoat\\\'s Daughter (2015), Nerve (2016), Who We Are Now (2017), Paradise Hills (2019), and Holidate (2020). She gained further recognition for her starring roles in multiple seasons of the FX anthology horror series American Horror Story (2013–present) and for the lead role of Chanel Oberlin on the FOX series Scream Queens (2015–2016).', 666144000, 'Rhinebeck, New York, USA', '34847', 'emma-roberts', 'upload/images/87w6fTvmJTQScgKKJFS91hYJ33a.jpg'),
(544, 'actor', 'Adam Scott', 'Adam Scott (born April 3, 1973) is an American actor, producer, screenwriter, director and podcaster. He is best known for his roles as Ben Wyatt in the NBC comedy Parks and Recreation, Henry Pollard in the Starz comedy series Party Down, Palek in the HBO drama Tell Me You Love Me and Derek Huff in the 2008 film Step Brothers. He has appeared in the Adult Swim comedy Childrens Hospital. He was also on the show NTSF:SD:SUV::, and the annual Adult Swim special The Greatest Event in Television History, which he also created and produced. Scott is the co-host and co-creator of the Earwolf podcast U Talkin\\\' U2 To Me? with Scott Aukerman.', 102643200, 'Santa Cruz, California, USA', '36801', 'adam-scott', 'upload/images/b82C29R6fGiPoqIglQ4lzS6q2YX.jpg'),
(545, 'actor', 'Zosia Mamet', 'Zosia Russell Mamet (born February 2, 1988) is an American actress and musician who has appeared in television series including Mad Men, United States of Tara and Parenthood, and played the character Shoshanna Shapiro on the HBO original series Girls. She currently stars as Annie Mouradian in the HBO Max original series The Flight Attendant.', 570758400, 'Randolph, Vermont, USA', '206966', 'zosia-mamet', 'upload/images/8G4n5CMVhzKfYworKrc9Pd2QjHm.jpg'),
(546, 'actor', 'Miguel Ángel Muñoz', '', 426124800, '  Madrid, Spain', '125852', 'miguel-ángel-muñoz', 'upload/images/k4W5AyG3KIh33wpDViGv61YrSDL.jpg'),
(547, 'actor', 'Marielle Jaffe', 'Jaclyn Marielle Jaffe is an American actress, singer and model best known for playing Olivia Morris in Wes Craven\\\'s Scream 4. Shes also had roles in other movies and tv shows including Percy Jackson, 10 things I hate about you, scrubs and The Secret Life of the American Teenager. Shes been married to music video director TK McKamy since 2016, they have two children together.', 614563200, 'Michigan, USA', '127127', 'marielle-jaffe', 'upload/images/x0goDf3BXDDrs3almv75PdDb20E.jpg'),
(548, 'actor', 'Sharon Stone', 'Sharon Vonne Stone (born March 10, 1958) is an American actress, producer, and former fashion model. She is the recipient of a Primetime Emmy Award and a Golden Globe Award, as well as having received nominations for an Academy Award and two Screen Actors Guild Awards.\n\nAfter modelling in television commercials and print advertisements, she made her film debut as an extra in Woody Allen\\\'s comedy-drama Stardust Memories (1980). Her first speaking part was in Wes Craven\\\'s horror film Deadly Blessing (1981), and throughout the 1980s, Stone went on to appear in films such as Irreconcilable Differences (1984), King Solomon\\\'s Mines (1985), Cold Steel (1987), Action Jackson (1988), and Above the Law (1988). She found mainstream prominence with her part in Paul Verhoeven\\\'s science fiction action film Total Recall (1990).\n\nStone became a sex symbol and rose to international recognition when she starred as Catherine Tramell in another Verhoeven film, the erotic thriller Basic Instinct (1992), for which she earned her first Golden Globe Award nomination for Best Actress in a Motion Picture – Drama. She received further critical acclaim with her performance in Martin Scorsese\\\'s epic crime drama Casino (1995), garnering the Golden Globe Award and an Academy Award nomination for Best Actress.\n\nStone received two more Golden Globe Award nominations for her roles in The Mighty (1998) and The Muse (1999). Her other notable film roles include Sliver (1993), The Specialist (1994), The Quick and the Dead (1995), Last Dance (1996), Sphere (1998), Catwoman (2004), Broken Flowers (2005), Alpha Dog (2006), Basic Instinct 2 (2006), Bobby (2006), Lovelace (2013), Fading Gigolo (2013), and The Disaster Artist (2017). In 1995, she received a star on the Hollywood Walk of Fame, and in 2005, she was named Officer of the Order of Arts and Letters in France.\n\nOn television, Stone has had notable performances in the miniseries War and Remembrance (1987) and the HBO television film If These Walls Could Talk 2 (2000). She made guest appearances in The Practice (2004), winning the Primetime Emmy Award for Outstanding Guest Actress in a Drama Series, and in Law & Order: Special Victims Unit (2010). Stone has also appeared in the series Agent X (2015), Mosaic (2017), and The New Pope (2019).\n\nDescription above from the Wikipedia article Sharon Stone, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -372816000, 'Meadville, Pennsylvania, USA', '4430', 'sharon-stone', 'upload/images/5lYs0HaAvsXPZJpMcndbSeQdPgT.jpg'),
(549, 'actor', 'Andy García', 'Andy García (born Andrés Arturo García Menéndez, April 12, 1956) is a Cuban-American actor. He\\\'s best known for his roles as Vincent Mancini in The Godfather III, George Stone in The Untouchables, Dr. Ramirez in Stand and Deliver, Raymond Avila in Internal Affairs, Michael Green in When a Man Loves a Woman, Frank Conner in Desperate Measures, Terry Benedict in the Ocean\\\'s Trilogy, Andre Allen on HBO\\\'s Ballers, Captain Norris in Passengers (2016), President Andrew Palma in Geostorm, Mitchel in Book Club 1 & 2, Ricardo Montalban in My Dinner with Hervé, Father Patrick in Words on Bathroom Walls, Billy Herrera in remake of Father of the Brida (2022), and Marsh in Expend4bles.\n\nHe first rose to prominence acting in Brian De Palma\\\'s The Untouchables (1987) alongside Kevin Costner, Sean Connery, and Robert De Niro. He continued to act in films such as Stand and Deliver (1988), and Internal Affairs (1990). He then costarred in Francis Ford Coppola\\\'s The Godfather Part III (1990) as Vincent Mancini, for which he received an Academy Award nomination for Best Supporting Actor.\n\nIn 2000, he produced and acted in the HBO television film, For Love or Country: The Arturo Sandoval Story (2000), where he received a Primetime Emmy Award and a Golden Globe Award nominations. In 2005, he won a Latin Grammy for Best Traditional Tropical Latin Album for producing Cuban musician Cachao\\\'s record Ahora sí.', -433036800, 'Havana, Cuba', '1271', 'andy-garcía', 'upload/images/aRooE4lECWf0YXd2NefeM4Wu4rn.jpg'),
(550, 'actor', 'Jose Coronado', 'Jose Coronado is a Spanish film and television actor. He won several awards for his performance as the lead actor in the 2011 film “No habrá paz para los malvados,” including a Goya, a Sant Jordi, and a Fotogramas de Plata.', -390787200, '  Madrid, Spain', '110129', 'jose-coronado', 'upload/images/9xo68HzH8n78Xv6gMzKK7XnjtHd.jpg'),
(551, 'actor', 'Iain Glen', 'Iain Alan Sutherland Glen (born 24 June 1961) is a Scottish actor. Glen is best known for his roles as Dr. Alexander Isaacs/Tyrant in three films of the Resident Evil film series (2004–2016) and as Ser Jorah Mormont in the HBO fantasy television series Game of Thrones (2011–2019). Other notable roles include John Hanning Speke in Mountains of the Moon (1990), Larry Winters in Silent Scream (1990) for which he won the Silver Bear for Best Actor from the Berlin International Film Festival, Manfred Powell in Lara Croft: Tomb Raider (2001), Brother John in Song for a Raggy Boy (2003), the title role in Jack Taylor (2010–2016), Sir Richard Carlisle in Downton Abbey (2011), James Willett in Eye in the Sky (2015), and Bruce Wayne in Titans (2019–present).', -268963200, 'Edinburgh, Scotland, UK', '20508', 'iain-glen', 'upload/images/n9zXQhjtXQnc30kqF66hdX4i3PG.jpg'),
(552, 'actor', 'Rosabell Laurenti Sellers', 'Rosabell Laurenti Sellers (born March 27, 1996) is an Italian-American actress. She is best known for her role as Tyene Sand in the HBO series Game of Thrones.', 827884800, 'Santa Monica, California, USA', '992808', 'rosabell-laurenti-sellers', 'upload/images/54jpEVJpRi74YR019n3XytOF4lb.jpg'),
(553, 'actor', 'Caroline Morahan', '', 0, '', '1534647', 'caroline-morahan', 'upload/images/wv2JmACidY4UApeizm9g3p0j7ov.jpg'),
(554, 'actor', 'Maia Morgenstern', 'A Romanian film and stage actress,  described by Florin Mitu of AMOS News as \\\"a symbol of Romanian theater and film\\\".  In the English-speaking world, she is probably best known for the role of Mary, the mother of Jesus, in Mel Gibson\\\'s The Passion of the Christ. In Romania, she has been nationally known since her 1992 role as Nela in Balanţa, a film known in the United States as The Oak, set during the waning days of Communist Romania.\n\nDescription above from the Wikipedia article Maia Morgenstern, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -242092800, 'Bucharest, Romania', '8768', 'maia-morgenstern', 'upload/images/zmqKMZcT5z0QKwTTmmb9O0rekbt.jpg'),
(555, 'actor', 'Corneliu Ulici', '', 417571200, 'Baia-Mare, Romania', '1611680', 'corneliu-ulici', 'upload/images/1hsexCWwQZIk9eyQLiv9H50i3Z1.jpg'),
(556, 'actor', 'Kamaliya', 'Kamaliya Zahoor, born Nataliya Shmarenkova on 18 May 1977, known professionally as simply Kamaliya, is a Ukrainian singer, actress, television personality, model, former Mrs. World beauty pageant titleholder, and philanthropist.[1][2][3] She has become widely known in the United Kingdom through her participation in the British reality television program Meet the Russians.', 232761600, 'Zabaykalsky Krai, Russia', '583454', 'kamaliya', 'upload/images/gUoDyqr0rRYpd7CmfESlrQTUucL.jpg'),
(557, 'director', 'Klaus Menzel', 'Jaclyn Marielle Jaffe is an American actress, singer and model best known for playing Olivia Morris in Wes Craven\\\'s Scream 4. Shes also had roles in other movies and tv shows including Percy Jackson, 10 things I hate about you, scrubs and The Secret Life of the American Teenager. Shes been married to music video director TK McKamy since 2016, they have two children together.', 614563200, 'Michigan, USA', '127127', 'klaus-menzel', 'upload/images/5sRDOEYHvbjG9eHctJN3i6QAG6O.jpg'),
(558, 'actor', 'Millie Bobby Brown', 'Millie Bobby Brown (born 19 February, 2004) is a British actress and producer. She gained recognition for playing Eleven in the Netflix science fiction series Stranger Things (2016–present), for which she received nominations for two Primetime Emmy Awards. Brown has starred in the adventure film Godzilla: King of the Monsters (2019) and its sequel Godzilla vs. Kong (2021). She also starred in and produced the Netflix mystery film Enola Holmes (2020) and its 2022 sequel.\n\nIn 2018, Brown was featured in the Time 100 list of the world\\\'s most influential people, and was appointed as a UNICEF Goodwill Ambassador, the then youngest person selected for this position.', 1077148800, 'Marbella, Málaga, Andalusia, Spain', '1356210', 'millie-bobby-brown', 'upload/images/8RZ62btK5YM3HU1CM7Y6fzumTRX.jpg'),
(559, 'actor', 'Finn Wolfhard', 'Finn Wolfhard (born December 23, 2002) is a Canadian actor and musician. He gained recognition for playing Mike Wheeler in the Netflix series Stranger Things (2016–present). His film roles include Richie Tozier in the film adaptation of Stephen King\\\'s horror novel It (2017) and its sequel It: Chapter Two (2019), Boris Pavlikovsky in the drama film The Goldfinch (2019), the voice of Pugsley Addams in The Addams Family (2019), and Trevor in the supernatural film Ghostbusters: Afterlife (2021). Wolfhard made his directorial debut with the comedy short film Night Shifts (2020).', 1040601600, 'Vancouver, British Columbia, Canada', '1442069', 'finn-wolfhard', 'upload/images/9uoEc9p5fPMSjZgW5hMxPK6L2eX.jpg'),
(560, 'actor', 'Gaten Matarazzo', 'Gaetano John \\\"Gaten\\\" Matarazzo III (born September 8, 2002) is an American actor. He began his career on the Broadway stage as Benjamin in Priscilla, Queen of the Desert and as Gavroche in Les Misérables. He stars as Dustin Henderson in the Netflix science-fiction-horror drama series Stranger Things, and hosts the short lived Netflix show Prank Encounters.', 1031443200, 'Little Egg Harbor Township, New Jersey, USA', '1653291', 'gaten-matarazzo', 'upload/images/yanRypHyaFRgTn31fwq8xzcfSHg.jpg'),
(561, 'actor', 'Caleb McLaughlin', 'Caleb Reginald McLaughlin (born October 13, 2001) is an American actor and singer. He is known for playing Lucas Sinclair in the Netflix series Stranger Things. McLaughlin began his career when he appeared in an opera called Lost in the Stars in Cooperstown, New York at the Glimmerglass Opera House. He then played on the Broadway stage as Young Simba in the musical The Lion King. In 2017, McLaughlin appeared in the BET miniseries The New Edition Story as young Ricky Bell.', 1002931200, 'Carmel, New York, USA', '1474123', 'caleb-mclaughlin', 'upload/images/xKXJtSOcgGmzSXExU6kz2FXAysC.jpg'),
(562, 'actor', 'David Harbour', 'David Kenneth Harbour (born April 10, 1975) is an American actor. He gained recognition for his portrayal of Jim Hopper in the Netflix science fiction drama series Stranger Things (2016–present), for which he earned a Critics\\\' Choice Television Award in 2018. For the role, he also received Primetime Emmy Award and Golden Globe Award nominations.\n\nHarbour had supporting roles in films such as Brokeback Mountain (2005), Quantum of Solace (2008), The Green Hornet (2011), End of Watch (2012), The Equalizer (2014), Black Mass (2015), Suicide Squad (2016) and Black Widow (2021). He portrayed the title character in the superhero film Hellboy (2019).', 166320000, 'New York City, New York, USA', '35029', 'david-harbour', 'upload/images/chPekukMF5SNnW6b22NbYPqAStr.jpg'),
(563, 'actor', 'Winona Ryder', 'Winona Laura Horowitz (born October 29, 1971), known professionally as Winona Ryder, is an American actress. She is the recipient of several awards, including a Golden Globe Award, and has been nominated for two Academy Awards. She is known for taking on quirky roles in her earlier films, later playing more prominent roles in the 1990s.\n\nAfter Ryder\\\'s film debut in Lucas (1986), she gained attention with her performance in Tim Burton\\\'s Beetlejuice (1988). She further rose to prominence with major roles in Heathers (1989), Mermaids (1990), Edward Scissorhands (1990), and Bram Stoker\\\'s Dracula (1992). She garnered critical acclaim and two consecutive Academy Award nominations for her portrayals of socialite May Welland in Martin Scorsese\\\'s The Age of Innocence (1993) and Jo March in the fifth film adaptation of Little Women (1994). Her other films during this period were Reality Bites (1994), How to Make an American Quilt (1995), The Crucible (1996), Alien Resurrection (1997), Celebrity (1998), and Girl, Interrupted (1999), which she also executive-produced.\n\nIn 2002, Ryder starred in the critically panned box office hit Mr. Deeds, after which her career declined and she took a break from films. In 2009, she returned in the high-profile film Star Trek. In 2010, she was nominated for two Screen Actors Guild Awards: as the lead actress in the television film When Love Is Not Enough: The Lois Wilson Story and as part of the cast of Black Swan. She also reunited with Burton for Frankenweenie (2012). She has starred as Joyce Byers in the Netflix science fiction horror series Stranger Things (2016–present), for which she has received Golden Globe and Screen Actors Guild nominations; and in 2020, she starred in the HBO drama miniseries The Plot Against America.\n\nHer relationship with Johnny Depp in the early 1990s and a 2001 arrest for shoplifting were both subjects of tabloid journalism. She has been open about her personal struggles with anxiety and depression. In 2000, Ryder received a star on the Hollywood Walk of Fame.', 57542400, 'Winona, Minnesota, USA', '1920', 'winona-ryder', 'upload/images/fkMfW3rDBmpPccT6uLmAMxVjEra.jpg'),
(564, 'actor', 'Natalia Dyer', 'Natalia Dyer was born on January 13, 1995 in Nashville, Tennessee. She is an American actress known primarily for her role as Nancy Wheeler in the Netflix science fiction drama series Stranger Things.\n\nHer career began around the age of twelve in 2009, in the family comedic drama Hannah Montana: The Movie (2009) starring Miley Cyrus. It was not until her late teens, did she land her breakthrough role on Netflix\\\'s horror drama series Stranger Things (2016). On January 29, 2017 at the 23rd Screen Actors Guild Awards show, Dyer and the cast of \\\"Stranger Things\\\" became co-winners for \\\"Outstanding Performance by an Ensemble in a Drama Series\\\". Fans can see her upcoming features including After Darkness (2017) and Mountain Rest (2018).', 789955200, 'Nashville, Tennessee, USA', '1039011', 'natalia-dyer', 'upload/images/tzC5fcHLbKsT5we8rn5Az0eulEk.jpg'),
(565, 'actor', 'Charlie Heaton', 'Charlie Ross Heaton (born 6 February 1994) is an English actor. He first gained recognition for starring as Jonathan Byers in the Netflix science fiction horror series Stranger Things (2016–present). Beginning his career as a musician, Heaton appeared on British television before starring in Stranger Things and feature films like the 2016 indie thriller Shut In; he has since starred in the thriller films Marrowbone (2017) and The New Mutants (2020), among others.', 760492800, 'Bridlington, East Riding of Yorkshire, England, UK', '1448222', 'charlie-heaton', 'upload/images/8Se6WZuvRmoB990bT29OPgVAyBo.jpg'),
(566, 'actor', 'Joe Keery', 'Joseph David Keery (born April 24, 1992) is an American actor and musician. He is best known for his role as Steve Harrington in the American science-fiction horror TV series, Stranger Things.', 704073600, 'Newburyport, Massachusetts, USA', '1467219', 'joe-keery', 'upload/images/ayIAVLMfZGEGIFwAo3pPnY7p59.jpg'),
(567, 'actor', 'Noah Schnapp', 'Noah Cameron Schnapp (born October 3, 2004) is an American actor. He gained recognition for playing Will Byers in the Netflix science fiction horror series Stranger Things. His film roles include Roger Donovan in Steven Spielberg\\\'s historical drama Bridge of Spies (2015) and the voice of Charlie Brown in the animated The Peanuts Movie (2015).\n\nDescription above from the Wikipedia article Noah Schnapp, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 1096761600, 'New York City, New York, USA', '1393177', 'noah-schnapp', 'upload/images/3GSWWrqQjio6G8L42ugGBGNks37.jpg'),
(568, 'actor', 'Cara Buono', 'Cara Buono (born March 1, 1971) is an American actress, screenwriter and director best known for her roles as Dr. Faye Miller in the fourth season of the AMC drama series Mad Men, Kelli Moltisanti in the sixth season of The Sopranos, Linda Salvo in the 2006 comedy Artie Lange\\\'s Beer League, and Karen Wheeler in the 2016 horror sci-fi Netflix original series Stranger Things. She has appeared in such films as Hulk (2003) and Let Me In (2010).\n\nDescription above from the Wikipedia article Cara Buono, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 36633600, 'The Bronx, New York, USA', '20047', 'cara-buono', 'upload/images/8nK8PSGTfDr3GtqdgUcWwbSlyJX.jpg'),
(569, 'actor', 'Sadie Sink', 'Sadie Elizabeth Sink (born April 16, 2002) is an American actress. She began acting at age seven in local theater productions, and played the title role in Annie (2012–14) and young Queen Elizabeth II in The Audience (2015) on Broadway. Sink made her television debut in a 2013 episode of The Americans and her film debut in the sports drama film Chuck (2016).\n\nShe had her breakthrough portraying Max Mayfield in the science fiction drama series Stranger Things (2017–present). In 2021, she played Ziggy Berman in the horror film trilogy Fear Street and the lead role in Taylor Swift\\\'s romantic drama All Too Well: The Short Film. She portrayed Ellie in Darren Aronofsky\\\'s psychological drama film The Whale (2022).', 1018915200, 'Brenham, Texas, USA', '1590797', 'sadie-sink', 'upload/images/tEHNLdwPmxu3Ikkvq8I6FUfGdZL.jpg'),
(570, 'actor', 'Priah Ferguson', '', 1159660800, 'Atlanta, Georgia, USA', '2029806', 'priah-ferguson', 'upload/images/wkVKPGdtqNQxr7zlKPpBFY63Rbv.jpg'),
(571, 'actor', 'Matthew Modine', 'Matthew Avery Modine (born March 22, 1959) is an award-winning American actor. His film roles include Private Joker in Stanley Kubrick\\\'s Full Metal Jacket, the title character in Alan Parker\\\'s Birdy, high school wrestler Louden Swain in Vision Quest, ex-CIA/football star turned chimpanzee trainer Alec McCall in Funky Monkey, and the oversexed Sullivan Groff in Weeds.', -340243200, 'Loma Linda, California, USA', '8654', 'matthew-modine', 'upload/images/z974QEHL12qUvLyk6hlWGAmDgom.jpg'),
(572, 'actor', 'Paul Reiser', 'From Wikipedia, the free encyclopedia\n\nPaul Reiser (born March 30, 1956) is an American actor, comedian, television writer, and musician. He is known for his roles as Michael Taylor in the 1980s sitcom My Two Dads, Paul Buchman in the NBC sitcom Mad About You, Modell in the 1982 film Diner, Carter Burke in the 1986 film Aliens, as Detective Jeffrey Friedman in Beverly Hills Cop (1984) and Beverly Hills Cop II (1987). More recently, Reiser is recognized as Jim Neiman in the 2014 film Whiplash and Doug Getty in the Amazon Video series Red Oaks.\n\nDescription above from the Wikipedia article Paul Reiser, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -402624000, 'New York City, New York, USA', '781', 'paul-reiser', 'upload/images/rGryzG00uSk8LsidacSBXVgo3iv.jpg'),
(573, 'actor', 'Dacre Montgomery', 'Dacre Montgomery (born 22 November 1994) is an Australian actor. He is best known his role as Jason Lee Scott in Power Rangers and Billy Hargrove in Stranger Things. Montgomery was born in Perth, Western Australia.  Description above from the Wikipedia article Dacre Montgomery, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 785462400, 'Perth, Western Australia, Australia', '1525047', 'dacre-montgomery', 'upload/images/38jnyqD2HCQVs4zNHktxA2Ko8KN.jpg'),
(574, 'actor', 'Joe Chrest', 'Joseph Chrest is an American academic and actor. He has had roles in numerous films and television shows including 21 Jump Street, 22 Jump Street, Oldboy, Lee Daniels\\\' The Butler, The Perfect Date, and as Ted Wheeler in Stranger Things.', -208396800, 'St. Albans, West Virginia, USA', '141762', 'joe-chrest', 'upload/images/7mcsJGnqRoVPTtxAUZEKt2dZnlw.jpg'),
(575, 'actor', 'Maya Hawke', 'Maya Ray Thurman Hawke (born July 8, 1998) is an American actress, model, and singer-songwriter. After beginning her career in modeling, Hawke made her screen debut as Jo March in the 2017 BBC adaptation of Little Women. She portrays Robin Buckley in the Netflix science fiction series Stranger Things (2019–present), and Eleanor Levetan in Do Revenge (2022). She has played supporting roles in the films Once Upon a Time in Hollywood (2019), Human Capital, Mainstream (2020), and Fear Street Part One: 1994 (2021).', 899856000, 'New York City, New York, USA', '1903874', 'maya-hawke', 'upload/images/abroQsos8bGN0ATm8j05z2THoOw.jpg'),
(576, 'actor', 'Brett Gelman', 'Brett Clifford Gelman is an American actor and comedian. He was born on October 6, 1976, in Highland Park, Illinois. He is best known for his roles as Murray Bauman in the Netflix series Stranger Things and Martin on the BBC series Fleabag.\n\nGelman began his career as a comedian in the early 2000s. He performed in numerous comedy clubs and improv theaters in New York City. In 2009, he was a writer and performer on the sketch comedy series Eagleheart. He also had a recurring role on the comedy series Another Period.\n\nIn 2016, Gelman was cast as Murray Bauman in the third season of Stranger Things. His character is a conspiracy theorist who helps the main characters investigate the supernatural events in Hawkins, Indiana. Gelman has since appeared in all four seasons of the show.\n\nIn 2016, Gelman also starred in the BBC series Fleabag. He played Martin, the boyfriend of the show\\\'s main character, Fleabag. Gelman\\\'s performance was critically acclaimed, and he was nominated for a Primetime Emmy Award for Outstanding Supporting Actor in a Comedy Series.\n\nGelman has also appeared in numerous films, including The Other Guys (2010), 30 Minutes or Less (2011), and A Very Harold & Kumar 3D Christmas (2011). He has also had recurring roles on the television shows Go On, Married, and Camping.', 213408000, 'Highland Park, Illinois, USA', '224197', 'brett-gelman', 'upload/images/ub2IuMWFNQGYghHTPq0lpmn2Ue0.jpg'),
(577, 'actor', 'Rob Morgan', 'Rob Morgan is an American actor known for his role as Turk Barrett in the Netflix series Daredevil, Jessica Jones, Luke Cage, Iron Fist, The Defenders, and The Punisher, and Hap Jackson in Mudbound. He is the only actor to appear in all six of Marvel\\\'s Netflix television series.', 99360000, 'USA', '1281250', 'rob-morgan', 'upload/images/ps6wR3JZnk6MY9tbtOLORgadqs6.jpg'),
(578, 'actor', 'John Reynolds', 'John Paul Reynolds is an American actor and writer. As an actor he is most well known for his roles in the television shows Search Party and Stranger Things.', 681350400, 'Madison, Wisconsin, USA', '1674830', 'john-reynolds', 'upload/images/1yzDTZqIeFQaI4i8eGC0TB1UfZg.jpg'),
(579, 'director', 'Matt Duffer', 'Matt Duffer and his twin brother Ross Duffer (born 1984), known professionally as the Duffer Brothers,  are American twin brothers who write and direct science fiction and  horror shows for film and television. They are best known for the 2015  horror Hidden and the 2016 Netflix science fiction horror series Stranger Things. They have also written episodes for Wayward Pines.', 445651200, 'Durham, North Carolina, USA', '1179419', 'matt-duffer', 'upload/images/kXO5CnSxC0znMAICGxnPeuGP73U.jpg'),
(580, 'director', 'Ross Duffer', 'Ross Duffer and his twin brother Matt Duffer (born 1984), known professionally as the Duffer Brothers,  are American twin brothers who write and direct science fiction and  horror shows for film and television. They are best known for the 2015  horror Hidden and the 2016 Netflix science fiction horror series Stranger Things. They have also written episodes for Wayward Pines.', 445651200, 'Durham, North Carolina, USA', '1179422', 'ross-duffer', 'upload/images/kN1HdFViQkcJOQlNcvvFJIx9Uju.jpg'),
(581, 'director', 'Shawn Levy', 'Shawn Adam Levy (born July 23, 1968) is a Canadian-American director, producer and actor who directed the comedy films Big Fat Liar, Just Married, Cheaper by the Dozen, The Pink Panther, Night at the Museum, and Date Night. He has also directed many television shows, including Cousin Skeeter, The Famous Jett Jackson and Pepper Dennis.', -45532800, 'Montreal, Quebec, Canada', '17825', 'shawn-levy', 'upload/images/b1ulkCHz8biG87LjLQQiMCebEZo.jpg'),
(582, 'director', 'Nimród Antal', 'Nimród E. Antal is a Hungarian American film director, screenwriter and actor.', 123465600, 'Los Angeles, California, USA', '41671', 'nimród-antal', 'upload/images/x0fSNFKlhcAbbuvFPHPuTSUvOBY.jpg'),
(583, 'director', 'Andrew Stanton', 'Andrew Stanton (born December 3, 1965) is an American film director, screenwriter, producer, and occasional voice actor based at Pixar Animation Studios. His film work includes writing and directing Finding Nemo and WALL-E; both films earned him the Academy Award for Best Animated Feature.\n\nDescription above from the Wikipedia article Andrew Stanton, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -128736000, 'Boston, Massachusetts, USA', '7', 'andrew-stanton', 'upload/images/tRwWuo06aN9vuXAPaswMN42x2ii.jpg'),
(584, 'director', 'Uta Briesewitz', 'Uta Briesewitz is a German film and television director and cinematographer.', -73699200, 'Leverkusen, Germany', '51853', 'uta-briesewitz', 'upload/images/4sIx2ojAeGjGB4FzxhbAL15DeFy.jpg'),
(585, 'director', 'Rebecca Thomas', '', 471484800, 'Las Vegas, Nevada, USA', '936974', 'rebecca-thomas', 'upload/images/oBEuF3C430rN277VbP64csrwRwC.jpg'),
(586, 'actor', 'Claire Foy', 'Claire Elizabeth Foy is an English actress. She studied acting at the Liverpool John Moores University and the Oxford School of Drama, and made her screen debut in the pilot of the supernatural comedy series Being Human, in 2008. Following her professional stage debut at the Royal National Theatre, she played the title role in the BBC One miniseries Little Dorrit (2008) and made her film debut in the American historical fantasy drama Season of the Witch (2011). Following leading roles in the television series The Promise (2011) and Crossbones (2014), Foy received praise for portraying the ill-fated queen Anne Boleyn in the miniseries Wolf Hall (2015).\n\nFoy was educated at Aylesbury High School from the age of 12 and later attended Liverpool John Moores University, studying drama and screen studies. She also trained in a one-year course at the Oxford School of Drama. She graduated in 2007 and moved to London\\\'s Peckham district to share a house with five friends from drama school. While at the Oxford School of Drama, Foy appeared in the plays Top Girls, Watership Down, Easy Virtue, and Touched. After appearing on television, she made her professional stage debut in DNA and The Miracle, two of a trio of single acts directed by Paul Miller at the Royal National Theatre in London (the third was Baby Girl).\n\nFoy gained international recognition for portraying the young Queen Elizabeth II in the first two seasons of the Netflix series The Crown, for which she won a Golden Globe and a Primetime Emmy, among other awards. In 2018, she starred in Steven Soderbergh\\\'s psychological thriller Unsane and portrayed Janet Shearon, wife of astronaut Neil Armstrong, in Damien Chazelle\\\'s biopic First Man. For the latter role, she was nominated for a BAFTA and a Golden Globe.\n\nDescription above from the Wikipedia Claire Foy licensed under CC-BY-SA, full list of contributors on Wikipedia.', 450921600, 'Stockport, Greater Manchester, England, UK', '120932', 'claire-foy', 'upload/images/EiH5rbYpRzhhejGESTZQeT7uYC.jpg'),
(587, 'actor', 'Olivia Colman', 'Sarah Caroline Sinclair CBE (January 30, 1974), known professionally as Olivia Colman, is an English actress. Known for her comedic and dramatic roles in film and television, she has received various accolades, including an Academy Award, a British Academy Film Award, two Emmy Awards, three British Academy Television Awards and three Golden Globe Awards.\n\nShe was acclaimed for her performance in the ITV crime-drama series Broadchurch (2013–2017), for which she received a British Academy Television Award for Best Actress. She played Queen Elizabeth II from 2019 to 2020 in the Netflix period-drama series The Crown, for which she received a Golden Globe Award and a Primetime Emmy Award for Outstanding Lead Actress in a Drama Series.\n\nFor her portrayal of Anne, Queen of Great Britain in the period black-comedy film The Favourite (2018), Colman received the Academy Award for Best Actress. She received additional Academy Award nominations for her performances in The Father (2020) and The Lost Daughter (2021). Other notable film and television credits include Hot Fuzz (2007), Tyrannosaur (2011), The Iron Lady (2011), Hyde Park on Hudson (2012), Locke (2013), The Lobster (2015), Fleabag (2016-2019), Murder on the Orient Express (2017), The Mitchells vs. the Machines (2021), Landscapers (2021), Empire of Light (2022), Puss in Boots: The Last Wish (2022), Secret Invasion (2023), Wonka (2023), Wicked Little Letters (2023) and Paddington in Peru (2024).', 128736000, 'Norwich, Norfolk, England, UK', '39187', 'olivia-colman', 'upload/images/4ZwZ66zXZyX26Kf2wfeMt1tQZQf.jpg'),
(588, 'actor', 'Imelda Staunton', 'Imelda Mary Philomena Bernadette Staunton (born 9 January 1956) is an English actress and singer. After training at the Royal Academy of Dramatic Art, Staunton began her career in repertory theatre in 1976 and appeared in various theatre productions in the United Kingdom.\n\nStaunton has performed in a variety of plays and musicals in London throughout her career, winning four Laurence Olivier Awards; three for Best Actress in a Leading Role in a Musical for her roles in the musicals Into the Woods, Sweeney Todd, and Gypsy, and one for Best Performance in a Supporting Role in a Play for her work in both A Chorus of Disapproval and The Corn is Green. Her other stage appearances include The Beggar\\\'s Opera, The Wizard of Oz, Uncle Vanya, Guys and Dolls, Entertaining Mr Sloane, and Good People. She has been nominated for 13 Olivier Awards.\n\nOn film, Staunton starred in Antonia and Jane; in several supporting roles in Kenneth Branagh\\\'s comedy Peter\\\'s Friends, his adaptation of Much Ado About Nothing; Ang Lee\\\'s adaptation of Sense and Sensibility; and the costume romantic comedy Shakespeare in Love. She drew critical acclaim for her performance in the title role in Mike Leigh\\\'s Vera Drake, for which she won the BAFTA Award for Best Actress in a Leading Role and the Venice Film Festival Volpi Cup for Best Actress, in addition to being nominated for Best Actress by the Academy Awards, the Golden Globe Awards and the Screen Actors Guild Awards. She later gained a wider audience for her portrayal as Dolores Umbridge in the Harry Potter films The Order of the Phoenix and The Deathly Hallows - Part 1. She continued supporting roles in Nanny McPhee, reunited with Leigh in Another Year, and the film continuation of Downton Abbey. She portrayed human rights activist Hefina Headon in the historical film Pride, and starred in the British comedy Finding Your Feet. She also provided voice acting roles for the films Chicken Run, Arthur Christmas, and Paddington.\n\nOn television, Staunton starred in the sitcoms Up the Garden Path and Is it Legal?. Her performance in My Family and Other Animals earned her a nomination for the International Emmy Award for Best Actress, while her roles in Return to Cranford and The Girl earned her BAFTA TV Award nominations for Best Actress in a Supporting Role. For the latter, she was also nominated for the Primetime Emmy Award for Outstanding Supporting Actress in a Miniseries or a Movie. She portrayed Queen Elizabeth II in the final two seasons of The Crown.', -441158400, 'Archway, London, England, UK', '11356', 'imelda-staunton', 'upload/images/tABRYOHUQeaUCAqrelJV5ZHjl1W.jpg'),
(589, 'actor', 'Jonathan Pryce', 'Jonathan Pryce, CBE (born June 1, 1947) is a Welsh stage and film actor and singer.\n\nAfter studying at the Royal Academy of Dramatic Art and meeting his long time partner, English actress Kate Fahy, in 1974, he began his career as a stage actor in the 1970s. His work in theatre, including an award-winning performance in the title role of the Royal Court Theatre\\\'s \\\"Hamlet\\\", led to several supporting roles in film and television. He made his breakthrough screen performance in Terry Gilliam\\\'s 1985 cult film \\\"Brazil\\\". Critically lauded for his versatility, Pryce has participated in big-budget films such as \\\"Evita\\\", \\\"Tomorrow Never Dies\\\", \\\"Pirates of the Caribbean\\\" and \\\"The New World\\\", as well as independent projects such as \\\"Glengarry Glen Ross\\\" and \\\"Carrington\\\". His career in theatre has also been prolific, and he has won two Tony Awards—the first in 1977 for his Broadway debut in \\\"Comedians\\\", the second for his 1991 role as \\\"The Engineer\\\" in the musical \\\"Miss Saigon\\\".', -712800000, 'Carmel, Flintshire, Wales, UK', '378', 'jonathan-pryce', 'upload/images/zwSv5uXzPTtmitFe39UdqnVwmdL.jpg'),
(590, 'actor', 'Lesley Manville', 'Lesley Manville was born on March 12, 1956 in Brighton, East Sussex, England. She is a multi award-winning actress of theatre, film, and television, and has worked extensively with director Mike Leigh. She is known for Another Year (2010), All or Nothing (2002), Topsy-Turvy (1999), and Secrets & Lies (1996), and her performance in Phantom Thread (2017), which was nominated for the Academy Award for Best Supporting Actress. She also had a supporting role in Maleficent (2014). Manville\\\'s extensive stage career includes roles in As You Like It, Les Liaisons Dangereuses and The Alchemist. Her film debut was in Dance with a Stranger (1985).', -435715200, 'Brighton, England, UK', '72305', 'lesley-manville', 'upload/images/tioPlSoypjdME3oMu3g7XmgIIKS.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(591, 'actor', 'Dominic West', 'Dominic Gerard Francis Eagleton West is an English actor, director, and musician. He is best known for playing Jimmy McNulty in HBO\\\'s The Wire (2002–2008), Noah Solloway in Showtime\\\'s The Affair (2014–2019), the latter of which earned him a Golden Globe Award for Best Actor – Television Series Drama nomination, Ebenezer Scrooge\\\'s nephew Fred in A Christmas Carol (1999, with Patrick Stewart as Scrooge), and Charles, Prince of Wales, in the Netflix drama The Crown (2022–present).\n\nWest was born in Sheffield, England, in 1969. He is the sixth of seven children born to Irish parents. He studied English literature at Trinity College Dublin and drama at the Guildhall School of Music and Drama.\n\nWest began his acting career in theater, appearing in productions of \\\"Hamlet\\\" and \\\"Oedipus Rex.\\\" He made his film debut in 1995 with a small role in the film \\\"The Boxer.\\\"\n\nWest\\\'s breakthrough role came in 2002, when he was cast as Jimmy McNulty in the HBO series The Wire. The Wire is considered one of the greatest television shows of all time, and West\\\'s performance as McNulty was critically acclaimed.\n\nWest has since starred in a number of other successful films and television shows, including \\\"300,\\\" \\\"The Hour,\\\" \\\"The Affair,\\\" and \\\"The Crown.\\\" He is a versatile actor who is equally comfortable in both dramatic and comedic roles.\n\nWest is also a talented musician. He plays the guitar and piano, and he has released two albums of his own music.', -6739200, 'Sheffield, Yorkshire, England, UK', '17287', 'dominic-west', 'upload/images/iJIdrZrE57eWlXAtXbntzacW6B8.jpg'),
(592, 'actor', 'Matt Smith', 'Matthew Robert Smith (born 28 October 1982) is an English actor. He is best known for his roles as the eleventh incarnation of the Doctor in the BBC series Doctor Who (2010–2013), Daemon Targaryen in the HBO series House of the Dragon (2022–present) and Prince Philip in the Netflix series The Crown (2016–2017), the latter of which earned him a Primetime Emmy Award nomination.\n\nSmith initially aspired to be a professional footballer, but spondylolysis forced him out of the sport. After joining the National Youth Theatre and studying drama and creative writing at the University of East Anglia, he became an actor in 2003, performing in plays including Murder in the Cathedral, Fresh Kills, The History Boys and On the Shore of the Wide World in London theatres. Extending his repertoire into West End theatre, he has since performed in the stage adaptation of Swimming with Sharks with Christian Slater, followed a year later by a critically acclaimed performance as Henry in That Face.\n\nSmith\\\'s first television role came in 2006 as Jim Taylor in the BBC adaptations of Philip Pullman\\\'s The Ruby in the Smoke and The Shadow in the North, while his first major role in television came as Danny in the 2007 BBC series Party Animals. Smith portrayed the eleventh incarnation of the Doctor in Doctor Who from 2010 to 2013, becoming the youngest person to portray the character. In film, he portrayed a dual role in Womb (2010), the physical forms of Skynet in Terminator Genisys (2015), 1960s pimp Jack in Last Night in Soho (2021), and Milo in Morbius (2022).', 404611200, 'Northampton, Northamptonshire, England, UK', '136532', 'matt-smith', 'upload/images/xr2GSp8Pm6fT5VGm0I9tsWVcZ8q.jpg'),
(593, 'actor', 'Claudia Harrison', 'Claudia Harrison is a British stage, film and television actress. She holds a degree in Drama from Birmingham University, Edgbaston, and trained at the Royal Academy of Dramatic Arts in London, England, UK.', 189302400, 'Claygate, Surrey, England, UK', '79127', 'claudia-harrison', 'upload/images/dSK2BBupETZYcsO0DfP2OD1AMnT.jpg'),
(594, 'actor', 'Tobias Menzies', 'Tobias Simpson Menzies (born March 7, 1974) is a British stage, television, and film actor, best known for his roles as Frank Randall / Jonathan \\\'Black Jack\\\' Randall on Outlander, Edmure Tully on HBO\\\'s Game of Thrones, Prince Philip - Duke of Edinburgh on The Crown, Geoffrey Dromgoole on The Night Manager, Nathaniel Bloom on The Honourable Woman, and as Marcus Junius Brutus in HBO\\\'s series Rome.', 131846400, 'Hammersmith, London, England, UK', '10920', 'tobias-menzies', 'upload/images/phcroLRZCjLje2jeKNkNQz4Jdpn.jpg'),
(595, 'actor', 'Marcia Warren', '', -823651200, ' Watford, Hertfordshire, England, UK', '1212145', 'marcia-warren', 'upload/images/nhpbQcoogi3uAdgmOW9A0FqdIxz.jpg'),
(596, 'actor', 'Helena Bonham Carter', 'Helena Bonham Carter CBE (born May 26, 1966) is an English actress. Known for her roles in independent films and blockbusters, especially period dramas, she is the recipient of various accolades, including a British Academy Film Award and three Screen Actors Guild Awards, in addition to nominations for two Academy Awards, four British Academy Television Awards, nine Golden Globe Awards, and five Primetime Emmy Awards.\n\nBonham Carter rose to prominence by playing Lucy Honeychurch in A Room with a View (1985) and the title character in Lady Jane (1986). Her early period roles saw her typecast as a virginal \\\"English rose\\\", a label she was uncomfortable with. She is best known for her eccentric fashion, dark aesthetic, and for often playing quirky women. For her role as Kate Croy in The Wings of the Dove (1997), Bonham Carter received a nomination for the Academy Award for Best Actress, and for her portrayal of Queen Elizabeth The Queen Mother in The King\\\'s Speech (2010), she won the BAFTA Award for Best Actress in a Supporting Role, and was nominated for the Academy Award for Best Supporting Actress. Her other films include Hamlet (1990), Howards End (1992), Mary Shelley\\\'s Frankenstein (1994), Mighty Aphrodite (1995), Fight Club (1999), Wallace & Gromit: The Curse of the Were-Rabbit (2005), the Harry Potter series (2007–2011) as Bellatrix Lestrange, Great Expectations (2012) as Miss Havisham, Les Misérables (2012), Cinderella (2015), Ocean\\\'s 8 (2018), and Enola Holmes (2020). Her collaborations with director Tim Burton, her former domestic partner, include Big Fish (2003), Corpse Bride (2005), Charlie and the Chocolate Factory (2005), Sweeney Todd: The Demon Barber of Fleet Street (2007) as Mrs. Lovett, Alice in Wonderland (2010) as the Red Queen, and Dark Shadows (2012).\n\nFor her role as children\\\'s author Enid Blyton in the BBC Four biographical film Enid (2009), she won the 2010 International Emmy Award for Best Actress and was nominated for the British Academy Television Award for Best Actress. Her other television films include Fatal Deception: Mrs. Lee Harvey Oswald (1993), Live from Baghdad (2002), Toast (2010), and Burton & Taylor (2013). From 2019 to 2020, she portrayed Princess Margaret, Countess of Snowdon in seasons three and four of Netflix\\\'s The Crown.', -113702400, 'Golders Green, London, England, UK', '1283', 'helena-bonham-carter', 'upload/images/hJMbNSPJ2PCahsP3rNEU39C8GWU.jpg'),
(597, 'actor', 'Victoria Hamilton', 'Victoria Hamilton is an English actress. After training at the London Academy of Music and Dramatic Art, Hamilton began her career in classical theatre, appearing in productions with the Royal Shakespeare Company and the National Theatre.', 39657600, 'Wimbledon, South London, England, UK', '55645', 'victoria-hamilton', 'upload/images/xisT8HsZW36JWuQ5MXkupwhVIpm.jpg'),
(598, 'actor', 'Marion Bailey', '', -588902400, ' Watford, Hertfordshire, England, UK', '72307', 'marion-bailey', 'upload/images/iyPvGc96bD8IfdIPPESYcWrF97g.jpg'),
(599, 'actor', 'Erin Doherty', '', 711244800, 'Crawley, West Sussex, England, UK', '2121856', 'erin-doherty', 'upload/images/mDT7zdjBbD78Sca7EngpBzWcOVe.jpg'),
(600, 'actor', 'Charles Edwards', '', -7948800, 'Haslemere, Surrey, England, UK', '281527', 'charles-edwards', 'upload/images/2mFLkYEMlqRSh630wwrcYzKoS1s.jpg'),
(601, 'actor', 'Pip Torrens', 'From Wikipedia, the free encyclopedia. \n\nPip Torrens (born June 2, 1960) is an English actor. He studied English Literature at Trinity College, Cambridge. His television appearances include Consenting Adults, two episodes of Doctor Who (\\\"Human Nature\\\"/\\\"The Family of Blood\\\"), Green Wing,Silk, The Government Inspector (as John Scarlett), The Last Detective and DI Torrens for a few episodes in The Bill in 2001. He has also appeared in a 2008 series of UK television advertisements for First Direct, with Matthew King. In 2011, he appeared in both episodes of an Outnumbered two-part special.  In 2012 he appeared in the first episode of series 8 of Hustle and presented new gameshow The Devil\\\'s Dinner Party.  His film appearances include Tomorrow Never Dies as the captain of HMS Bedford, the 2001 film To End All Wars and voicework for Valiant.\n\n Description above from the Wikipedia article Pip Torrens, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -302400000, 'Bromley, Kent, England, UK', '36666', 'pip-torrens', 'upload/images/2CMGIZ0hXTB4FcCXGlfVGaHGBBm.jpg'),
(602, 'actor', 'Sam Phillips', 'Sam Phillips is an English actor and writer. Phillips is the son of television director Nic Phillips and graduate of the Guildhall School of Music and Drama.', 454809600, 'London, England, UK', '1181524', 'sam-phillips', 'upload/images/dRHJRYxhFBmaCxfz8YGhHPBoekI.jpg'),
(603, 'actor', 'Elizabeth Debicki', 'Elizabeth Debicki (born 24 August 1990) is an Australian actress. After making her feature film debut in A Few Best Men (2011), she appeared in The Great Gatsby (2013) as Jordan Baker. Other roles are in the limited series The Night Manager (2016) and Widows (2018).', 651456000, 'Paris, France', '1133349', 'elizabeth-debicki', 'upload/images/ljHfp4MKl5quPmf98gGHBNdO9Vd.jpg'),
(604, 'actor', 'Will Keen', '', 5356800, 'Oxford, Oxfordshire, England UK', '51119', 'will-keen', 'upload/images/avHYumhxeHnWR1IDqQ9eVyV7M0x.jpg'),
(605, 'actor', 'Josh O\\\'Connor', 'Josh O\\\'Connor (born May 20, 1990) is a British actor. After training at the Bristol Old Vic Theatre School, he had supporting roles in television series such as Doctor Who in 2013 and Peaky Blinders in 2014. He had his breakthrough playing the lead role of a sheep farmer in Francis Lee\\\'s romantic drama God\\\'s Own Country (2017), for which he won a British Independent Film Award.\n\nFor portraying a young Charles III in the Netflix drama series The Crown (2019–2020), O\\\'Connor won a Primetime Emmy Award and a Golden Globe Award. He has since starred in the period dramas Emma (2020) and La chimera (2023).', 643161600, 'Cheltenham, Gloucestershire, England, UK', '1206334', 'josh-oconnor', 'upload/images/fiDjDWCGSZ7xDaN1rKAP4gvRn1a.jpg'),
(606, 'director', 'Benjamin Caron', '', 205113600, '', '136505', 'benjamin-caron', 'upload/images/hkjjQf2puC76kuyIMem6jIJomb8.jpg'),
(607, 'director', 'Christian Schwochow', '', 275356800, 'Bergen auf Rügen, Germany', '72842', 'christian-schwochow', 'upload/images/x7nzTUilJHfeARbIBYFE2PA75OQ.jpg'),
(608, 'director', 'Philip Martin', '', -536457600, 'Libano', '80660', 'philip-martin', NULL),
(609, 'director', 'Jessica Hobbs', '', NULL, '', '190873', 'jessica-hobbs', 'upload/images/np9nt25SXURVkumXVbvKtPtGF35.jpg'),
(610, 'director', 'Stephen Daldry', 'Stephen David Daldry CBE (born 2 May 1960) is an English director and producer of film, theatre, and television. He has won three Tony Awards for his work on Broadway and an Olivier Award for his work in the West End. He has received three Academy Awards nominations for Best Director, for the films Billy Elliot (2000), The Hours (2002), and The Reader (2008).\n\nFrom 2016 to 2020, he produced and directed the Netflix television series The Crown, for which he received one Producers Guild Award nomination, one Producers Guild Award win, two Primetime Emmy Award nominations, and one Primetime Emmy Award win for Outstanding Directing for a Drama Series and Outstanding Drama Series.\n\nDescription above from the Wikipedia article Stephen Daldry, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -273542400, 'Dorset, England', '468', 'stephen-daldry', 'upload/images/3nxFXIgMXhqU1aCOp7TOOEnhKCq.jpg'),
(611, 'director', 'Alex Gabassi', '', NULL, '', '1499895', 'alex-gabassi', 'upload/images/jFdPUJwDLTyr5rTSnsHiElGYBna.jpg'),
(612, 'director', 'Julian Jarrold', 'From Wikipedia, the free encyclopedia\n\nJulian Edward Peter Jarrold, born in Norwich, is a BAFTA Award-nominated English film and television director.\n\nHe is a member of the family which founded Jarrolds of Norwich in 1823 and was educated in Norfolk at Gresham\\\'s School, Holt. He now lives in North London.\n\nDescription above from the Wikipedia article Julian Jarrold, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -303955200, 'Norwich, Norfolk, England, UK', '29226', 'julian-jarrold', 'upload/images/jPaNB0NuUr81hmDXP2K14ABim9h.jpg'),
(613, 'director', 'May el-Toukhy', 'May el-Thouky (born August 17, 1977) is a Danish-Egyptian film director, known for directing the 2019 film Queen of Hearts. She also directed the 2015 film Long Story Short.\n\nDescription above from the Wikipedia article May el-Thouky, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 240624000, 'Charlottenlund, Denmark', '1290996', 'may-el-toukhy', 'upload/images/5DlwQ6AZBEYsnBQXbXMxvwYklkC.jpg'),
(614, 'director', 'Erik Richter Strand', '', 148608000, '', '109918', 'erik-richter-strand', 'upload/images/1cnrIfkFTaERUsMyWcUo51VqQVl.jpg'),
(615, 'director', 'Paul Whittington', 'Paul Whittington is a British film and television director.', NULL, '', '128131', 'paul-whittington', NULL),
(616, 'director', 'Sam Donovan', 'Sam Donovan is a British film and television director.', NULL, '', '229028', 'sam-donovan', 'upload/images/adMnGi4lE2Z9CPswi79zsDmxSLQ.jpg'),
(617, 'director', 'Philippa Lowthorpe', 'Philippa Lowthorpe (born 27 December 1961) is an award-winning film and television director. She was awarded the Deluxe Director Award at the WFTV Film and Television Awards for the miniseries Three Girls.\n\nDescription from her Wikipedia page.', -252892800, 'Yorkshire, England', '96305', 'philippa-lowthorpe', NULL),
(618, 'actor', 'Penn Badgley', 'Penn Dayton Badgley (born November 1, 1986) is an American actor. He is primarily known for his roles as Dan Humphrey in The CW teen drama series Gossip Girl (2007–2012) and Joe Goldberg in the Netflix thriller series You (2018–present). For Gossip Girl, he received six Teen Choice Award nominations, and for You, he earned MTV Movie & TV Award and Saturn Award nominations.\n\nBadgley first became known for portraying Phillip Chancellor IV on the soap opera The Young and the Restless (2000–2001), which earned him a Young Artist Award nomination, and he followed this with roles in the comedy films John Tucker Must Die (2006) and Drive-Thru (2007). Badgley went on to appear in a number of films, such as the thriller The Stepfather (2009), the teen comedy-drama Easy A (2010), the financial thriller Margin Call (2011), the biographical film Greetings from Tim Buckley (2012) and the independent drama The Paper Store (2016). For Margin Call, he won an Independent Spirit Award.', 531187200, 'Baltimore, Maryland, USA', '110927', 'penn-badgley', 'upload/images/7NtfavGGJdZPfKhw11tGQSOmyFA.jpg'),
(619, 'actor', 'Victoria Pedretti', 'Victoria Pedretti, born March 23 in 1995 is an American actress best known for her roles as Eleanor \\\"Nell\\\" Crain in the Netflix horror series The Haunting of Hill House (2018), Dani Clayton in the follow-up The Haunting of Bly Manor (2020), and Love Quinn in the Netflix thriller series You (2019–). She also had a small part in Quentin Tarantino\\\'s Once Upon a Time in Hollywood (2019).', 795916800, 'Fairless Hills, Pennsylvania, USA', '2117434', 'victoria-pedretti', 'upload/images/dSrIMNn803L8fqqWjkCSRv4iOu1.jpg'),
(620, 'actor', 'Saffron Burrows', '​From Wikipedia, the free encyclopedia\n\nSaffron Dominique Burrows (born 22 October 1972) is an English actress and former fashion model, who starred as Det. Serena Stevens on Law & Order: Criminal Intent.', 88560000, 'London, England, UK', '9825', 'saffron-burrows', 'upload/images/2qMLZh9XWquBt7TZF9wmDiOtJdm.jpg'),
(621, 'actor', 'Ambyr Childers', 'From Wikipedia, the free encyclopedia\n\nChilders was born in Cottonwood, Arizona and raised in Murrieta, California. Childers attended Vista Murrieta High School. After appearing in the 2003 film Dickie Roberts: Former Child Star, Childers became established for her role on the daytime soap opera All My Children as Colby Chandler, whom she portrayed from 2006 to 2008. She also played Elizabeth \\\"E\\\" Dodd in The Master. Childers is married to movie producer Randall Emmett and their daughter, London, was born on February 2, 2010.', 585187200, 'Murrieta, California, USA', '75330', 'ambyr-childers', 'upload/images/lPe6SNstGpXT5PTnFOW8zntP8gQ.jpg'),
(622, 'actor', 'Elizabeth Lail', 'Elizabeth Dean Lail (born on March 25, 1992) is an American actress. Known for her role as Anna in the ABC adventure fantasy TV series \\\'Once Upon a Time\\\', Guinevere Beck on Netflix\\\'s thriller \\\'You\\\', & Vanessa in Blumhouse’s adaptation of Five Night’s At Freddy’s (2023)', 701481600, 'Williamson County, Texas, USA', '1368507', 'elizabeth-lail', 'upload/images/lDYjEyqojUs2sF3CgdsOZ9vr2KL.jpg'),
(623, 'actor', 'Tati Gabrielle', 'Tatiana Gabrielle Hobson (born January 25, 1996) is an American actress. She is known for her roles as Gaia on The CW science fiction television series The 100, Prudence on the Netflix original series Chilling Adventures of Sabrina, Marienne Bellamy on the Netflix series You, and for providing the voice of Willow Park on the Disney animated series The Owl House.\n\nDescription above from the Wikipedia article Tati Gabrielle, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 822528000, 'San Francisco, California, USA', '1859934', 'tati-gabrielle', 'upload/images/wBYFlOliwkC4V7lPW1xsQLQ1h1i.jpg'),
(624, 'actor', 'James Scully', 'James Scully is an actor, known for Straight Up (2019), The Last Thing He Wanted (2020) and You (2018).', 691459200, 'San Antonio, Texas, USA', '1778501', 'james-scully', 'upload/images/uy3HeUzCFRM7aVsx9aGblcyEqSe.jpg'),
(625, 'actor', 'Charlotte Ritchie', 'Charlotte Anne Ritchie (born 29 August 1989) is an English actress and singer-songwriter. She is famous for her roles in the TV series Fresh Meat (2011–2016), Siblings (2014–2016) and Call the Midwife (2015–2018) and for her lead role in Benny and Jolene (2013). She is currently starring in BBC\\\'s Ghosts (2019–) as Alison.\n\nIn 2004, she played a lead in a short film entitled The Open Doors with Michael Sheen. She appeared as an uncredited extra in the 2005 film, Harry Potter and the Goblet of Fire. She also featured in The Pierglass at the Young Pleasance Theatre in August 2006 at the Edinburgh Festival Fringe. She was a presenter on Boomerang and performed with All Angels in an episode of Emmerdale. She also played Emily Owen, a neighbour in the BBC\\\'s Life of Riley.\n\nFrom 2011 to 2016, she portrayed Oregon in the Channel 4 comedy series Fresh Meat. She stars in Siblings which was first broadcast in summer 2014 and she appeared as a guest panellist in the same year on 8 Out of 10 Cats. In 2015, she joined the cast of popular period drama Call The Midwife. In 2016, she appeared in the UK production of Noel Coward\\\'s Private Lives, playing the role of Sibyl Chase. On New Years Day 2019, she had the guest-starring role of Lin in the Doctor Who episode \\\"Resolution\\\". In 2019, she played Alison in Ghosts, a BBC sitcom, and Alison in Dead Pixels. She played the role of George in Channel 4 series Feel Good in 2020.\n\nDescription above is from the Wikipedia article Charlotte Ritchie, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 620352000, 'Clapton, London, England, UK', '1488056', 'charlotte-ritchie', 'upload/images/39E5KoQ1oJ1FfJEdSeO7sIx6mzQ.jpg'),
(626, 'actor', 'Dylan Arnold', 'Dylan Arnold (born February 11, 1994) is an American actor. He is known for playing Noah in After (2019), a role which he will reprise in After We Collided (2020). He is also known for playing Cameron Elam in Halloween (2018), a role he will reprise in Halloween Kills (2020).', 760924800, 'USA', '1039523', 'dylan-arnold', 'upload/images/ipmcpPccYlVqBDiKnE3LGhaePuP.jpg'),
(627, 'actor', 'Tilly Keeper', 'Tilly Keeper (born 16 August 1997) is an English actress, known for her role as Louise Mitchell on the BBC soap opera EastEnders. Shortly after leaving the soap, Keeper appeared in the BBC film Make Me Famous. She has since been cast in the Netflix series You as Lady Phoebe.', 871689600, 'Westminster, London, England, UK', '1816499', 'tilly-keeper', 'upload/images/r0NcqL6Vgp6ZQJSQ6fl8kL8Db46.jpg'),
(628, 'actor', 'Shalita Grant', 'Shalita Grant was raised in Petersburg, Virginia and attended high school at the Baltimore School for the Arts in Maryland where she was a YoungArts Winner in Theater and Presidential Scholar in the Arts. At 17, she received a scholarship to attend the Julliard School for her B.F.A. in Drama, graduating in 2010.', 588729600, 'Baltimore, Maryland, USA', '1493225', 'shalita-grant', 'upload/images/nX5PNQ8v2Kyx2DdMfKDnIjd2piB.jpg'),
(629, 'actor', 'Travis Van Winkle', 'Travis Van Winkle (born November 4, 1982) is an American actor.', 405216000, 'Victorville, California, USA', '74290', 'travis-van-winkle', 'upload/images/thanvrjfpP9h8E9QmPbtutZoEHa.jpg'),
(630, 'actor', 'Amy-Leigh Hickman', 'Amy-Leigh Hickman (born 16 September 1997) is an English actress.', 874368000, 'Hastings, East Sussex, England, UK', '1819749', 'amy-leigh-hickman', 'upload/images/8s6Mvx63GQvk6HlA3ZCEEwe5c2U.jpg'),
(631, 'actor', 'Luca Padovan', 'Luca Padovan is an actor, known for You (2018), Crazy Ex-Girlfriend (2015) and The Magicians (2015).', 1060992000, 'New York', '2126167', 'luca-padovan', 'upload/images/4LotI2IGryLZc4UncPJngIx2ZT1.jpg'),
(632, 'actor', 'Ed Speleers', '​Edward John Speleers (born 7 April 1988) is an English actor and producer. He is best known for playing the title role in the 2006 film Eragon, the antagonist character Stephen Bonnet in the TV series Outlander, as well as James \\\"Jimmy\\\" Kent in the TV series Downton Abbey.', 576374400, 'Chichester, West Sussex, England', '25438', 'ed-speleers', 'upload/images/aE8latD1mdBg4JY6jpqJPakzpy4.jpg'),
(633, 'actor', 'Lukas Gage', 'Lukas Gage is an American actor. He has appeared in American Vandal, T@gged, Scouts Guide to the Zombie Apocalypse, Euphoria, and The White Lotus. In 2020, his quarantine audition tape went viral.', 801619200, 'San Diego, California, USA', '1371509', 'lukas-gage', 'upload/images/j7Zub5J9PgCnsfgEC5QCr160JtH.jpg'),
(634, 'actor', 'Zach Cherry', 'Zach Cherry is an American actor and improv comedian. He is known for his role as Dylan George on the Apple TV+ series Severance.', 720576000, '  United States', '1838225', 'zach-cherry', 'upload/images/fT3Wv8ef0Vn0daHWAObCp2Bd4Y.jpg'),
(635, 'actor', 'Carmela Zumbado', 'Carmela Zumbado is a first-generation American actress of Cuban and Colombian descent. She is the sister of actresses Marisela Zumbado and Gigi Zumbado, and the daughter of acclaimed photojournalist, Tony Zumbado and Lilliam Zumbado. She is most widely known for her breakout role as Delilah Alves in the Netflix thriller \\\"You\\\", where she starred opposite Penn Badgley and Victoria Pedretti.', 667612800, 'Miami, Florida, USA', '1292730', 'carmela-zumbado', 'upload/images/fGH4gA2wssENiYfKbXLrTgaVXMD.jpg'),
(636, 'actor', 'Shay Mitchell', 'Shannon \\\'Shay\\\' Mitchell (born April 10, 1987) is a Canadian model and actress. She is best known for portraying Emily Fields in the ABC Family series Pretty Little Liars, and Peach Salinger in the TV series You.', 545011200, 'Toronto, Ontario,  Canada', '222088', 'shay-mitchell', 'upload/images/rO5K4ApMi57RciVd2xIYt6W2m0N.jpg'),
(637, 'actor', 'Ben Mehl', '', NULL, '', '1485910', 'ben-mehl', 'upload/images/IqBw9uyU2N2WopsKsUuZQVWSrV.jpg'),
(638, 'director', 'Marcos Siega', 'Marcos Siega (born June 8, 1969 in New York City, New York) is a film, television, commercial, and music video director. He has also worked as a producer and a musician.\n\nIn the late 1980s he helped form the New York based punk band Bad Trip, releasing two full length records and numerous EPs. When he began directing music videos, many bands and musicians noted that Siega\\\'s background in rock music was beneficial. He has worked with bands such as Weezer, System of a Down, P.O.D., Papa Roach, Blink-182, The All-American Rejects and many more. His 2000 video for Blink-182\\\'s \\\"All the Small Things\\\" garnered him three MTV Video Music Award nominations and he was nominated for a Grammy Award for his Papa Roach video \\\"Broken Home\\\". In 2001 he signed with award winning commercial production company Hungryman Films and made his move into the spot world.\n\nSiega has gone on to direct films and acclaimed television series such as Dexter, True Blood, Cold Case, and Veronica Mars to name but a few. He is co-executive producer of The Vampire Diaries and also directed the pilot and several subsequent episodes. Pretty Persuasion, the 2005 film he directed, was nominated for Grand Jury Prize at the Sundance Film Festival.\n\nDescription above from the Wikipedia article Marcos Siega, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -17884800, 'New York City, New York, USA', '74062', 'marcos-siega', NULL),
(639, 'director', 'Lee Toland Krieger', '', 412214400, 'Los Angeles, California, USA', '109745', 'lee-toland-krieger', NULL),
(640, 'director', 'Erin Feeley', 'Erin Feeley works as a script supervisor, producer and director for film and television projects.', NULL, '', '1399096', 'erin-feeley', NULL),
(641, 'director', 'Cherie Nowlan', '', NULL, '', '118471', 'cherie-nowlan', 'upload/images/y6KmOUDxM2eCGYFL8srWqjifjyR.jpg'),
(642, 'director', 'Victoria Mahoney', 'Born and raised in New York, Mahoney developed her debut feature film \\\"Yelling to the Sky\\\" through the Directors and Screenwriters Sundance Institute Labs and was named an Auerbach Fellow, Annenberg Fellow, Cinereach Fellow, Maryland Fellow, Tribeca Fellow and IFP Narrative Lab fellow. She was named one of, \\\"25 New Faces of Independent Film\\\" by Filmmaker Magazine, one of ShadowAndAct/IndieWire\\\'s \\\"Filmmakers to Watch\\\" and one of, \\\"3 Filmmakers to Watch\\\" in Elle Magazine\\\'s, Women In Hollywood issue.\n\nYelling to the Sky, World Premiered in \\\'Main Competition\\\' at the Berlin Film Festival, where it was nominated for the Golden Bear.\n\nIn 2018, JJ Abrams hired Victoria to direct second unit for him on Star Wars Ep IX \\\"The Rise of Skywalker\\\".', NULL, 'New York, New York, USA', '42138', 'victoria-mahoney', 'upload/images/5BNUlo3TeNmYrlAeu6zrYr9mbW1.jpg'),
(643, 'director', 'Martha Mitchell', 'Martha Mitchell is an American television director.\n\nShe has directed for a number of notable television series. Prior to directing, Mitchell worked as a script supervisor on numerous films, the pilot episode of New York Undercover and episodes of Law & Order from 1990 to 1996.', NULL, '', '1214045', 'martha-mitchell', NULL),
(644, 'director', 'DeMane Davis', 'DeMane Davis is a television director, producing director, filmmaker and voice over artist.', NULL, '', '1080857', 'demane-davis', 'upload/images/nlp8kQ1jcN0Zbt2rv9SRdIqjl2q.jpg'),
(645, 'director', 'Meera Menon', '', NULL, '', '1157091', 'meera-menon', NULL),
(646, 'director', 'Marta Cunningham', 'Marta Cunningham is an American actress, writer, dancer, choreographer, producer and filmmaker, best known for her feature length, Emmy nominated documentary \\\"Valentine Road\\\", which competed in the 2013 Sundance Film Festival.', 40867200, 'San Mateo, California, USA', '1140474', 'marta-cunningham', NULL),
(647, 'director', 'Kellie Cyrus', '', NULL, '', '1341721', 'kellie-cyrus', NULL),
(648, 'actor', 'Katee Sackhoff', 'Kathryn Ann \\\"Katee\\\" Sackhoff (born April 8, 1980) is an American actress known mainly for playing Captain Kara \\\"Starbuck\\\" Thrace on the Sci Fi Channel\\\'s television program Battlestar Galactica. In 2004 she was nominated for a Saturn Award in the \\\"Best Supporting Actress in a Television Series\\\" category for her work in the Battlestar Galactica miniseries. In May 2006, she won the Saturn Award for the same role. She starred in the eighth season of 24 as Dana Walsh.\n\nDescription above from the Wikipedia article Katee Sackhoff, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 324000000, 'Portland, Oregon, USA', '51798', 'katee-sackhoff', 'upload/images/pBllr4CwkL5DlQCPPqCXhwRqwo9.jpg'),
(649, 'actor', 'Justin Chatwin', 'Justin Chatwin (born October 31, 1982) is a Canadian actor. He began his career in 2001 with a brief appearance in the musical comedy Josie and the Pussycats. Following his breakthrough role as Robbie Ferrier in the blockbuster War of the Worlds (2005), Chatwin headlined studio films such as The Invisible (2007) and Dragonball Evolution (2009), an action-adventure feature based on the manga series Dragon Ball. In the 2010s, Chatwin acted in small independent films. He starred as rock star idol Bobby Shore in the sci-fi musical Bang Bang Baby (2014), which earned him a Canadian Screen Awards nomination for Best Supporting Actor, and appeared in the romantic comedy Unleashed (2016), and drama Summer Night (2019).\n\nThroughout the 2000s, Chatwin made guest appearances in several television series including Weeds and Lost. His first regular role was on the Showtime comedy-drama Shameless, where he portrayed Jimmy Lishman between 2011 and 2015. Chatwin starred as a cartoonist in the CBS murder mystery drama American Gothic (2016), and also that year he appeared as superhero Grant Gordon / The Ghost in the Doctor Who Christmas special \\\"The Return of Doctor Mysterio\\\". From 2019 to 2021, Chatwin played scientist Erik Wallace in Netflix\\\'s Another Life. Chatwin\\\'s journey from Vancouver to Patagonia on motorcycle was depicted in the documentary series No Good Reason (2020), which he also executive produced.', 404870400, 'Nanaimo, British Columbia, Canada', '503', 'justin-chatwin', 'upload/images/qByFlG1GqX2PTM7J8r14wSQwbZ.jpg'),
(650, 'actor', 'Samuel Anderson', 'From Wikipedia, the free encyclopedia\n\nSamuel Anderson (born 1982) is an English actor. He played the role of police officer Ross Kirk in Emmerdale up until early 2009.\n\nHe originated the role of Crowther in the 2004 National Theatre production of Alan Bennett\\\'s play The History Boys and subsequently performed the same role in the Broadway, Sydney, Wellington and Hong Kong productions and radio and film versions.\n\nAs well as stage performances, Anderson\\\'s television appearances include BAFTA award winning BBC Three comedy Gavin &amp; Stacey – playing recurring character Fingers – and BBC Four TV comedy Stuck.\n\nDescription above from the Wikipedia article Samuel Anderson (actor), licensed under CC-BY-SA, full list of contributors on Wikipedia.', 388713600, 'Handsworth, Birmingham, England, UK', '55465', 'samuel-anderson', 'upload/images/155QL3ZdGm6NseuA2bMnAXyB6hZ.jpg'),
(651, 'actor', 'Elizabeth Faith Ludlow', 'Elizabeth Faith Ludlow is an American actress known for her portrayal of Arat in the AMC postapocalyptic horror television series The Walking Dead (2016–2018); she is also known for her role as Mona in the USA Network TV series Satisfaction, and as Cas Isakovic in Another Life (2019-2021). She also appeared in Guardians of the Galaxy Vol. 2.', 613008000, 'USA', '1718567', 'elizabeth-faith-ludlow', 'upload/images/1uPWvmq1SsFqjJPhgZsr8GNXbcI.jpg'),
(652, 'actor', 'A.J. Rivera', 'A.J. Rivera is a film and television actor.', NULL, '', '1590297', 'aj-rivera', 'upload/images/qmPEVvazwYEsakY9A1X7XZKIo7e.jpg'),
(653, 'actor', 'Alexander Eling', '', NULL, '', '2371246', 'alexander-eling', 'upload/images/owKNcy8qqtxI1PN0HI43rFZTXNy.jpg'),
(654, 'actor', 'JayR Tinaco', '', NULL, ' Sydney, Australia', '2059180', 'jayr-tinaco', 'upload/images/dhVbXL7EPrN1Wq3fnKowv40ymS5.jpg'),
(655, 'actor', 'Blu Hunt', 'Blu Hunt (born July 11, 1995) is an American actress. She is best known for her roles as Inadu/The Hollow in The CW supernatural drama series The Originals (2017) and as August Catawnee in the Netflix science fiction drama series Another Life (2019–2022).\n\nHunt made her film debut as Danielle Moonstar / Mirage in the superhero film The New Mutants (2020), which is part of the X-Men film series.', 805420800, 'Sacramento, California, USA', '1827498', 'blu-hunt', 'upload/images/18lrHD5StBQ2d03zWIO3a3nLJHG.jpg'),
(656, 'actor', 'Alex Ozerov-Meyer', 'Alex Ozerov (born August 3rd, 1992) is a Russian-Canadian film and television actor. He is best known for his recurring television series appearances on The Americans and Orphan Black.', 712800000, 'Tula, Russia', '1094772', 'alex-ozerov-meyer', 'upload/images/g0DtLoImOAVdEPm8QCtBHBJVZHK.jpg'),
(657, 'actor', 'Lina Renna', '', 1240617600, 'Vancouver, British Columbia, Canada', '1698098', 'lina-renna', 'upload/images/jdkfBoOjPEdu1KXxthYlBuielMf.jpg'),
(658, 'actor', 'Tongayi Chirisa', 'Tongayi Arnold Chirisa is a Zimbabwean actor known for playing Man Friday on NBC\\\'s Crusoe television series, Father Nicholas on The Jim Gaffigan Show, and Hekule on Leon Schuster\\\'s Mr. Bones 2: Back from the Past movie. He is also an occasional singer.', 366076800, 'Harare, Zimbabwe', '105875', 'tongayi-chirisa', 'upload/images/iNUnPz0fcz2kGYZ5lhkXo042iAl.jpg'),
(659, 'actor', 'Jake Abel', 'From Wikipedia, the free encyclopedia.\n\nJacob Allen \\\"Jake\\\" Abel (born November 18, 1987) is an American actor.\n\nAbel was born in Canton, Ohio. His first break was landing a role in the Disney Channel Original Movie Go Figure as Spencer, and later had a recurring role on Threshold, and numerous guest starring roles on such shows as Cold Case and ER. He was honored with a Rising Star award at the 16th Hamptons International Film Festival in October, 2008 for his work in the film Flash of Genius. In 2009, Abel can be seen in The Lovely Bones directed by Peter Jackson, and Angel of Death, which is a 10-episode web series. In February 2009, Jake was cast as the 19-year old Adam Milligan, on the CW hit series Supernatural. He was next seen as Luke Castellan in Percy Jackson & the Olympians: The Lightning Thief, released on February 12, 2010. Afterward Abel starred in I Am Number Four as Mark James.\n\nDescription above from the Wikipedia article Jake Abel, licensed under CC-BY-SA, full list of contributors on Wikipedia​', 564192000, 'Canton, Ohio, USA', '105727', 'jake-abel', 'upload/images/ijog1BFmm4BgZGnScwoYJKkwAcO.jpg'),
(660, 'actor', 'Selma Blair', '​Selma Blair Beitner (born June 23, 1972) is an American actress. She\\\'s known for her roles in the comedies Legally Blonde (2001) and The Sweetest Thing (2002), and achieved international fame with her portrayal of Liz Sherman in the big-budget fantasy films Hellboy (2004) and Hellboy II: The Golden Army (2008).\n\nAfter training at the Stella Adler Conservatory of Acting, Blair began acting in the mid-90s. Blair began her career with small roles and guest roles in various television series. Blair appeared with co-stars Sarah Michelle Gellar, and Ryan Phillippe in the 1999 film Cruel Intentions, for which Blair won an MTV Movie Award for Best Kiss - Lesbian Kiss between Blair and co-star Gellar.\n\nShe went on to star as Zoe Bean in two seasons of TV series Zoe, Duncan, Jack and Jane (1999-2000), She rejoined actress Reese Witherspoon in the comedy film Legally Blonde (2001).  She also starred opposite Cameron Diaz and Christina Applegate in The Sweetest Thing and in two independent films that garnered her much critical acclaim: Dana Lustig\\\'s Kill Me Later and Todd Solondz\\\'s controversial Storytelling, and one of her most recognized roles, Liz Sherman in Hellboy (2004) and its successful sequel released in 2008, Hellboy II: The Golden Army, based on the popular comic.\n\nHer films include The Deal, The Big Empty, and Ed Burn\\\'s Purple Violets. Her other notable film credits include Highway (2002), A Guy Thing (2003), A Dirty Shame (2004), The Fog (2005), WΔZ (2007), Feast of Love (2007), The Poker House (2008), Dark Horse (2011), In Their Skin (2012), Ordinary World  (2016), Mothers and Daughters (2016), Mom and Dad (2017), After (2019) and A Dark Foe (2020).\n\nShe starred opposite Molly Shannon in the TV series Kath & Kim, based on the Australian television series of the same name. She also starred as Kate Wales on the sitcom Anger Management (2012–2014); and as Kris Jenner in the first season of the FX drama series American Crime Story (2016). In 2010, Blair narrated the audiobook The Diary of Anne Frank, earning a nomination for the Grammy Award for Best Spoken Word Album for Children.\n\nShe can also be seen in the My Friend Steve 1998 music video Charmed. Her stage work includes the role of Kayleen in Rajiv Joseph\\\'s Gruesome Playground Injuries, which had its world premiere at Houston\\\'s Alley Theatre in October 2009.\n\nIn October 2018, Blair revealed that she had been diagnosed with multiple sclerosis in August of that year.', 78105600, 'Southfield, Michigan, USA', '11826', 'selma-blair', 'upload/images/5KfULwS7ZPZc6Ac1OP0ka2PhZZy.jpg'),
(661, 'actor', 'Dillon Casey', 'Dillon Casey (born October 29th, 1983) is a Canadian-American actor and producer. He is best known for his role as Sean Pierce in the CW television series Nikita (2010).', 436233600, 'Dallas, Texas, USA', '1235237', 'dillon-casey', 'upload/images/dzWygEvNmfSbwNZ4I0wkkXidqoi.jpg'),
(662, 'actor', 'Jessica Camacho', 'Born in Chicago, Camacho got her first taste of acting when she took an acting class at the suggestion of a friend. She instantly fell in love with the craft and moved to San Francisco, where she supported herself as a waitress while taking night classes at the renowned American Conservatory Theatre. She went on to work in theatre and television in Chicago, where she was able to obtain her Screen Actors Guild member-ship card before settling full time in Los Angeles.\n\nCamacho can be seen starring in CBS\\\' highly anticipated, legal drama series, \\\"All Rise.\\\" Written and executive produced by Canadian writer Spottiswood and directed by Mike Robin, \\\"All Rise\\\" pulls back the curtain of a Los Angeles county court system, taking a deeper dive into the personal and professional lives of the judges, lawyers, clerks, bailiffs and cops. Camacho shines as Emily Lopez-Berarro, a tough and determined public defender who is undaunted in her efforts to prove her clients\\\' innocence. \\\"All Rise\\\" premieres on CBS September 23, 2019.\n\nAdditionally, Camacho can be seen starring in Netflix\\\'s sci-fi drama series \\\"Another Life\\\" opposite Katee Sackhoff and Selma Blair. Created by Aaron Martin (\\\"Saving Hope,\\\" \\\"DeGrassi: The Next Generation\\\") \\\"An-other Life\\\" centers on astronaut Niko Breckinridge (Sackhoff) who is focused on searching for alien intelligence. Camacho will play Michelle Vargas, the crew\\\'s aggressive, tell-it-like-it-is communications expert. \\\"Another Life\\\" will stream internationally on Netflix platforms on July 25, 2019. Camacho will also appear this fall in a top-secret recurring role on HBO\\\'s highly-anticipated superhero series \\\"Watchmen\\\" opposite Regina King, Jeremy Irons and Don Johnson. Written by Damon Lindelof, the show is based on characters from the iconic graphic novel and is set in an alternate history where superheroes are treated as outlaws.\n\nCamacho was most recently seen as a series regular throughout season two of NBC\\\'s action/thriller series \\\"Taken,\\\" based on the internationally renowned blockbuster film franchise. She was a scene-stealer as whip-smart, rule-breaking Army captain, Santana. She has also appeared in the DC Comics world, and is well known for her recurring role as Gypsy on \\\"The Flash\\\" for The CW.\n\nOn the film front Camacho has been seen in \\\"Think Like a Man,\\\" \\\"Veronica Mars,\\\" and most recently \\\"Ro-man J. Israel, Esq.\\\" opposite Denzel Washington. Additional television credits include: regular roles on \\\"Sleepy Hollow\\\" for FOX and \\\"Last Resort\\\" for ABC, and appearing on \\\"Casual,\\\" \\\"Frequency,\\\" \\\"Harley and the Davidsons,\\\" \\\"Minority Report,\\\" \\\"Longmire,\\\" \\\"Rizzoli & Isles,\\\" \\\"Stalker,\\\" \\\"Bones,\\\" \\\"Castle,\\\" \\\"NCIS: Los Angeles,\\\" \\\"Hello Ladies,\\\" \\\"Law & Order: Special Victims Unit,\\\" \\\"Nikita,\\\" \\\"Gossip Girl,\\\" \\\"The Mentalist,\\\" \\\"Dexter,\\\" and \\\"Justified.\\\"\n\nOn the charity front, Camacho\\\'s passions are protecting our planet, helping the needy and forgotten, working with groups that help people develop skills and passions that can change their life, and being a voice for abused and neglected animals. She has worked with a handful of organizations over the years to further her voice in these arenas. Camacho currently resides in Los Angeles with her pup, Jules.\n\nDescription above from the IMDB article Jessica Camacho', 407116800, 'Chicago, Illinois, USA', '1030995', 'jessica-camacho', 'upload/images/rmms55MpLdBWRDX8LLDTctgXUuA.jpg'),
(663, 'actor', 'Greg Hovanessian', '', NULL, 'Canada ', '1572218', 'greg-hovanessian', 'upload/images/t7kMVx2W4QA12T8CYdq2X6meC7s.jpg'),
(664, 'actor', 'Helen King', '', 68256000, 'Dunfermline, Fife, Scotland, UK', '1243358', 'helen-king', 'upload/images/xdqxTBNRPSP6q5WMhkOoKkxoG2i.jpg'),
(665, 'actor', 'Tyler Hoechlin', 'Tyler Lee Hoechlin  (born September 11, 1987) is an American actor who got his big break starring alongside Tom Hanks in the film Road to Perdition (2002) as Michael Sullivan Jr. For television he is best known for his roles as Superman/Clark Kent in Superman & Lois (and other connected shows) and as Martin Brewer in 7th Heaven.', 558316800, 'Corona, California, USA', '78198', 'tyler-hoechlin', 'upload/images/n2hXiC2MABZnZoQKtWLkP73LKWe.jpg'),
(666, 'actor', 'Shannon Chan-Kent', 'Shannon Chan-Kent is a Canadian television, screen and stage actress of Chinese and Irish descent. She holds a degree in Opera Performance from the University of British Columbia.', 590976000, 'Vancouver, Canada', '221843', 'shannon-chan-kent', 'upload/images/pt8rq0yQXPHxXBDi1xbeVBjfqiD.jpg'),
(667, 'actor', 'Kurt Yaeger', '', NULL, '', '814184', 'kurt-yaeger', 'upload/images/mNHNZpibu7bu4Zz3w3JV2w81HJf.jpg'),
(668, 'actor', 'Parveen Dosanjh', '', NULL, '', '1562501', 'parveen-dosanjh', 'upload/images/6XRcr5R1PsYtjQSPZ7B3vUX4DMH.jpg'),
(669, 'director', 'Metin Hüseyin', 'From Wikipedia, the free encyclopedia\n\nMetin Hüseyin (born in 1959 in London, United Kingdom) is a British television and film director. Hüseyin was born in Hackney, London to a Turkish Cypriot family. His parents, Osman Hüseyin and Andaç Raif, immigrated from Cyprus to the United Kingdom in the 1950\\\'s where they married, set up a dry cleaning business and had five children. His debut film, Tight Trousers, was nominated for a BAFTA Film Award for Best Short Film in 1989, and in 1998 he received an RTS award and a British Academy Television Award nomination for Common as Muck and The History of a Foundling; Tom Jones won three BAFTAs. In 2002 film he directed the film Anita and Me and has also directed episodes of The All New Alexei Sayle Show, Randall & Hopkirk (Deceased) and Kingdom, some episodes of BBC\\\'s drama Merlin and Shameless.', -343872000, 'London, UK', '283184', 'metin-hüseyin', 'upload/images/uFQ9GV5DECjU2gkux3EKlkMPzvc.jpg'),
(670, 'director', 'Sheree Folkson', 'Sheree Folkson is a British film and television director. Some of her television credits are American Horror Story, The Bill, Band of Gold, Doctor Who, The Young Person\\\'s Guide to Becoming a Rock Star, Casanova, Hope Springs, Truckers, the American series Ugly Betty, Penny Dreadful: City of Angels, Bridgerton and Sex/Life. Her film credits include Gypsy Woman, My Family and Other Animals and The Decoy Bride starring David Tennant.\n\nDescription above from the Wikipedia article Sheree Folkson, licensed under CC-BY-SA, full list of contributors on Wikipedia.', NULL, 'UK', '123798', 'sheree-folkson', 'upload/images/z1P4sdObW2vnDzwrnn1EFJnWTcP.jpg'),
(671, 'director', 'Mairzee Almas', '', NULL, '', '1400942', 'mairzee-almas', 'upload/images/wGOEgnJZtELk4SQpQEVFoMChAyl.jpg'),
(672, 'director', 'Omar Madha', '', NULL, '', '1240413', 'omar-madha', NULL),
(673, 'director', 'Shannon Kohli', '', NULL, '', '1396344', 'shannon-kohli', 'upload/images/5ZK1s2lZAaLZqNEmU1yGrrdX59b.jpg'),
(674, 'director', 'Avi Youabian', '', NULL, 'Tehran, Iran', '971003', 'avi-youabian', NULL),
(675, 'director', 'Allan Arkush', 'Allan Arkush (born April 30, 1948) is an American director and producer of films, television and videos.\n\nDescription above from the Wikipedia article Allan Arkush, licensed under CC-BY-SA, full list of contributors on Wikipedia.​', -683942400, 'Jersey City, New Jersey, USA', '83198', 'allan-arkush', NULL),
(676, 'actor', 'Nolan North', 'Nolan North (born October 31, 1970) is an American actor and voice actor. He is known for his roles as Nathan Drake in the Uncharted video game series, Desmond Miles in the Assassin\\\'s Creed video game series, Dr. Edward Richtofen in the Call of Duty Zombies mode, Deadpool in various Marvel Comics media, and the Penguin in the Batman: Arkham franchise.\n\nNorth was born in New Haven, Connecticut. He attended the University of Connecticut, where he studied theater. After graduating, he moved to Los Angeles to pursue a career in acting.\n\nNorth\\\'s first major voice acting role was as Nathan Drake in the 2007 video game Uncharted: Drake\\\'s Fortune. He has since reprised the role in four sequels, as well as the spin-off game Uncharted: The Lost Legacy.\n\nNorth has also voiced a wide variety of other characters in video games, including Desmond Miles in the Assassin\\\'s Creed series, Dr. Edward Richtofen in the Call of Duty Zombies mode, Deadpool in various Marvel Comics media, and the Penguin in the Batman: Arkham franchise.\n\nIn addition to his voice acting work, North has also appeared in several live-action television shows and films, including The X-Files, CSI: Miami, and The Penguins of Madagascar.\n\nNorth is 6 feet tall.', 26179200, 'New Haven, Connecticut, USA', '19508', 'nolan-north', 'upload/images/gb499KZIoBTZnKCGKE4zwzlcfSe.jpg'),
(677, 'actor', 'Stephanie Lemelin', 'Stephanie Lemelin is an American actress and comedienne. She is best known for voicing Artemis Crock on Young Justice, Eep on Dawn of the Croods and Audrey on Harvey Girls Forever!.', 299462400, 'Sewell, Mantua Township, New Jersey, USA', '222139', 'stephanie-lemelin', 'upload/images/of3XWkT2XPgci18PMIQd6Ozzrm.jpg'),
(678, 'actor', 'Khary Payton', 'Khary Payton (born May 16, 1972 in Augusta, Georgia) is an American actor and voice actor best known for playing Cyborg in the Teen Titans animated series and the upcoming Online video Game: DC Universe Online. In the cartoon series Justice League, Payton provided the voice of the villain Ten (from the Royal Flush Gang). He also provided the voice of Drebin in the game Metal Gear Solid 4: Guns of the Patriots.\n\nCurrently, he appears on a recurring basis as Dr. Terrell Jackson on the ABC daytime soap opera General Hospital.\n\nDescription above from the Wikipedia article Khary Payton, licensed under CC-BY-SA, full list of contributors on Wikipedia​', 74822400, 'Augusta, Georgia, US', '65640', 'khary-payton', 'upload/images/4PgEGuAb2KkaRb7P9PdK40pPeVH.jpg'),
(679, 'actor', 'Danica McKellar', '​From Wikipedia, the free encyclopedia.  \n\nDanica Mae McKellar (born January 3, 1975) is an American actress, author, and education advocate. She is best known for her role as Winnie Cooper in the television show The Wonder Years, and later as author of the three The New York Times bestsellers, Math Doesn\\\'t Suck, Kiss My Math, and Hot X: Algebra Exposed, which encourage middle-school girls to have confidence and succeed in mathematics.\n\nDescription above from the Wikipedia article Danica McKellar, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 157939200, 'La Jolla, California, USA', '65220', 'danica-mckellar', 'upload/images/qVasJ8uKtvrntIXaPylneLW3ykf.jpg'),
(680, 'actor', 'Jesse McCartney', 'Jesse McCartney (born April 10, 1987) is an American singer-songwriter and voice actor. McCartney achieved fame in late 1990s on the soap opera All My Children as JR Chandler, then later joined boy band Dream Street. He branched into a solo career, having appeared in the television series Summerland and as a recurring character in the ABC Family series Greek.', 544924800, 'Ardsley, New York, United States', '49915', 'jesse-mccartney', 'upload/images/95f7jVXUwkHUUfj3AjvTJYx3pei.jpg'),
(681, 'actor', 'Greg Cipes', 'Gregory Michael Cipes (born January 4, 1980) is an American voice and film actor. He is also a singer, musician, composer, and professional surfer.\n\nDescription above from the Wikipedia article Greg Cipes, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 315792000, 'Coral Springs, Florida, USA', '60227', 'greg-cipes', 'upload/images/vw9HrluWIc2HmQ3sCmpEyXB7xQP.jpg'),
(682, 'actor', 'Jason Spisak', 'Jason Spisak was born on August 29, 1973 in Wilkes-Barre, Pennsylvania, USA. He is an actor and producer, known for Young Justice (2010), Time Lapse (2014) and Everything Must Go (2010). He is married to Amber Lynn Myers. They have two children.', 115430400, 'Wilkes Barre, Pennsylvania, USA', '216973', 'jason-spisak', 'upload/images/yWxJDXNcocccr1LkEuVXapVdcXS.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(683, 'actor', 'Zehra Fazal', '', 462499200, 'Libertyville, Illinois, USA', '2222440', 'zehra-fazal', 'upload/images/gEL0hqxcckQth8ogIEByxirXa7f.jpg'),
(684, 'actor', 'Troy Baker', 'Troy Baker was born on April 1, 1976 in Dallas, Texas, USA as Troy Edward Baker. He is known for his work on The Last of Us (2013), BioShock Infinite (2013) and Batman: Arkham Knight (2015). He has been married to Pamela Walworth since October 13, 2012. He was previously married to Kimberly Beck.', 197164800, 'Dallas, Texas, USA', '963818', 'troy-baker', 'upload/images/k3eNrfCd6tEH7RKDwn6ZUpmjMnf.jpg'),
(685, 'actor', 'Lacey Chabert', 'Lacey Nicole Chabert (born September 30, 1982) is an American actress, voice actress and singer. She first gained prominence as a child actress for her role as Claudia Salinger in the television drama Party of Five (1994–2000). She has also provided the voice of Eliza Thornberry in the animated series The Wild Thornberrys (1998–2004) and two feature films, Meg Griffin during the first production season of the animated sitcom Family Guy, and superheroine Zatanna Zatara in various pieces of DC Comics-related media. In film she has appeared in Lost in Space (1998), Not Another Teen Movie (2001), Daddy Day Care (2003) and had leading roles as Gretchen Wieners in Mean Girls (2004), and as Dana Mathis in the horror remake Black Christmas (2006).', 402192000, 'Purvis, Mississippi, USA', '22082', 'lacey-chabert', 'upload/images/s4gEejBUkJPwdSezGlIpFXeidKD.jpg'),
(686, 'actor', 'Denise Boutte', 'Denise Boutte is an American actress, who has appeared in the films Why Did I Get Married? as Trina, Death Valley: The Revenge of Bloody Bill, as Mandy, and Sister\\\'s Keeper. She stars in the sitcom Meet the Browns as Sasha Brown.', 380246400, 'Maurice, Louisiana, USA', '43946', 'denise-boutte', 'upload/images/xDStDy0ecMRy76CWOdWj90oRIEz.jpg'),
(687, 'actor', 'Eric Lopez', '', 261878400, 'Havana, Cuba', '184082', 'eric-lopez', 'upload/images/4J97E27McuNTWQBWuUvnJwbJEqH.jpg'),
(688, 'actor', 'Kevin Michael Richardson', 'Kevin Michael Richardson (born October 25, 1964) is an American actor and voice artist who currently stars in The Cleveland Show. He is also well known for being the voice of Tartarus in the video game Halo 2.\n\nDescription above from the Wikipedia article Kevin Michael Richardson, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -163641600, 'The Bronx, New York, USA', '24362', 'kevin-michael-richardson', 'upload/images/xXt9Nh7RAT5bOen66TaXreNYmCl.jpg'),
(689, 'actor', 'Bruce Greenwood', 'Stuart Bruce Greenwood (born August 12, 1956) is a Canadian actor and producer. He is known for his role as the American president John F. Kennedy in Thirteen Days, for which he won the Satellite Award for Best Supporting Actor – Motion Picture, and as Captain Christopher Pike in J.J. Abrams\\\'s Star Trek movie reboot series. He has been nominated for three Canadian Screen Awards, once for Best Actor (for Elephant Song) and twice for Best Supporting Actor (for The Sweet Hereafter and Being Julia).\n\nHe is known for his roles as Nick Parsons in Double Jeopardy, Stuart Ramsey in Passenger 57, Bob Andrews in Father\\\'s Day, Earl Cavanaugh in Here on Earth, National Security Advisor Bill Sokal in Rules of Engagement, JFK in Thirteen Days, Anthony \\\'Tony\\\' Leighton in Swept Away, Cmdr. Robert Iverson in The Core; Lt. Bennie Macko in Hollywood Homicide, Lawrence Robertson in I, Robot, Lord Charles in Being Julia, Nolan Walsh in Racing Stripes, Jack Dunphy (Truman Capote\\\'s lover) in Capote; Hugh Sullivan in The Mermaid Chair, Professor Davis McClaren in Eight Below, Jack McCready in Deja Vu, Keenan Jones / Garrett in I\\\'m Not There, the President in National Treasure: Book of Secrets, Christopher Pike in Star Trek and its sequel Star Trek Into Darkness, George McCray in A Dog Named Christmas, Lance Fender in Dinner for Schmucks, Stephen Meek in Meek\\\'s Cutoff, Cooper in Super 8, Bill Kill Cullen in The Place Beyond the Pines, Charlie Anderson in Flight, Hugh Butterfield in Endless Love, Vince in The Captive, Andrew Heyward in Truth (2015), Dr. Jake Houseman in the TV movie version of Dirty Dancing (2017), Uncle Dean in Kodachrome, the US President in Kingsman: The Golden Circle, Gerald in Gerald\\\'s Game, Robert McNamara in The Post, and Dr. John Dalton in Doctor Sleep.\n\nHis best known TV roles are as Dr. Randolph Bell on The Resident, Gil Garcetti on American Crime Story, Emmet Cole on The River, Mitch Yost on John from Cincinnati, Dr. Nathan Bradford on Sleepwalkers, Thomas Veil on Nowhere Man, Jack Gage on Legmen, Pierce Lawton on Knot\\\'s Landing, and Dr. Seth Griffin on St. Elsewhere.\n\nHe has voiced Bruce Wayne / Batman in the animated series Young Justice and in several Batman cartoon videos, and voiced Chiron in the animated series Class Titans.', -422496000, 'Noranda, Québec, Canada', '21089', 'bruce-greenwood', 'upload/images/rVpyddWneBBYYzYhMRmWoHMg3Hg.jpg'),
(690, 'actor', 'Phil LaMarr', 'Phillip \\\"Phil\\\" LaMarr (born January 24, 1967) is an American actor, comedian and voice actor. One of the original cast members on the sketch comedy series MADtv, he is also known for his voice acting on the animated series Futurama, Static Shock, Samurai Jack, Justice League, Justice League Unlimited, Star Wars: Knights of the Old Republic II The Sith Lords, Star Wars: The Clone Wars, Metal Gear Solid 2: Sons of Liberty, Metal Gear Solid 4: Guns of the Patriots, and inFAMOUS.', -92707200, 'Los Angeles, California, USA', '31549', 'phil-lamarr', 'upload/images/l5w0qABfsFBxjfWNnpFiaXnh4Nm.jpg'),
(691, 'actor', 'Crispin Freeman', 'Crispin Freeman (born February 9, 1972) is an American voice actor, ADR director and writer who provides voices for English versions of Japanese anime, animation and video games. In anime, some of his prominent roles include Zelgadis Graywords in Slayers, Kyon in The Melancholy of Haruhi Suzumiya, Alucard in Hellsing, Kirei Kotomine in Fate/Zero and Fate/stay night: Unlimited Blade Works, Itachi Uchiha in Naruto, and Shizuo Heiwajima in Durarara!!.', 66441600, 'Chicago, Illinois, USA', '75039', 'crispin-freeman', 'upload/images/rOnOnBVr0EI1YOawxyQsTDwh8tI.jpg'),
(692, 'actor', 'Grey DeLisle', 'Grey DeLisle (born August 24, 1973), sometimes credited as Grey Griffin, is an American voice actress, comedian and singer-songwriter. DeLisle is known for various roles in animated productions and video games. On September 27, 2018, she released her debut comedy act, titled \\\"My First Comedy Special\\\".\n\nOn November 10, 2019, The Simpsons producers announced that DeLisle would replace Russi Taylor as the voice of Martin Prince and Sherri and Terri, after Taylor\\\'s death in July 2019.\n\nDescription above from the Wikipedia article Grey DeLisle, licensed under CC-BY-SA, full list of contributors on Wikipedia .', 114998400, 'Fort Ord, California, USA', '15761', 'grey-delisle', 'upload/images/vrUHaXe1pG56yZkgH7Hs3LGRLTT.jpg'),
(693, 'actor', 'Masasa Moyo', '', 1900800, 'London, Ontario, Canada', '34520', 'masasa-moyo', 'upload/images/9TvAkxkLGsnREVqzg7JRHtSVzZW.jpg'),
(694, 'actor', 'Yuri Lowenthal', 'Yuri Lowenthal (born March 5, 1971; Alliance, Ohio) is a voice actor that has voiced several anime and video game characters. He also voiced Kamal for the alternate reality game I Love Bees.\n\nHe is best friends with Doug Erholtz. He is married to fellow voice actress Tara Platt. He graduated from The College of William & Mary in Williamsburg, Virginia.\n\nLowenthal co-founded Monkey Kingdom Productions with partner Tara Platt in 2004. Monkey Kingdom Productions is an independent film production company, currently producing Lowenthal\\\'s Tumbling After. In 2007 Yuri Lowenthal and Tara Platt provided their voices for Shin Megami Tensei: Persona 3 and also for Shin Megami Tensei: Persona 4.\n\nIn the anime industry, he is most known for his roles as Sasuke Uchiha, in Naruto, Suzaku Kururugi in Code Geass, Simon in Gurren Lagann and Jinnosuke/\\\"Kuma\\\" in Afro Samurai and its sequel.\n\nIn the video gaming world, he is well known to be the voice of the Prince of Persia in several of Ubi Soft\\\'s games, including The Sands of Time, The Forgotten Sands, and The Two Thrones. Although he does not provide the voice of the Prince in Warrior Within.\n\nHe also provides the voice of Cecil Harvey in the Nintendo DS remake of Final Fantasy IV, and again in Dissidia: Final Fantasy on the PSP. He is also the voice of Ben Tennyson from Ben 10: Alien Force and Ben 10: Ultimate Alien.\n\nYuri Lowenthal and Tara Platt also co-authored a new book on voice-over called Voice-Over Voice Actor: What It\\\'s Like Behind the Mic. It is available through Bug Bot Press and Emerald Book Company.\n\nHe is also a frequent guest at the San Diego Comic-Con International.\n\nDescription above from the Wikipedia article Yuri Lowenthal, licensed under CC-BY-SA,full list of contributors on Wikipedia.', 36979200, 'Alliance, Ohio, USA', '127387', 'yuri-lowenthal', 'upload/images/aLgXm0kbbIC8I5OBmnsK8TgVKwy.jpg'),
(695, 'actor', 'Jason Marsden', 'Jason Marsden (born January 3, 1975) is an American screen and voice actor.', 157939200, 'Providence, Rhode Island, USA', '61983', 'jason-marsden', 'upload/images/3SR5TiCuTLebP00LTTQwDUSP14s.jpg'),
(696, 'actor', 'Vanessa Marshall', 'Vanessa Marshall (born October 19, 1969 in Los Angeles, California, U.S.) is an American voice and television actress who is most active in films, cartoons and video games. She is the daughter of actress Joan Van Ark and reporter John Marshall.', -6393600, 'Los Angeles, California, USA', '81663', 'vanessa-marshall', 'upload/images/yZsWfaiOxaN5MZkWIKPbxz1KKS1.jpg'),
(697, 'director', 'Christopher Berkeley', '', NULL, 'United States of America', '209181', 'christopher-berkeley', NULL),
(698, 'director', 'Vinton Heuck', '', NULL, '', '1316466', 'vinton-heuck', NULL),
(699, 'director', 'Melchior Zwyer', '', NULL, '', '1637778', 'melchior-zwyer', NULL),
(700, 'director', 'Jay Oliva', 'From Wikipedia, the free encyclopedia.\n\nJay Oliva is an American storyboard artist, a film producer and animated film director working for Warner Brothers Animation.\n\nDescription above from the Wikipedia Jay Oliva licensed under CC-BY-SA, full list of contributors on Wikipedia.', NULL, '', '105643', 'jay-oliva', 'upload/images/y7EbnuoKFMvU7uZ4aD50jThyNoF.jpg'),
(701, 'director', 'Michael Chang', '', 67564800, 'Hoboken, New Jersey, USA', '127380', 'michael-chang', NULL),
(702, 'director', 'Christina Sotta', 'Christina Sotta is a storyboard artist and director, known for directing Justice League Dark: Apokolips War (2020), Scooby Doo! The Sword and the Scooby (2021), as well as two episodes of Harley Quinn.', NULL, '', '2579481', 'christina-sotta', NULL),
(703, 'director', 'Tim Divar', '', NULL, '', '1659481', 'tim-divar', NULL),
(704, 'director', 'Doug Murphy', '', NULL, '', '1227608', 'doug-murphy', NULL),
(705, 'director', 'Matt Youngberg', 'Matthew Youngberg (born February 17, 1977) is an American writer, animator, storyboard artist, director, and producer, who is best known as co-creator of DuckTales (2017) alongside Francisco Angones.\n\nPrior to DuckTales (2017), Youngberg had worked on Warner Bros. Animation series based on DC superheroes starting with Batman Beyond as a storyboard artist before rising up as a director on Teen Titans and The Batman. Youngberg continued working on superhero action based shows when moving to Cartoon Network as a director on Ben 10: Ultimate Alien and supervising producer on Ben 10: Omniverse and Transformers: Animated. He also directed the Skydance Animation short film Bad Luck Spot! (2023).', 224985600, '', '127382', 'matt-youngberg', 'upload/images/ea3qDvf5jtt5r05iLCvn2i9Sa8P.jpg'),
(706, 'director', 'Sam Liu', 'From Wikipedia, the free encyclopedia.\n\nSam Liu is an American animation director and storyboard artist. He is best know for his directing on animated superhero films at both Marvel Entertainment and Warner Bros. Animation. Titles include All-Star Superman, Superman/Batman:Public Enemies, Hulk Vs, Planet Hulk, Thor: Son of Asgard and co-directing with Lauren Montgomery on Justice League: Crisis on Two Earths and Batman:Year One.\n\nAfter studying at Art Center College of Design as an Illustration major , Sam went into comic books drawing for Image Comics. He then moved to animation, directing on Roughnecks: Starship Troopers Chronicles and Godzilla: The Series for Sony Animation. He later went to Sony Computer Entertainment of America to design characters for PlayStation then came back to animation, winning an Emmy  for his work on The Batman (TV series) in 2006.  Sam has since worked on many animated movies for Marvel Entertainment and Warner Bros. Animation and is currently directing on the upcoming Green Lantern animated series with Bruce Timm.\n\nDescription above from the Wikipedia article Sam liu, licensed under CC-BY-SA, full list of contributors on Wikipedia .', NULL, '', '90367', 'sam-liu', 'upload/images/3u01dPeS4Us9sUFzwS8DzjA3udr.jpg'),
(707, 'director', 'Victor Cook', '', NULL, '', '56851', 'victor-cook', 'upload/images/wGVULDUmlIzlBc8s37xyLQU39Ah.jpg'),
(708, 'director', 'Lauren Montgomery', 'From Wikipedia, the free encyclopedia.\n\nLauren Montgomery is a film animation director and storyboard artist.  She is noted for her storyboard work for animated television and DVD movie features. She has directed the Wonder Woman animated film of the same name, Green Lantern: First Flight, Justice League: Crisis on Two Earths (with Sam Liu) and Superman/Batman: Apocalypse.\n\nDescription above from the Wikipedia article Lauren Montgomery, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 326246400, ' Los Angeles, California, U.S.', '74863', 'lauren-montgomery', 'upload/images/vYgnYprzvl7sP6mcoxAhm66GneE.jpg'),
(709, 'actor', 'Gordon Cormier', 'Canadian actor famous for his roles in The Stand, Lost in Space and Two Sentence Horror Stories. In 2021, he was cast to play Aang in the live-action version of Avatar: The Last Airbender.', 1255046400, '', '2447707', 'gordon-cormier', 'upload/images/6WBCyXtoqvRLicpCnj4If8AYBS5.jpg'),
(710, 'actor', 'Kiawentiio', 'Television actress best recognized for her role as Ka\\\'kwet on the series Anne with an E. She is also an artist and shares her paintings and drawings through Instagram for her over 120,000 followers.', 1146182400, 'Akwesasne, Ontario, Canada', '2718335', 'kiawentiio', 'upload/images/zlJj19IMzPE5ljWB3b4u0TP3t7x.jpg'),
(711, 'actor', 'Ian Ousley', 'Ian Ousley is a professional actor, who is best known for his recurring role of Robby Corman on Netflix’s 13 Reasons Why.  Also, he played the character of Jeremy in the popular television series Young Sheldon. In 2019, he essayed the role of Brayden in the show, Sorry for Your Loss.  Aside from being an actor, Ousley is a trained Taekwondo player. He has competed in several Taekwondo championships during his high school days.', 1017273600, 'College Station, Texas, USA', '2595507', 'ian-ousley', 'upload/images/r9Yg0iVUtk5vXlEH8Psy52A7fLf.jpg'),
(712, 'actor', 'Dallas Liu', 'Chinese-Indonesian actor well-known for his portrayal of Shuji Ishii-Peters in the Hulu comedy series PEN15. He was also featured in the show Legendary Dudas and portrayed young Jin Kazama in the Tekken film franchise.', 998352000, 'Jakarta, Indonesia', '1792920', 'dallas-liu', 'upload/images/aismdzGeONTJHiPfofNaKGZSKZu.jpg'),
(713, 'actor', 'Daniel Dae Kim', 'Daniel Dae Kim (born August 4, 1968) is a South Korean-American actor, best known for his roles as Chin Ho Kelly in Hawaii Five-0 and Jin-Soo Kwon in Lost.\n\nDescription above from the Wikipedia article Daniel Dae Kim, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -44496000, 'Busan, South Korea', '18307', 'daniel-dae-kim', 'upload/images/aXbTKgL4u6oVumQ459B9VkGTn4A.jpg'),
(714, 'actor', 'Paul Sun-Hyung Lee', '', 82771200, 'Daejeon, South Korea', '178068', 'paul-sun-hyung-lee', 'upload/images/9NfgxUhz0O2rsQk89aSCYDi1uoB.jpg'),
(715, 'actor', 'Elizabeth Yu', 'Elizabeth Yu is an up and coming actress from New Jersey, New York. She started acting in elementary school and later continued her passion throughout high school.\n\nYu has been acting professionally for the past two years and has already racked up a couple of acting credits to her name like Netflix\\\'s Avatar : The Last Airbender Live Action adaptation .', 1033862400, 'Mystic Island,New Jersey, United States', '3417134', 'elizabeth-yu', 'upload/images/1b5kmylrUqST2BgyD5wD5MBQNgE.jpg'),
(716, 'actor', 'Ken Leung', 'Kenneth \\\"Ken\\\" Leung (born January 21, 1970) is an American actor best known for his role as Miles Straume in the ABC television series Lost and roles in such films as Shanghai Kiss, Rush Hour, X-Men: The Last Stand, and Saw.\n\n​From Wikipedia, the free encyclopedia', 1728000, 'New York City, New York, USA', '2131', 'ken-leung', 'upload/images/hpatUP6u74gkpDRmn9voNY9V43O.jpg'),
(717, 'actor', 'Lim Kay Siu', '', -310608000, 'Singapore', '17155', 'lim-kay-siu', 'upload/images/amv2AtC5YBXxiK7HPHGDCpk9cDZ.jpg'),
(718, 'actor', 'Tamlyn Tomita', 'Tamlyn Naomi Tomita (born January 27, 1966) is a Japanese American actress, who has appeared in many Hollywood films and television series.', -123984000, 'Okinawa, Japan', '3134', 'tamlyn-tomita', 'upload/images/rmlZGE8f18Fxpgd9AlOko8cK074.jpg'),
(719, 'actor', 'Maria Zhang', 'Maria Zhang is an actress, known for All I Ever Wanted, Continuum (2018) and WorkInProgress: A ...', 616550400, '', '3320666', 'maria-zhang', 'upload/images/A8l9dWZH1oSBag58GfbFAT8wfB8.jpg'),
(720, 'actor', 'Yvonne Chapman', '', NULL, '', '2225815', 'yvonne-chapman', 'upload/images/rDbiwuGvzd8WOgyQNo5RTmbwvF1.jpg'),
(721, 'actor', 'Casey Camp-Horinek', '', NULL, '', '1052618', 'casey-camp-horinek', 'upload/images/roPy4mfbGqTYXwTX76zv6XFQsdG.jpg'),
(722, 'actor', 'Bryan Cranston', 'Bryan Lee Cranston (born March 7, 1956) is an American actor, director, and producer who is mainly known for portraying Walter White in the AMC crime drama series Breaking Bad (2008–2013) and Hal in the Fox sitcom Malcolm in the Middle (2000–2006). He has received a number of awards—including six Primetime Emmy Awards, four Screen Actors Guild Awards, two Tony Awards, and a Golden Globe Award—with a nomination for an Academy Award and a BAFTA Award.\n\nBryan Cranston\\\'s performance on Breaking Bad earned him the Primetime Emmy Award for Outstanding Lead Actor in a Drama Series four times (2008, 2009, 2010, and 2014). After becoming a producer of the show in 2011, he also won the award for Outstanding Drama Series twice. Breaking Bad also earned Cranston five Golden Globe nominations (with one win) and nine Screen Actors Guild Award nominations (with four wins). He was previously nominated three times for Outstanding Supporting Actor in a Comedy Series for his role in Malcolm in the Middle. Cranston co-developed and occasionally appeared in the crime drama series Sneaky Pete (2015–2019) and served as a director for episodes of Malcolm in the Middle, Breaking Bad, Modern Family, and The Office.\n\nIn 2014, Cranston earned a Tony Award for Best Actor in a Play for his portrayal of President Lyndon B. Johnson in the Broadway play All the Way, a role he reprised in the HBO 2016 television film of the same name. In 2018, he received the Laurence Olivier Award for Best Actor in a Play for his portrayal of Howard Beale in the play Network at London\\\'s National Theatre, later winning his second Tony Award for Best Actor in a Play for the same role on Broadway. For portraying Dalton Trumbo in the film Trumbo (2015), he received nominations for an Academy Award, a BAFTA Award, a Screen Actors Guild Award and a Golden Globe Award, all for Best Actor in a Leading Role.\n\nCranston has appeared in several other films, such as Saving Private Ryan (1998), Little Miss Sunshine (2006), Drive (2011), Argo (2012), Godzilla (2014), and The Upside (2017). He also provided voice acting in the films Madagascar 3: Europe\\\'s Most Wanted (2012), Kung Fu Panda 3 (2016), and Isle of Dogs (2018).', -436147200, 'Hollywood, Los Angeles, California, USA', '17419', 'bryan-cranston', 'upload/images/7Jahy5LZX2Fo8fGJltMreAI49hC.jpg'),
(723, 'actor', 'Dean Norris', 'Dean Joseph Norris (born April 8, 1963 height 5\\\' 7\\\" (1,70 m)) is an American actor, best known for portraying DEA agent Hank Schrader on the AMC series Breaking Bad (2008–2013) and town selectman James \\\"Big Jim\\\" Rennie on the CBS series Under the Dome (2013–present). He has also appeared in films such as Lethal Weapon 2 (1989), Total Recall (1990), Terminator 2: Judgment Day (1991), Starship Troopers (1997), Little Miss Sunshine (2006), and Evan Almighty (2007).\n\nNorris was born in South Bend, Indiana, to Jack, a furniture store owner, and Rosie Norris. He has four sisters. Norris graduated from Clay High School in 1981, where he says he got straight A\\\'s. He is a 1985 graduate of Harvard College, where he majored in social studies. He also attended the Royal Academy of Dramatic Art.', -212544000, 'South Bend, Indiana, USA', '14329', 'dean-norris', 'upload/images/rHQqo9toD7fgE6HvfJ7oymdY6YO.jpg'),
(724, 'actor', 'Betsy Brandt', 'Betsy Ann Brandt is an American actress. She portrayed Marie Schrader in Breaking Bad (2008–2013) and played Heather Hughes in the CBS sitcom Life in Pieces (2015–2019).', 100915200, 'Bay City, Michigan, USA', '1217934', 'betsy-brandt', 'upload/images/kIbVUpGfLAF1KMn1YvWPnc12DRP.jpg'),
(725, 'actor', 'Aaron Paul', 'Aaron Paul Sturtevant (born August 27, 1979) is an American actor. He is best known for his critically acclaimed role as Jesse Pinkman in the hit AMC series Breaking Bad (2008–13). For his portrayal of Jesse Pinkman, he won the Primetime Emmy Award for Outstanding Supporting Actor in a Drama Series in 2010 and 2012, making him one of five actors to win this award more than once. He also won the Saturn Award for Best Supporting Actor on Television in 2010, 2012, and 2014, making him the only actor to win this award three times.', 304560000, 'Emmett, Idaho, USA', '84497', 'aaron-paul', 'upload/images/8Ac9uuoYwZoYVAIJfRLzzLsGGJn.jpg'),
(726, 'actor', 'Anna Gunn', 'Anna Gunn (born August 11, 1968) is an American actress, best known for her roles as ADA Jean Ward on The Practice, Martha Bullock on Deadwood, and Skyler White on Breaking Bad.', -43891200, 'Cleveland, Ohio, USA', '134531', 'anna-gunn', 'upload/images/adppyeu1a4REN3khtgmXusrapFi.jpg'),
(727, 'actor', 'RJ Mitte', 'Roy Frank “RJ” Mitte III (born August 21, 1992) is an American actor best known for his role as Walter White Jr. on the AMC television series, Breaking Bad.\n\nMitte moved to Hollywood in 2006, and began training with personal talent manager Addison Witt. Mitte has mild cerebral palsy. His manager states that it was Mitte\\\'s diligence and attitude that has helped him overcome challenges in all areas of his life.\n\nDescription above from the Wikipedia article RJ Mitte, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 714355200, 'Lafayette, Louisiana, USA', '209674', 'rj-mitte', 'upload/images/aG6NYV2EgzBFLRIl7vvbtd7go1j.jpg'),
(728, 'actor', 'Bob Odenkirk', 'Robert John Odenkirk (born October 22, 1962) is an American actor, comedian, and filmmaker best known for his role as Saul Goodman on Breaking Bad (2008–2013) and its spin-off Better Call Saul (2015–2022). For the latter, he has received five nominations for Primetime Emmy Award for Outstanding Lead Actor in a Drama Series. As a producer on Better Call Saul since its premiere, he has also received six nominations for Primetime Emmy Award for Outstanding Drama Series. He is also known for the HBO sketch comedy series Mr. Show with Bob and David (1995–1998), which he co-created and co-starred in with fellow comic David Cross. In 2015, he and Cross reunited, along with the rest of the Mr. Show cast, for W/ Bob & David on Netflix.\n\nOdenkirk wrote for television series Saturday Night Live (1987–1991) and The Ben Stiller Show (1992), winning Emmy Award for Outstanding Writing for a Variety Series in 1989 and 1993. He also wrote for Late Night with Conan O\\\'Brien (1993–1994) and acted in a recurring role as Agent Stevie Grant in The Larry Sanders Show (1993–1998). In the early 2000s, Odenkirk discovered the comedy duo Tim & Eric. He produced their television series Tom Goes to the Mayor (2004–2006) and Tim and Eric Awesome Show, Great Job! (2007–2010). His feature directorial credits include the films Melvin Goes to Dinner (2003), Let\\\'s Go to Prison (2006), and The Brothers Solomon (2007).\n\nThe success of Breaking Bad and Better Call Saul led to acting work in high-profile projects such as Nebraska (2013), the first season of Fargo (2014), Steven Spielberg\\\'s The Post (2017), Pixar\\\'s Incredibles 2 (2018), Little Women (2019) and, as the lead, the action film Nobody (2021), which he also produced.\n\nDescription above from the Wikipedia article Bob Odenkirk, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -227059200, 'Berwyn, Illinois, USA', '59410', 'bob-odenkirk', 'upload/images/rF0Lb6SBhGSTvjRffmlKRSeI3jE.jpg'),
(729, 'actor', 'Jonathan Banks', 'Jonathan Banks (born January 31, 1947) is an American character actor in film and television.\n\nBanks dropped out of Indiana University to join a touring company as a stage manager. He went to Australia with the company and stayed on working in theatre there. In 1974, he moved to Los Angeles and performed on stage before picking up bit parts on television. Probably his best-known movie roles are in two films starring Eddie Murphy: 48 Hrs. and Beverly Hills Cop. In 48 Hrs. he plays a character who is a friend of the lead and is killed by the villain, beginning the lead characters\\\' story. In Beverly Hills Cop, he plays a villain who kills the lead characters\\\' friend and begins his story. Other movie roles include appearances in Armed and Dangerous, Freejack, Flipper, Airplane!, Gremlins, Murder Me, Murder You, and Under Siege 2: Dark Territory.\n\nHis biggest break on television, came with the series Wiseguy, in which he played Frank McPike for four years, a role which led to an Emmy award nomination. Although his character was primarily the hero\\\'s mentor, stories occasionally featured McPike as hero. In 1981 he appeared as Dutch Schultz on the NBC series the Gangster Chronicles. He also starred on the short-lived science fiction TV series Otherworld, as Kommander Neveen Kroll and in the sitcom Fired Up.\n\nBanks has also made guest appearances on TV shows including Alias, CSI, Day Break, Highlander: The Series, Matlock, SeaQuest DSV, Star Trek: Deep Space Nine, Women of the House and Walker Texas Ranger. Most recently, Banks appeared in the final Season Two episodes of Dexter, and in episodes of ER, Cold Case, and Shark, Modern Family. In the second season finale of Breaking Bad, Banks appeared as a mysterious character named Mike. Banks was made a series regular for the third season.', -723254400, 'Washington, D.C., USA', '783', 'jonathan-banks', 'upload/images/lIZZPQLEstz7DkETN4Q9fHp7jjV.jpg'),
(730, 'actor', 'Steven Michael Quezada', 'Steven Michael Quezada; born February 15, 1963 is an American actor and politician. He played Drug Enforcement Administration agent Steven Gomez in the AMC series Breaking Bad from 2008 to 2013.', -217036800, '', '61535', 'steven-michael-quezada', 'upload/images/pVYrDkwI6GWvCNL2kJhpDJfBFyd.jpg'),
(731, 'actor', 'Giancarlo Esposito', 'Giancarlo Giuseppe Alessandro Esposito (born April 26, 1958) is an American actor. He is best known for portraying Gus Fring in the AMC crime drama series Breaking Bad (2009–2011) and the prequel series Better Call Saul (2017–2022). For this role he won the Critics\\\' Choice Television Award for Best Supporting Actor in a Drama Series and earned three nominations for the Primetime Emmy Award for Outstanding Supporting Actor in a Drama Series.\n\nEsposito\\\'s other television roles include Federal Agent Mike Giardello in the NBC police drama series Homicide: Life on the Street (1998–1999), Sidney Glass / Magic Mirror in the ABC supernatural drama series Once Upon a Time (2011–2017), Tom Neville in the NBC science fiction series Revolution (2012–2014), Dr. Edward Ruskins in the Netflix comedy-drama series Dear White People (2017–present), Stan Edgar in the Amazon Prime Video superhero drama series The Boys (2019–present), and Moff Gideon in the Disney+ space western drama series The Mandalorian (2019–present), the lattermost of which earned him two Primetime Emmy Award nominations. He also portrayed American Baptist pastor and politician Adam Clayton Powell Jr. in the TV series Godfather of Harlem (2019–present). Esposito also portrays Antón Castillo, the main antagonist of the video game Far Cry 6, released in 2021.\n\nHe is also known for his appearances in several Spike Lee films, such as School Daze (1988), Do the Right Thing (1989), Mo\\\' Better Blues (1990), and Malcolm X (1992). Esposito\\\'s other major films include Taps (1981), King of New York (1990), Harley Davidson and the Marlboro Man (1991), Fresh (1994), The Usual Suspects (1995), Ali (2001), Last Holiday (2006), Gospel Hill (2008), Rabbit Hole (2010), Maze Runner: The Scorch Trials (2015), The Jungle Book (2016), Money Monster (2016), Okja (2017), Maze Runner: The Death Cure (2018), and Stargirl (2020).', -368755200, 'Copenhagen, Denmark', '4808', 'giancarlo-esposito', 'upload/images/lBvDQZjxhIGMbH61iHnqerpbqHc.jpg'),
(732, 'actor', 'Charles Baker', 'Charles Edward Baker (born February 27, 1971) is an American actor, writer, and director. He played Skinny Pete on the AMC series Breaking Bad, and had a recurring role on the NBC series The Blacklist.', 36460800, 'Washington, District of Columbia, USA', '82945', 'charles-baker', 'upload/images/mhSoY1plaop5eufoHDP4fkIGUfh.jpg'),
(733, 'actor', 'Christopher Cousins', 'Christopher Maher Cousins (born September 27, 1960) is an American actor who has been acting in television since 1986. He is best known for playing conman Cain Rogan in forty-one episodes of the soap opera One Life to Live. Between 2009 and 2012, he played Ted Beneke in thirteen episodes of the AMC series Breaking Bad. In 2013 and 2014, he played Victor Doyle in seven episodes of the NBC series Revolution.', -292291200, 'New York City, New York, USA', '20379', 'christopher-cousins', 'upload/images/9fmoeZLGbJfiYU6mIbrUkjF9wsR.jpg'),
(734, 'actor', 'Matt Jones', 'Matthew Lee Jones (born November 1, 1981) is an American actor, voice actor and comedian. He is known for his roles as Douglas on Bob Hearts Abishola, Baxter on the CBS sitcom Mom, Special Agent Ned Dornaget on NCIS, and Brandon \\\"Badger\\\" Mayhew on the AMC series Breaking Bad.\n\nHe also voices the animated characters of Dave on Hamster & Gretel, Kyle in the movie Home and animated series Home: Adventures with Tip & Oh, Pig on Pig Goat Banana Cricket, Drip in the movies Planes: Fire & Rescue and Planes Fire & Rescue: Smokejumpers, and Gunther Magnuson on Kick Buttowski: Suburban Daredevil.', 373420800, 'Sacramento, California, USA', '191202', 'matt-jones', 'upload/images/uRLrrPJ5eKXIpJBwSJizezUZd4G.jpg'),
(735, 'actor', 'Michael Shamus Wiles', 'Michael Shamus Wiles (born October 27, 1955) is an American character actor of film and television onscreen since the 1980s who has appeared in over 100 films and television shows.\n\nHe portrayed Marc Mitscher in Pearl Harbor and Mr. Parmagi in Hellraiser: Inferno. He is also known for recurring roles as ASAC George Merkert on Breaking Bad and as Jury on Sons of Anarchy. Other notable appearances include Puppet Master 4, Lost Highway, Fight Club, Rock Star and Transformers. In 2011, he appeared in Rockstar Games hit detective game L.A. Noire as Fire Chief Albert Lynch. He appeared in a 2015 production of the Hydrogen Jukebox.', -447552000, 'Everett, Washington, USA', '9291', 'michael-shamus-wiles', 'upload/images/niY4gYqAUjmnU4KRiguxpsKliWA.jpg'),
(736, 'actor', 'Lavell Crawford', 'Lavell Maurice Crawford is an American comedian and actor. He is best known for playing Huell Babineaux in Breaking Bad and its spin-off Better Call Saul. He also played the role of Gus Patch in the Netflix original movie The Ridiculous 6.', -35942400, 'St. Louis, Missouri, USA', '564348', 'lavell-crawford', 'upload/images/mvDs3bWKicnC98nGJNqrm4NaALd.jpg'),
(737, 'actor', 'Ray Campbell', '', NULL, '', '159334', 'ray-campbell', 'upload/images/nbapP8LvO1KZrmlpNWthEP40H75.jpg'),
(738, 'actor', 'Tina Parker', 'Tina Parker is an American actress and director known for her role of Francesca Liddy, Saul Goodman\\\'s assistant on Breaking Bad and Better Call Saul.', NULL, '', '147085', 'tina-parker', 'upload/images/qa4BFhrCGQKwqdTgLJ8S2rr95hD.jpg'),
(739, 'actor', 'Carmen Serano', 'From Wikipedia, the free encyclopedia\n\nCarmen Serano (born Carmen Maria Robles; August 18, 1973) is a Hispanic American actress. She starred in the 2007 film Urban Justice alongside Steven Seagal. In 2008 she appeared in five episodes of the series, Breaking Bad.\n\nDescription above from the Wikipedia article Carmen Serano, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 114480000, 'Chula Vista, California, USA', '115688', 'carmen-serano', 'upload/images/nzJEe2UqvvMIBJZP1aeFEj4EunN.jpg'),
(740, 'actor', 'Emily Rios', 'From Wikipedia, the free encyclopedia.\n\nEmily Clara Rios (born April 27, 1989) is a Mexican American actress and model. She is best known for her role as Andrea Cantillo on the AMC series Breaking Bad.  From Wikipedia, the free encyclopedia\n\nEmily Clara Rios\n\n(born April 27, 1989) is a Mexican American actress and model. She is best known for her role as Andrea Cantillo on the AMC series Breaking Bad.\n\nEarly life\n\nRios was born in Los Angeles, California. She was raised as a Jehovah\\\'s Witness in El Monte, California.\n\nCareer\n\nRios was discovered during a day out at a shopping mall. She appeared in the 2005 short film For Them and the 2006 film Quinceañera. In 2008, she appeared in the independent film Vicious Circle. She has also had recurring roles in the television series Friday Night Lights, Men of a Certain Age, Breaking Bad, and The Bridge.', 609638400, 'Los Angeles, California, USA', '211474', 'emily-rios', 'upload/images/h8d9eg0wpyXcvJlunpZklh2asVY.jpg'),
(741, 'actor', 'Krysten Ritter', 'Krysten Alyce Ritter (born December 16, 1981) is an American actress, director, musician, author, and model. She came to prominence when she appeared as Jane Margolis in the AMC drama series Breaking Bad from 2009 to 2010. She then had the title (and lead) role in two series: Chloe in the ABC sitcom Don\\\'t Trust the B---- in Apartment 23 (2012–2013), and superhero Jessica Jones in the Netflix series Jessica Jones (2015–2019). She also appeared as Jessica Jones in the 2017 miniseries The Defenders, and reprised her role as Jane Margolis in the 2019 Breaking Bad spinoff TV film El Camino. Ritter also had a supporting role in the HBO miniseries Love & Death (2023).\n\nRitter has also appeared in the television series Veronica Mars, Gilmore Girls, \\\'Til Death and Gravity. She appeared in the films What Happens in Vegas (2008), Confessions of a Shopaholic (2009), She\\\'s Out of My League (2010), Veronica Mars (2014), Big Eyes (2014), and The Hero (2017).', 377308800, 'Bloomsburg, Pennsylvania, USA', '78080', 'krysten-ritter', 'upload/images/vDr20j128E6Uo1XZLChPoW7FbMG.jpg'),
(742, 'director', 'Adam Bernstein', 'From Wikipedia, the free encyclopedia\n\nAdam Bernstein (born May 7, 1960) is an American film director, music video director and television director. For his work on the television show Fargo in 2014, he received a nomination for the Primetime Emmy Award for Outstanding Directing for a Miniseries, Movie or a Dramatic Special. In 2007, he won a Primetime Emmy Award for Outstanding Comedy Series for his work on 30 Rock.', -304646400, 'Princeton, New Jersey, USA', '111338', 'adam-bernstein', 'upload/images/jtU4MFHJ1KBbMj77yhJ4Od3tpIr.jpg'),
(743, 'director', 'Colin Bucksey', '', -757382400, 'Camberwell, London, England, UK', '1212287', 'colin-bucksey', 'upload/images/apHHMfnkCVna1iYR3K5PA0TQ14D.jpg'),
(744, 'director', 'Michelle MacLaren', 'Michelle Maxwell MacLaren is a Canadian television director and producer who has worked on numerous series both in Canada and the United States, and is perhaps best known for her work on shows such as The X-Files, Breaking Bad and most recently Frank Darabont\\\'s acclaimed series The Walking Dead. She was recently nominated for two Primetime Emmy Awards; one for directing a season three episode of Breaking Bad entitled \\\"One Minute\\\" and the other for Outstanding Drama Series (Breaking Bad), on which she served as an co-executive producer.', -157766400, 'Vancouver, British Columbia, Canada', '29779', 'michelle-maclaren', 'upload/images/3LcH5eNiysMWaepARllVrS4Dzn7.jpg'),
(745, 'director', 'Scott Winant', '', NULL, '', '1214396', 'scott-winant', 'upload/images/6B7nTUfpOW714j6A1GO0obiggX7.jpg'),
(746, 'director', 'Tim Hunter', 'From Wikipedia, the free encyclopedia.\n\nTim Hunter (June 15, 1947 in Los Angeles, California) is an American television and film director. Since the late 1980s he has mostly worked on television, directing episodes for dozens of televisions series including Breaking Bad, Carnivàle, Chicago Hope, Crossing Jordan, Deadwood, Falcon Crest, Homicide: Life on the Street, House M.D., Law & Order, Lie to Me, Mad Men, and Twin Peaks. During the early-to-mid 1980s, Hunter directed feature films, including 1986\\\'s River\\\'s Edge, which won that year\\\'s award for best picture at the Independent Spirit Awards.', -711590400, 'Los Angeles, California, USA', '15858', 'tim-hunter', 'upload/images/n03G1gCKqxpi6udwINygNiLoGdn.jpg'),
(747, 'director', 'Félix Enríquez Alcalá', 'Félix Enríquez Alcalá is an American television and movie director, cinematographer, producer and painter. He graduated with a fine arts degree from SMU and followed that up by attending the Art Center School of Design, Los Angeles.', -594000000, 'Bakersfield, California, USA', '77211', 'félix-enríquez-alcalá', 'upload/images/rlnSbY7tueXmlyjI8St7ee1PniI.jpg'),
(748, 'director', 'Bronwen Hughes', 'Bronwen Hughes is a Canadian film director. She was born in Toronto.', NULL, '', '18320', 'bronwen-hughes', 'upload/images/6m7XiXVXyEaN81e4OyDfWxBpNov.jpg'),
(749, 'director', 'Phil Abraham', '', NULL, '', '1214445', 'phil-abraham', 'upload/images/kSFThx7LRAFjFPEMERR4O0kuGzf.jpg'),
(750, 'director', 'Jim McKay', 'Jim McKay is an American director, producer and writer for film and television.', -252460800, 'Englewood, New Jersey, USA', '205639', 'jim-mckay', 'upload/images/hrrBk9T8Ds0UH9NKds1gkbJioTo.jpg'),
(751, 'director', 'John Dahl', '​From Wikipedia, the free encyclopedia\n\nJohn Dahl (born 1956) is an American film director and screenwriter, best known for his work in the neo-noir genre.', -412041600, 'Billings, Montana, USA', '21053', 'john-dahl', 'upload/images/8WDCi9LJ9Lc7z6BSwGiQqfkSx61.jpg'),
(752, 'director', 'Peter Medak', 'From Wikipedia, the free encyclopedia.\n\nPeter Medak (born 23 December 1937) is a Hungarian-born film director of British and American films.\n\nDescription above from the Wikipedia article Peter Medak, licensed under CC-BY-SA, full list of contributors on Wikipedia', -1010620800, 'Budapest, Hungary', '21377', 'peter-medak', 'upload/images/oUPjJXMOSomwrqFx4eobxROVZOV.jpg'),
(753, 'director', 'Vince Gilligan', 'George Vincent \\\"Vince\\\" Gilligan, Jr. (born February 10, 1967) is an American writer, producer, and director. He is known for his television work, specifically as creator, head writer, executive producer, and a director of Breaking Bad and its spin-off Better Call Saul. He was a writer and producer for The X-Files and was the co-creator of its spin-off The Lone Gunmen.', -91238400, 'Richmond, Virginia, USA', '66633', 'vince-gilligan', 'upload/images/z3E0DhBg1V1PZVEtS9vfFPzOWYB.jpg'),
(754, 'director', 'Michael Slovis', 'Michael Slovis  is a cinematographer and director, known for Breaking Bad (2008), CSI: Crime Scene Investigation (2000) and Ed (2000).', NULL, 'New York City, New York, USA', '52034', 'michael-slovis', 'upload/images/6L2U9eY6YisJlxlmQEwims8Gkf3.jpg'),
(755, 'director', 'Johan Renck', 'Johan Renck is one of the most respected and sought after directors of  commercials and music videos today, so much so that the French magazine  CB News dubbed him \\\"the number one director of commercials and music  videos in the world \\\".\n\nHis directing career started in 1992 when  he joined the production company Mekano Film and Television in  Stockholm, Sweden. In 1994 he left Mekano to join forces with childhood  friend director Jonas Åkerlund. They established a new production  company, Renck Åkerlund Films, which immediately became one of the  leaders of its kind in Sweden. During the same time he worked with his  music project, Stakka Bo, with big success and a lot of his time was  occupied by the music career. In 1997 he started to work as a director  full time and quickly became a well-known name worldwide and in 1999 he  was working with Madonna and Nike among others.', -97027200, 'Uppsala, Sweden', '212408', 'johan-renck', 'upload/images/pkPO6RhVFcKDiEUtbHjTkq4JjYi.jpg'),
(756, 'director', 'Terry McDonough', '', NULL, '', '1193575', 'terry-mcdonough', NULL),
(757, 'director', 'Bryan Cranston', 'Bryan Lee Cranston (born March 7, 1956) is an American actor, director, and producer who is mainly known for portraying Walter White in the AMC crime drama series Breaking Bad (2008–2013) and Hal in the Fox sitcom Malcolm in the Middle (2000–2006). He has received a number of awards—including six Primetime Emmy Awards, four Screen Actors Guild Awards, two Tony Awards, and a Golden Globe Award—with a nomination for an Academy Award and a BAFTA Award.\n\nBryan Cranston\\\'s performance on Breaking Bad earned him the Primetime Emmy Award for Outstanding Lead Actor in a Drama Series four times (2008, 2009, 2010, and 2014). After becoming a producer of the show in 2011, he also won the award for Outstanding Drama Series twice. Breaking Bad also earned Cranston five Golden Globe nominations (with one win) and nine Screen Actors Guild Award nominations (with four wins). He was previously nominated three times for Outstanding Supporting Actor in a Comedy Series for his role in Malcolm in the Middle. Cranston co-developed and occasionally appeared in the crime drama series Sneaky Pete (2015–2019) and served as a director for episodes of Malcolm in the Middle, Breaking Bad, Modern Family, and The Office.\n\nIn 2014, Cranston earned a Tony Award for Best Actor in a Play for his portrayal of President Lyndon B. Johnson in the Broadway play All the Way, a role he reprised in the HBO 2016 television film of the same name. In 2018, he received the Laurence Olivier Award for Best Actor in a Play for his portrayal of Howard Beale in the play Network at London\\\'s National Theatre, later winning his second Tony Award for Best Actor in a Play for the same role on Broadway. For portraying Dalton Trumbo in the film Trumbo (2015), he received nominations for an Academy Award, a BAFTA Award, a Screen Actors Guild Award and a Golden Globe Award, all for Best Actor in a Leading Role.\n\nCranston has appeared in several other films, such as Saving Private Ryan (1998), Little Miss Sunshine (2006), Drive (2011), Argo (2012), Godzilla (2014), and The Upside (2017). He also provided voice acting in the films Madagascar 3: Europe\\\'s Most Wanted (2012), Kung Fu Panda 3 (2016), and Isle of Dogs (2018).', -436147200, 'Hollywood, Los Angeles, California, USA', '17419', 'bryan-cranston', 'upload/images/7Jahy5LZX2Fo8fGJltMreAI49hC.jpg'),
(758, 'director', 'Rian Johnson', 'Rian Craig Johnson (born December 17, 1973) is an American filmmaker. He made his directorial debut with the neo-noir mystery film Brick (2005), which received positive reviews and grossed nearly $4 million on a $450,000 budget. Transitioning to higher-profile films, Johnson achieved mainstream recognition for writing and directing the science-fiction thriller Looper (2012) to critical and commercial success. Johnson landed his largest project when he wrote and directed the space opera Star Wars: The Last Jedi (2017), which grossed over $1 billion. He returned to the mystery genre with Knives Out (2019), which earned him an Academy Award nomination for Best Original Screenplay, and its sequel, Glass Onion (2022).\n\nOutside of film, Johnson directed three episodes of the television drama series Breaking Bad (2008–2013). He received the Directors Guild of America Award for Outstanding Directing – Drama Series in 2013 for his work on the season 5 episode \\\"Fifty-One\\\".', 124934400, 'Silver Spring, Maryland, USA', '67367', 'rian-johnson', 'upload/images/uPWwvdppeZVKPbYcjXKU8zyuAVh.jpg'),
(759, 'director', 'Peter Gould', 'Peter Gould is an American television writer, director and producer. He worked on all five seasons of the AMC drama Breaking Bad. He was nominated for four Writers Guild of America (WGA) Awards for his work on the series. After Breaking Bad ended, he went on to become the co-creator and co-showrunner, with Breaking Bad creator Vince Gilligan, of the show\\\'s spinoff, Better Call Saul. He became the series\\\' sole showrunner after Gilligan left the writers room.', NULL, 'New York City, New York, USA', '24951', 'peter-gould', 'upload/images/a2dJSpUiXQ2NAxqSzztr6WsnhOJ.jpg'),
(760, 'director', 'Sam Catlin', 'Sam Catlin is an American television writer, director, and producer. He is the showrunner of AMC\\\'s Preacher, and previously worked as a writer/producer on Breaking Bad. He has been nominated for a Writers Guild of America (WGA) Award for his work on the series.', NULL, '', '1223194', 'sam-catlin', 'upload/images/xc9Ax2kpvQLayUaFL1d1NTUQ7df.jpg'),
(761, 'director', 'John Shiban', '', -249177600, 'USA', '29924', 'john-shiban', 'upload/images/rdmBnBQnxAab2FE2CP6A6hGnUXT.jpg'),
(762, 'director', 'Thomas Schnauz', '', NULL, '', '103009', 'thomas-schnauz', 'upload/images/uMz5wsgv6QQAgFI809SgCCbwYn9.jpg'),
(763, 'director', 'George Mastras', '', NULL, '', '1223193', 'george-mastras', 'upload/images/2K0NELbA0Ow45ECudbO2eFc1Fe4.jpg'),
(764, 'director', 'Tricia Brock', 'Tricia Brock is a director and writer.', NULL, '', '1215145', 'tricia-brock', 'upload/images/5OV41AzetM5WrJ0zKqmw4mShEk5.jpg'),
(765, 'director', 'David Slade', 'David Aldrin Slade (born 26 September 1969) is a British film director who began his career making music videos. His work includes videos for artists such as Aphex Twin, Rob Dougan, System of a Down, Stone Temple Pilots, Tori Amos, and Muse.', -8380800, 'UK', '27571', 'david-slade', 'upload/images/9jL9OasecqvhQFvGYQtB4K6omGf.jpg'),
(766, 'director', 'Charles Haid', 'From Wikipedia, the free encyclopedia.\n\nCharles Maurice Haid III (born June 2, 1943) is an American actor and director, with notable work in both movies and television. He is known for his portrayal of Officer Andy Renko in Hill Street Blues.\n\nHaid was born in San Francisco, California, the son of Grace Marian (née Folger) and Charles Maurice Haid, Jr. He attended Carnegie Institute of Technology (now Carnegie Mellon University), where he met Steven Bochco. He was associate producer of the original stage production of Godspell in 1971, which was developed at CMU.\n\nHaid\\\'s acting credits include the 1976/1977 police drama series Delvecchio as Sgt. Paul Schonski and the 1980s police drama series Hill Street Blues, as Officer Andy Renko, and as Dr. Mason Parrish in the 1980 movie Altered States. His directing credits include an episode of ER which earned him a Directors Guild Award, and DGA nominations for the TV-movie Buffalo Soldiers and an episode of NYPD Blue. He is a regular director on the FX series Nip/Tuck. He has also directed for the FX series Sons of Anarchy. He is a regular director for the CBS series Criminal Minds. He also portrayed serial killer Randall Garner (aka \\\"The Fisher King\\\") on Criminal Minds.\n\nDuring a visit to New Zealand in the 1980s, Haid was interviewed for a television news program, and surprised many viewers when he discussed his Shakespearean background, and love of live stage work.\n\nIn 2004-2005 Haid played C. T. Finney, a corrupt New York police captain on the sixth season of the NBC show Third Watch.\n\nHaid provided the voice of the one-legged rabbit \\\"Lucky Jack\\\" in the 2004 Disney animated film Home On The Range. Twenty years earlier, Haid voiced main character \\\"Montgomery Moose\\\" in the pilot episode of The Get Along Gang, produced by Nelvana. He was replaced by Sparky Marcus for the subsequent series.\n\nHaid is a cousin of television talk show host Merv Griffin.\n\nDescription above from the Wikipedia article Charles Haid, licensed under CC-BY-SA, full list of contributors on Wikipedia​', -838944000, 'San Francisco, California, USA', '69791', 'charles-haid', 'upload/images/6X2iBOvxH9ud6XFgMwNycFnfVqh.jpg'),
(767, 'actor', 'Damian Lewis', 'Damian Watcyn Lewis (born 11 February 1971) is an English actor and producer. He is probably best known in the United States for starring as Detective Charlie Crews in the NBC drama Life as well as portraying Major Richard Winters in the HBO miniseries Band of Brothers.\n\nDescription above from the Wikipedia article Damian Lewis, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 35078400, 'St. John\\\'s Wood, London, England, UK', '20186', 'damian-lewis', 'upload/images/qm4M15FTUmuf1j8Kp3M7p0LaqC2.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(768, 'actor', 'Donnie Wahlberg', 'Donald Edmond \\\"Donnie\\\" Wahlberg, Jr. (born August 17, 1969) is an American singer-songwriter, actor, film producer, and record producer. One of his siblings is actor Mark Wahlberg and he is married to comedian/actress Jenny McCarthy.\n\nHe is a founding member of the popular 1980s and 1990s boy band New Kids on the Block.\n\nHe\\\'s most known for his TV role as Det. Danny Reagan on Blue Bloods, for which he was nominated for a People\\\'s Choice Award for Favorite TV Crime Drama Actor in 2017. He\\\'s also known for his roles as Donnie on the sitcom Return of the Mac, Det. Horst Cali on The Kill Point, Paul Rader on Runaway, Det. Joel Stevens on Boomtown, Lt. C. Carwood Lipton on the award-winning miniseries Band of Brothers, and Chris Scott on Big Apple.\n\nGraham Yost, executive producer and writer of Boomtown, had worked with him in Band of Brothers and was so impressed by his performance that he wrote the role of Joel Stevens specifically for him.\n\nHe\\\'s taken part in the reality shows Donnie Loves Jenny, Wahlburgers, Rock This Boat: New Kids on the Block, and The Masked Singer. He is narrator of HLN\\\'s true crime show Very Scary People. He is executive producer and narrator of the reality series Boston\\\'s Finest, in part produced by his company Donnie D. Productions.\n\nHe\\\'s known for his film roles as Det. Eric Matthews in the Saw film series (starting in Saw II), Shane in Zookeeper, Det. Teddy Riley in Righteous Kill, Commander Burton in Annapolis, Douglas \\\'Duddits\\\' Cavell in Dreamcatcher, and Vincent Grey in The Sixth Sense. He\\\'s also had roles in TV movies including The Taking of Pelham One Two Three (1998 TV movie), as well as Kings of South Beach, and Bunker Hill.\n\nAs of 2011, he is the host of an internet radio show on Friday nights at 8 pm PST called \\\"DDUB\\\'s R&B Back Rub\\\" on Cherry Tree Radio.', -11836800, 'Dorchester, Boston, Massachusetts, USA', '2680', 'donnie-wahlberg', 'upload/images/8OQTlgl7eGAFlKTF2o8rZZT0MoF.jpg'),
(769, 'actor', 'David Schwimmer', 'David Lawrence Schwimmer (born November 2, 1966) is an American actor and director of television and film. He was born in New York, and his family moved to Los Angeles when he was two. He began his acting career performing in school plays at Beverly Hills High School. In 1988, he graduated from Northwestern University with a Bachelor of Arts degree in theater and speech. After graduation, Schwimmer co-founded the Lookingglass Theatre Company. For much of the late-1980s, he lived in Los Angeles as a struggling, unemployed actor.\n\nHe appeared in the television movie A Deadly Silence in 1989. He then appeared in a number of television roles, including L.A. Law, The Wonder Years, NYPD Blue, and Monty in the early 1990s. Schwimmer later gained worldwide recognition for playing Ross Geller in the situation comedy Friends. Aside from appearing in television, he starred in his first leading role in The Pallbearer (1996), which was followed by roles in Kissing a Fool (1998), Six Days Seven Nights (1998), Apt Pupil, and Picking Up the Pieces (2000). He was then cast in the miniseries Band of Brothers (2001) as Herbert Sobel.\n\nFollowing the series finale of Friends in 2004, Schwimmer was cast as the titular character in the 2005 drama Duane Hopwood. Other film roles include the computer animated film Madagascar (2005), the dark comedy Big Nothing (2006), the thriller Nothing But the Truth (2008), and Madagascar: Escape 2 Africa (2008). Schwimmer made his London stage debut in the leading role in Some Girl(s) in 2005. In 2006, he made his Broadway debut in The Caine Mutiny Court-Martial. Schwimmer made his feature film directorial debut with the 2007 comedy Run Fatboy Run. The following year he made his Off-Broadway directorial debut in the 2008 production Fault Lines.\n\nDescription above from the Wikipedia article David Schwimmer, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -99878400, 'Astoria, New York, USA', '14409', 'david-schwimmer', 'upload/images/uSFSGhvcHEg44gt3pOvtkQml6oj.jpg'),
(770, 'actor', 'Eion Bailey', 'From Wikipedia, the free encyclopedia.\n\nEion Francis Hamilton Bailey (born June 8, 1976) is an American actor, perhaps best known for appearing in the HBO miniseries Band of Brothers as Pvt. David Kenyon Webster and in the films Fight Club, Center Stage, Mindhunters and Sexual Life. He currently has a recurring role on the USA Network TV show Covert Affairs.\n\nDescription above from the Wikipedia article Eion Bailey, licensed under CC-BY-SA, full list of contributors on Wikipedia.​', 203040000, 'Santa Ynez Valley, California, USA', '7498', 'eion-bailey', 'upload/images/3DW13W47cKk4LQZwS4EvRaNBoVu.jpg'),
(771, 'actor', 'Ron Livingston', 'Ronald Joseph \\\"Ron\\\" Livingston (born June 5, 1967) is an American film and television actor. His roles include a disaffected corporate employee in the film Office Space, a sardonic writer in a short-term relationship with Carrie Bradshaw in the TV show Sex and the City, and Captain Lewis Nixon in the miniseries Band of Brothers. In 2006, he starred as FBI negotiator Matt Flannery in the Fox series Standoff, co-starring Rosemarie DeWitt, and he was an ad spokesman for Sprint Nextel. In 2009 he portrayed flight engineer Maddux Donner in the series Defying Gravity, which was cancelled after a single season.\n\nDescription above from the Wikipedia article Ron Livingston, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -81302400, 'Cedar Rapids, Iowa, USA', '17402', 'ron-livingston', 'upload/images/pr5CjWnkaf5WKTIYh8wtNufjmyb.jpg'),
(772, 'actor', 'Matthew Settle', 'Jeffrey Matthew Settle (born September 17, 1969) is an American actor best known for playing Captain Ronald Speirs on the HBO show Band of Brothers and Rufus Humphrey on Gossip Girl.\n\nDescription above from the Wikipedia article Matthew Settle, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -9158400, 'Hickory, North Carolina, USA', '33286', 'matthew-settle', 'upload/images/69D3JqJslcqJ1lqwcet2zGRAr7n.jpg'),
(773, 'actor', 'Michael Cudlitz', 'Michael Cudlitz (born December 29, 1964) is an American actor, best known for his role on Southland and Band of Brothers.', -158025600, 'Long Island, New York, USA', '52415', 'michael-cudlitz', 'upload/images/1snLOta9L2DAhmOTvNIn7OSxzQC.jpg'),
(774, 'actor', 'Neal McDonough', 'Neal McDonough was trained at the London Academy of Dramatic Arts and Sciences. His theatre credits include \\\'Cheap Talk\\\', \\\'Foreigner\\\', \\\'As You Like It\\\', \\\'Rivals\\\', \\\'A Midsummer Night\\\'s Dream\\\', \\\'Bald Soprano\\\', and \\\'Waiting for Lefty\\\'. The young actor won a 1991 Best Actor Dramalogue Award for \\\'Away Alone\\\'. McDonough has been a \\\'Star Trek\\\' fan since he was a kid. Playing Lieutenant Hawk in \\\'Star Trek First Contact\\\' was a life-long dream. McDonough has three pictures on his bedroom wall. One is a picture of his mom, the other is the Holy Virgin Mary, and the third is William Shatner as Captain Kirk. He has numerous television credits including \\\'NYPD Blue\\\', \\\'Quantum Leap\\\', and the voice of Bruce Banner in the animated series \\\'The Incredible Hulk\\\' among others. He graduated Syracuse University with a Bachelor of Fine Arts degree in 1988. ', -122515200, 'Dorchester, Massachusetts, USA', '2203', 'neal-mcdonough', 'upload/images/3mI3i1CpjATSCta1Tb2qsyl1KCh.jpg'),
(775, 'actor', 'Scott Grimes', 'Scott Grimes (born July 9, 1971) is an American actor, voice artist and musician. Some of his most prominent roles are his appearances on ER, Party of Five, Band of Brothers, and American Dad.', 47865600, 'Lowell, Massachusetts, USA', '35091', 'scott-grimes', 'upload/images/oB0xperEt45g8Ti6lpObpi6c5XV.jpg'),
(776, 'actor', 'Shane Taylor', '​From Wikipedia, the free encyclopedia.  \n\nShane Taylor (born 13 March 1974) is a British television and screen actor born in Dover, Kent, England. He is perhaps best known for his portrayal of medic Eugene Roe in the HBO/BBC World War II miniseries Band of Brothers.\n\nDescription above from the Wikipedia article Shane Taylor, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 132364800, 'Dover, Kent, England', '126429', 'shane-taylor', 'upload/images/inQU6RuRxZnyVhb0PvYicShZfox.jpg'),
(777, 'actor', 'Ross McCall', 'Ross McCall  (b. 13 January 1976, Port Glasgow, Scotland) is a Scottish actor notable for his role as Cpl. Joseph Liebgott in the 2001 HBO miniseries Band of Brothers. His first notable screen role was at the age of 13 when he appeared as Freddie Mercury in the 1989 promotional video for the Queen song \\\"The Miracle\\\", the role for which he was picked out of a large number of applicants. In 1993, McCall was featured in BBC children\\\'s TV series The Return of the Borrowers. In 2005 Ross co-starred in the independent drama film Green Street. He played Kenny Battaglia in the television series, Crash, on the Starz network. He reprised his role as Dave in the 2009 straight-to-video sequel Green Street 2: Stand Your Ground. In 2008, he co-starred in an After Dark Horrorfest film, Autopsy. McCall was raised Roman Catholic. He was engaged to actress Jennifer Love Hewitt, with whom he Guest starred in an episode of Ghost Whisperer. On 5 January 2009, People Magazine reported that Hewitt called off their engagement in late 2008. He is a supporter of Celtic F.C., and trained at Redroofs Theatre School in Maidenhead. On 23 February 2010, he appeared as a guest star on White Collar on the episode \\\"Bottlenecked\\\". Ross was portrayed as Matthew Keller. He reprised the role in episode 14 of White Collar season 2. On 6 March 2010, in an interview with The Mail on Sunday, Sheridan Smith revealed that she and McCall had begun dating after a 10 year friendship. On 1 June 2010, he appeared as a guest star on Luther. He starts production on the feature film \\\'The Guest Room\\\', shooting at the Sunset Gower studios in LA in July 2010.\n\nDescription above from the Wikipedia article Ross McCall, licensed under CC-BY-SA, full list of contributors on Wikipedia', 190339200, 'Port Glasgow, Scotland, UK', '56366', 'ross-mccall', 'upload/images/6l3lARiyHHISOIntSlvYv0JgTHz.jpg'),
(778, 'actor', 'Frank John Hughes', 'From Wikipedia, the free encyclopedia\n\nFrank John Hughes (born November 11, 1967) is an American film and television actor, and screenwriter. Hughes is best known for his portrayals of \\\"Wild Bill\\\" Guarnere in the HBO miniseries Band of Brothers, Tom Fox in Catch Me If You Can, Tim Woods in 24, and Walden Belfiore in The Sopranos.', -67564800, 'New York City, New York, USA', '9275', 'frank-john-hughes', 'upload/images/cPlPRD36uPNYMlPeoHjvmOc60iX.jpg'),
(779, 'actor', 'Nolan Hemmings', 'Son of actor and director David Hemmings, who named him after his character in 1969\\\'s Charge of the Light Brigade, Captain Nolan.', NULL, '', '1232094', 'nolan-hemmings', 'upload/images/pYbbQMAnxoLIKuhkgclnFz4b8vV.jpg'),
(780, 'actor', 'Michael Fassbender', 'Michael Fassbender (born 2 April 1977) is an Irish actor. He is the recipient of various accolades, including a Screen Actors Guild Award, a Critics\\\' Choice Movie Award, and nominations for two Academy Awards, four British Academy Film Awards and three Golden Globe Awards.\n\nBorn in Heidelberg and raised in Killarney, Fassbender made his feature film debut as a Spartan warrior in the fantasy war epic 300 (2006). His earlier roles included various stage productions, as well as starring roles on television such as in the HBO miniseries Band of Brothers (2001) and the Sky One fantasy drama Hex (2004–05). He first came to prominence for his role as IRA volunteer Bobby Sands in Hunger (2008), for which he won a British Independent Film Award. Subsequent roles include the independent film Fish Tank (2009), as a Royal Marines lieutenant in Inglourious Basterds (2009), as Edward Rochester in the 2011 film adaptation of Jane Eyre, as Carl Jung in A Dangerous Method (2011), as the sentient android, David 8, in Ridley Scott\\\'s Prometheus (2012) and its sequel, Alien: Covenant (2017), and in the musical comedy drama Frank (2014) as an eccentric musician loosely inspired by Frank Sidebottom.\n\nFassbender debuted as the Marvel Comics supervillain Magneto in X-Men: First Class (2011), and went on to share the role with Ian McKellen in X-Men: Days of Future Past (2014) before reprising it again in X-Men: Apocalypse (2016) and Dark Phoenix (2019). Also in 2011, his performance as a sex addict in Shame earned him the Volpi Cup for Best Actor at the Venice Film Festival and was nominated for Golden Globe and BAFTA Awards. His role as slave owner Edwin Epps in 12 Years a Slave (2013) was similarly praised, earning him his first Academy Award nomination for Best Supporting Actor. In the same year, Fassbender appeared in another Ridley Scott film, The Counselor. He portrayed the title role in the Danny Boyle-directed biopic Steve Jobs (2015), and played Macbeth in Justin Kurzel\\\'s adaptation of William Shakespeare\\\'s play. For the former, he received Academy Award, BAFTA, Golden Globe and SAG nominations. He also produced and starred in the Western Slow West (2015). In 2020, he was listed at number nine on The Irish Times list of Ireland\\\'s greatest film actors.\n\nFassbender began competing in auto racing in 2017 with the Ferrari Challenge. He currently races in the European Le Mans Series, driving for Proton Competition.', 228787200, 'Heidelberg, Baden-Wurttemburg, Germany', '17288', 'michael-fassbender', 'upload/images/44HPVHj1DijOuUe0zYuQfSZujKH.jpg'),
(781, 'actor', 'Dexter Fletcher', 'Dexter Fletcher (born 31 January 1966) is an English actor and director. He has appeared in Guy Ritchie\\\'s Lock, Stock and Two Smoking Barrels and the crime comedy Smoking Guns, as well as in television shows such as the comedy-drama Hotel Babylon, the HBO series Band of Brothers and, earlier in his career, the children\\\'s show Press Gang. He was also in the film Bugsy Malone. He had a short stint as a presenter on the third series of Channel 4\\\'s GamesMaster in 1993 and 1994.\n\nFletcher made his directorial debut with Wild Bill (2011), and also directed Sunshine on Leith (2013) and Eddie the Eagle (2015). He replaced Bryan Singer as director of Bohemian Rhapsody, a biopic about the band Queen, released in October 2018; due to DGA rules, he received executive producer credit. In 2019 he directed Rocketman, a film based on the life of Elton John.\n\nDescription above from the Wikipedia article Dexter Fletcher, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -123638400, 'North London, England, UK', '974', 'dexter-fletcher', 'upload/images/yRI8MDB5sg8b8EZkzFz5cCBrnKL.jpg'),
(782, 'actor', 'James Madio', 'James Madio (born November 22, 1975 in The Bronx, New York City, New York) is an American actor.', 185846400, 'The Bronx, New York City, New York, USA', '65395', 'james-madio', 'upload/images/v17uyHhMLooVWKjMRS4NoGeTPyB.jpg'),
(783, 'actor', 'Richard Speight Jr.', 'From Wikipedia, the free encyclopedia. Richard Speight, Jr. (born September 4, 1970) is an American actor, probably best known for his recurring role as Deputy Bill Kohler on the TV series Jericho prior to its cancellation. He also previously starred on the CBS drama The Agency, and as the Trickster/Gabriel/Loki on Supernatural.\n\nDescription above from the Wikipedia article Richard Speight, Jr., licensed under CC-BY-SA,full list of contributors on Wikipedia.', 21254400, 'Nashville, Tennessee, USA', '58112', 'richard-speight-jr', 'upload/images/6vvSWeeuClFDzicL4XWKsMDznLB.jpg'),
(784, 'actor', 'Rick Warden', '', 54950400, '', '83137', 'rick-warden', 'upload/images/8fIkj97BW4PRsHq1ow1hzuqe0lr.jpg'),
(785, 'actor', 'Kirk Acevedo', '​From Wikipedia, the free encyclopedia.  \n\nKirk Acevedo (born November 27, 1971) is an American actor. Notable is his portrayal of Miguel Alvarez in the HBO series Oz, Joe Toye in Band of Brothers and his role as FBI Agent Charlie Francis in the science-fiction series Fringe from 2008 onwards.', 60048000, 'Brooklyn - New York - USA', '55861', 'kirk-acevedo', 'upload/images/jFUHECwo7L3KOZ0HxCQytl90qed.jpg'),
(786, 'actor', 'Rick Gomez', 'Richard Harper Gomez (born June 1, 1972) is an American actor. He is known for portraying Radio Technician 4th Grade George Luz in the HBO television miniseries Band of Brothers, and as \\\"Endless Mike\\\" Hellstrom in the Nickelodeon TV series The Adventures of Pete and Pete.', 76204800, 'Bayonne, New Jersey, USA', '123532', 'rick-gomez', 'upload/images/gmVYPHJgmRVIzhaVYMns4kgBVqm.jpg'),
(787, 'actor', 'Peter Youngblood Hills', '', 254793600, 'Johannesburg, South Africa', '19869', 'peter-youngblood-hills', 'upload/images/dPSZv0dJY0tpMWvSxgpVjpNA7cC.jpg'),
(788, 'director', 'Richard Loncraine', 'From Wikipedia, the free encyclopedia.\n\nRichard Loncraine is a British film and television director.\n\nLoncraine received early training in the features department of the BBC, including a season directing items for Tomorrow\\\'s World. Before his career in film, he was a sculptor and the first to create a chrome Newton\\\'s cradle.\n\nDescription above from the Wikipedia article Richard Loncraine, licensed under CC-BY-SA, full list of contributors on Wikipedia.​', -732153600, 'Cheltenham, England', '33315', 'richard-loncraine', 'upload/images/2mpUQgkeo8QNMQwmJE1OzAmGAM5.jpg'),
(789, 'director', 'Mikael Salomon', 'Mikael Salomon is a Danish filmmaker and cinematographer. After a long career in Denmark, he moved to Hollywood in the late 1980s. He has been nominated for an Oscar  twice.', -784252800, 'Copenhagen, Denmark', '30149', 'mikael-salomon', 'upload/images/2vrGZoDHsXzywPsTMApMrBLeCIN.jpg'),
(790, 'director', 'Tom Hanks', 'Thomas Jeffrey Hanks (born July 9, 1956) is an American actor and filmmaker. Known for both his comedic and dramatic roles, Hanks is one of the most popular and recognizable film stars worldwide, and is widely regarded as an American cultural icon.\n\nHanks made his breakthrough with leading roles in the comedies Splash (1984) and Big (1988). He won two consecutive Academy Awards for Best Actor for starring as a gay lawyer suffering from AIDS in Philadelphia (1993) and a young man with below-average IQ in Forrest Gump (1994). Hanks collaborated with film director Steven Spielberg on five films: Saving Private Ryan (1998), Catch Me If You Can (2002), The Terminal (2004), Bridge of Spies (2015), and The Post (2017), as well as the 2001 miniseries Band of Brothers, which launched him as a director, producer, and screenwriter.\n\nHanks\\\' other notable films include the romantic comedies Sleepless in Seattle (1993) and You\\\'ve Got Mail (1998); the dramas Apollo 13 (1995), The Green Mile (1999), Cast Away (2000), Road to Perdition (2002), and Cloud Atlas (2012); and the biographical dramas Saving Mr. Banks (2013), Captain Phillips (2013), Sully (2016), and A Beautiful Day in the Neighborhood (2019). He has also appeared as the title character in the Robert Langdon film series, and has voiced Sheriff Woody in the Toy Story film series.\n\nDescription above from the Wikipedia article Tom Hanks, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -425433600, 'Concord, California, USA', '31', 'tom-hanks', 'upload/images/xndWFsBlClOJFRdhSt4NBwiPq2o.jpg'),
(791, 'director', 'Phil Alden Robinson', '​Phil Alden Robinson is an American director and screenwriter for film and television, best known for \\\"Field of Dreams\\\", \\\"Sneakers\\\", and \\\"The Sum of All Fears\\\".', -626054400, 'Long Beach, New York, USA', '23968', 'phil-alden-robinson', 'upload/images/cYgEgM3MxDb0I1olvrZNHXjuC6I.jpg'),
(792, 'director', 'David Frankel', 'David Frankel (born April 2, 1959) is an American filmmaker.\n\nDescription above from the Wikipedia article David Frankel, licensed under CC-BY-SA, full list of contributors on Wikipedia.', -339292800, 'New York City, New York, USA', '5065', 'david-frankel', 'upload/images/xhiIfSUwQmELt4iSDdfAnC2QLBe.jpg'),
(793, 'director', 'David Nutter', 'David Nutter (born 1960) is an American television and film director and television producer. He is best known for directing pilot episodes for television. In 2015, he received a Primetime Emmy Award for Outstanding Directing for a Drama Series, for his work on the HBO series Game of Thrones. He is also known for The Pacific (2010) and Space: Above and Beyond (1995).', NULL, '', '33316', 'david-nutter', 'upload/images/obyikiv6rf8hgwUKJKRJdMT3YEK.jpg'),
(794, 'director', 'Tony To', 'Tony To is a television producer and director and current president of production and development at Lucasfilm. He is best known for producing and also directing for the HBO miniseries Band of Brothers, for which he won an Emmy Award. He later returned to produce and direct for the 2010 companion miniseries The Pacific. He has also directed episodes of House and Harsh Realm. Before his position at Lucasfilm, To served as executive vice president of production for The Walt Disney Studios. On July 21, 2020, he and director Daniel Sackheim founded Bedrock Entertainment with ITV Studios America as partner.', NULL, '', '166291', 'tony-to', NULL),
(795, 'actor', 'Mark Wahlberg', 'Mark Robert Michael Wahlberg (born June 5, 1971), former stage name Marky Mark, is an American actor, businessman, and former rapper. His work as a leading man spans the comedy, drama, and action genres. He has received multiple accolades, including a BAFTA Award, and nominations for two Academy Awards, three Golden Globe Awards, nine Primetime Emmy Awards, and three Screen Actors Guild Awards.\n\nWahlberg was born in Boston, Massachusetts in 1971. During his early life, he perpetrated several crimes. In the 1990s, Wahlberg was a member of the music group Marky Mark and the Funky Bunch, with whom he released the albums Music for the People (1991) and You Gotta Believe (1992). Wahlberg made his screen debut in Renaissance Man (1994) and had his first starring role in Fear (1996). He received critical praise for his performance as porn actor Dirk Diggler in Boogie Nights (1997).\n\nIn the early 2000s, he ventured into big-budget action movies, such as The Perfect Storm (2000), Planet of the Apes (2001), and The Italian Job (2003). He was nominated for the Academy Award for Best Supporting Actor for playing a police officer in the crime drama The Departed (2006). He was nominated for the Golden Globe Award for Best Actor for the sports drama biopic The Fighter (2010), in which he starred as Micky Ward. In the 2010s, he landed successful comedy roles with The Other Guys (2010), Ted (2012), Ted 2 (2015), Daddy\\\'s Home (2015), and Daddy\\\'s Home 2 (2017). He also became the protagonist in two films in the Transformers live-action film franchise, Transformers: Age of Extinction and Transformers: The Last Knight. He was the world\\\'s highest-paid actor in 2017.\n\nWahlberg served as executive producer of five HBO series: the comedy-drama Entourage (2004–2011), the period crime drama Boardwalk Empire (2010–2014), the comedy-dramas How to Make It in America (2010–2011) and Ballers (2015–2019), and the documentary McMillions (2020). He is co-owner of the Wahlburgers chain and co-starred in the reality TV series about it. He received a star on the Hollywood Walk of Fame in 2010.', 44928000, 'Boston, Massachusetts, USA', '13240', 'mark-wahlberg', 'upload/images/bTEFpaWd7A6AZVWOqKKBWzKEUe8.jpg'),
(796, 'actor', 'Nathalie Emmanuel', 'Nathalie Joanne Emmanuel (born 2 March 1989) is an English actress best known for her role as Sasha Valentine in the soap opera Hollyoaks, Computer Hacktivist Ramsey in the action film Furious 7 and as the interpreter Missandei on the HBO fantasy series Game of Thrones.', 604800000, 'Essex, England, UK', '1251069', 'nathalie-emmanuel', 'upload/images/koSwmmonFJiZDfwmZgdVA7I1aR.jpg'),
(797, 'actor', 'Simu Liu', 'Simu Liu (born 19 April 1989) is a Canadian actor, writer, and stuntman. He is known for his performance as Jung Kim in the award-winning CBC Television sitcom Kim\\\'s Convenience. He received nominations at the ACTRA Awards and Canadian Screen Awards for his work in Blood and Water. He portrays Shang-Chi in the 2021 Marvel Cinematic Universe film Shang-Chi and the Legend of the Ten Rings.', 608947200, 'Harbin, Heilongjiang, China', '1489211', 'simu-liu', 'upload/images/zrJjYjOYzDj7eY9oiHAoz8Yh0yk.jpg'),
(798, 'actor', 'Bear Grylls', 'Edward Michael \\\"Bear\\\" Grylls (born 7 June 1974) is a British adventurer, writer and television presenter. He is widely known for his television series Man vs. Wild (2006–2011), originally titled Born Survivor: Bear Grylls  in the United Kingdom.\n\nGrylls is also involved in a number of  wilderness survival television series in the UK and US. In July 2009,  Grylls was appointed the youngest-ever Chief Scout in the UK at age 35.\n\nGrylls was born in Donaghadee, County Down, Northern Ireland.He grew up in Donaghadee until the age of four, when his family moved to Bembridge on the Isle of Wight.\n\nHe is the son of Conservative politician Sir Michael Grylls, who was implicated in the cash-for-questions affair, and Lady Sarah Grylls. Lady Grylls is the daughter of politician Patricia Ford, briefly an Ulster Unionist Party MP, and cricketer and businessman Neville Ford.  Grylls has one sibling, an elder sister, Lara Fawcett, a cardio-tennis  coach, who gave him the nickname \\\'Bear\\\' when he was a week old.\n\nGrylls was educated at Ludgrove School and Eton College, where he helped start its first mountaineering club, and Birkbeck, University of London, where he graduated with a degree, obtained part-time, in Hispanic studies in 2002. He graduated from the University of West of England.\n\nFrom an early age, he learned to climb and sail with his father, who was a member of the prestigious Royal Yacht Squadron. As a teenager, he learned to skydive and earned a second dan black belt in Shotokan karate. At age eight he became a Cub Scout. He speaks English, Spanish, and French. He is a Christian, and has described his faith as the \\\"backbone\\\" in his life.\n\nGrylls married Shara Cannings Knight in 2000. They have three sons. In August 2015, it was reported that Grylls had deserted his young son, Jesse, on Saint Tudwal\\\'s Island along the North Wales coast, as the tide approached, leaving him to be rescued by the RNLI. The RNLI later criticised him for the stunt, saying its crew \\\"had not appreciated\\\" that a child would be involved.', 139795200, 'County Down, Northern Ireland', '208629', 'bear-grylls', 'upload/images/vAjjR7b5lnip01W0OIjvaPynNON.jpg'),
(799, 'actor', 'Michael Landes', 'Michael Christopher Landes (born September 18, 1972) is an American actor. He is known for his roles of Jimmy Olsen in the first season of Lois and Clark: The New Adventures of Superman, Detective Nicholas O\\\'Malley in Special Unit 2, Officer Thomas Burke in Final Destination 2, and David Conlon in The Wedding Bells.', 85622400, 'The Bronx, New York, U.S', '57428', 'michael-landes', 'upload/images/2EdaNaUQdWi7Vi0pLNaS9Ys9fVi.jpg'),
(800, 'actor', 'Paul Guilfoyle', 'Paul Guilfoyle is an American stage and screen actor, best known for playing Captain Jim Brass on the television series \\\"CSI: Crime Scene Investigation\\\". He graduated from Yale University in 1977 with a major in economics and studied at the Actor\\\'s Studio in New York City.\n\nHe is often mistakenly referred to as the son of character actor Paul Guilfoyle but they are not related.', -652579200, 'Boston, Massachusetts, USA', '925', 'paul-guilfoyle', 'upload/images/c7unxeM13lF9pMhZhYwlNsSFjFe.jpg'),
(801, 'actor', 'Ali Suliman', 'Ali Suliman was born in 1977, in Nazareth, Palestine. His interest in the dramatic arts led him to the prestigious \\\" Acting School\\\" in Tel-Aviv, where he graduated in the year 2000. At the end of his studies, he joined the \\\"Commedia Dell\\\'Arte\\\", Masks Theater group in London. Ali decided to broaden his horizons within the boundaries of drama, by taking a position at the RAHAT community center, as an acting teacher.\n\nAfter his time at Negev, Ali went on to star in such award-winning films as \\\"Paradise Now\\\" (Best Foreign film winner Golden Globes, and Best Foreign film nominee - Academy Awards), and \\\"The Syrian Bride\\\". He also starred opposite Jamie Foxx and Jennifer Garner in the critically acclaimed action thriller \\\"The Kingdom\\\".\n\nUpcoming projects include the political thriller \\\"Body of Lies\\\" from legendary director Ridley Scott.', 245289600, 'Nazareth, Israel', '762', 'ali-suliman', 'upload/images/fG9V68oshqkuDSSRkLZdCci6z1Q.jpg'),
(802, 'actor', 'Rob Collins', 'Rob Collins is an Australian television and stage actor and singer. Born in Darwin from a Tiwi Islands background, Collins worked with the National Indigenous Music Awards before coming to acting.\n\nCollins is currently best known for his major roles in the Australian television series **Cleverman** and **The Wrong Girl**, both of which premiered in 2016.', 302572800, 'Darwin, Northern Territory, Australia', '1636490', 'rob-collins', 'upload/images/dwru1rbrfHGa1PQRbl9ZwA7a7F6.jpg'),
(803, 'actor', 'Elizabeth Chahin', '', 0, '', '2879806', 'elizabeth-chahin', 'upload/images/719PqnIkC599BNByNAsHaCp9vlg.jpg'),
(804, 'actor', 'Viktor Åkerblom', '', 665280000, 'Söderköping, Östergötlands Län, Sweden', '105465', 'viktor-åkerblom', 'upload/images/qeAD9O929WUzBPFNKc7IU9fbXva.jpg'),
(805, 'actor', 'Zamantha Díaz', '', 0, '', '3222852', 'zamantha-díaz', 'upload/images/iTDcO8WVMw1bgtBVriEMrCdHVor.jpg'),
(806, 'director', 'Simon Cellan Jones', '', 0, '', '2879806', 'simon-cellan-jones', 'upload/images/qehGPEQGGGmSYMHPIiQI2zvDrGM.jpg'),
(807, 'actor', 'Jack Black', 'Thomas Jacob \\\"Jack\\\" Black (born August 28, 1969) is an American actor, comedian, musician, and songwriter. Black is known for his roles in the films High Fidelity (2000), Shallow Hal (2001), Orange County (2002), School of Rock (2003), Envy (2004), Gulliver\\\'s Travels (2010), Bernie (2011) and The House with a Clock in Its Walls (2018), in addition to his role in the Jumanji franchise. He also voices the giant panda named Po from DreamWorks Animation\\\'s Kung Fu Panda films. He gained Golden Globe nominations for his work in School of Rock and Bernie, and he was given a star on Hollywood\\\'s Walk of Fame in 2018.\n\nBlack is also the lead vocalist of the Grammy Award–winning comedy rock duo Tenacious D, which he formed in 1994 with long time friend, Kyle Gass. They have released multiple studio albums including their self titled debut Tenacious D, The Pick of Destiny, Rize of the Fenix, and Post-Apocalypto, in addition to their television series Tenacious D (1997–2000) and film Tenacious D in The Pick of Destiny (2006). Since 2018, Black has maintained a YouTube channel called Jablinski Games.', -10886400, 'Santa Monica, California, USA', '70851', 'jack-black', 'upload/images/rtCx0fiYxJVhzXXdwZE2XRTfIKE.jpg'),
(808, 'actor', 'Awkwafina', 'Nora Lum (born June 2, 1988), known professionally as Awkwafina, is an American actress, rapper, and comedian who rose to prominence in 2012 when her rap song \\\"My Vag\\\" became popular on YouTube. She then released her debut album, Yellow Ranger (2014), and appeared on the MTV comedy series Girl Code (2014–2015). Her second album, In Fina We Trust, was released in 2018. She played supporting roles in the comedy films Neighbors 2: Sorority Rising (2016), Ocean\\\'s 8 (2018), Crazy Rich Asians (2018), and Jumanji: The Next Level (2019).\n\nAwkwafina played a leading role in the comedy-drama film The Farewell (2019), for which she received critical acclaim and won the Golden Globe Award for Best Actress in a Motion Picture – Comedy or Musical, becoming the first woman of Asian descent to win a Golden Globe in any lead actress film category, and additionally won the Satellite Award for Best Actress and was nominated for the BAFTA Rising Star Award and the Critics\\\' Choice Movie Award for Best Actress.\n\nAwkwafina is co-creator, writer, and executive producer of the Comedy Central series Awkwafina Is Nora from Queens (2020–present), in which she stars as a fictionalized version of herself. She then appeared in Swan Song (2021), voiced Courtney in The Angry Birds Movie 2, Sisu in Raya and the Last Dragon (2021) and Ms. Tarantula in The Bad Guys (2022), and portrayed Katy in the Marvel Cinematic Universe (MCU) superhero film Shang-Chi and the Legend of the Ten Rings (2021).', 581212800, 'Stony Brook, Brookhaven, New York, USA', '1625558', 'awkwafina', 'upload/images/l5AKkg3H1QhMuXmTTmq1EyjyiRb.jpg'),
(809, 'actor', 'Viola Davis', 'Viola Davis (born August 11, 1965) is an American actress and producer. The recipient of numerous accolades, Davis is one of the few performers to have been awarded an Emmy, a Grammy, an Oscar, and a Tony (EGOT); additionally, she is the sole African-American to achieve the Triple Crown of Acting as well as the third person to achieve both statuses. Time named her one of the 100 most influential people in the world in 2012 and 2017, and in 2020, The New York Times ranked her ninth on its list of the greatest actors of the 21st century.\n\nDavis began her career in Central Falls, Rhode Island, appearing in small stage productions. After graduating from the Juilliard School in 1993, she won an Obie Award in 1999 for her performance as Ruby McCollum in Everybody\\\'s Ruby. She played minor roles in film and television in the late 1990s and early 2000s, before earning the Tony Award for Best Featured Actress in a Play for her role as Tonya in the 2001 Broadway production of August Wilson\\\'s King Hedley II. Her film breakthrough came with her role as a troubled mother in the drama Doubt (2008), for which she received her first Academy Award nomination for Best Supporting Actress. Davis won the 2010 Tony Award for Best Actress in a Play for her role as Rose Maxson in the Broadway revival of August Wilson\\\'s play Fences.\n\nFor starring as a 1960s housemaid in the comedy-drama The Help (2011), Davis received a nomination for the Academy Award for Best Actress. From 2014 to 2020, she played lawyer Annalise Keating in the ABC drama series How to Get Away with Murder, for which she became the first black actress to win the Primetime Emmy Award for Outstanding Lead Actress in a Drama Series in 2015. In 2016, Davis reprised the role of Maxson in the film adaptation of Fences, winning the Academy Award for Best Supporting Actress. She played Amanda Waller in the DC Extended Universe, beginning with Suicide Squad (2016). In 2020, she portrayed Ma Rainey in the biopic Ma Rainey\\\'s Black Bottom, for which she received a fourth Academy Award nomination, becoming the most-Oscar-nominated black actress. Her performances in Widows (2018) and The Woman King (2022) earned her further nominations for the BAFTA Best Actress Award, making her the most-BAFTA-nominated black actress.\n\nDavis and her husband, Julius Tennon, are founders of a production company, JuVee Productions. Davis is also widely recognized for her advocacy and support of human rights and equal rights for women and women of color. She received a star on the Hollywood Walk of Fame in 2017 and became a L\\\'Oréal Paris ambassador in 2019. The audiobook narration of her 2022 memoir Finding Me earned Davis a Grammy Award in 2023.', -138585600, 'Saint Matthews, South Carolina, USA', '19492', 'viola-davis', 'upload/images/xDssw6vpYNRjsybvMPRE30e0dPN.jpg'),
(810, 'actor', 'Ke Huy Quan', 'Ke Huy Quan (born August 20, 1971), also known as Jonathan Ke Quan, is an American actor. As a young actor, Quan rose to fame playing Short Round in Indiana Jones and the Temple of Doom (1984) and Data in The Goonies (1985).\n\nFollowing a few roles in the 1990s, Quan took an almost 20-year acting hiatus during which he worked as a stunt choreographer and assistant director. He returned to acting with the science fiction film Everything Everywhere All at Once (2022). His performance was widely praised and won him many accolades, including an Academy Award, Critics Choice, Golden Globe, Independent Spirit, and SAG Award.', 51494400, 'Saigon, Vietnam [now Ho Chi Minh City]', '690', 'ke-huy-quan', 'upload/images/5PfYVcNLs1gGKIo0qwJrvyc2UOZ.jpg'),
(811, 'actor', 'Dustin Hoffman', 'Dustin Lee Hoffman (born August 8, 1937) is an American actor and filmmaker. He is known for his versatile portrayals of antiheroes and emotionally vulnerable characters. Actor Robert De Niro described him as \\\"an actor with the everyman\\\'s face who embodied the heartbreakingly human\\\". At a young age Hoffman knew he wanted to study in the arts, and entered into the Los Angeles Conservatory of Music; later he decided to go into acting, for which he trained at the Pasadena Playhouse in Los Angeles. His first theatrical performance was 1961\\\'s A Cook for Mr. General as Ridzinski. During that time he appeared in several guest roles on television shows like Naked City and The Defenders. He then starred in the 1966 off-Broadway play Eh? where his performance garnered him both a Theatre World Award and Drama Desk Award.\n\nHis breakthrough role was as Benjamin Braddock in Mike Nichols\\\' critically acclaimed and iconic film The Graduate (1967), for which he received his first Academy Award nomination. His next role was \\\"Ratso\\\" Rizzo in John Schlesinger\\\'s Midnight Cowboy (1969), in which he acted alongside Jon Voight; they both received Oscar nominations, and the film went on to win the Academy Award for Best Picture. He gained success in the 1970s playing roles that shaped the craft of his acting, crossing genres effortlessly in the western Little Big Man (1970), the prison drama Papillon (1973), playing a controversial and groundbreaking comedian in Bob Fosse\\\'s Lenny (1975), Marathon Man alongside Laurence Olivier (1976), and as Carl Bernstein investigating the Watergate scandal in All the President\\\'s Men (1976). In 1979, Hoffman starred in the family drama Kramer vs. Kramer alongside Meryl Streep. They both received Academy Awards for their performances.\n\nAfter a three-year break from films, Hoffman returned in Sydney Pollack\\\'s show business comedy Tootsie (1982) about a struggling actor who pretends to be a woman in order to get an acting role. He returned to stage acting with a 1984 performance as Willy Loman in Death of a Salesman and reprised the role a year later in a television film earning a Primetime Emmy Award. In 1987 he starred alongside Warren Beatty in Elaine May\\\'s comedy Ishtar. He won his second Academy Award for Best Actor for his portrayal of the autistic savant Ray Babbitt in the 1988 film Rain Man, co-starring Tom Cruise. In 1989, he was nominated for a Tony Award and a Drama Desk Award for playing Shylock in a stage performance of The Merchant of Venice. In the 1990s, he made appearances in such films as Warren Beatty\\\'s action comedy adaptation Dick Tracy (1990), Steven Spielberg\\\'s Hook (1991) as Captain Hook, medical disaster Outbreak (1995), legal crime drama Sleepers (1996), and the satirical black comedy Wag the Dog (1997) alongside Robert De Niro.', -1022457600, 'Los Angeles, California, USA', '4483', 'dustin-hoffman', 'upload/images/yFjTzJHE6AFbwQifOlnNDzmiwlq.jpg'),
(812, 'actor', 'James Hong', 'James Hong (born February 22, 1929) is a Chinese American actor and former president of the Association of Asian/Pacific American Artists (AAPAA). A prolific acting veteran, Hong\\\'s career spans over 50 years and includes more than 350 roles in film, television, and video games.', -1289347200, 'Minneapolis, Minnesota, USA', '20904', 'james-hong', 'upload/images/v3lfw5aHOy0paOCx6WHiSnwzbH0.jpg'),
(813, 'actor', 'Angelina Jolie', 'Angelina Jolie is an American actress. She has received an Academy Award, two Screen Actors Guild Awards, and three Golden Globe Awards. Jolie has promoted humanitarian causes throughout the world, and is noted for her work with refugees as a Goodwill Ambassador for the United Nations High Commissioner for Refugees (UNHCR). She has been cited as one of the world\\\'s most beautiful women and her off-screen life is widely reported.\n\nThough she made her screen debut as a child alongside her father Jon Voight in the 1982 film Lookin\\\' to Get Out, Jolie\\\'s acting career began in earnest a decade later with the low-budget production Cyborg 2 (1993). Her first leading role in a major film was in Hackers (1995). She starred in the critically acclaimed biographical films George Wallace (1997) and Gia (1998), and won an Academy Award for Best Supporting Actress for her performance in the drama Girl, Interrupted (1999). Jolie achieved wider fame after her portrayal of video game heroine Lara Croft in Lara Croft: Tomb Raider (2001), and since then has established herself as one of the best-known and highest-paid actresses in Hollywood. She has had her biggest commercial successes with the action-comedy Mr. & Mrs. Smith (2005) and the animated film Kung Fu Panda (2008).\n\nDivorced from actors Jonny Lee Miller and Billy Bob Thornton, Jolie currently lives with actor Brad Pitt, in a relationship that has attracted worldwide media attention. Jolie and Pitt have three adopted children, Maddox, Pax, and Zahara, as well as three biological children, Shiloh, Knox, and Vivienne.', 171072000, 'Los Angeles, California, USA ', '11701', 'angelina-jolie', 'upload/images/k3W1XXddDOH2zibPkNotIh5amHo.jpg'),
(814, 'actor', 'Jackie Chan', 'Jackie Chan (Chinese: 成龍; born 7 April 1954), born Chan Kong-sang, is a Hong Kong actor, action choreographer, filmmaker, comedian, producer, martial artist, screenwriter, entrepreneur, singer and stunt performer. In his movies, he is known for his acrobatic fighting style, comic timing, use of improvised weapons, and innovative stunts. Jackie Chan has been acting since the 1970s and has appeared in over 100 films.\n\nChan has received stars on the Hong Kong Avenue of Stars and the Hollywood Walk of Fame. As a cultural icon, Chan has been referenced in various pop songs, cartoons, and video games. Chan is also a Cantopop and Mandopop star, having released a number of albums and sung many of the theme songs for the films in which he has starred.\n\nChan was born on April 7, 1954, in Victoria Peak, in the former Crown colony of Hong Kong, as Chan Kong-sang (meaning \\\"born in Hong Kong\\\") to Charles and Lee-Lee Chan, refugees from the Chinese Civil War. He was nicknamed Paopao (Chinese: 炮炮, literally meaning \\\"Cannonball\\\") because he was such a big baby, weighing 12 pounds, or about 5.4 kgs. Since his parents worked for the French Consul to Hong Kong, Chan spent his formative years within the grounds of the consul\\\'s residence in the Victoria Peak district. Chan attended the Nah-Hwa Primary School on Hong Kong Island, where he failed his first year, after which his parents withdrew him from the school.\n\nIn 1960, his father immigrated to Canberra, Australia, to work as the head cook for the American embassy, and Chan was sent to the China Drama Academy, a Peking Opera School run by Master Yu Jim-yuen. Chan trained rigorously for the next decade, excelling in martial arts and acrobatics. He eventually became part of the Seven Little Fortunes, a performance group made up of the school\\\'s best students, gaining the stage name Yuen Lo in homage to his master. Chan became close friends with fellow group members Sammo Hung and Yuen Biao, the three of them later to be known as the Three Brothers or Three Dragons. At the age of 17, he worked as a stuntman in the Bruce Lee films Fist of Fury and Enter the Dragon under the stage name Chan Yuen Lung. He received his first starring role later that year, in Little Tiger of Canton, which had a limited release in Hong Kong in 1973.', -496627200, 'Victoria Peak, Hong Kong', '18897', 'jackie-chan', 'upload/images/nraZoTzwJQPHspAVsKfgl3RXKKa.jpg'),
(815, 'actor', 'Seth Rogen', 'Seth Aaron Rogen (born April 15, 1982) is a Canadian-American actor, comedian, producer and filmmaker. Originally a stand-up comedian in Vancouver, he moved to Los Angeles for a part in Judd Apatow\\\'s series Freaks and Geeks, and then got a part on the sitcom Undeclared, which also hired him as a writer. After landing his job as a staff writer on the final season of Da Ali G Show, Apatow guided Rogen toward a film career. As a staff writer, he was nominated for a Primetime Emmy Award for Outstanding Writing for a Variety Series.\n\nHis first movie appearance was a minor role in Donnie Darko (2001). Rogen was cast in a supporting role and credited as a co-producer in Apatow\\\'s directorial debut, The 40-Year-Old Virgin. Universal Pictures subsequently cast him as the lead in Apatow\\\'s films Knocked Up and Funny People. Rogen co-starred as Steve Wozniak in Universal\\\'s Steve Jobs biopic in 2015. In 2016, he developed the AMC television series Preacher with his writing partner Evan Goldberg and Sam Catlin. He also serves as a writer, executive producer, and director, with Goldberg.\n\nRogen and Goldberg co-wrote the films Superbad, Pineapple Express, The Green Hornet, This Is the End, and directed both This Is the End and The Interview, all of which Rogen starred in. He has also done voice work for the films Shrek the Third, Horton Hears a Who!, the Kung Fu Panda trilogy, The Spiderwick Chronicles, Monsters vs. Aliens, Paul, Sausage Party, the 2019 version of The Lion King, and The Super Mario Bros. Movie.', 387676800, 'Vancouver, British Columbia, Canada', '19274', 'seth-rogen', 'upload/images/2dPFskUtoiG0xafsSEGl9Oz4teA.jpg'),
(816, 'director', 'Mike Mitchell', 'Ke Huy Quan (born August 20, 1971), also known as Jonathan Ke Quan, is an American actor. As a young actor, Quan rose to fame playing Short Round in Indiana Jones and the Temple of Doom (1984) and Data in The Goonies (1985).\n\nFollowing a few roles in the 1990s, Quan took an almost 20-year acting hiatus during which he worked as a stunt choreographer and assistant director. He returned to acting with the science fiction film Everything Everywhere All at Once (2022). His performance was widely praised and won him many accolades, including an Academy Award, Critics Choice, Golden Globe, Independent Spirit, and SAG Award.', 51494400, 'Saigon, Vietnam [now Ho Chi Minh City]', '690', 'mike-mitchell', 'upload/images/9ErS7QpRTxPNPreL6hInXYUdF1X.jpg'),
(817, 'actor', 'Dhanush', 'Venkatesh Prabhu Kasthuri Raja, known professionally as Dhanush, is an Indian actor, producer, director, lyricist and playback singer who works mainly in Tamil cinema. One of the most recognizable stars of contemporary South Indian cinema, his accolades include 4 National Film Awards (two as actor and two as producer), 14 SIIMA Awards, 9 Vijay Awards, 7 Filmfare Awards South, 5 Vikatan Awards, 5 Edison Awards and a Filmfare Award. After initially gaining recognition as a versatile character actor in films such as Kadhal Konden and Pudhupettai, Dhanush came to further prominence as a popular leading man in Polladhavan and Yaaradi Nee Mohini, both of which were critically acclaimed and commercially successful. His role as a rooster fight jockey in Aadukalam won him the National Film Award for Best Actor and the Filmfare Award for Best Actor – Tamil. He saw continued critical and commercial success with hit films such as Mayakkam Enna, Velaiilla Pattadhari, Vadachennai, Asuran, Karnan and Thiruchitrambalam. Vadachennai emerged as the highest-grossing A-rated Tamil film of all time, while Thiruchitrambalam entered the 100 Crore Club within a month of its release. Dhanush also gained recognition in the Bollywood film industry through his performance as an obsessive one-sided lover in the film Raanjhanaa, which won him the Filmfare Award for Best Male Debut in addition to a nomination for the Filmfare Award for Best Actor. He is also well known as a playback singer and lyricist, often contributing to the soundtracks of his own films. In 2011, his song \\\"Why This Kolaveri Di\\\" from the romantic psychological thriller film Moonu became the first Indian music video to cross 100 million views on YouTube.', 428198400, 'Chennai, Tamil Nadu, India', '550165', 'dhanush', 'upload/images/xnGKntkTDURY5mJ0sOVRI3VIDsY.jpg'),
(818, 'actor', 'Priyanka Arul Mohan', 'Priyanka Arul Mohan is an Indian model and film Actress, who has worked predominantly in Telugu, Kannada and Tamil movie industry. She made her acting debut through Kannada movie Ondh Kathe Hella directed by Girish Girija Joshi in the year 2019. Priya made Telugu debut through Nani - Vikram K Kumar\\\'s thriller movie Gang Leader, which gave her immense popularity.', 773020800, 'Chennai, Tamilnadu,  India', '2243286', 'priyanka-arul-mohan', 'upload/images/wlX9ApnzPpMqVVGJ9Iwo5Ie4wyI.jpg'),
(819, 'actor', 'Nivedhithaa Sathish', '', 906768000, 'Chennai, Tamil Nadu, India', '2512339', 'nivedhithaa-sathish', 'upload/images/yFn5SxXNaCMRvQJ9awJKR8Z2ET6.jpg'),
(820, 'actor', 'Shivaraj Kumar', 'Shivaraj Kumar is an Indian actor who appears in Kannada films.', -235872000, 'Shimoga, Karnataka, India', '1343007', 'shivaraj-kumar', 'upload/images/aOQ6tjRLjMReW8Pig9PjJaudl5b.jpg'),
(821, 'actor', 'Sundeep Kishan', 'Sundeep Kishan is an Indian film actor, best known for his role in the  film Prasthanam. Earlier he had assisted director Gautham Menon on  Vaaranam Aayiram.', 547344000, 'Chennai, Tamilnadu,  India', '1011802', 'sundeep-kishan', 'upload/images/qUGN6rvwu9Qef3DGenha2pIEpNY.jpg'),
(822, 'actor', 'Edward Sonnenblick', '', -86400, 'Cupertino, California, USA', '1936126', 'edward-sonnenblick', 'upload/images/8RAG0dhQp1L50zMpP0sh1rLP3tf.jpg');
INSERT INTO `actor_director` (`id`, `ad_type`, `ad_name`, `ad_bio`, `ad_birthdate`, `ad_place_of_birth`, `ad_tmdb_id`, `ad_slug`, `ad_image`) VALUES
(823, 'actor', 'John Kokken', 'John Kokken aka Anish John Kokken is an Indian film actor, who works mainly in Telugu and Tamil cinemas.', 354499200, 'Mumbai, Maharashtra, India', '2735982', 'john-kokken', 'upload/images/3dIc5cYnlzLYjaZYTOkrTIAg2D1.jpg'),
(824, 'actor', 'Vinoth Kishan', 'Vinoth Kishan is an Indian film actor who primarily appeared in Tamil, Telugu and Malayalam language films. As a child, he made his debut in Bala\\\'s \\\"Nandha\\\", followed by playing villains in \\\"Naan Mahan Alla\\\" and \\\"Vidiyum Munn\\\".', 617587200, 'Chennai, Tamil Nadu, India', '1418690', 'vinoth-kishan', 'upload/images/eT6QbjpqwqSgKiyOlaWwXzUdbOO.jpg'),
(825, 'actor', 'Jayaprakash', 'Jayaprakash is an Indian film actor and producer. He ventured  into film business in the early 2000s as a producer, making several  films under his banner GJ Cinema and later turned actor, with Cheran\\\'s 2007 film, Mayakannadi. Subsequently performing a variety of supporting roles, he found more success as a character actor, with his most notable performances featuring in Pasanga,Moodar Koodam, Naadodigal, Yuddham Sei, Naan Mahaan Alla and Mankatha.', -378691200, 'Chennai, Tamil Nadu, India', '560038', 'jayaprakash', 'upload/images/11g55pqwavrHBP09EQpUuJrllDU.jpg'),
(826, 'actor', 'Aditi Balan', 'Aditi Balan is an Indian film actress who works mainly in Tamil and Malayalam films.', 653875200, 'Chennai, Tamil Nadu, India', '1922502', 'aditi-balan', 'upload/images/g9eYQwx69tNGNNoqoubREEi05Br.jpg'),
(827, 'director', 'Arun Matheswaran', 'Aditi Balan is an Indian film actress who works mainly in Tamil and Malayalam films.', 653875200, 'Chennai, Tamil Nadu, India', '1922502', 'arun-matheswaran', 'upload/images/vYaxEP8x8UBuiQ2vUtjzIOKfeWI.jpg'),
(828, 'actor', 'David Attenborough', 'Sir David Attenborough (8th May 1926) is a broadcaster and naturalist. His career as the respected face and voice of natural history programmes has endured for more than 50 years. He is best known for writing and presenting the nine \\\"Life\\\" series, in conjunction with the BBC Natural History Unit, which collectively form a comprehensive survey of all life on the planet. He is also a former senior manager at the BBC, having served as controller of BBC Two and director of programming for BBC Television in the 1960s and 1970s.\n\nHe is the younger brother of director, producer and actor Richard Attenborough.', -1377561600, 'London, England, UK', '86543', 'david-attenborough', 'upload/images/tt3LW3XftcvxOZtMXmIaJSWFN7y.jpg'),
(829, 'director', 'Toby Nowlan', '', NULL, '', '3023035', 'toby-nowlan', NULL),
(830, 'director', 'Ed Charles', '', NULL, '', '2942396', 'ed-charles', NULL),
(831, 'director', 'Huw Cordey', '', NULL, '', '1241968', 'huw-cordey', NULL),
(832, 'actor', 'Kate Atkinson', 'Kate Atkinson (born 28 June 1972) is an Australian film, television and theatre actress. She is best known for her roles on television series SeaChange as police officer Karen Miller and Offspring as Renee. Since 2013, she has appeared in a regular role in Wentworth as Deputy Governor Vera Bennett.', 78537600, 'Kalgoorlie, Western Australia, Australia', '80266', 'kate-atkinson', 'upload/images/vHRuhu9Cc0mxMUR8FEssRq7kxXa.jpg'),
(833, 'actor', 'Robbie Magasiva', 'From Wikipedia, the free encyclopedia\n\nRobbie Magasiva (born in 1972) is a Samoan New Zealand actor who has starred in several films and as a member of the Naked Samoans comedy troupe. He has also appeared on television and theatre, and was the co-presenter of New Zealand\\\'s Tagata Pasifika with famed athlete Beatrice Faumuina. Magasiva is also known for his role on Shortland Street as Dr. Maxwell Avia which he has played from June 2009 to present.\n\nDescription above from the Wikipedia article Robbie Magasiva, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 75254400, 'Wellington, New Zealand', '76834', 'robbie-magasiva', 'upload/images/fdnh8qJZhQveUvz7tmrUXwAhJXF.jpg'),
(834, 'actor', 'Jacqueline Brennan', 'Jacquie Brennan is an Australia TV Actress, stage and voice over artist, who is best known for her roles as Linda Miles on Wentworth, Mel on The Hollowmen, Samantha on Bullpitt and for guest appearances on Secret Bridesmaids Business, Informer 3838, City Homicide and many more.', NULL, '', '1240664', 'jacqueline-brennan', 'upload/images/y3O73soOPqLeJd0ykfopuYbcHHe.jpg'),
(835, 'actor', 'Katrina Milosevic', '', NULL, '', '1218733', 'katrina-milosevic', 'upload/images/oG5tdFzLPysL5IDlec47NwGBfCM.jpg'),
(836, 'actor', 'Nicole da Silva', 'From Wikipedia, the free encyclopedia\n\nNicole da Silva (born 18 September 1981) is an Australian actress, best known for her roles as Stella Dagostino in the series Rush (2008–2011), and as Franky Doyle in the show Wentworth (2013–2018, 2019). She has made appearances in series such as Carla Cametti PD (2009) and Doctor Doctor (2016–present).', 369619200, 'Sydney, New South Wales, Australia', '1235032', 'nicole-da-silva', 'upload/images/6qf8wb47MWRXqp9vWCVQV9GNp7A.jpg'),
(837, 'actor', 'Celia Ireland', 'Celia Ireland is an Australian actress. She is best known for her role as Regina Butcher on the television series All Saints and her Logie award winning role as Liz Birdsworth on the prison drama series Wentworth.', -114566400, 'Newcastle, Australia', '84556', 'celia-ireland', 'upload/images/5Jn1HekfmjDlogh9G1dZKUmPSJG.jpg'),
(838, 'actor', 'Pamela Rabe', '', -336873600, 'Oakville, Ontario, Canada', '217137', 'pamela-rabe', 'upload/images/cbu3MMqRU6O8fDTajoHiNSXCn6e.jpg'),
(839, 'actor', 'Kate Jenkinson', '', 367459200, 'Perth, Australia', '215298', 'kate-jenkinson', 'upload/images/gtqc8SAC9hp2kffeD5SwrZHHRU7.jpg'),
(840, 'actor', 'Tammy Macintosh', 'Tammy MacIntosh (born 16 February 1970) is an Australian actress.', 3974400, 'Perth, Western Australia, Australia', '223903', 'tammy-macintosh', 'upload/images/dKU6IZpKZMMMLQ8tAKF1PPLFmTd.jpg'),
(841, 'actor', 'Shareena Clanton', '', 644889600, '', '1450929', 'shareena-clanton', 'upload/images/8wR4aph7EkLpZ5fUfxZtMsl0CmO.jpg'),
(842, 'actor', 'Danielle Cormack', 'From Wikipedia, the free encyclopedia.  Danielle Cormack (born 26 December 1970) is a stage  and screen actress from New Zealand.  She was one of the original core cast of the long-running soap opera Shortland Street, though she is most famous for her role as the Amazon Ephiny in the television series Xena: Warrior Princess, and more recently as Cynthia Ross in The Cult, and Shota in Legend of the Seeker. Her works include the 2009 film, Separation City, and the Australian series Rake.  Description above from the Wikipedia article Danielle Cormack , licensed under CC-BY-SA,full list of contributors on Wikipedia.', 31017600, 'Auckland, New Zealand', '66577', 'danielle-cormack', 'upload/images/xp4Ar2mm5dGzIYftHLtkTYN9N80.jpg'),
(843, 'actor', 'Bernard Curry', 'Bernard Curry (born 27 March 1974) is a Sydney-based Australian actor, best known for his role as Jake Stewart in Wentworth, Luke Handley in Neighbours and Hugo Austin in Home and Away.', 133574400, 'Melbourne, Victoria, Australia', '42394', 'bernard-curry', 'upload/images/tSZTKbE0TkU0CbZxzgeixqlyoTq.jpg'),
(844, 'actor', 'Socratis Otto', '', NULL, '', '75174', 'socratis-otto', 'upload/images/sVDIF8Rr7dx0Kb8T5T7ssxeEd6q.jpg'),
(845, 'actor', 'Rarriwuy Hick', 'Rarriwuy Hick is an Australian actress, known for her roles in the television series Redfern Now and Cleverman.', NULL, ' Sydney, Australia', '1275903', 'rarriwuy-hick', 'upload/images/8NJrbt2aguLr9eXKcJ4fD9YnpLL.jpg'),
(846, 'actor', 'Leah Purcell', '', 19440000, 'Murgon, Queensland, Australia', '38782', 'leah-purcell', 'upload/images/pZdJfok4L5MEPyzgjQZlIePtVPP.jpg'),
(847, 'actor', 'Susie Porter', 'Susie Porter is a Logie Award winning Australian television and film actress.  In 2000, she starred in the film Bootmen and in the crime drama film The Monkey\\\'s Mask, which she plays a lesbian private detective who falls in love with a suspect. In 2001 she appeared in the Australian movie Mullet and had a small role in Star Wars Episode II: Attack of the Clones. In 2005, Porter had a supporting role in the Australian film Little Fish. In 2006, she had a role in the film The Caterpillar Wish which won her Best Supporting Actress in the AFI Awards.', 31536000, 'Newcastle, Australia', '51671', 'susie-porter', 'upload/images/ynlvVxiKsmzJ5L7Rj6Kcntnczzh.jpg'),
(848, 'actor', 'Aaron Jeffery', 'Aaron C. Jeffery (born 1970) is a Logie Award winning New Zealand – Australian actor.  Born in Howick, Auckland, Jeffery moved to Australia at the age of 17 and studied acting at NIDA.  Jeffery has been in a relationship with his former McLeod\\\'s Daughters co-star Zoe Naylor since 2010.[1] The couple welcomed their first child together, a daughter called Sophia Jade Jeffery, in 2012.Jeffery also has another daughter from a previous relationship.', 20390400, 'Auckland, New Zealand', '92172', 'aaron-jeffery', 'upload/images/8mt7NCevggbt9kVL5NBuz630n4K.jpg'),
(849, 'actor', 'Libby Tanner', 'Libby Tanner is an Australian Television, stage and theatre director who was born in Melbourne, Victoria Australia. Tanner is best known for her roles in All Saints (1998) as Bronwyn \\\'Bron\\\' Craig, Headland (2005), Rescue Special Ops (2009), Nowhere Boys (2013) and as fan favourite Prison Psych Bridget Westfall in Australian award winning drama Wentworth (2013), where she joined the cast of the series during season 3, Tanner and fellow actor on the series Nicole da Silva became the fan favourite relationship calling the character ship \\\'Fridget\\\'.\n\nDuring Tanner\\\'s run on All Saints she would be nominated 7 times for Logies and won twice in 2002 and 2003 for Most Popular Actress.\n\nTanner runs her own theatre company \\\'Mad as Us\\\'.', 4752000, 'Melbourne, Victoria, Australia', '1229671', 'libby-tanner', 'upload/images/kyjuFAOmb8mFbYVUQzuxZh7h1NX.jpg'),
(850, 'actor', 'David de Lautour', 'David de Lautour is an actor and writer.', 407289600, 'Christchurch, Canterbury, New Zealand', '1212129', 'david-de-lautour', 'upload/images/bpXXaZ93AmOXfI1ptFLWF6VFxT.jpg'),
(851, 'actor', 'Sigrid Thornton', '', -343526400, 'Canberra, Australian Capital Territory, Australia', '76181', 'sigrid-thornton', 'upload/images/tz3maeyiAUj9r17HsyYk2rIjDX3.jpg'),
(852, 'actor', 'Ra Chapman', '', NULL, '', '934252', 'ra-chapman', NULL),
(853, 'director', 'Kevin Carlin', '', NULL, '', '1228895', 'kevin-carlin', NULL),
(854, 'director', 'Catherine Millar', '', NULL, '', '1221012', 'catherine-millar', NULL),
(855, 'director', 'Pino Amenta', '', NULL, '', '1219620', 'pino-amenta', NULL),
(856, 'director', 'Steve Jodrell', '', NULL, '', '97589', 'steve-jodrell', NULL),
(857, 'director', 'Dee McLachlan', 'Dee McLachlan is a film director, producer, and writer from Middle Park, Victoria. She has directed such films as Scavengers, The Double 0 Kid, Running Wild, Deadly Chase, and The Second Jungle Book: Mowgli & Baloo.', -594259200, '', '83284', 'dee-mclachlan', NULL),
(858, 'director', 'Tori Garrett', '', NULL, '', '1799687', 'tori-garrett', NULL),
(859, 'director', 'Jet Wilkinson', '', NULL, '', '1532988', 'jet-wilkinson', NULL),
(860, 'actor', 'Tyrese Gibson', 'Tyrese Darnell Gibson (born December 30, 1978), also known mononymously as Tyrese, is an American Grammy-nominated R&B singer, songwriter, actor, author, television producer, former fashion model and MTV VJ. He is best known for his role as Roman Pearce in the The Fast and the Furious series.', 283824000, 'Los Angeles, California, USA', '8169', 'tyrese-gibson', 'upload/images/1K315wBQBvDBuZMlzoozuGsqFXZ.jpg'),
(861, 'actor', 'Ludacris', 'Christopher Brian Bridges (born September 11, 1977), known professionally as Ludacris, is an American rapper and actor. After forming his own label, Disturbing tha Peace, in the late 1990s, he later signed with Def Jam South and would go on to become one of the first Dirty South rappers to achieve mainstream success with his subsequent releases. For his music, Ludacris has won an MTV Video Music Award and three Grammy Awards.\n\nAs an actor, he is best known for his role as Tej Parker in the Fast and Furious film franchise. His other notable roles include Crash (2004), Gamer (2009), New Year\\\'s Eve (2011), and End of the Road (2023). For his performance in the ensemble of Crash, he was co-awarded a Screen Actors Guild Award and a Critic\\\'s Choice Award for Best Cast.\n\nHis daughter Karma Bridges is an actress.', 242784000, 'Champaign, Illinois, USA', '8171', 'ludacris', 'upload/images/erkJijujhe48vhJ8iCEtVpNEeVn.jpg'),
(862, 'actor', 'John Cena', 'John Felix Anthony Cena is an American professional wrestler, actor, and former rapper currently signed to WWE. Widely regarded as one of the greatest professional wrestlers of all time, he is tied with Ric Flair for the most world championship reigns in professional wrestling history.\n\nBorn and raised in West Newbury, Massachusetts, Cena moved to California in 1998 to pursue a career as a bodybuilder. He transitioned to professional wrestling in 1999 when he debuted for Ultimate Pro Wrestling (UPW). He signed with the World Wrestling Federation (WWF, now WWE) in 2001, where he was initially assigned to Ohio Valley Wrestling (OVW). He gained fame in the WWE after adopting the persona of a trash-talking rapper. He won his first singles title, the United States Championship, in 2004. The next year, he won the WWE Championship for the first time, and his character subsequently transitioned into a clean-cut \\\"Superman-like\\\" hero. He then led the company as its franchise player, and public face for the next decade.\n\nA joint-record 16-time world champion, Cena has won the WWE Championship thirteen times, a record for the title. He is also a five-time United States Champion, a four-time world tag team champion, a two-time Royal Rumble match winner, a one-time Money in the Bank match winner, and has headlined several major WWE pay-per-view events, including their flagship event, WrestleMania, five times. His professional wrestling career has been met with mixed critical and audience reception, with praise for his character work and promotional skills, but criticism for his supposed over-representation and on-screen placement relative to other wrestlers.\n\nCena first starred in The Marine (2006), and gained praise for his performances in Trainwreck (2015), Ferdinand (2017), Blockers, and Bumblebee (both 2018). He starred in F9 and portrayed Peacemaker in The Suicide Squad (both 2021) and in the eponymous television series. His debut studio album, You Can\\\'t See Me (2005), was certified platinum. Outside his work in entertainment, Cena is known for his involvement in numerous charitable causes, namely with the Make-A-Wish Foundation, where he has granted the most wishes, at over 650.', 230601600, 'West Newbury, Massachusetts, USA', '56446', 'john-cena', 'upload/images/rgB2eIOt7WyQjdgJCOuESdDlrjg.jpg'),
(863, 'actor', 'Jordana Brewster', 'Jordana Brewster (born April 26, 1980) is an American actress. She began her acting career with an appearance in the soap opera All My Children (1995). After that, she joined the cast of As the World Turns (1995–2001), as a recurring role, Nikki Munson. She was later cast as one of the main characters in her first film feature film The Faculty (1998). Her role brought her to the attention of a much wider audience. She also landed a starring role in a NBC television miniseries entitled The 60s (1999).\n\nHer breakthrough role came in the action film The Fast and the Furious (2001). Other film roles include the action comedy film D.E.B.S. (2004), the horror film The Texas Chainsaw Massacre: The Beginning (2006), and the fourth and fifth films of the The Fast and the Furious film series, Fast & Furious (2009) and Fast Five (2011). She has appeared as a recurring role in the NBC television series Chuck (2008–2009).\n\nDescription above from the Wikipedia article Jordana Brewster, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 325555200, 'Panama City, Panama', '22123', 'jordana-brewster', 'upload/images/8VzFsSfT7NnMGyH5JQBQdTxDHcO.jpg'),
(864, 'actor', 'Sung Kang', 'Kang was born in Gainesville, Georgia, to South Korean immigrant parents and spent his adolescence in California. He attended the University of California, Riverside. While in college he chose acting over law school, a decision which was met with disappointment from his parents due to their concerns over the lack of Asians on American television and lack of job prospects.\n\nHis first major role was in Better Luck Tomorrow (2002), in which he played Han Lue, an aloof gang member and the cousin of Virgil Hu (played by Jason Tobin). He was one of the stars in The Motel, in which he played Sam Kim. He played the same character Han Lue in The Fast and the Furious film franchise, appearing in The Fast and the Furious: Tokyo Drift, Fast & Furious, Fast Five, Fast & Furious 6, and F9 as well as the short film Los Bandoleros. He also had a role in Jet Li\\\'s film War (2007), playing an FBI agent, and was featured in the movie Forbidden Warrior as Doran, a son of Genghis Khan. He had a small role in the action movie Live Free or Die Hard, and he appeared in Walter Hill\\\'s movie Bullet to the Head (2013) as Detective Taylor Kwon, opposite Sylvester Stallone.\n\nKang has had several notable television roles, including the recurring role of the narcissistic President Gin Kew Yun Chun Yew Nee in the Korean drama parody \\\"Tae Do (Attitudes and Feelings, Both Desirable and Sometimes Secretive)\\\" alongside Bobby Lee on MADtv. He portrayed FBI Agent Tae Kim in the short-lived crime procedural Gang Related on FOX. Both roles required him to speak Korean, which he is conversant in. The character Tae Kim was written specifically for him by creator Chris Morgan, who had worked on the Fast & Furious film franchise.', 71539200, 'Gainesville, Georgia, USA', '61697', 'sung-kang', 'upload/images/ox4ti0WmpJoN19n3iYJ2T2vHP5f.jpg'),
(865, 'actor', 'Jason Momoa', 'Joseph Jason Namakaeha Momoa (born August 1, 1979) is an American actor and filmmaker. He made his acting debut as Jason Ioane on the syndicated action drama series Baywatch: Hawaii (1999–2001), which was followed by his portrayal of Ronon Dex on the Syfy science fiction series Stargate Atlantis (2005–2009), Khal Drogo in the first two seasons of the HBO fantasy drama series Game of Thrones (2011–2012), Declan Harp on the Discovery Channel historical drama series Frontier (2016–2018), and Baba Voss on the Apple TV+ science fiction series See (2019–present). Momoa was featured as the lead of the two lattermost series.\n\nSince 2016, Momoa portrays Arthur Curry / Aquaman in the DC Extended Universe (DCEU), headlining the eponymous 2018 film and its 2023 sequel. Momoa also played Duncan Idaho in the 2021 film adaptation of the science fiction novel Dune.\n\nDescription above from the Wikipedia article Jason Momoa, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 302313600, 'Honolulu, Hawaii, USA', '117642', 'jason-momoa', 'upload/images/6dEFBpZH8C8OijsynkSajQT99Pb.jpg'),
(866, 'actor', 'Scott Eastwood', 'Scott Eastwood (born Scott Clinton Reeves; March 21, 1986) is an American actor, model, and professional skydiver. He has appeared in the films Flags of Our Fathers (2006), Gran Torino (2008), Invictus (2009), The Forger (2012), Trouble with the Curve (2012), Texas Chainsaw (2013), Fury (2014), The Perfect Wave (2014), The Longest Ride (2015), Mercury Plains (2016), Suicide Squad (2016), Snowden (2016) and The Fate of the Furious (2017). He has also been the model for the fragrance Cool Water by Davidoff. He is the youngest son of Academy Award-winning actor-director Clint Eastwood and second youngest of Jacelyn Reeves.\n\nDescription above from the Wikipedia article Scott Eastwood, licensed under CC-BY-SA, full list of contributors on Wikipedia.', 511747200, 'Monterey, California, USA', '928572', 'scott-eastwood', 'upload/images/afBfMtNlGm9dZ2eNSjSVk3XkgoU.jpg'),
(867, 'actor', 'Daniela Melchior', 'Daniela Melchior (born November 1, 1996) is a Portuguese actress. After beginning her career in her home country, she made her English-language debut as Ratcatcher 2 in the DC Extended Universe (DCEU) film The Suicide Squad (2021).', 846806400, 'Lisbon, Portugal', '1784612', 'daniela-melchior', 'upload/images/as7JfOagvDzhINDdA9Lkrp98UnJ.jpg'),
(868, 'director', 'Louis Leterrier', 'Joaquim António Portugal Baptista de Almeida (born 15 March 1957) is a Portuguese actor.\n\nHe began his acting during the 1980s, appearing on the 1982 action movie The Soldier. He achieved international fame with his portrayals of Félix Cortez in the 1995 Tom Clancy\\\'s thriller Clear and Present Danger, drug kingpin Bucho in the 1995 action thriller film Desperado, Ramon Salazar on the Fox thriller drama series 24 and the corrupt businessman Hernan Reyes in 2011 street racing film Fast Five. His other well known films include The Honorary Consul (1983), Good Morning, Babylon (1987), Only You (1994), The Mask of Zorro (1998), Behind Enemy Lines (2001), The Death and Life of Bobby Z (2007), Che: Part Two (2008) and The Burning Plain (2008).\n\nHe has worked in Europe, Argentina, Mexico, the United States and Brazil in many film and stage productions, winning several international awards.', -403920000, 'São Sebastião da Pedreira, Lisbon, Portugal', '22462', 'louis-leterrier', 'upload/images/bpqqRRyCLeoAup2OAv1Dtm5C8Tn.jpg');

-- --------------------------------------------------------

--
-- Table structure for table `app_ads`
--

CREATE TABLE `app_ads` (
  `id` int(11) NOT NULL,
  `ads_name` varchar(255) DEFAULT NULL,
  `ads_info` text DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `app_ads`
--

INSERT INTO `app_ads` (`id`, `ads_name`, `ads_info`, `status`) VALUES
(1, 'Admob', '{\"publisher_id\":\"pub-3940256099942544\",\"banner_on_off\":\"1\",\"banner_id\":\"ca-app-pub-3940256099942544\\/6300978111\",\"interstitial_on_off\":\"1\",\"interstitial_id\":\"ca-app-pub-3940256099942544\\/1033173712\",\"interstitial_clicks\":\"2\"}', 0),
(2, 'StartApp', '{\"publisher_id\":\"203601319\",\"banner_on_off\":\"1\",\"banner_id\":\"\",\"interstitial_on_off\":\"1\",\"interstitial_id\":\"\",\"interstitial_clicks\":\"2\"}', 0),
(3, 'Facebook', '{\"publisher_id\":\"\",\"banner_on_off\":\"1\",\"banner_id\":\"IMG_16_9_APP_INSTALL#932987606893395_932988046893351\",\"interstitial_on_off\":\"1\",\"interstitial_id\":\"IMG_16_9_APP_INSTALL#932987606893395_932990020226487\",\"interstitial_clicks\":\"5\",\"native_on_off\":\"1\",\"native_id\":\"nid\",\"native_position\":\"2\"}', 0),
(4, 'AppLovin\\\'s MAX', '{\"publisher_id\":\"\",\"banner_on_off\":\"1\",\"banner_id\":\"3221a2640039c8a8\",\"interstitial_on_off\":\"1\",\"interstitial_id\":\"06b9bf27824eb7f6\",\"interstitial_clicks\":\"2\",\"native_on_off\":\"0\",\"native_id\":\"06b9bf27824eb7f6\",\"native_position\":\"2\"}', 0),
(5, 'Wortise', '{\"publisher_id\":\"c2f94dbb-e29a-4a95-bbf9-fbf860c428b3\",\"banner_on_off\":\"0\",\"banner_id\":\"test-banner\",\"interstitial_on_off\":\"0\",\"interstitial_id\":\"test-interstitial\",\"interstitial_clicks\":\"2\",\"native_on_off\":\"0\",\"native_id\":\"f78f3300-dc1b-4ece-b85b-2bc5ecbca8bb\",\"native_position\":\"3\"}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `channels_list`
--

CREATE TABLE `channels_list` (
  `id` int(11) NOT NULL,
  `channel_cat_id` int(11) NOT NULL,
  `channel_access` varchar(255) NOT NULL DEFAULT 'Paid',
  `channel_name` varchar(255) NOT NULL,
  `channel_slug` varchar(255) NOT NULL,
  `channel_description` text DEFAULT NULL,
  `channel_thumb` varchar(255) NOT NULL,
  `channel_url_type` varchar(255) NOT NULL,
  `channel_url` varchar(500) NOT NULL,
  `channel_url2` varchar(500) DEFAULT NULL,
  `channel_url3` varchar(500) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `views` bigint(20) NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `channels_list`
--

INSERT INTO `channels_list` (`id`, `channel_cat_id`, `channel_access`, `channel_name`, `channel_slug`, `channel_description`, `channel_thumb`, `channel_url_type`, `channel_url`, `channel_url2`, `channel_url3`, `seo_title`, `seo_description`, `seo_keyword`, `views`, `status`) VALUES
(1, 1, 'Paid', 'Sample TV Channel - m3u8', 'sample-tv-channel-m3u8', '<p>Sample TV Channel - m3u8</p>', 'upload/tearofsteel.jpg', 'HLS', 'https://demo.unified-streaming.com/k8s/features/stable/video/tears-of-steel/tears-of-steel.ism/.m3u8', NULL, NULL, '', '', '', 4, 1),
(2, 3, 'Paid', 'Nat Geo People', 'nat-geo-people', '<p>Nat Geo People was an international pay television channel owned by National Geographic Partners, a joint venture between The Walt Disney Company (73%) and the National Geographic Society (27%).[2] Targeted at female audiences, with programming focusing on people and cultures, the channel is available in 50 countries in both linear and non-linear formats.[3]</p>\r\n<p>The channel was launched as Adventure One Channel on 1 November 1999, rebranded on 2003 as Adventure One (A1) and was later rebranded on 1 May 2007 as National Geographic Adventure, strengthening the overall Nat Geo presence.[4] All countries adopted the change, except in Europe which instead changed A1 to Nat Geo Wild.[5] Nat Geo Adventure is also a global adventure travel video and photography portal, which launched worldwide in 2009.</p>\r\n<p>Nat Geo Adventure was aimed at younger audiences, providing programming based around outdoor adventure, travel and stories involving people having fun while exploring the world.</p>\r\n<p>In early 2008, National Geographic Adventure Australia and Italy launched a new video sharing feature on their website called Blognotes.</p>\r\n<p>In 2010, Nat Geo Adventure launched its own HD feed in Asia via AsiaSat 5.</p>\r\n<p>Nat Geo Adventure Italy upgraded to HD on Sky Italia on 1 February 2012, At the time of launch (0500 UTC).</p>', 'upload/images/New_NatGeo.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 2, 1),
(3, 3, 'Free', 'Food Food', 'food-food', '<p>Food is any substance consumed to provide nutritional support for an organism. Food is usually of plant, animal, or fungal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism\\\'s cells to provide energy, maintain life, or stimulate growth. Different species of animals have different feeding behaviours that satisfy the needs of their unique metabolisms, often evolved to fill a specific ecological niche within specific geographical contexts.</p>\r\n<p>Omnivorous humans are highly adaptable and have adapted to obtain food in many different ecosystems. Historically, humans secured food through two main methods: hunting and gathering and agriculture. As agricultural technologies increased, humans settled into agriculture lifestyles with diets shaped by the agriculture opportunities in their geography. Geographic and cultural differences has led to creation of numerous cuisines and culinary arts, including a wide array of ingredients, herbs, spices, techniques, and dishes. As cultures have mixed through forces like international trade and globalization, ingredients have become more widely available beyond their geographic and cultural origins, creating a cosmopolitan exchange of different food traditions and practices.</p>', 'upload/images/food_food_logo.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 1, 1),
(4, 4, 'Free', 'B4U Music', 'b4u-music', '<p>B4U Music is an Indian Hindi music channel owned by the B4U Network Limited.</p>\r\n<p>The channel broadcasts a mixture of contemporary Bollywood, Indipop, Bhangra and international music. Programs include celebrity interviews, artist profiles, concerts and chart rundowns, as well as video request shows.</p>\r\n<p>There are four different versions of the channel being broadcast in the UK, North America, Africa, the Middle East and South Asia. Each feed produces a quantity of local programming which reflects the culture and tastes of the local population of the Indian diaspora and new logo on 12.12.2020.</p>', 'upload/images/b4u_music.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 3, 1),
(5, 5, 'Paid', 'Al Jazeera Sky News', 'al-jazeera-sky-news', '<p>Al Jazeera (Arabic: الجزيرة, romanized: al-jazīrah, IPA: [&aelig;l (d)ʒ&aelig;ˈziːrɐ], \\\"The Peninsula\\\")[3] is a state-owned Arabic-language international radio and TV broadcaster of Qatar. It is based in Doha and operated by the media conglomerate Al Jazeera Media Network. The flagship of the network, its station identification, is Al Jazeera.</p>\r\n<p>The patent holding is a \\\"private foundation for public benefit\\\" under Qatari law.[4] Under this organizational structure, the parent receives funding from the government of Qatar but maintains its editorial independence.[5][6] In June 2017, the Saudi, Emirati, Bahraini, and Egyptian governments insisted on the closure of the entire conglomerate as one of thirteen demands made to the Government of Qatar during the Qatar diplomatic crisis.[citation needed] The channel has been criticised by some organisations as well as nations such as Saudi Arabia for being \\\"Qatari propaganda\\\".</p>', 'upload/images/sky_news.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 0, 1),
(6, 6, 'Paid', 'Sony Six', 'sony-six', '<p>Sony SIX was launched in April 2012 by Sony Pictures Networks; initially, the channel focused on programming such as Indian Premier League cricket, UFC mixed martial arts, association football, and badminton, aiming to target a younger audience.[1][2]</p>\r\n<p>On 24 October 2022, the channel was rebranded as Sony Sports Ten 5, as part of a wider rebranding of all Culver Max Entertainment channels.</p>', 'upload/images/Sony_Six.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 2, 1),
(7, 6, 'Paid', 'DD Sports', 'dd-sports', '<p>DD Sports was launched on 18 March 1998. In the beginning, it broadcast sports programmes for six hours a day, which was increased to 12 hours in 1999. From 1 June 2000, DD Sports became a \\\"round-the-clock\\\" satellite channel. It was an encrypted pay channel between 2000 and 2003, and on 15 July 2003, it became the only free-to-air sports channel in the country.[1][2]</p>\r\n<p>Besides showing live sporting events like cricket, football, and tennis, DD Sports showcases Indian sports including kabaddi and kho-kho. In addition to international sporting events, important national tournaments of hockey, football, athletics, cricket, swimming, tennis, badminton, archery, and wrestling are also telecast. The DD Sports channel also telecasts news-based programmes, sports quizzes, and personality-oriented shows.</p>', 'upload/images/DD_Sports.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 2, 1),
(8, 3, 'Paid', 'FYI TV18', 'fyi-tv18', '<p>FYI (stylized as fyi,) is an American basic cable channel owned by A&amp;E Networks, a joint venture between the Disney Media Networks subsidiary of The Walt Disney Company and Hearst Communications (each owns 50%). The network features lifestyle programming, with a mix of reality, culinary, home renovation and makeover series.</p>\r\n<p>The network originally launched in 1998 as The Biography Channel, as an offshoot of A&amp;E and named after its television series Biography. As such, it originally featured factual programs, such as reruns of its namesake. As A&amp;E shifted its focus towards reality television and drama series, the Biography Channel became the home for several series that had been displaced by the flagship network (including Biography itself), but shifted towards reality-oriented series itself in 2007 and was rebranded as simply Bio. In 2014, the channel was rebranded as FYI.&nbsp;</p>', 'upload/images/FYI_TV18_Logo.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 2, 1),
(9, 6, 'Free', 'Star Sports', 'star-sports', '<p>Star Sports</p>', 'upload/images/star-sports.jpg', 'HLS', 'https://demo.unified-streaming.com/k8s/features/stable/video/tears-of-steel/tears-of-steel.mp4/.m3u8', 'https://demo.unified-streaming.com/k8s/features/stable/video/tears-of-steel/tears-of-steel.mp4/.m3u8', 'https://demo.unified-streaming.com/k8s/features/stable/video/tears-of-steel/tears-of-steel.mp4/.m3u8', '', '', '', 8, 1),
(10, 2, 'Paid', 'Colors TV', 'colors-tv', '<p>Colors TV is an Indian general entertainment broadcast network owned by Viacom18.[1] The network\\\'s programming consists of family dramas, comedies, youth-oriented reality shows, shows on crime and television films</p>', 'upload/images/Colors_TV.jpg', 'HLS', 'https://www.youtube.com/watch?v=Xmm3Kr5P1Uw', NULL, NULL, '', '', '', 3, 1),
(11, 2, 'Free', 'Sony Max', 'sony-max', '<p>Sony Max (known popularly as Set Max) is an Indian pay television entertainment channel which is a sister channel to Sony Entertainment Television, operated by Culver Max Entertainment. The channel started broadcasting on 20 July 1999[1] and is available internationally. It launched a HD simulcast version on 25 December 2015.</p>', 'upload/images/Sony_Max_Logo.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 1, 1),
(12, 6, 'Paid', 'Star Sports 1', 'star-sports-1', '<p>Star Sports (formerly ESPN Star Sports) is a group of Indian multinational pay television sports channels owned by Disney Star (formerly Star India), a subsidiary of The Walt Disney Company India. Previously a part of ESPN Star Sports with its operations based in Singapore, Star India took over the Indian business and relaunched channels under the unified Star Sports brand in 2013.</p>', 'upload/images/star_sports_1.jpg', 'HLS', 'https://dai2.xumo.com/amagi_hls_data_xumo1212A-redboxfilmhub/CDN/playlist.m3u8', NULL, NULL, '', '', '', 7, 1),
(13, 6, 'Free', 'Sony Ten 1', 'sony-ten-1', '<p>Sony Sports Network, formerly Sony Pictures Sports Network, and also known as Sony TEN, is a group of Indian pay television sports channels owned by Culver Max Entertainment (formerly Sony Pictures Networks India).</p>\r\n<p>The original TEN Sports channel was first established on 1 April 2002 by Abdul Rahman Bukhatir. It was acquired by Essel Group in 2010, and was added to Essel\\\'s existing Zee Sports channel, launched in 2005. After the acquisition, Zee launched two new channels, TEN Cricket and TEN Golf, and rebranded Zee Sports as TEN Action.</p>\r\n<p>In August 2016, Sony Pictures Networks India acquired all of the sports channels under Zee from Essel. In 2017, the networks were formally merged with Sony\\\'s existing Sony ESPN and Sony Six channels as Sony Pictures Sports Network, with the TEN channels rebranded as Sony TEN. The channels were then rebranded as Sony Sports Network in October 2022, with all five channels now carrying the \\\"Sony Sports Ten \\\" prefix.&nbsp;</p>', 'upload/images/Sony_Ten_1.jpg', 'HLS', 'https://livedoc.cgtn.com/1000d/prog_index.m3u8', NULL, NULL, '', '', '', 4, 1),
(14, 2, 'Paid', 'Zee TV', 'zee-tv', '<p>Zee TV (stylised as ZEE TV) is a Hindi general entertainment pay television channel in India. It was launched on 2 October 1992, as the first privately owned TV channel in the country.[1][2] It is owned by Zee Entertainment Enterprises. Zee TV also launched in the UK in 1995.</p>', 'upload/images/Zee-TV-Logo-2011.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 0, 1),
(15, 2, 'Paid', 'StarPlus', 'starplus', '<p>StarPlus is an Indian Hindi language general entertainment pay television channel owned by Disney Star (formerly Star India), a subsidiary of The Walt Disney Company India. The network\\\'s programming consists of family dramas, comedies, youth-oriented reality shows, shows on crime and television films.</p>', 'upload/images/Star_Plus_HD_India.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 0, 1),
(16, 3, 'Paid', 'TLC India', 'tlc-india', '<p>TLC India is an Indian television channel, previously known as Discovery Travel &amp; Living. It focuses on lifestyle programmes, with topics such health, cooking and travel.</p>\r\n<p>The channel launched in October 2004 and was the first international channel launched under the \\\"Discovery Travel &amp; Living\\\" name.</p>', 'upload/images/TLC-BG-1-2.jpg', 'HLS', 'https://siloh.pluto.tv/lilo/production/SkyNews/master.m3u8', NULL, NULL, '', '', '', 0, 1),
(17, 2, 'Paid', 'Sony Sab', 'sony-sab', '<p>Sony SAB was launched as SAB TV by Gautam Adhikari and Markand Adhikari under their company Sri Adhikari Brothers (thus the acronym) on 23 April 1999. At first, it was launched as a Hindi-language comedy channel. Sony Pictures Networks took over SAB TV in March 2005[2][3] and rebranded it as Sony SAB, with a new focus on general entertainment[4] and eventually turning itself into a youth channel. In 2008, Sony SAB changed its appeal to being a Hindi-language generalist network.</p>', 'upload/images/Sony_Entertainment_Television.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 0, 1),
(18, 4, 'Paid', 'MTV Music', 'mtv-music', '<p>MTV Music is a British pay television channel operated by Paramount Networks UK &amp; Australia. The brand was first launched in the UK and Ireland before launching in Australia, New Zealand, Italy, the Netherlands and Poland. Unlike other MTV Music channels, This channel offers subtitles on selected programmes.</p>', 'upload/images/MTV_Music_Logo.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 6, 1),
(19, 2, 'Paid', '&TV', 'tv', '<p>And TV (stylized as &amp;TV) is a Hindi language entertainment channel owned by Zee Entertainment Enterprises. Launched as a general entertainment channel from ZEEL group, it started broadcasting on 2 March 2015.[1] On 1 June 2019, &amp;TV closed down in the UK due to the launch of ZEE5; Zee TV and ZEE5 will air most of its former programmes.</p>', 'upload/images/&tv_Logo.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 1, 1),
(20, 5, 'Paid', 'Sky News', 'sky-news', '<p>In March 2000, <strong>Sky News Active</strong>, a 24-hour interactive service providing headlines and other services which ranged from weather, the top story of the day, and showbiz on demand, was launched.</p>', 'upload/images/sky-news-logo.jpg', 'HLS', 'https://siloh.pluto.tv/lilo/production/SkyNews/master.m3u8', NULL, NULL, '', '', '', 0, 1),
(21, 4, 'Free', 'Mastiii', 'mastiii', '<p>Mastiii is a Hindi language free to air music television channel. Launched by TV Vision, which is a fully owned subsidiary.</p>', 'upload/images/mastiii_live_tv.jpg', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 0, 1),
(22, 5, 'Paid', 'Aaj Tak', 'aaj-tak', '<p>Aaj Tak is an Indian Hindi-language news channel owned by TV Today Network, part of the New Delhi-based media conglomerate Living Media group</p>', 'upload/images/aaj_tak_live.jpg', 'HLS', 'https://feeds.intoday.in/aajtak/api/aajtakhd/master.m3u8', NULL, NULL, '', '', '', 4, 1),
(23, 2, 'Free', 'BBC (MPEG)', 'bbc-mpeg', '<p>The British Broadcasting Corporation is the national broadcaster of the United Kingdom, based at Broadcasting House in London, England.</p>', 'upload/images/bbc_news_logo.jpg', 'HLS', 'https://bitmovin-a.akamaihd.net/content/playhouse-vr/mpds/105560.mpd', NULL, NULL, '', '', '', 0, 1),
(24, 5, 'Paid', 'ABP News', 'abp-news', '<p>ABP News is an Indian Hindi-language free-to-air television news channel owned by ABP Group. The news channel was launched in 1998 originally as STAR News before being acquired by ABP Group. It won the Best Hindi News Channel award in the 21st edition of the Indian Television Academy Awards in 2022.</p>', 'upload/images/abp_hindi.jpg', 'HLS', 'https://abplivetv.akamaized.net/hls/live/2043010/hindi/master.m3u8', NULL, NULL, '', '', '', 0, 1),
(25, 4, 'Free', '9XM', '9xm', '<p>9XM</p>', 'upload/images/9xm_logo.png', 'HLS', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', NULL, NULL, '', '', '', 2, 1),
(26, 5, 'Paid', 'ABP Asmita', 'abp-asmita', '<p>ABP Asmita is an Indian 24-hour regional news channel broadcasting in the Gujarati language. It operates from Ahmedabad, Gujarat. It is owned by ABP Group. The channel was launched on 1 January 2016.</p>', 'upload/images/ABP_Asmita.jpg', 'HLS', 'https://abplivetv.akamaized.net/hls/live/2043010/hindi/master.m3u8', 'https://ndtv24x7elemarchana.akamaized.net/hls/live/2003678/ndtv24x7/ndtv24x7master.m3u8', NULL, '', '', '', 1, 1),
(27, 5, 'Paid', 'Live Tv', 'live-tv', '<p>NDTV.com provides latest news from India and around the world. Get breaking news alerts from India and follow today&rsquo;s live news updates in field of politics, business, technology, Bollywood, cricket and more.</p>', 'upload/images/N-NDTV.png', 'HLS', 'https://ndtv24x7elemarchana.akamaized.net/hls/live/2003678/ndtv24x7/ndtv24x7master.m3u8', 'https://d2q8p4pe5spbak.cloudfront.net/bpk-tv/9XM/9XM.isml/index.m3u8', 'https://abplivetv.akamaized.net/hls/live/2043010/hindi/master.m3u8', '', '', '', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `channel_category`
--

CREATE TABLE `channel_category` (
  `id` int(11) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `category_slug` varchar(255) NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `channel_category`
--

INSERT INTO `channel_category` (`id`, `category_name`, `category_slug`, `status`) VALUES
(1, 'LIVE TV', 'live-tv', 1),
(2, 'Entertainment', 'entertainment', 1),
(3, 'Lifestyle', 'lifestyle', 1),
(4, 'Music', 'music', 1),
(5, 'News', 'news', 1),
(6, 'Sports', 'sports', 1);

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `id` int(11) NOT NULL,
  `coupon_code` varchar(255) NOT NULL,
  `coupon_percentage` int(11) NOT NULL,
  `coupon_user_limit` int(4) NOT NULL DEFAULT 0,
  `coupon_used` int(4) NOT NULL DEFAULT 0,
  `coupon_exp_date` int(11) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `episodes`
--

CREATE TABLE `episodes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `video_access` varchar(255) NOT NULL DEFAULT 'Paid',
  `episode_series_id` int(11) NOT NULL,
  `episode_season_id` int(11) NOT NULL,
  `video_title` text NOT NULL,
  `release_date` int(11) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `video_description` text DEFAULT NULL,
  `video_slug` varchar(200) DEFAULT NULL,
  `video_image` varchar(200) DEFAULT NULL,
  `video_type` varchar(255) DEFAULT NULL,
  `video_quality` int(1) DEFAULT NULL,
  `video_url` longtext DEFAULT NULL,
  `video_url_480` longtext DEFAULT NULL,
  `video_url_720` longtext DEFAULT NULL,
  `video_url_1080` longtext DEFAULT NULL,
  `download_enable` int(1) DEFAULT NULL,
  `download_url` varchar(500) DEFAULT NULL,
  `subtitle_on_off` int(1) DEFAULT NULL,
  `subtitle_language1` varchar(255) DEFAULT NULL,
  `subtitle_url1` varchar(500) DEFAULT NULL,
  `subtitle_language2` varchar(255) DEFAULT NULL,
  `subtitle_url2` varchar(255) DEFAULT NULL,
  `subtitle_language3` varchar(255) DEFAULT NULL,
  `subtitle_url3` varchar(255) DEFAULT NULL,
  `imdb_id` varchar(255) DEFAULT NULL,
  `imdb_rating` varchar(255) DEFAULT NULL,
  `imdb_votes` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `views` bigint(20) NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `episodes`
--

INSERT INTO `episodes` (`id`, `video_access`, `episode_series_id`, `episode_season_id`, `video_title`, `release_date`, `duration`, `video_description`, `video_slug`, `video_image`, `video_type`, `video_quality`, `video_url`, `video_url_480`, `video_url_720`, `video_url_1080`, `download_enable`, `download_url`, `subtitle_on_off`, `subtitle_language1`, `subtitle_url1`, `subtitle_language2`, `subtitle_url2`, `subtitle_language3`, `subtitle_url3`, `imdb_id`, `imdb_rating`, `imdb_votes`, `seo_title`, `seo_description`, `seo_keyword`, `views`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Paid', 1, 1, 'When You\\\'re Lost in the Darkness', 1673740800, '81', '<p>2003. As a parasitic fungal outbreak begins to ravage the country and the world, Joel Miller attempts to escape the escalating chaos with his daughter and brother. Twenty years later, a now hardened Joel and his partner Tess fight to survive under a totalitarian regime, while the insurgent Fireflies harbor a teenage girl with a unique gift.</p>', 'when-youre-lost-in-the-darkness', 'upload/images/aRquEWm8wWF1dfa9uZ1TXLvVrKD.jpg', 'HLS', 0, 'https://cdn.bitmovin.com/content/assets/art-of-motion-dash-hls-progressive/mpds/f08e80da-bf1d-4e3d-8899-f0f6155f6efa.mpd', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8.4', NULL, '', '', '', 10, 1, NULL, '2024-01-22 16:25:21'),
(2, 'Paid', 1, 1, 'Infected', 1674345600, '53', '<p>In 2003, an Indonesian scientist makes a devastating discovery. In 2023, now outside of the quarantine zone, Joel and Tess clash over Ellie\\\'s fate as they navigate a long-abandoned Boston overrun with Infected.</p>', 'infected', 'upload/images/vGf7chl6XL7o3yYc8A5m3kjz8px.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, 0, NULL, 1, 'English', 'https://envato.viavilab.com/video_streaming/upload/CONSTANTINE%202.srt', NULL, NULL, NULL, NULL, 'tt14500884', '8.2', NULL, '', '', '', 2, 1, NULL, '2024-01-22 16:03:31'),
(3, 'Paid', 1, 1, 'Long Time', 1674950400, '77', '<p>Doomsday prepper Bill prepares to ride out the apocalypse alone...until a mysterious stranger upends his plans. Years later, Joel and Ellie seek Bill\\\'s guidance &ndash; and find themselves at a crossroads.</p>', 'long-time', 'upload/images/bzy4hAtkY3OOInY4q6MJigLmC1m.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7', NULL, '', '', '', 1, 1, NULL, '2024-01-22 18:21:07'),
(4, 'Free', 2, 2, 'War and Peace', 1643932800, '45m', '<p>With a difference of opinion related to the ongoing war, Dr. Homi Bhabha and Dr. Vikram Sarabhai look back at the time when they first met each other.</p>', 'war-and-peace', 'upload/RocketBoysposter.jpeg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 16, 1, NULL, '2024-01-24 17:30:49'),
(5, 'Free', 2, 2, 'It\\\'s Like Gravity', 1643932800, '45m', '<p>With a difference of opinion related to the ongoing war, Dr. Homi Bhabha and Dr. Vikram Sarabhai look back at the time when they first met each other.</p>', 'its-like-gravity', 'upload/roket_e2.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 3, 1, '2024-01-22 18:24:04', '2024-01-24 17:31:25'),
(6, 'Free', 2, 2, 'The Greater Good', 1643932800, '45m', '<p>With a difference of opinion related to the ongoing war, Dr. Homi Bhabha and Dr. Vikram Sarabhai look back at the time when they first met each other.</p>', 'the-greater-good', 'upload/images/kOGM01ZhELmJCxdVObqQbRwXXH3.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 1, 1, '2024-01-22 18:24:06', '2024-01-24 17:31:22'),
(7, 'Free', 2, 2, 'A Tryst with Destiny', 1643932800, '45m', '<p>With a difference of opinion related to the ongoing war, Dr. Homi Bhabha and Dr. Vikram Sarabhai look back at the time when they first met each other.</p>', 'a-tryst-with-destiny', 'upload/roket_e3.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 0, 1, '2024-01-22 20:12:48', '2024-01-24 17:29:59'),
(8, 'Paid', 3, 4, 'Teacher Sahi Hona Chahiye', 1643932800, '45m', '<p>Abhilash is worried about his General Studies Exam. Dissatisfied with his mentor, he decides to quit his coaching institute.</p>', 'teacher-sahi-hona-chahiye', 'upload/asp_ep.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 7, 1, '2024-01-22 20:13:25', '2024-01-23 18:59:19'),
(9, 'Paid', 3, 4, 'Teacher Sahi Hona Chahiye', 1643932800, '45m', '<p>Abhilash is worried about his General Studies Exam. Dissatisfied with his mentor, he decides to quit his coaching institute.</p>', 'teacher-sahi-hona-chahiye', 'upload/images/suXX4sFFgUGMv47jCibP4hhsmN7.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9.0', NULL, '', '', '', 0, 1, '2024-01-22 20:13:41', '2024-01-22 20:16:01'),
(10, 'Paid', 4, 6, 'Openings', 1603411200, '59', '<p>Sent to an orphanage at age 9, Beth develops an uncanny knack for chess &mdash; and a growing dependence on the green tranquilizers given to the children.</p>', 'openings', 'upload/images/4taUmpWKaTH2dRisytelueNoo8s.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt10062310', '8.2', NULL, '', '', '', 1, 1, NULL, '2024-01-23 12:03:02'),
(11, 'Paid', 4, 6, 'Exchanges', 1603411200, '65', '<p>Suddenly plunged into a confusing new life in suburbia, teenage Beth studies her high school classmates and hatches a plan to enter a chess tournament.</p>', 'exchanges', 'upload/images/gmNLUrlRLPS5evVvh0wEI5I4cIs.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt10062312', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(12, 'Paid', 4, 6, 'Doubled Pawns', 1603411200, '46', '<p>The trip to Cincinnati launches Beth and her mother into a whirlwind of travel and press coverage. Beth sets her sights on the U.S. Open in Las Vegas.</p>', 'doubled-pawns', 'upload/images/r1JYQ0YdrPOm59MlVwPkResu0Qw.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt10062314', '8.1', NULL, '', '', '', 0, 1, NULL, NULL),
(13, 'Paid', 4, 6, 'Middle Game', 1603411200, '49', '<p>Russian class opens the door to a new social scene. In Mexico City, Beth meets the intimidating Borgov, while her mother cozies up to a pen pal.</p>', 'middle-game', 'upload/images/3CCEL9SoI5cm7g0hUb5Q6iTYbLi.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt10062318', '8.2', NULL, '', '', '', 0, 1, NULL, NULL),
(14, 'Paid', 5, 7, 'The End\\\'s Beginning', 1576800000, '62', '<p>Hostile townsfolk and a cunning mage greet Geralt in the town of Blaviken. Ciri finds her royal world upended when Nilfgaard sets its sights on Cintra.</p>', 'the-ends-beginning', 'upload/images/kvnbgfKMSOeq08gWeL7FrzT0mah.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8071662', '7.8', NULL, '', '', '', 1, 1, NULL, '2024-01-23 12:41:20'),
(15, 'Paid', 5, 7, 'Four Marks', 1576800000, '62', '<p>Bullied and neglected, Yennefer accidentally finds a means of escape. Geralt\\\'s hunt for a so-called devil goes to hell. Ciri seeks safety in numbers.</p>', 'four-marks', 'upload/images/7KWyZgiSXSAuagbtzjTZLrkOtNk.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8343768', '7.3', NULL, '', '', '', 0, 1, NULL, NULL),
(16, 'Paid', 5, 7, 'Betrayer Moon', 1576800000, '68', '<p>Geralt takes on another Witcher\\\'s unfinished business in a kingdom stalked by a ferocious beast. At a brutal cost, Yennefer forges a magical new future.</p>', 'betrayer-moon', 'upload/images/jiNkIfEOsKQNNc0roNmzZZ0VJVi.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8343770', '7.5', NULL, '', '', '', 0, 1, NULL, NULL),
(17, 'Paid', 5, 7, 'Of Banquets, Bastards and Burials', 1576800000, '63', '<p>Against his better judgment, Geralt accompanies Jaskier to a royal ball. Ciri wanders into an enchanted forest. Yennefer tries to protect her charges.</p>', 'of-banquets-bastards-and-burials', 'upload/images/AfebvAOUQDaIy2TMmzhWk1ddZMJ.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8343772', '7.7', NULL, '', '', '', 0, 1, NULL, NULL),
(18, 'Paid', 5, 7, 'Bottled Appetites', 1576800000, '60', '<p>Heedless of warnings, Yennefer looks for a cure to restore what she\\\'s lost. Geralt inadvertently puts Jaskier in peril. The search for Ciri intensifies.</p>', 'bottled-appetites', 'upload/images/10yazSY4hMWfH8M48D7rhHVDvsA.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8343774', '7.7', NULL, '', '', '', 0, 1, NULL, NULL),
(19, 'Paid', 18, 34, 'Pilot', 1200787200, '59', '<p>When an unassuming high school chemistry teacher discovers he has a rare form of lung cancer, he decides to team up with a former student and create a top of the line crystal meth in a used RV, to provide for his family once he is gone.</p>', 'pilot', 'upload/images/ydlY3iPfeOAvu8gVqrxPoMvzNCn.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt0959621', '8.3', NULL, '', '', '', 2, 1, NULL, '2024-01-23 18:05:56'),
(20, 'Paid', 18, 34, 'Cat\\\'s in the Bag...', 1201392000, '49', '<p>Walt and Jesse attempt to tie up loose ends. The desperate situation gets more complicated with the flip of a coin. Walt\\\'s wife, Skyler, becomes suspicious of Walt\\\'s strange behavior.</p>', 'cats-in-the-bag', 'upload/images/tjDNvbokPLtEnpFyFPyXMOd6Zr1.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt1054724', '8.2', NULL, '', '', '', 0, 1, NULL, NULL),
(21, 'Paid', 18, 34, '...And the Bag\\\'s in the River', 1202601600, '49', '<p>Walter fights with Jesse over his drug use, causing him to leave Walter alone with their captive, Krazy-8. Meanwhile, Hank has a scared straight moment with Walter Jr. after his aunt discovers he has been smoking pot. Also, Skylar is upset when Walter stays away from home.</p>', 'and-the-bags-in-the-river', 'upload/images/2kBeBlxGqBOdWlKwzAxiwkfU5on.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt1054725', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(22, 'Paid', 18, 35, 'Seven Thirty-Seven', 1236470400, '48', '<p>Walt and Jesse are vividly reminded of Tuco&rsquo;s volatile nature, and try to figure a way out of their business partnership. Hank attempts to mend fences between the estranged Marie and Skyler.</p>', 'seven-thirty-seven', 'upload/images/7vVujNqjP23MtPqUTBNITIW3DDA.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt1232244', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(23, 'Paid', 18, 35, 'Grilled', 1237075200, '48', '<p>Walt and Jesse find themselves in close quarters with an unhinged Tuco. Marie and Hank comfort Skyler, who is distraught over Walt&rsquo;s disappearance. Hank pays a visit to Mrs. Pinkman on some not-so-official business.</p>', 'grilled', 'upload/images/43mpP5yxIyBsDeFOMb0WvUh0I4a.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt1232249', '8.8', NULL, '', '', '', 0, 1, NULL, NULL),
(24, 'Paid', 8, 20, 'Pilot', 1536451200, '48', '<p>A charming first encounter quickly turns into something more nefarious when bookstore manager Joe takes a very strong liking to grad student Beck.</p>', 'pilot', 'upload/images/sFILcK0exJVJV4BZMAOPzpBEuUT.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt7360754', '7.5', NULL, '', '', '', 0, 1, NULL, NULL),
(25, 'Paid', 8, 20, 'The Last Nice Guy in New York', 1537056000, '45', '<p>As Beck deals with unwanted advances from her advisor, she brings Joe to Peach&rsquo;s high society soiree. Joe tries to navigate matters with Benji.</p>', 'the-last-nice-guy-in-new-york', 'upload/images/1cRkfqsbcN6ycsP6inRJUxH98CB.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt7608276', '8.1', NULL, '', '', '', 0, 1, NULL, NULL),
(26, 'Paid', 8, 20, 'Maybe', 1537660800, '43', '<p>Beck&rsquo;s continued casual encounters catch Joe off guard, as does a run-in with the police. Both make him realize a key situation must be dealt with.</p>', 'maybe', 'upload/images/3ZxT1HSfobIFPxZd1MijPgDCbq5.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt7608280', '7.5', NULL, '', '', '', 0, 1, NULL, NULL),
(27, 'Paid', 8, 21, 'A Fresh Start', 1577318400, '50', '<p>Joe &ndash; now &ldquo;Will&rdquo; &ndash; arrives in his own personal hell on Earth: LA. He\\\'s trying to go straight, but the past doesn&rsquo;t always leave well enough alone.</p>', 'a-fresh-start', 'upload/images/vro1jm1ZiJQsokvzyf20qC3uChP.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8762996', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(28, 'Paid', 8, 21, 'Just the Tip', 1577318400, '50', '<p>Joe realizes Will Bettelheim isn&rsquo;t all he&rsquo;s cracked up to be. The fallout threatens to get in the way of his burgeoning connection with Love.</p>', 'just-the-tip', 'upload/images/4cySeaiNrzpJXWQM0wm0fuYGgGa.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt9734770', '7.6', NULL, '', '', '', 0, 1, NULL, NULL),
(29, 'Paid', 6, 10, 'Chapter One: The Vanishing of Will Byers', 1468540800, '48', '<p>On his way home from a friend\\\'s house, young Will sees something terrifying. Nearby, a sinister secret lurks in the depths of a government lab.</p>', 'chapter-one-the-vanishing-of-will-byers', 'upload/images/AdwF2jXvhdODr6gUZ61bHKRkz09.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt4593118', '8.4', NULL, '', '', '', 2, 1, NULL, '2024-01-23 18:05:24'),
(30, 'Paid', 6, 10, 'Chapter Two: The Weirdo on Maple Street', 1468540800, '55', '<p>Lucas, Mike and Dustin try to talk to the girl they found in the woods. Hopper questions an anxious Joyce about an unsettling phone call.</p>', 'chapter-two-the-weirdo-on-maple-street', 'upload/images/8iA56ugQyHZmX81wSsNqwXjCE6F.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt4593122', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(31, 'Free', 6, 11, 'Chapter One: MADMAX', 1509062400, '48', '<p>As the town preps for Halloween, a high-scoring rival shakes things up at the arcade, and a skeptical Hopper inspects a field of rotting pumpkins.</p>', 'chapter-one-madmax', 'upload/images/efz0MgPAxPw11PIeAJNgKKg3Paa.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt6020684', '8.3', NULL, '', '', '', 0, 1, NULL, NULL),
(32, 'Paid', 6, 11, 'Chapter Two: Trick or Treat, Freak', 1509062400, '56', '<p>After Will sees something terrible on trick-or-treat night, Mike wonders whether Eleven\\\'s still out there. Nancy wrestles with the truth about Barb.</p>', 'chapter-two-trick-or-treat-freak', 'upload/images/oGMZxF4yivOSCGZTMgiDD2Ye2Hi.jpg', 'URL', 0, 'https://webdesign-flash.ro/p/evp/content/videos/fwd-480p.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt6020792', '8', NULL, '', '', '', 0, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `genres`
--

CREATE TABLE `genres` (
  `id` int(10) UNSIGNED NOT NULL,
  `genre_name` varchar(255) DEFAULT NULL,
  `genre_slug` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `genres`
--

INSERT INTO `genres` (`id`, `genre_name`, `genre_slug`, `status`) VALUES
(1, 'Drama', 'drama', 1),
(3, 'Comedy', 'comedy', 1),
(5, 'Thriller', 'thriller', 1),
(6, 'Horror', 'horror', 1),
(8, 'Romance', 'romance', 1),
(9, 'Adventure', 'adventure', 1),
(10, 'Sci-Fi', 'sci-fi', 1),
(11, 'Fantasy', 'fantasy', 1),
(13, 'Crime and Mystery', 'crime-and-mystery', 1);

-- --------------------------------------------------------

--
-- Table structure for table `home_sections`
--

CREATE TABLE `home_sections` (
  `id` int(11) NOT NULL,
  `section_name` varchar(500) NOT NULL,
  `section_slug` varchar(255) NOT NULL,
  `post_type` varchar(255) DEFAULT NULL,
  `movie_ids` text DEFAULT NULL,
  `show_ids` text DEFAULT NULL,
  `sport_ids` text DEFAULT NULL,
  `tv_ids` text DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `home_sections`
--

INSERT INTO `home_sections` (`id`, `section_name`, `section_slug`, `post_type`, `movie_ids`, `show_ids`, `sport_ids`, `tv_ids`, `status`) VALUES
(1, 'Latest Movies', 'latest-movies', 'Movie', '20,19,18,13,6,4,1,7', '', '', '', 1),
(2, 'Latest Shows', 'latest-shows', 'Shows', '', '5,2,1,3', '', '', 1),
(3, 'Best In Sports', 'best-in-sports', 'Sports', '', '', '20,19,17,14,1,18', '', 1),
(4, 'Live TV', 'live-tv', 'LiveTV', '', '', '', '26,3,2,5,1,13,21,23', 1),
(5, 'Popular Movies', 'popular-movies', 'Movie', '18,15,12,11,7,6,1,21', '', '', '', 1),
(6, 'Popular Shows', 'popular-shows', 'Shows', '', '4,2,3,5', '', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` int(11) NOT NULL,
  `language_name` varchar(60) NOT NULL,
  `language_slug` varchar(255) NOT NULL,
  `language_image` varchar(255) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` (`id`, `language_name`, `language_slug`, `language_image`, `status`) VALUES
(1, 'Hindi', 'hindi', 'hindixl_070617120630.png', 1),
(2, 'English', 'english', 'eng_cat.png', 1),
(4, 'French', 'french', NULL, 1),
(6, 'Malayalam', 'malayalam', NULL, 1),
(7, 'Arabic', 'arabic', NULL, 1),
(8, 'Spanish', 'spanish', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `movie_videos`
--

CREATE TABLE `movie_videos` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `video_access` varchar(255) NOT NULL DEFAULT 'Paid',
  `movie_lang_id` int(11) NOT NULL,
  `movie_genre_id` text NOT NULL,
  `upcoming` int(1) NOT NULL DEFAULT 0,
  `video_title` text NOT NULL,
  `release_date` int(11) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `video_description` text DEFAULT NULL,
  `actor_id` text DEFAULT NULL,
  `director_id` text DEFAULT NULL,
  `video_slug` varchar(200) DEFAULT NULL,
  `video_image_thumb` varchar(255) DEFAULT NULL,
  `video_image` varchar(200) DEFAULT NULL,
  `trailer_url` text DEFAULT NULL,
  `video_type` varchar(255) DEFAULT NULL,
  `video_quality` int(1) DEFAULT NULL,
  `video_url` longtext DEFAULT NULL,
  `video_url_480` varchar(255) DEFAULT NULL,
  `video_url_720` varchar(255) DEFAULT NULL,
  `video_url_1080` varchar(255) DEFAULT NULL,
  `download_enable` int(1) DEFAULT NULL,
  `download_url` varchar(500) DEFAULT NULL,
  `subtitle_on_off` int(1) DEFAULT NULL,
  `subtitle_language1` varchar(255) DEFAULT NULL,
  `subtitle_url1` varchar(500) DEFAULT NULL,
  `subtitle_language2` varchar(255) DEFAULT NULL,
  `subtitle_url2` varchar(255) DEFAULT NULL,
  `subtitle_language3` varchar(255) DEFAULT NULL,
  `subtitle_url3` varchar(255) DEFAULT NULL,
  `imdb_id` varchar(255) DEFAULT NULL,
  `imdb_rating` varchar(255) DEFAULT NULL,
  `imdb_votes` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `views` bigint(20) NOT NULL DEFAULT 0,
  `content_rating` varchar(255) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `movie_videos`
--

INSERT INTO `movie_videos` (`id`, `video_access`, `movie_lang_id`, `movie_genre_id`, `upcoming`, `video_title`, `release_date`, `duration`, `video_description`, `actor_id`, `director_id`, `video_slug`, `video_image_thumb`, `video_image`, `trailer_url`, `video_type`, `video_quality`, `video_url`, `video_url_480`, `video_url_720`, `video_url_1080`, `download_enable`, `download_url`, `subtitle_on_off`, `subtitle_language1`, `subtitle_url1`, `subtitle_language2`, `subtitle_url2`, `subtitle_language3`, `subtitle_url3`, `imdb_id`, `imdb_rating`, `imdb_votes`, `seo_title`, `seo_description`, `seo_keyword`, `views`, `content_rating`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Paid', 2, '1', 0, 'Oppenheimer', 1689724800, '3h 1m', '<p>The story of J. Robert Oppenheimer\\\'s role in the development of the atomic bomb during World War II.</p>', '13,14,15,16,17,18,19,20,21,22,23', '24', 'oppenheimer', 'upload/images/8Gxv8gSFCU0XGDykEGv7zR1n2ua.jpg', 'upload/images/fm6KqXpk3M2HVveHwCrBSSBaO0V.jpg', 'https://www.youtube.com/watch?v=bK6ldnjE3Y0', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt15398776', '8.1', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(2, 'Free', 4, '1,13', 0, 'Killers of the Flower Moon', 1697587200, '3h 26m', '<p>When oil is discovered in 1920s Oklahoma under Osage Nation land, the Osage people are murdered one by one&mdash;until the FBI steps in to unravel the mystery.</p>', '36,37,38,39,40,41,42,43,44,45,46', '47', 'killers-of-the-flower-moon', 'upload/images/dB6Krk806zeqd0YNp2ngQ9zXteH.jpg', 'upload/images/1X7vow16X7CnCoexXh4H4F2yDJv.jpg', 'https://www.youtube.com/watch?v=EG0si5bSd6I', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt5537002', '7.5', NULL, '', '', '', 1, NULL, 1, NULL, '2024-01-23 18:04:17'),
(3, 'Paid', 2, '1,13', 0, 'Anatomy of a Fall', 1691884800, '2h 32m', '<p>A woman is suspected of her husband&rsquo;s murder, and their blind son faces a moral dilemma as the sole witness.</p>', '69,70,71,72,73,74,75,76,77,78,79', '80', 'anatomy-of-a-fall', 'upload/images/kQs6keheMwCxJxrzV83VUwFtHkB.jpg', 'upload/images/kszooR7v1TLFM4pzx6IkKq2jDAN.jpg', 'https://www.youtube.com/watch?v=fTrsp5BMloA', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt17009710', '7.8', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(4, 'Paid', 5, '3,1,8', 0, 'Fallen Leaves', 1694649600, '1h 21m', '<p>The story of two lonely people who meet each other by chance in the Helsinki night and try to find the first, only, and ultimate love of their lives. Their path towards this honorable goal is clouded by the man\\\'s alcoholism, lost phone numbers, not knowing each other\\\'s names or addresses, and life\\\'s general tendency to place obstacles in the way of those seeking their happiness.</p>', '93,94,95,96,97,98,99,100,101,102,103', '104', 'fallen-leaves', 'upload/images/ca9341N5crOnOCPhCJhQu0iYcTb.jpg', 'upload/images/oQMcTqUkz1LIQceyjyiA4UO9UgM.jpg', 'https://www.youtube.com/watch?v=AI3IASNvKeQ', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt21027780', '7.3', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(5, 'Paid', 2, '1', 0, 'About Dry Grasses', 1689120000, '3h 17m', '<p>A young art teacher hopes to be transfered to Istanbul after completing his mandatory duty in a remote village school in Anatolia. After accusations of innapropriate contact with a student surface, his hopes of escape fade and he descends further into an existential crisis.</p>', '105,106,107,108,109,110,111,112,113,114,115', '116', 'about-dry-grasses', 'upload/images/mUFpdQSFAch1fMUb9MqHoESpmLS.jpg', 'upload/images/y2fxmO7IUV9YXvoUhFppwGcUTt.jpg', 'https://www.youtube.com/watch?v=WdgQdjWhvNg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt13231544', '7.7', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(6, 'Free', 4, '5,9', 0, 'Mission: Impossible - Dead Reckoning Part One', 1688774400, '2h 44m', '<p>Ethan Hunt and his IMF team embark on their most dangerous mission yet: To track down a terrifying new weapon that threatens all of humanity before it falls into the wrong hands. With control of the future and the world\\\'s fate at stake and dark forces from Ethan\\\'s past closing in, a deadly race around the globe begins. Confronted by a mysterious, all-powerful enemy, Ethan must consider that nothing can matter more than his mission&mdash;not even the lives of those he cares about most.</p>', '117,118,119,120,121,122,123,124,125,90,126', '127', 'mission-impossible-dead-reckoning-part-one', 'upload/images/NNxYkU70HPurnNCSiCjYAmacwm.jpg', 'upload/images/628Dep6AxEtDxjZoGP78TsOxYbK.jpg', 'https://www.youtube.com/watch?v=2m1drlOZSDw', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt9603212', '7.6', NULL, '', '', '', 1, NULL, 1, NULL, '2024-01-23 18:04:33'),
(7, 'Paid', 2, '9', 0, 'Guardians of the Galaxy Vol. 3', 1683072000, '2h 30m', '<p>Peter Quill, still reeling from the loss of Gamora, must rally his team around him to defend the universe along with protecting one of their own. A mission that, if not completed successfully, could quite possibly lead to the end of the Guardians as we know them.</p>', '128,129,130,131,124,132,133,134,135,136,137', '138', 'guardians-of-the-galaxy-vol-3', 'upload/images/r2J02Z2OpNTctfOSN1Ydgii51I3.jpg', 'upload/images/5YZbUmjbMa3ClvSW1Wj3D6XGolb.jpg', 'https://www.youtube.com/watch?v=u3V5KDHRQvk', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt6791350', '8', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(8, 'Paid', 2, '9,3,11', 0, 'Dungeons & Dragons: Honor Among Thieves', 1679529600, '2h 14m', '<p>A charming thief and a band of unlikely adventurers undertake an epic heist to retrieve a lost relic, but things go dangerously awry when they run afoul of the wrong people.</p>', '139,140,141,142,143,144,145,146,147,148,149', '150,151', 'dungeons-dragons-honor-among-thieves', 'upload/images/v7UF7ypAqjsFZFdjksjQ7IUpXdn.jpg', 'upload/images/oblUNeHlwV3VsjB5ITMlco5ZSOF.jpg', 'https://www.youtube.com/watch?v=IiMinixSXII', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt2906216', '7.4', NULL, '', '', '', 6, NULL, 1, NULL, '2024-01-24 14:53:25'),
(9, 'Paid', 1, '3,1', 0, 'Dunki', 1703116800, '2h 39m', '<p>Four friends from a sleepy little village in Punjab share a common dream: to go to England. Their problem is that they have neither the visa nor the ticket. A soldier alights from a train one day, and their lives change. He gives them a soldier\\\'s promise: He will take them to the land of their dreams. What follows is a hilarious and heartwarming tale of a perilous journey through the desert and the sea, but most crucially through the hinterlands of their mind.</p>', '152,153,154,155,156,157,158,159,160,161,162', '163', 'dunki', 'upload/images/jj9ue91o7dVJNUL8pOMDjO0udfK.jpg', 'upload/images/5R19VzUX3unBGgWAMmCJKLcOsbo.jpg', 'https://www.youtube.com/watch?v=uOlDK7g7b-E', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt15428134', '6.7', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(10, 'Paid', 1, '9,5', 0, 'Jawan', 1694044800, '2h 49m', '<p>An emotional journey of a prison warden, driven by a personal vendetta while keeping up to a promise made years ago, recruits inmates to commit outrageous crimes that shed light on corruption and injustice, in an attempt to get even with his past, and that leads him to an unexpected reunion.</p>', '152,164,165,166,167,168,169,170,171,172,173', '174', 'jawan', 'upload/images/bMISXhkBDll6JPsevdJJ1ItnW6S.jpg', 'upload/images/28er4p7B5zMSxUDQKPF1hBsgnys.jpg', 'https://www.youtube.com/watch?v=MWOlnZSnXJo', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt15354916', '7.2', NULL, '', '', '', 4, NULL, 1, NULL, '2024-01-24 19:20:38'),
(11, 'Paid', 1, '9,5', 0, 'Pathaan', 1674604800, '2h 26m', '<p>A soldier caught by enemies and presumed dead comes back to complete his mission, accompanied by old companions and foes.</p>', '152,175,176,177,178,179,180,181,182,183,184', '185', 'pathaan', 'upload/images/arf00BkwvXo0CFKbaD9OpqdE4Nu.jpg', 'upload/images/fTLZ3H7leVUeBxaqEKDWtn6pIis.jpg', 'https://www.youtube.com/watch?v=yswBxKPFSvA', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt12844910', '6.6', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(12, 'Paid', 1, '1', 0, 'Animal', 1701388800, '3h 21m', '<p>A son undergoes a remarkable transformation as the bond with his father begins to fracture, and he becomes consumed by a quest for vengeance.</p>', '188,195,189,191,186,187,196,193,192,190,194', '197', 'animal', 'upload/images/hr9rjR3J0xBBKmlJ4n3gHId9ccx.jpg', 'upload/images/13QFKJa7ZPY3VN0L6sxKuNoLHFf.jpg', 'https://www.youtube.com/watch?v=8FkLRUJj-o0', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7.4', NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-22 14:13:11'),
(13, 'Free', 1, '9,5', 0, 'Tiger 3', 1699747200, '2h 36m', '<p>Following the events of Tiger Zinda Hai, War, and Pathaan, Avinash Singh Rathore returns as Tiger but this time the battle is within. He has to choose between his country or family as an old enemy is after his life, who claims that his family was killed by Tiger. He holds Tiger captive in Pakistan as the Indian agent\\\'s loyalty towards his country faces its biggest test.</p>', '179,198,199,200,201,202,203,204,205,206,207', '208', 'tiger-3', 'upload/images/7wgED7Yx9VLcNWSO91VgwicHmMD.jpg', 'upload/images/kqSxCsGIT4rqrZTTMpYP8RIzojv.jpg', 'https://www.youtube.com/watch?v=vEjTUDjjU6A', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt18411490', '6.5', NULL, '', '', '', 1, NULL, 1, NULL, '2024-01-23 18:04:42'),
(14, 'Paid', 1, '3,1', 0, 'OMG 2', 1691712000, '2h 35m', '<p>Life is bliss until one day Kanti Sharan Mudgal&rsquo;s son Vivek is blamed for immoral conduct and expelled from school. Overwhelmed, Kanti plans to leave town until a divine intervention leads him to seek justice by taking those responsible to court.</p>', '223,224,225,226,227,228,229,213,230,231,232', '233', 'omg-2', 'upload/images/kApiO3oL6t100aCtkcwEhk2kqgK.jpg', 'upload/images/9wmSV9Nk3j7GIEBQghJIGI0U2Nk.jpg', 'https://www.youtube.com/watch?v=Y6ZKXqM7HNQ', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt15732324', '7.2', NULL, '', '', '', 1, NULL, 1, NULL, '2024-01-23 18:54:41'),
(15, 'Free', 2, '1,5', 0, 'Mission Raniganj', 1696550400, '2h 14m', '<p>A real-life story of additional chief mining engineer Jaswant Singh Gill who helped in the rescue of people when a coal mine in Raniganj, West Bengal, was flooded. The incident dates back to 1989.</p>', '224,234,203,235,226,236,237,238,239,240,241', '242', 'mission-raniganj', 'upload/images/UjgNDMPyzDN71bsU7Ekgw1yKfQ.jpg', 'upload/images/A8tbA2tvsvg7swQlsAfb1PLwfJg.jpg', NULL, 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt21262240', '6.1', NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-23 16:46:32'),
(16, 'Paid', 1, '3,1,8', 0, 'Rocky Aur Rani Kii Prem Kahaani', 1690502400, '2h 59m', '<p>Gym-freak brat Rocky falls in love with Rani, who comes from a well-educated Bengali family. Being from polar opposite worlds, the two decide to switch their families to adjust to each other\\\'s cultures and backgrounds and to know if their marriage will survive. Rocky and Rani are trapped in a world where they are united by love but divided by families and the ultimate question is will they fit in?</p>', '243,244,245,246,247,248,249,250,251,252,253', '254', 'rocky-aur-rani-kii-prem-kahaani', 'upload/images/vTQIqlxUkOuyf2UKhlM2OUaFGKz.jpg', 'upload/images/bynRHBHqxkWk0HU2sYXKtz9HYxF.jpg', 'https://www.youtube.com/watch?v=OWC6OErVtW8', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt14993250', '6', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(17, 'Paid', 1, '9,1', 0, 'Ponniyin Selvan: Part II', 1682640000, '2h 44m', '<p>968 AD. The Pandyan assassins gather once again to destroy the Chola dynasty. Now the mighty Chola princes must fight the Pandyas, the Rashtrakutas and other Chola enemies who have joined forces. Also, at play are the rumours of Ponniyin Selvan&rsquo;s death at sea, the powerful Pazhuvettarayar&rsquo;s betrayal, and the tragic destiny of Aditha Karikalan, whose heart was long lost to the vengeful Nandini.</p>', '263,264,265,266,267,268,269,270,271,272,273', '274', 'ponniyin-selvan-part-ii', 'upload/images/1fMM5yjLYJNfO3CSQBpfC1kqeIK.jpg', 'upload/images/dWwcwqAOkS6e4GCRJ5fC9iSVx9O.jpg', NULL, 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt22444570', '6.4', NULL, '', '', '', 3, NULL, 1, NULL, '2024-01-22 16:56:37'),
(18, 'Free', 1, '3,5', 0, 'Jailer', 1691625600, '2h 45m', '<p>Muthuvel Pandian, a retired, stern yet compassionate jailer lives a peaceful life with his family, but trouble knocks his door when his cop son&rsquo;s tryst with an antique mafia gang goes awry and forces Muthu to step back into a dark world he had voluntarily took a break from.</p>', '282,283,284,280,275,279,281,285,277,276,278', '286', 'jailer', 'upload/images/pTmMxAHqX4vsIDE6HPPxOR0Q6TN.jpg', 'upload/images/v9L9ydhE5gExur77cLGyaxGNJoN.jpg', 'https://www.youtube.com/watch?v=xenOE1Tma0A', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '6.7', NULL, '', '', '', 1, NULL, 1, NULL, '2024-01-24 15:42:07'),
(19, 'Paid', 1, '3,1,8', 0, 'Bawaal', 1689897600, '2h 17m', '<p>Ajay Dixit, an ordinary history teacher in a high school, enjoys mini celebrityhood in his town courtesy of the fake image he has built. He shares a strained relationship with his newly-wed wife. Circumstances force him to take a trip to Europe for the World War II trail accompanied by his wife. Will his relationship with his wife survive this trip? Will he manage to win the war within?</p>', '287,288,289,290,291,292,293,294,295,296,297', '298', 'bawaal', 'upload/images/kT0mA3kYzvl2UZGxhJnLyTUYa2z.jpg', 'upload/images/5c8jqkGxC4fr0VmbkhOzxzmLDmV.jpg', 'https://www.youtube.com/watch?v=55KHuM6dcLk', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt19755170', '6', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(20, 'Free', 1, '5', 0, 'Salaar: Part 1 - Ceasefire', 1703116800, '2h 54m', '<p>In the city of Khansaar, Raja Mannar plans to make his son, Vardharaja Mannar his successor, but Raja Mannar\\\'s ministers and advisors plan a coup d\\\'&eacute;tat by hiring armies from Russia and Serbia to attack and kill Vardha and Raja. Vardha, along with his brother and a few trusted men, manage to escape from Khansaar. Vardha goes to his childhood best friend, Deva, who learns about his predicament and sets out to make him the undisputed successor of Khansaar.</p>', '304,302,303,307,299,309,300,306,301,305,308', '310', 'salaar-part-1-ceasefire', 'upload/images/hPZE10GAgdLFr2LmyWaSCoeYTfs.jpg', 'upload/images/hOx2kPyniEHJj9wquzJMuStFFUG.jpg', 'https://www.youtube.com/watch?v=4GPvYMKtrtI', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '6.6', NULL, '', '', '', 3, NULL, 1, NULL, '2024-01-24 16:16:31'),
(21, 'Paid', 1, '9,1', 0, 'Shamshera', 1658448000, '2h 38m', '<p>Set in the 1800s, the film is about a \\\"dacoit\\\" tribe who take charge in fight for their rights and independence against the British.</p>', '186,318,319,320,321,322,323,324,325,326,327', '328', 'shamshera', 'upload/images/rryN6GhaoovO3sM8IEqGyKgCmXf.jpg', 'upload/images/ciikYAXN79YzwfUbCbkZzkQ2pvj.jpg', NULL, 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'tt8426926', '5.6', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(22, 'Paid', 1, '1', 1, 'Maidaan', 1712880000, '2h 10m', '<p>Inspired by the Indian national football team coach and manager Syed Abdul Rahim, who is regarded as the architect of Indian football, encapsulating the golden era from 1952 to 1962.</p>', '374,375,166,376', '377', 'maidaan', 'upload/images/b3ZIV3iLKtJvyDZncIyINYUIUdt.jpg', 'upload/images/maidaan-831.png', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-24 14:47:28'),
(23, 'Free', 1, '9,5', 1, 'Fighter', 1706054400, '2h 44m', '<p>Top IAF aviators come together in the face of imminent danger, to form Air Dragons. FIGHTER unfolds their camaraderie, brotherhood and battles, internal and external.</p>', '382,175,188,383,384,385,386,387,388,389,390', '185', 'fighter', 'upload/images/zDZowwb9GZGEctAu2PCpjiPQAMM.jpg', 'upload/images/qQCNoibm9yz3IyFhdvbDTROZeZd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt13818368', '4.5', NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-23 16:46:38'),
(24, 'Paid', 2, '3', 1, 'Bachelor Party', 1706227200, '0h 0m', '<p>Six years after the comedy blockbuster &ldquo;Kirik Party,&rdquo; Paramvah Studios is bringing to you yet another comedy adventure which will get you high on humour.</p>', '402,403,404,405,406,407,408', '409', 'bachelor-party', 'upload/images/iPzriQUwDNTx7sOJJGi9jXyE7WL.jpg', 'upload/images/rjVoC0pQEEdH6KLIkt20aeab96x.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt27424501', '0', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(25, 'Paid', 2, '3,1,8', 1, 'Beautiful Wedding', 1706054400, '1h 40m', '<p>In the aftermath of Beautiful Disaster, Abby and Travis wake after a crazy night in Vegas as accidental newlyweds! With the mob on their heels, they flee to Mexico for a wild, weird honeymoon&mdash;but are they in for another disaster?</p>', '410,411,412,413,414,415,416,417,418,419,420', '421', 'beautiful-wedding', 'upload/images/yA9CO79V0lr9IWEmqQdp2ozvYQE.jpg', 'upload/images/ik7weMW5cize6A1ApJ9dXHG6QQn.jpg', 'https://www.youtube.com/watch?v=xjCEbq5HYhI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt26546123', '0', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(26, 'Free', 2, '3,1', 1, 'Miller\\\'s Girl', 1705536000, '1h 33m', '<p>A talented young writer embarks on a creative odyssey when her teacher assigns a project that entangles them both in an increasingly complex web.</p>', '473,475,474,472,471,470', '476', 'millers-girl', 'upload/images/ieU0zUj7WhE0GrgpgofRH0sNjbI.jpg', 'upload/images/j64H7GlYSarltRHJOl75jxLTRV6.jpg', 'https://www.youtube.com/watch?v=vk2OJZHutBM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '5.8', NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-23 12:47:16'),
(28, 'Free', 2, '3,1,8', 1, 'Sometimes I Think About Dying', 1704844800, '1h 31m', '<p>Fran likes to think about dying. It brings sensation to her quiet life. When she makes the new guy at work laugh, it leads to more: a date, a slice of pie, a conversation, a spark. The only thing standing in their way is Fran herself.</p>', '495,493,487,488,497,494,490,491,489,496', '498', 'sometimes-i-think-about-dying', 'upload/images/qy3ebryFg9QOX6F77iv5pG3gfwr.jpg', 'upload/images/9aGrZMpo4aYZAJPF37xNLWKjyDc.jpg', 'https://www.youtube.com/watch?v=idtCErzXixE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '5.3', NULL, '', '', '', 2, NULL, 1, NULL, '2024-01-23 16:23:12'),
(29, 'Paid', 2, '1', 1, 'The Promised Land', 1696464000, '2h 7m', '<p>In 18th century Denmark, Captain Ludvig Kahlen &mdash; a proud, ambitious, but impoverished war hero &mdash; sets out to tame a vast, uninhabitable land on which seemingly nothing can grow. He seeks to start farming crops, build a colony in the name of the King, and gain a noble title for himself. This beautiful but forbidding area also happens to be under the rule of the merciless Frederik De Schinkel, a preening nobleman who realizes the threat Kahlen represents to his power. Struggling against the elements and local brigands, Kahlen is joined by a couple who have fled the clutches of the rapacious De Schinkel. As this group of misfits begin to build a small community in this inhospitable place, De Schinkel swears vengeance, and the confrontation between him and Kahlen promises to be as violent and intense as these two men.</p>', '499,500,501,502,503,504,505,506,507,508,509', '510', 'the-promised-land', 'upload/images/npQgoOWn4fnvOIIyTj4rIV80FXC.jpg', 'upload/images/6KTY6ld8Hu8XmgnzXVXS9frI3L8.jpg', 'https://www.youtube.com/watch?v=fRO5x4Kp7gU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt20561198', '7.5', NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(33, 'Paid', 2, '9,1', 1, 'Arthur the King', 1710460800, '0h 0m', '<p>Over the course of ten days and 435 miles, an unbreakable bond is forged between pro adventure racer Michael Light and a scrappy street dog companion dubbed Arthur. As the team is pushed to their outer limits of endurance in the race, Arthur redefines what victory, loyalty and friendship truly mean.</p>', '795,796,797,798,799,800,801,802,803,804,805', '806', 'arthur-the-king', 'upload/images/kzTMaDxz69yQ2pokgnYlS6y4GgC.jpg', 'upload/images/pa7jM1TIoa2DZfkE1zoqo4CHVG8.jpg', 'https://www.youtube.com/watch?v=wjDJNEPghNY', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt10720352', NULL, NULL, '', '', '', 0, NULL, 1, NULL, NULL),
(34, 'Free', 2, '9,3', 1, 'Kung Fu Panda 4', 1709683200, '0h 0m', '<p>Po is gearing up to become the spiritual leader of his Valley of Peace, but also needs someone to take his place as Dragon Warrior. As such, he will train a new kung fu practitioner for the spot and will encounter a villain called the Chameleon who conjures villains from the past.</p>', '807,808,809,722,810,811,477,812,813,814,815', '816', 'kung-fu-panda-4', 'upload/images/kDp1vUBnMpe8ak4rjgl3cLELqjU.jpg', 'upload/images/1XDDXPXGiI8id7MrUxK36ke7gkX.jpg', 'https://www.youtube.com/watch?v=_inKs4eeHiI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt21692408', NULL, NULL, '', '', '', 0, NULL, 1, NULL, '2024-01-23 16:46:10'),
(35, 'Free', 6, '9', 1, 'Captain Miller', 1704931200, '2h 38m', '<p>In the 1930s, during the British Raj, Analeesan \\\"Eesa\\\", a former soldier of the British Indian Army called Captain Miller, is on a mission to protect the people from the British after witnessing an atrocity.</p>', '817,818,819,396,820,821,822,823,824,825,826', '827', 'captain-miller', 'upload/images/nCnLI0MP8BkKK50WfGUiTTmYqIG.jpg', 'upload/images/ihKBc0jkHLum0KRPrmRT6b0WVQW.jpg', 'https://www.youtube.com/watch?v=ujhWbKP1rKA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'tt22170036', '7.9', NULL, '', '', '', 3, NULL, 1, NULL, '2024-01-24 15:41:42'),
(36, 'Free', 6, '9,5,1', 1, 'Kantara A Legend: Chapter 1', 1723680000, '2h 19m', '<p>Kantara: Chapter 1 is an upcoming Indian Kannada-language period action thriller film set during the reign of Kadambas of Banavasi written and directed by Rishab Shetty, and produced by Vijay Kiragandur, under Hombale Films. It is a prequel to the 2022 film Kantara. The film stars Rishab Shetty.</p>', '652', '336', 'kantara-a-legend-chapter-1', 'upload/Kantara.jpg', 'upload/kantara_poster.jpg', 'https://www.youtube.com/watch?v=Frp0zC4643U', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 4, NULL, 1, NULL, '2024-01-24 16:01:00'),
(37, 'Paid', 2, '5', 0, 'Fast X', 1684281600, '2h 22m', '<p>Over many missions and against impossible odds, Dom Toretto and his family have outsmarted, out-nerved and outdriven every foe in their path. Now, they confront the most lethal opponent they\\\'ve ever faced: A terrifying threat emerging from the shadows of the past who\\\'s fueled by blood revenge, and who is determined to shatter this family and destroy everything&mdash;and everyone&mdash;that Dom loves, forever.</p>', '867,865,862,863,861,140,796,866,864,860,132', '868', 'fast-x', 'upload/images/fiVW06jE7z9YnO4trhaMEdclSiC.jpg', 'upload/images/4XM8DUTQb3lhLemJC51Jx4a2EuA.jpg', 'https://www.youtube.com/watch?v=32RAq6JzY-w', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7.2', NULL, '', '', '', 19, NULL, 1, NULL, '2024-01-25 19:42:12');

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `id` int(11) NOT NULL,
  `page_title` varchar(500) NOT NULL,
  `page_slug` varchar(500) NOT NULL,
  `page_content` text NOT NULL,
  `page_order` int(3) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` (`id`, `page_title`, `page_slug`, `page_content`, `page_order`, `status`) VALUES
(1, 'About Us', 'about-us', '<p>Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century. Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>', 1, 1),
(2, 'Terms Of Use', 'terms-of-use', '<p><strong>Use of this site is provided by Demos subject to the following Terms and Conditions:</strong><br />1. Your use constitutes acceptance of these Terms and Conditions as at the date of your first use of the site.<br />2. Demos reserves the rights to change these Terms and Conditions at any time by posting changes online. Your continued use of this site after changes are posted constitutes your acceptance of this agreement as modified.<br />3. You agree to use this site only for lawful purposes, and in a manner which does not infringe the rights, or restrict, or inhibit the use and enjoyment of the site by any third party.<br />4. This site and the information, names, images, pictures, logos regarding or relating to Demos are provided &ldquo;as is&rdquo; without any representation or endorsement made and without warranty of any kind whether express or implied. In no event will Demos be liable for any damages including, without limitation, indirect or consequential damages, or any damages whatsoever arising from the use or in connection with such use or loss of use of the site, whether in contract or in negligence.<br />5. Demos does not warrant that the functions contained in the material contained in this site will be uninterrupted or error free, that defects will be corrected, or that this site or the server that makes it available are free of viruses or bugs or represents the full functionality, accuracy and reliability of the materials.<br />6. Copyright restrictions: please refer to our Creative Commons license terms governing the use of material on this site.<br />7. Demos takes no responsibility for the content of external Internet Sites.<br />8. Any communication or material that you transmit to, or post on, any public area of the site including any data, questions, comments, suggestions, or the like, is, and will be treated as, non-confidential and non-proprietary information.<br />9. If there is any conflict between these Terms and Conditions and rules and/or specific terms of use appearing on this site relating to specific material then the latter shall prevail.<br />10. These terms and conditions shall be governed and construed in accordance with the laws of England and Wales. Any disputes shall be subject to the exclusive jurisdiction of the Courts of England and Wales.<br />11. If these Terms and Conditions are not accepted in full, the use of this site must be terminated immediately.</p>', 2, 1),
(3, 'Privacy Policy', 'privacy-policy', '<h4><strong>Privacy Policy of&nbsp;<span class=\\\"highlight preview_company_name\\\">Company Name</span></strong></h4>\r\n<p><span class=\\\"highlight preview_company_name\\\">Company Name</span>&nbsp;operates the&nbsp;<span class=\\\"highlight preview_website_name\\\">Website Name</span>&nbsp;website, which provides the SERVICE.</p>\r\n<p>This page is used to inform website visitors regarding our policies with the collection, use, and disclosure of Personal Information if anyone decided to use our Service, the&nbsp;<span class=\\\"highlight preview_website_name\\\">Website Name</span>&nbsp;website.</p>\r\n<p>If you choose to use our Service, then you agree to the collection and use of information in relation with this policy. The Personal Information that we collect are used for providing and improving the Service. We will not use or share your information with anyone except as described in this Privacy Policy.</p>\r\n<p>The terms used in this Privacy Policy have the same meanings as in our Terms and Conditions, which is accessible at&nbsp;<span class=\\\"highlight preview_website_url\\\">Website URL</span>, unless otherwise defined in this Privacy Policy.</p>\r\n<h4><strong>Information Collection and Use</strong></h4>\r\n<p>For a better experience while using our Service, we may require you to provide us with certain personally identifiable information, including but not limited to your name, phone number, and postal address. The information that we collect will be used to contact or identify you.</p>\r\n<h4><strong>Log Data</strong></h4>\r\n<p>We want to inform you that whenever you visit our Service, we collect information that your browser sends to us that is called Log Data. This Log Data may include information such as your computer\\\'s Internet Protocol (&ldquo;IP&rdquo;) address, browser version, pages of our Service that you visit, the time and date of your visit, the time spent on those pages, and other statistics.</p>\r\n<h4><strong>Cookies</strong></h4>\r\n<p>Cookies are files with small amount of data that is commonly used an anonymous unique identifier. These are sent to your browser from the website that you visit and are stored on your computer\\\'s hard drive.</p>\r\n<p>Our website uses these &ldquo;cookies&rdquo; to collection information and to improve our Service. You have the option to either accept or refuse these cookies, and know when a cookie is being sent to your computer. If you choose to refuse our cookies, you may not be able to use some portions of our Service.</p>\r\n<h4><strong>Service Providers</strong></h4>\r\n<p>We may employ third-party companies and individuals due to the following reasons:</p>\r\n<ul>\r\n<li>To facilitate our Service</li>\r\n<li>To provide the Service on our behalf</li>\r\n<li>To perform Service-related services or</li>\r\n<li>To assist us in analyzing how our Service is used.</li>\r\n</ul>\r\n<p>We want to inform our Service users that these third parties have access to your Personal Information. The reason is to perform the tasks assigned to them on our behalf. However, they are obligated not to disclose or use the information for any other purpose.</p>\r\n<h4><strong>Security</strong></h4>\r\n<p>We value your trust in providing us your Personal Information, thus we are striving to use commercially acceptable means of protecting it. But remember that no method of transmission over the internet, or method of electronic storage is 100% secure and reliable, and we cannot guarantee its absolute security.</p>\r\n<h4><strong>Links to Other Sites</strong></h4>\r\n<p>Our Service may contain links to other sites. If you click on a third-party link, you will be directed to that site. Note that these external sites are not operated by us. Therefore, we strongly advise you to review the Privacy Policy of these websites. We have no control over, and assume no responsibility for the content, privacy policies, or practices of any third-party sites or services.</p>\r\n<p>Children\\\'s Privacy</p>\r\n<p>Our Services do not address anyone under the age of 13. We do not knowingly collect personal identifiable information from children under 13. In the case we discover that a child under 13 has provided us with personal information, we immediately delete this from our servers. If you are a parent or guardian and you are aware that your child has provided us with personal information, please contact us so that we will be able to do necessary actions.</p>\r\n<h4><strong>Changes to This Privacy Policy</strong></h4>\r\n<p>We may update our Privacy Policy from time to time. Thus, we advise you to review this page periodically for any changes. We will notify you of any changes by posting the new Privacy Policy on this page. These changes are effective immediately, after they are posted on this page.</p>\r\n<h4><strong>Contact Us</strong></h4>\r\n<p>If you have any questions or suggestions about our Privacy Policy, do not hesitate to contact us.</p>', 3, 1),
(4, 'FAQ', 'faq', '<div id=\\\"kt-accordion-panel-939336\\\" class=\\\"kt-accordion-panel kt-accordion-panel-active\\\" role=\\\"region\\\" aria-labelledby=\\\"kt-accordion-header-939336\\\" data-panel-height=\\\"0px\\\">\r\n<div class=\\\"kt-accordion-panel-inner\\\">\r\n<h2><strong>What does LOREM mean?</strong></h2>\r\n<p>&lsquo;Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>\r\n<h2><strong>Why does LOREM mean?</strong></h2>\r\n<p>&lsquo;Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>\r\n<h2><strong>Which does LOREM mean?</strong></h2>\r\n<p>&lsquo;Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>\r\n<h2><strong>Who does LOREM mean?</strong></h2>\r\n<p>&lsquo;Lorem ipsum dolor sit amet, consectetur adipisici elit&hellip;&rsquo; (complete text) is dummy text that is not meant to mean anything. It is used as a placeholder in magazine layouts, for example, in order to give an impression of the finished document. The text is intentionally unintelligible so that the viewer is not distracted by the content. The language is not real Latin and even the first word &lsquo;Lorem&rsquo; does not exist. It is said that the lorem ipsum text has been common among typesetters since the 16th century.</p>\r\n</div>\r\n</div>', 4, 1),
(5, 'Contact Us', 'contact-us', '<p>Write your Contact us details here..</p>\r\n<p>Do you want to create similar OTT App ?</p>\r\n<p>Purchase source code from via this link:- <span style=\\\"color: #e03e2d;\\\"><a style=\\\"color: #e03e2d;\\\" href=\\\"https://1.envato.market/JakrN\\\">https://1.envato.market/JakrN</a></span></p>\r\n<p>We are open to new projects too.<br />WhatsApp: +91 9227777522</p>', 5, 1);

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL,
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_gateway`
--

CREATE TABLE `payment_gateway` (
  `id` int(11) NOT NULL,
  `gateway_name` varchar(255) NOT NULL,
  `gateway_short_info` varchar(500) DEFAULT NULL,
  `gateway_info` text DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `payment_gateway`
--

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `gateway_short_info`, `gateway_info`, `status`) VALUES
(1, 'Paypal', 'For International Payment', '{\"mode\":\"sandbox\",\"paypal_client_id\":null,\"paypal_secret\":null,\"braintree_merchant_id\":null,\"braintree_public_key\":null,\"braintree_private_key\":null,\"braintree_merchant_account_id\":null}', 0),
(2, 'Stripe', 'For International Payment', '{\"stripe_secret_key\":null,\"stripe_publishable_key\":null}', 0),
(3, 'Razorpay', 'Pay with Wallets and UPI', '{\"razorpay_key\":null,\"razorpay_secret\":null}', 0),
(4, 'Paystack', 'Payments for Africa', '{\"paystack_secret_key\":null,\"paystack_public_key\":null}', 0),
(5, 'Instamojo', 'Pay with Wallets and UPI', '{\"mode\":\"sandbox\",\"instamojo_client_id\":null,\"instamojo_client_secret\":null}', 0),
(6, 'PayUMoney', 'Pay with Wallets and UPI', '{\"mode\":\"sandbox\",\"payu_merchant_id\":null,\"payu_key\":null,\"payu_salt\":null}', 0),
(7, 'Mollie', 'Payment for Europe', '{\"mollie_api_key\":null}', 0),
(8, 'Flutterwave', 'Payments for Africa', '{\"flutterwave_public_key\":null,\"flutterwave_secret_key\":null,\"flutterwave_encryption_key\":null}', 0),
(9, 'Paytm', 'Pay with Paytm Wallet', '{\"mode\":\"sandbox\",\"paytm_merchant_id\":null,\"paytm_merchant_key\":null}', 0),
(10, 'Cashfree', 'Pay with Wallets and UPI', '{\"mode\":\"sandbox\",\"cashfree_appid\":null,\"cashfree_secret_key\":null}', 0),
(11, 'Coingate', 'Payment for Cryptocurrency', '{\"mode\":\"sandbox\",\"coingate_api_key\":null,\"coingate_receive_currency\":null}', 0),
(12, 'Bank Transfer', 'Manual Bank Transfer', '{\"banktransfer_info\":\"<p><strong>Account<\\/strong>: 2223330032299999<br \\/><strong>IFSC<\\/strong>: SBIN000123456<br \\/><strong>Bank Name<\\/strong>: SBI<br \\/><strong>Beneficiary Name<\\/strong>: John Deo<\\/p>\\r\\n<p><br \\/>Transfer the exact amount for the payment to be successful. Please make payment only in the account number mentioned above.<\\/p>\\r\\n<p>If you have any questions, you can contact customer support at any time.<\\/p>\"}', 0),
(13, 'Braintree', 'For International Payment', '{\"mode\":\"sandbox\",\"braintree_merchant_id\":null,\"braintree_public_key\":null,\"braintree_private_key\":null,\"braintree_merchant_account_id\":null}', 0),
(14, 'SSLCOMMERZ', 'Payment for Bangladesh', NULL, 0),
(15, 'CinetPay', 'CinetPay for West Africa and Central Africa', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `payu_transactions`
--

CREATE TABLE `payu_transactions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `paid_for_id` bigint(20) UNSIGNED DEFAULT NULL,
  `paid_for_type` varchar(255) DEFAULT NULL,
  `transaction_id` varchar(255) NOT NULL,
  `gateway` text NOT NULL,
  `body` text NOT NULL,
  `destination` varchar(255) NOT NULL,
  `hash` text NOT NULL,
  `response` text DEFAULT NULL,
  `status` enum('pending','failed','successful','invalid') NOT NULL DEFAULT 'pending',
  `verified_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `recently_watched`
--

CREATE TABLE `recently_watched` (
  `id` int(11) NOT NULL,
  `video_type` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `season`
--

CREATE TABLE `season` (
  `id` int(11) NOT NULL,
  `series_id` int(11) NOT NULL,
  `season_name` varchar(500) NOT NULL,
  `season_slug` varchar(255) NOT NULL,
  `season_poster` varchar(500) NOT NULL,
  `trailer_url` text DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `season`
--

INSERT INTO `season` (`id`, `series_id`, `season_name`, `season_slug`, `season_poster`, `trailer_url`, `seo_title`, `seo_description`, `seo_keyword`, `status`) VALUES
(1, 1, 'Season 1', 'season-1', 'upload/images/pMfG5XIlmvCL9bQQiJKdTvmF2FW.jpg', 'https://www.youtube.com/watch?v=uLtkt8BonwM', NULL, NULL, NULL, 1),
(2, 2, 'Season 1', 'season-1', 'upload/images/zep9WA61eVCovERGLI1FHeJWuWA.jpg', 'https://www.youtube.com/watch?v=rOD-78_0pPU', NULL, NULL, NULL, 1),
(3, 2, 'Season 2', 'season-2', 'upload/images/8fpDnSJ14jUEkCkLknGHdzdfQTm.jpg', 'https://www.youtube.com/watch?v=rOD-78_0pPU', NULL, NULL, NULL, 1),
(4, 3, 'Season 1', 'season-1', 'upload/images/dHAxJpWuDyFzCRkbPJfWxfWdMBs.jpg', 'https://www.youtube.com/watch?v=LWPXkRNK8SM', NULL, NULL, NULL, 1),
(5, 3, 'Season 2', 'season-2', 'upload/images/lG8wK40jH4EX6dbVFI1fzw2E96N.jpg', 'https://www.youtube.com/watch?v=LWPXkRNK8SM', NULL, NULL, NULL, 1),
(6, 4, 'Limited Series', 'limited-series', 'upload/images/zU0htwkhNvBQdVSIKB9s6hgVeFK.jpg', 'https://www.youtube.com/watch?v=oZn3qSgmLqI', NULL, NULL, NULL, 1),
(7, 5, 'Season 1', 'season-1', 'upload/images/uZsV5ZIZQMHekWDQQMsBwN0C3yA.jpg', 'https://www.youtube.com/watch?v=eb90gqGYP9c', NULL, NULL, NULL, 1),
(8, 5, 'Season 2', 'season-2', 'upload/images/7vjaCdMw15FEbXyLQTVa04URsPm.jpg', 'https://www.youtube.com/watch?v=eb90gqGYP9c', NULL, NULL, NULL, 1),
(9, 5, 'Season 3', 'season-3', 'upload/images/hVlNFW0wT2Ow0ilXlfPyps8pHvt.jpg', 'https://www.youtube.com/watch?v=eb90gqGYP9c', NULL, NULL, NULL, 1),
(10, 6, 'Season 1', 'season-1', 'upload/images/rbnuP7hlynAMLdqcQRCpZW9qDkV.jpg', 'https://www.youtube.com/watch?v=mnd7sFt5c3A', NULL, NULL, NULL, 1),
(11, 6, 'Stranger Things 2', 'stranger-things-2', 'upload/images/lXS60geme1LlEob5Wgvj3KilClA.jpg', 'https://www.youtube.com/watch?v=mnd7sFt5c3A', NULL, NULL, NULL, 1),
(12, 6, 'Stranger Things 3', 'stranger-things-3', 'upload/images/x2LSRK2Cm7MZhjluni1msVJ3wDF.jpg', 'https://www.youtube.com/watch?v=mnd7sFt5c3A', NULL, NULL, NULL, 1),
(13, 6, 'Stranger Things 4', 'stranger-things-4', 'upload/images/zvGTZYDCoMSMIBkXExxRxLYimqN.jpg', 'https://www.youtube.com/watch?v=mnd7sFt5c3A', NULL, NULL, NULL, 1),
(14, 7, 'Season 1', 'season-1', 'upload/images/6TKuHmdHdeeZkLdYxsIV099N8I6.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(15, 7, 'Season 2', 'season-2', 'upload/images/sWPgOyn6Ae9iIpxNpEHLrr12I3Q.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(16, 7, 'Season 3', 'season-3', 'upload/images/sgUNbsq2zGRpFCOPv5yuCR9WAd5.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(17, 7, 'Season 4', 'season-4', 'upload/images/aHDi4JwxZA5n7PXLO66z9j0b2Nd.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(18, 7, 'Season 5', 'season-5', 'upload/images/okswp8IvmdPznyBU5RiymQroc6f.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(19, 7, 'Season 6', 'season-6', 'upload/images/pTtA9CxNwln23B7VrtROXphyhwo.jpg', 'https://www.youtube.com/watch?v=JWtnJjn6ng0', NULL, NULL, NULL, 1),
(20, 8, 'Season 1', 'season-1', 'upload/images/lDsJxWEVDZCi6UXBLwAcyh2Z6n.jpg', 'https://www.youtube.com/watch?v=ga1m0wjzscU', NULL, NULL, NULL, 1),
(21, 8, 'Season 2', 'season-2', 'upload/images/wZDUeDRbbFrMiTDVRy85Zdzgqcp.jpg', 'https://www.youtube.com/watch?v=ga1m0wjzscU', NULL, NULL, NULL, 1),
(22, 8, 'Season 3', 'season-3', 'upload/images/yxIdKGEjagaLs5kMjw92kAHmopH.jpg', 'https://www.youtube.com/watch?v=ga1m0wjzscU', NULL, NULL, NULL, 1),
(23, 8, 'Season 4', 'season-4', 'upload/images/d14IUBHQkSEpdPAbCrHRii3j5PW.jpg', 'https://www.youtube.com/watch?v=ga1m0wjzscU', NULL, NULL, NULL, 1),
(24, 8, 'Season 5', 'season-5', 'upload/images/d14IUBHQkSEpdPAbCrHRii3j5PW.jpg', 'https://www.youtube.com/watch?v=ga1m0wjzscU', '', '', '', 1),
(25, 9, 'Season 1', 'season-1', 'upload/images/htazQ0cPoloL5SJ2bqOCKh9UTcc.jpg', 'https://www.youtube.com/watch?v=qAtBbgtMnZ8', NULL, NULL, NULL, 1),
(26, 9, 'Season 2', 'season-2', 'upload/images/gW3FJouZ3Ab57OR50Fy2jLaKAKH.jpg', 'https://www.youtube.com/watch?v=qAtBbgtMnZ8', NULL, NULL, NULL, 1),
(27, 16, 'Specials', 'specials', 'upload/images/fn2wMnrPWIjDMnxIf0H89ZtDehK.jpg', NULL, '', '', '', 1),
(28, 16, 'Season 1', 'season-1', 'upload/images/fn2wMnrPWIjDMnxIf0H89ZtDehK.jpg', NULL, NULL, NULL, NULL, 1),
(29, 16, 'Invasion', 'invasion', 'upload/images/ufu4g1s98H0Q5NbsEdoTct44IUW.jpg', NULL, NULL, NULL, NULL, 1),
(30, 16, 'Outsiders', 'outsiders', 'upload/images/oL31ADgSgVdgoJPRAdWISQBIO0w.jpg', NULL, NULL, NULL, NULL, 1),
(31, 16, 'Phantoms', 'phantoms', 'upload/images/uV75k4z66w7BSc10viWeXBK5yW5.jpg', NULL, NULL, NULL, NULL, 1),
(32, 17, 'Season 1', 'season-1', 'upload/images/afOVe53kXHSY198dwd7KdSppwca.jpg', 'https://www.youtube.com/watch?v=ByAn8DF8Ykk', NULL, NULL, NULL, 1),
(33, 18, 'Specials', 'specials', 'upload/images/40dT79mDEZwXkQiZNBgSaydQFDP.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1),
(34, 18, 'Season 1', 'season-1', 'upload/images/1BP4xYv9ZG4ZVHkL7ocOziBbSYH.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1),
(35, 18, 'Season 2', 'season-2', 'upload/images/e3oGYpoTUhOFK0BJfloru5ZmGV.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1),
(36, 18, 'Season 3', 'season-3', 'upload/images/ffP8Q8ew048YofHRnFVM18B2fPG.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1),
(37, 18, 'Season 4', 'season-4', 'upload/images/5ewrnKp4TboU4hTLT5cWO350mHj.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1),
(38, 18, 'Season 5', 'season-5', 'upload/images/r3z70vunihrAkjILQKWHX0G2xzO.jpg', 'https://www.youtube.com/watch?v=XZ8daibM3AE', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `series`
--

CREATE TABLE `series` (
  `id` int(11) NOT NULL,
  `series_lang_id` int(11) NOT NULL,
  `series_genres` text NOT NULL,
  `upcoming` int(1) NOT NULL DEFAULT 0,
  `series_access` varchar(255) NOT NULL DEFAULT 'Paid',
  `series_name` varchar(500) NOT NULL,
  `series_slug` varchar(255) NOT NULL,
  `series_info` text NOT NULL,
  `actor_id` text DEFAULT NULL,
  `director_id` text DEFAULT NULL,
  `series_poster` varchar(500) NOT NULL,
  `imdb_id` varchar(255) DEFAULT NULL,
  `imdb_rating` varchar(255) DEFAULT NULL,
  `imdb_votes` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `content_rating` varchar(255) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `series`
--

INSERT INTO `series` (`id`, `series_lang_id`, `series_genres`, `upcoming`, `series_access`, `series_name`, `series_slug`, `series_info`, `actor_id`, `director_id`, `series_poster`, `imdb_id`, `imdb_rating`, `imdb_votes`, `seo_title`, `seo_description`, `seo_keyword`, `content_rating`, `status`) VALUES
(1, 2, '1', 0, 'Paid', 'The Last of Us', 'the-last-of-us', 'Twenty years after modern civilization has been destroyed, Joel, a hardened survivor, is hired to smuggle Ellie, a 14-year-old girl, out of an oppressive quarantine zone. What starts as a small job soon becomes a brutal, heartbreaking journey, as they both must traverse the United States and depend on each other for survival.', '48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68', '311,312,313,314,315,316,317', 'upload/images/uDgy6hyPd82kOHh6I95FLtLnj6p.jpg', '100088', '8.6', NULL, '', '', '', '13+', 1),
(2, 1, '1', 0, 'Free', 'Rocket Boys', 'rocket-boys', 'Spanning three crucial decades (1940-60s) in the history of India, the story chronicles the life of three great men responsible for launching India\\\'s space and nuclear programs respectively: Dr. Homi J. Bhabha, the architect of India\\\'s Nuclear Programme, Dr. Vikram Sarabhai, universally acknowledged as the Father of the Indian Space Programme and Dr. A.P.J. Abdul Kalam, the pioneer of modern Indian aerospace and nuclear technology. The season traces the journey of Bhabha and Sarabhai coming to terms with the challenges facing a young, independent nation and their friendship, sacrifice and determination.', '329,330,331,332,258,333,235,253,334,335', '336', 'upload/images/kOGM01ZhELmJCxdVObqQbRwXXH3.jpg', '138211', '7.8', NULL, '', '', '', NULL, 1),
(3, 1, '1', 0, 'Paid', 'Aspirants', 'aspirants', 'Aspirants is a story of 3 friends - Abhilash, SK, and Guri. The story takes place in the past and the present where the past captures the struggle and the drama behind the making of UPSC CSE aspirants in Old Rajinder Nagar of Delhi, while the present talks about the aftermath. It is the story of three UPSC aspirants journey.', '337,338,339,340,341,342,343,344,345,346,347,348,349,350', '351', 'upload/images/suXX4sFFgUGMv47jCibP4hhsmN7.jpg', '124411', '7.5', NULL, '', '', '', NULL, 1),
(4, 2, '1', 0, 'Paid', 'The Queen\\\'s Gambit', 'the-queens-gambit', 'In a 1950s orphanage, a young girl reveals an astonishing talent for chess and begins an unlikely journey to stardom while grappling with addiction.', '352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372', '373', 'upload/images/34OGjFEbHj0E3lE2w0iTUVq0CBz.jpg', '87739', '8.5', NULL, '', '', '', NULL, 1),
(5, 2, '1', 0, 'Free', 'The Witcher', 'the-witcher', 'Geralt of Rivia, a mutated monster-hunter for hire, journeys toward his destiny in a turbulent world where people often prove more wicked than beasts.', '438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458', '459,460,461,,463,464,465,466,467,468,469', 'upload/images/foGkPxpw9h8zln81j63mix5B7m8.jpg', '71912', '8.1', NULL, '', '', '', NULL, 1),
(6, 2, '1', 0, 'Paid', 'Stranger Things', 'stranger-things', 'When a young boy vanishes, a small town uncovers a mystery involving secret experiments, terrifying supernatural forces, and one strange little girl.', '576,561,568,565,573,562,559,560,574,566,578,571,575,558,564,567,572,570,577,569,563', '583,579,582,585,580,581,584', 'upload/images/56v2KjBlU4XaOv9rVYEQypROD7P.jpg', NULL, '8.6', NULL, '', '', '', NULL, 1),
(7, 2, '1', 1, 'Paid', 'The Crown', 'the-crown', 'The gripping, decades-spanning inside story of Her Majesty Queen Elizabeth II and the Prime Ministers who shaped Britain\\\'s post-war destiny. \r\n\r\nThe Crown tells the inside story of two of the most famous addresses in the world – Buckingham Palace and 10 Downing Street – and the intrigues, love lives and machinations behind the great events that shaped the second half of the 20th century. Two houses, two courts, one Crown.', '586,587,122,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,', '606,607,608,609,610,611,612,613,614,615,616,617', 'upload/images/aWnEtYJn31swY2pC8cOtje98bYc.jpg', '65494', '8.2', NULL, '', '', '', NULL, 1),
(8, 2, '1', 0, 'Free', 'You', 'you', 'A dangerously charming, intensely obsessive young man goes to extreme measures to insert himself into the lives of those he is transfixed by.', '621,630,637,635,625,626,632,622,624,471,631,633,618,620,628,636,623,627,629,619,634', '641,644,640,647,639,638,646,643,645,642', 'upload/images/2ZNFu0hkSVtAI6LRWGIlCPNd1Tj.jpg', NULL, '8.1', NULL, '', '', '', NULL, 1),
(9, 2, '1', 1, 'Paid', 'Another Life', 'another-life', 'After a massive alien artifact lands on Earth, Niko Breckinridge leads an interstellar mission to track down its source and make first contact.', '648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668', '669,670,671,672,673,674,675', 'upload/images/6ygiUWflbmz5p2LFc3COVHriQzK.jpg', '79130', '6.1', NULL, '', '', '', NULL, 1),
(16, 2, '9', 1, 'Paid', 'Young Justice', 'young-justice', 'Teenage superheroes strive to prove themselves as members of the Justice League.', '676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696', '697,698,699,700,701,702,703,704,705,706,707,708', 'upload/images/3Id4UGssefRUWLdsh8MXx0nnxst.jpg', '33217', '8.4', NULL, '', '', '', NULL, 1),
(17, 2, '1', 1, 'Paid', 'Avatar: The Last Airbender', 'avatar-the-last-airbender', 'A young boy known as the Avatar must master the four elemental powers to save a world at war — and fight a ruthless enemy bent on stopping him.', '721,712,713,715,709,711,716,710,717,719,714,718,720', NULL, 'upload/images/syc4jp5vlEBlI4QX3RSTUk52EUN.jpg', NULL, '0', NULL, '', '', '', NULL, 1),
(18, 2, '1', 0, 'Paid', 'Breaking Bad', 'breaking-bad', 'When Walter White, a New Mexico chemistry teacher, is diagnosed with Stage III cancer and given a prognosis of only two years left to live. He becomes filled with a sense of fearlessness and an unrelenting desire to secure his family\\\'s financial future at any cost as he enters the dangerous world of drugs and crime.', '722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,39,737,738,739,740,741', '742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,722,758,759,760,761,762,763,764,765,766', 'upload/images/9faGSFi5jam6pDWGNd0p8JcJgXQ.jpg', '1396', '8.9', NULL, '', '', '', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `time_zone` varchar(255) NOT NULL DEFAULT 'UTC',
  `default_language` varchar(255) NOT NULL DEFAULT 'en',
  `styling` varchar(255) NOT NULL DEFAULT 'light',
  `site_name` varchar(255) NOT NULL,
  `site_email` varchar(255) NOT NULL,
  `site_logo` varchar(255) NOT NULL,
  `site_favicon` varchar(255) NOT NULL,
  `site_description` text DEFAULT NULL,
  `site_keywords` text DEFAULT NULL,
  `site_header_code` text DEFAULT NULL,
  `site_footer_code` text DEFAULT NULL,
  `site_copyright` text NOT NULL,
  `currency_code` varchar(255) NOT NULL,
  `footer_fb_link` varchar(500) DEFAULT NULL,
  `footer_twitter_link` varchar(500) DEFAULT NULL,
  `footer_instagram_link` varchar(500) DEFAULT NULL,
  `footer_google_play_link` varchar(500) DEFAULT NULL,
  `footer_apple_store_link` varchar(500) DEFAULT NULL,
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_port` varchar(255) DEFAULT NULL,
  `smtp_email` varchar(255) DEFAULT NULL,
  `smtp_password` varchar(255) DEFAULT NULL,
  `smtp_encryption` varchar(255) DEFAULT NULL,
  `gdpr_cookie_on_off` int(1) NOT NULL DEFAULT 1,
  `gdpr_cookie_title` varchar(500) DEFAULT NULL,
  `gdpr_cookie_text` text DEFAULT NULL,
  `gdpr_cookie_url` varchar(255) DEFAULT NULL,
  `omdb_api_key` varchar(255) DEFAULT NULL,
  `external_css_js` varchar(255) DEFAULT 'local',
  `google_login` varchar(255) NOT NULL DEFAULT 'false',
  `facebook_login` varchar(255) NOT NULL DEFAULT 'false',
  `google_client_id` varchar(255) DEFAULT NULL,
  `google_client_secret` varchar(255) DEFAULT NULL,
  `google_redirect` text DEFAULT NULL,
  `facebook_app_id` varchar(255) DEFAULT NULL,
  `facebook_client_secret` varchar(255) DEFAULT NULL,
  `facebook_redirect` text DEFAULT NULL,
  `maintenance mode` varchar(255) DEFAULT NULL,
  `envato_buyer_name` varchar(255) DEFAULT NULL,
  `envato_purchase_code` varchar(255) DEFAULT NULL,
  `menu_shows` int(1) NOT NULL DEFAULT 1,
  `menu_movies` int(1) NOT NULL DEFAULT 1,
  `menu_sports` int(1) NOT NULL DEFAULT 1,
  `menu_livetv` int(1) NOT NULL DEFAULT 1,
  `recaptcha_site_key` varchar(255) DEFAULT NULL,
  `recaptcha_secret_key` varchar(255) DEFAULT NULL,
  `recaptcha_on_login` int(1) NOT NULL DEFAULT 0,
  `recaptcha_on_signup` int(1) NOT NULL DEFAULT 0,
  `recaptcha_on_forgot_pass` int(1) NOT NULL DEFAULT 0,
  `recaptcha_on_contact_us` int(1) NOT NULL DEFAULT 0,
  `tmdb_api_key` varchar(500) DEFAULT NULL,
  `tmdb_api_language` varchar(20) NOT NULL DEFAULT 'en-US',
  `maintenance_title` varchar(500) DEFAULT NULL,
  `maintenance_description` text DEFAULT NULL,
  `maintenance_mode` varchar(255) NOT NULL DEFAULT 'up',
  `maintenance_secret` varchar(500) NOT NULL DEFAULT 'viaviweb'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `time_zone`, `default_language`, `styling`, `site_name`, `site_email`, `site_logo`, `site_favicon`, `site_description`, `site_keywords`, `site_header_code`, `site_footer_code`, `site_copyright`, `currency_code`, `footer_fb_link`, `footer_twitter_link`, `footer_instagram_link`, `footer_google_play_link`, `footer_apple_store_link`, `smtp_host`, `smtp_port`, `smtp_email`, `smtp_password`, `smtp_encryption`, `gdpr_cookie_on_off`, `gdpr_cookie_title`, `gdpr_cookie_text`, `gdpr_cookie_url`, `omdb_api_key`, `external_css_js`, `google_login`, `facebook_login`, `google_client_id`, `google_client_secret`, `google_redirect`, `facebook_app_id`, `facebook_client_secret`, `facebook_redirect`, `maintenance mode`, `envato_buyer_name`, `envato_purchase_code`, `menu_shows`, `menu_movies`, `menu_sports`, `menu_livetv`, `recaptcha_site_key`, `recaptcha_secret_key`, `recaptcha_on_login`, `recaptcha_on_signup`, `recaptcha_on_forgot_pass`, `recaptcha_on_contact_us`, `tmdb_api_key`, `tmdb_api_language`, `maintenance_title`, `maintenance_description`, `maintenance_mode`, `maintenance_secret`) VALUES
(1, 'Asia/Kolkata', 'en', 'style-six', 'Viavi Streaming - Watch TV Shows, Movies Online', 'info@viavilab.com', 'upload/site_logo.png', 'upload/favicon.png', 'Viavi Streaming is Best Script for Streaming Website & Application | Streaming App | Streaming Script | TV Streaming Source Code | TV Clone | Netflix Clone | Amazon Prime Clone | Hotstar Clone | Streaming App', 'Video Streaming, Streaming Website, Streaming App, Live TV, Movies, TV Shows', '', '', 'Copyright © 2024 www.viaviweb.com All Rights Reserved.', 'USD', 'https://www.facebook.com/viaviweb/', 'https://twitter.com/viaviwebtech/', 'https://www.instagram.com/viaviwebtech/', 'https://play.google.com/store/apps/dev?id=7157478532572017100', 'https://apps.apple.com/in/developer/vishal-pamar/id1141291247', NULL, NULL, NULL, NULL, 'SSL', 1, 'This website is using cookies', 'We use them to give you the best experience. If you continue using our website, we\\\'ll assume that you are happy to receive all cookies on this website.', '#', '815fcbbc', 'LOCAL', '0', '0', NULL, NULL, 'http://localhost/envato/video_streaming/auth/google/callback', NULL, NULL, 'http://localhost/envato/video_streaming/auth/facebook/callback', '', '', '', 1, 1, 1, 1, NULL, NULL, 0, 0, 0, 0, '', 'en-US', 'The Website Under Maintenance!', '<p>This Website Under Maintenance!</p>', 'up', 'viaviweb');

-- --------------------------------------------------------

--
-- Table structure for table `settings_android_app`
--

CREATE TABLE `settings_android_app` (
  `id` int(11) NOT NULL,
  `app_name` varchar(255) NOT NULL,
  `app_logo` varchar(255) DEFAULT NULL,
  `app_version` varchar(255) DEFAULT NULL,
  `app_company` varchar(255) DEFAULT NULL,
  `app_email` varchar(255) DEFAULT NULL,
  `app_website` varchar(255) DEFAULT NULL,
  `app_contact` varchar(255) DEFAULT NULL,
  `app_about` text DEFAULT NULL,
  `app_privacy` text DEFAULT NULL,
  `app_terms` text DEFAULT NULL,
  `onesignal_app_id` varchar(255) DEFAULT NULL,
  `onesignal_rest_key` varchar(255) DEFAULT NULL,
  `app_update_hide_show` varchar(255) DEFAULT NULL,
  `app_update_version_code` varchar(255) DEFAULT NULL,
  `app_update_desc` text DEFAULT NULL,
  `app_update_link` varchar(255) DEFAULT NULL,
  `app_update_cancel_option` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `settings_android_app`
--

INSERT INTO `settings_android_app` (`id`, `app_name`, `app_logo`, `app_version`, `app_company`, `app_email`, `app_website`, `app_contact`, `app_about`, `app_privacy`, `app_terms`, `onesignal_app_id`, `onesignal_rest_key`, `app_update_hide_show`, `app_update_version_code`, `app_update_desc`, `app_update_link`, `app_update_cancel_option`) VALUES
(1, 'Video Streaming App', 'upload/site_logo.png', '1.0.0', 'VIAVIWEB', 'info@viaviweb.com', 'www.viaviweb.com', '+91 9227777522', '<p>Watch your favorite TV channels Live in your mobile phone with this application on your device. that support almost all format.The application is specially optimized to be extremely easy to configure and detailed documentation is provided.<br /><br />Do you want to create similar OTT App ?<br /><br />Purchase source code from via this link:- <a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a></p>\r\n<p><br /><strong>We are open to new projects too.</strong><br />WhatsApp: +91 9227777522</p>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a></div>\r\n</div>\r\n</div>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span></div>\r\n</div>\r\n</div>', '<p><strong>We are committed to protecting your privacy</strong></p>\r\n<p>We collect the minimum amount of information about you that is commensurate with providing you with a satisfactory service. This policy indicates the type of processes that may result in data being collected about you. Your use of this website gives us the right to collect that information.&nbsp;</p>\r\n<p><strong>Information Collected</strong></p>\r\n<p>We may collect any or all of the information that you give us depending on the type of transaction you enter into, including your name, address, telephone number, and email address, together with data about your use of the website. Other information that may be needed from time to time to process a request may also be collected as indicated on the website.</p>\r\n<p><strong>Information Use</strong></p>\r\n<p>We use the information collected primarily to process the task for which you visited the website. Data collected in the UK is held in accordance with the Data Protection Act. All reasonable precautions are taken to prevent unauthorised access to this information. This safeguard may require you to provide additional forms of identity should you wish to obtain information about your account details.</p>\r\n<p><strong>Cookies</strong></p>\r\n<p>Your Internet browser has the in-built facility for storing small files - \\\"cookies\\\" - that hold information which allows a website to recognise your account. Our website takes advantage of this facility to enhance your experience. You have the ability to prevent your computer from accepting cookies but, if you do, certain functionality on the website may be impaired.</p>\r\n<p><strong>Disclosing Information</strong></p>\r\n<p>We do not disclose any personal information obtained about you from this website to third parties unless you permit us to do so by ticking the relevant boxes in registration or competition forms. We may also use the information to keep in contact with you and inform you of developments associated with us. You will be given the opportunity to remove yourself from any mailing list or similar device. If at any time in the future we should wish to disclose information collected on this website to any third party, it would only be with your knowledge and consent.&nbsp;</p>\r\n<p>We may from time to time provide information of a general nature to third parties - for example, the number of individuals visiting our website or completing a registration form, but we will not use any information that could identify those individuals.&nbsp;</p>\r\n<p>In addition Dummy may work with third parties for the purpose of delivering targeted behavioural advertising to the Dummy website. Through the use of cookies, anonymous information about your use of our websites and other websites will be used to provide more relevant adverts about goods and services of interest to you. For more information on online behavioural advertising and about how to turn this feature off, please visit youronlinechoices.com/opt-out.</p>\r\n<p><strong>Changes to this Policy</strong></p>\r\n<p>Any changes to our Privacy Policy will be placed here and will supersede this version of our policy. We will take reasonable steps to draw your attention to any changes in our policy. However, to be on the safe side, we suggest that you read this document each time you use the website to ensure that it still meets with your approval.</p>\r\n<p><strong>Contacting Us</strong></p>\r\n<p>If you have any questions about our Privacy Policy, or if you want to know what information we have collected about you, please email us at hd@dummy.com. You can also correct any factual errors in that information or require us to remove your details form any list under our control.</p>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span></div>\r\n</div>\r\n</div>', '<p>Write your terms of use here</p>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a><a class=\\\"x1i10hfl xjbqb8w x6umtig x1b1mbwd xaqea5y xav7gou x9f619 x1ypdohk xt0psk2 xe8uvvx xdj266r x11i5rnm xat24cr x1mh8g0r xexx8yu x4uap5 x18d9i69 xkhd6sd x16tdsg8 x1hl2dhg xggy1nq x1a2a7pz xt0b8zv x1fey0fg\\\" tabindex=\\\"0\\\" role=\\\"link\\\" href=\\\"https://1.envato.market/JakrN?fbclid=IwAR3ATux2QgydSyT6znGgzPYdXFpemBFxkB-QKcrYxFpMuCKb2Bjz8jSLh-k\\\" target=\\\"_blank\\\" rel=\\\"nofollow noopener noreferrer\\\">https://1.envato.market/JakrN</a></div>\r\n</div>\r\n</div>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span></div>\r\n</div>\r\n</div>\r\n<p><textarea id=\\\"BFI_DATA\\\" style=\\\"width: 1px; height: 1px; display: none;\\\"></textarea></p>\r\n<div id=\\\"WidgetFloaterPanels\\\" class=\\\"LTRStyle\\\" style=\\\"display: none; text-align: left; direction: ltr; visibility: hidden;\\\" translate=\\\"no\\\">\r\n<div id=\\\"WidgetFloater\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"WidgetLogoPanel\\\"><span id=\\\"WidgetTranslateWithSpan\\\">TRANSLATE with <img id=\\\"FloaterLogo\\\" alt=\\\"\\\" /></span> <span id=\\\"WidgetCloseButton\\\" title=\\\"Exit Translation\\\">x</span></div>\r\n<div id=\\\"LanguageMenuPanel\\\">\r\n<div class=\\\"DDStyle_outer\\\"><input id=\\\"LanguageMenu_svid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_svid\\\" type=\\\"text\\\" value=\\\"en\\\" /> <input id=\\\"LanguageMenu_textid\\\" style=\\\"display: none;\\\" autocomplete=\\\"on\\\" name=\\\"LanguageMenu_textid\\\" type=\\\"text\\\" /> <span id=\\\"__LanguageMenu_header\\\" class=\\\"DDStyle\\\" tabindex=\\\"0\\\">English</span>\r\n<div style=\\\"position: relative; text-align: left; left: 0;\\\">\r\n<div style=\\\"position: absolute; ;left: 0px;\\\">\r\n<div id=\\\"__LanguageMenu_popup\\\" class=\\\"DDStyle\\\" style=\\\"display: none;\\\">\r\n<table id=\\\"LanguageMenu\\\" border=\\\"0\\\">\r\n<tbody>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ar\\\">Arabic</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#he\\\">Hebrew</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pl\\\">Polish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#bg\\\">Bulgarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hi\\\">Hindi</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#pt\\\">Portuguese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ca\\\">Catalan</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mww\\\">Hmong Daw</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ro\\\">Romanian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHS\\\">Chinese Simplified</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#hu\\\">Hungarian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ru\\\">Russian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#zh-CHT\\\">Chinese Traditional</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#id\\\">Indonesian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sk\\\">Slovak</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cs\\\">Czech</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#it\\\">Italian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sl\\\">Slovenian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#da\\\">Danish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ja\\\">Japanese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#es\\\">Spanish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#nl\\\">Dutch</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tlh\\\">Klingon</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#sv\\\">Swedish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#en\\\">English</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ko\\\">Korean</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#th\\\">Thai</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#et\\\">Estonian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lv\\\">Latvian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#tr\\\">Turkish</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fi\\\">Finnish</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#lt\\\">Lithuanian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#uk\\\">Ukrainian</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fr\\\">French</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ms\\\">Malay</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ur\\\">Urdu</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#de\\\">German</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#mt\\\">Maltese</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#vi\\\">Vietnamese</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#el\\\">Greek</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#no\\\">Norwegian</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#cy\\\">Welsh</a></td>\r\n</tr>\r\n<tr>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#ht\\\">Haitian Creole</a></td>\r\n<td><a tabindex=\\\"-1\\\" href=\\\"#fa\\\">Persian</a></td>\r\n<td>&nbsp;</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<img style=\\\"height: 7px; width: 17px; border-width: 0px; left: 20px;\\\" alt=\\\"\\\" /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\\\"CTFLinksPanel\\\"><span id=\\\"ExternalLinksPanel\\\"><a id=\\\"HelpLink\\\" title=\\\"Help\\\" href=\\\"https://go.microsoft.com/?linkid=9722454\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\"> <img id=\\\"HelpImg\\\" alt=\\\"\\\" /></a> <a id=\\\"EmbedLink\\\" title=\\\"Get this widget for your own site\\\"></a> <img id=\\\"EmbedImg\\\" alt=\\\"\\\" /> <a id=\\\"ShareLink\\\" title=\\\"Share translated page with friends\\\"></a> <img id=\\\"ShareImg\\\" alt=\\\"\\\" /> </span></div>\r\n<div id=\\\"FloaterProgressBar\\\"></div>\r\n</div>\r\n<div id=\\\"WidgetFloaterCollapsed\\\" style=\\\"display: none;\\\">TRANSLATE with <img id=\\\"CollapsedLogoImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"FloaterSharePanel\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"ShareTextDiv\\\"><span id=\\\"ShareTextSpan\\\"> COPY THE URL BELOW </span></div>\r\n<div id=\\\"ShareTextboxDiv\\\"><input id=\\\"ShareTextbox\\\" name=\\\"ShareTextbox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" /> <!--a id=\\\"TwitterLink\\\" title=\\\"Share on Twitter\\\"> <img id=\\\"TwitterImg\\\" /></a> <a-- id=\\\"FacebookLink\\\" title=\\\"Share on Facebook\\\"> <img id=\\\"FacebookImg\\\" /></a--> <a id=\\\"EmailLink\\\" title=\\\"Email this translation\\\"></a> <img id=\\\"EmailImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"ShareFooter\\\"><span id=\\\"ShareHelpSpan\\\"><a id=\\\"ShareHelpLink\\\"></a> <img id=\\\"ShareHelpImg\\\" alt=\\\"\\\" /></span> <span id=\\\"ShareBackSpan\\\"><a id=\\\"ShareBack\\\" title=\\\"Back To Translation\\\"></a> Back</span></div>\r\n<input id=\\\"EmailSubject\\\" name=\\\"EmailSubject\\\" type=\\\"hidden\\\" value=\\\"Check out this page in {0} translated from {1}\\\" /> <input id=\\\"EmailBody\\\" name=\\\"EmailBody\\\" type=\\\"hidden\\\" value=\\\"Translated: {0}%0d%0aOriginal: {1}%0d%0a%0d%0aAutomatic translation powered by Microsoft&reg; Translator%0d%0ahttp://www.bing.com/translator?ref=MSTWidget\\\" /> <input id=\\\"ShareHelpText\\\" type=\\\"hidden\\\" value=\\\"This link allows visitors to launch this page and automatically translate it to {0}.\\\" /></div>\r\n<div id=\\\"FloaterEmbed\\\" style=\\\"display: none;\\\">\r\n<div id=\\\"EmbedTextDiv\\\"><span id=\\\"EmbedTextSpan\\\">EMBED THE SNIPPET BELOW IN YOUR SITE</span> <a id=\\\"EmbedHelpLink\\\" title=\\\"Copy this code and place it into your HTML.\\\"></a> <img id=\\\"EmbedHelpImg\\\" alt=\\\"\\\" /></div>\r\n<div id=\\\"EmbedTextboxDiv\\\"><input id=\\\"EmbedSnippetTextBox\\\" name=\\\"EmbedSnippetTextBox\\\" readonly=\\\"readonly\\\" type=\\\"text\\\" value=\\\"&lt;div id=\\\'MicrosoftTranslatorWidget\\\' class=\\\'Dark\\\' style=\\\'color:white;background-color:#555555\\\'&gt;&lt;/div&gt;&lt;script type=\\\'text/javascript\\\'&gt;setTimeout(function(){var s=document.createElement(\\\'script\\\');s.type=\\\'text/javascript\\\';s.charset=\\\'UTF-8\\\';s.src=((location &amp;&amp; location.href &amp;&amp; location.href.indexOf(\\\'https\\\') == 0)?\\\'https://ssl.microsofttranslator.com\\\':\\\'http://www.microsofttranslator.com\\\')+\\\'/ajax/v3/WidgetV3.ashx?siteData=ueOIGRSKkd965FeEGM5JtQ**&amp;ctf=true&amp;ui=true&amp;settings=manual&amp;from=en\\\';var p=document.getElementsByTagName(\\\'head\\\')[0]||document.documentElement;p.insertBefore(s,p.firstChild); },0);&lt;/script&gt;\\\" /></div>\r\n<div id=\\\"EmbedNoticeDiv\\\"><span id=\\\"EmbedNoticeSpan\\\">Enable collaborative features and customize widget: <a href=\\\"http://www.bing.com/widget/translator\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Bing Webmaster Portal</a></span></div>\r\n<div id=\\\"EmbedFooterDiv\\\"><span id=\\\"EmbedBackSpan\\\"><a title=\\\"Back To Translation\\\">Back</a></span></div>\r\n</div>\r\n</div>', NULL, NULL, 'false', '1', 'Please update new app', 'https://play.google.com/store/apps/details?id=com.posts365.brandingapp', 'false');

-- --------------------------------------------------------

--
-- Table structure for table `settings_player`
--

CREATE TABLE `settings_player` (
  `id` int(11) NOT NULL,
  `player_style` varchar(255) DEFAULT NULL,
  `player_vector_icons` varchar(255) NOT NULL DEFAULT 'no',
  `player_watermark` varchar(255) DEFAULT NULL,
  `player_logo` varchar(255) DEFAULT NULL,
  `player_logo_position` varchar(255) DEFAULT NULL,
  `player_url` varchar(255) DEFAULT NULL,
  `autoplay` varchar(255) NOT NULL DEFAULT 'false',
  `pip_mode` varchar(255) NOT NULL DEFAULT 'ON',
  `rewind_forward` varchar(255) NOT NULL DEFAULT 'ON',
  `player_ad_on_off` varchar(255) NOT NULL DEFAULT 'OFF',
  `player_default_ads` varchar(255) NOT NULL DEFAULT 'Custom',
  `vast_type` varchar(255) NOT NULL DEFAULT 'Local',
  `vast_url` varchar(500) DEFAULT NULL,
  `custom_ad1_source` varchar(255) DEFAULT NULL,
  `custom_ad1_timestart` varchar(255) DEFAULT NULL,
  `custom_ad1_link` varchar(255) DEFAULT NULL,
  `custom_ad2_source` varchar(255) DEFAULT NULL,
  `custom_ad2_timestart` varchar(255) DEFAULT NULL,
  `custom_ad2_link` varchar(255) DEFAULT NULL,
  `custom_ad3_source` varchar(255) DEFAULT NULL,
  `custom_ad3_timestart` varchar(255) DEFAULT NULL,
  `custom_ad3_link` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `settings_player`
--

INSERT INTO `settings_player` (`id`, `player_style`, `player_vector_icons`, `player_watermark`, `player_logo`, `player_logo_position`, `player_url`, `autoplay`, `pip_mode`, `rewind_forward`, `player_ad_on_off`, `player_default_ads`, `vast_type`, `vast_url`, `custom_ad1_source`, `custom_ad1_timestart`, `custom_ad1_link`, `custom_ad2_source`, `custom_ad2_timestart`, `custom_ad2_link`, `custom_ad3_source`, `custom_ad3_timestart`, `custom_ad3_link`) VALUES
(1, 'classic_skin_dark', 'no', 'yes', 'upload/site_logo.png', 'topRight', '#', 'no', 'ON', 'yes', 'OFF', 'None', 'URL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `slider`
--

CREATE TABLE `slider` (
  `id` int(11) NOT NULL,
  `slider_title` varchar(500) NOT NULL,
  `slider_image` varchar(255) NOT NULL,
  `slider_type` varchar(255) DEFAULT NULL,
  `slider_post_id` int(11) DEFAULT NULL,
  `slider_display_on` varchar(255) NOT NULL DEFAULT 'Home',
  `slider_url` text DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `slider`
--

INSERT INTO `slider` (`id`, `slider_title`, `slider_image`, `slider_type`, `slider_post_id`, `slider_display_on`, `slider_url`, `status`) VALUES
(2, 'Tiger 3', 'upload/tiger_3.jpg', 'Movies', 13, 'Home,Movies', NULL, 1),
(4, 'Mission: Impossible - Dead Reckoning Part One', 'upload/HCS-82.jpg', 'Movies', 6, 'Home,Movies', NULL, 1),
(5, 'Fast X (2023)', 'upload/d1e1283aa8027a49030c06d76cda954c.jpg', 'Movies', 37, 'Home,Movies', NULL, 1),
(6, 'Killers of the flower moon', 'upload/et00365290-qxcdybdnfg-landscape.jpg', 'Movies', 2, 'Home,Movies', NULL, 1),
(7, 'Salaar', 'upload/et00301886-vpwtttdmdt-landscape.png', 'Movies', 20, 'Home,Movies', NULL, 1),
(8, 'Breaking Bad', 'upload/p8696131_b_h10_aa.jpg', 'Shows', 18, 'Home,Shows', NULL, 1),
(9, 'ICC T20 World Cup 2024', 'upload/ICC-Reveals-New-Logo-For-The-T20-World-Cup-2024.png', 'Sports', 1, 'Sports,LiveTV', NULL, 1),
(12, 'Stranger Things', 'upload/stranger-things-netflix.jpg', 'Shows', 6, 'Home,Shows', NULL, 1),
(13, 'Jawan', 'upload/Jawan.jpg', 'Movies', 10, 'Home,Movies', NULL, 1),
(14, 'Star Sports 1', 'upload/Star-Sports-1.jpg', 'LiveTV', 12, 'Sports,LiveTV', NULL, 1),
(15, 'Colors TV', 'upload/Colors_TV.jpg', 'LiveTV', 10, 'LiveTV', NULL, 1),
(16, 'Sony Six', 'upload/Sony_Entertainment_Television.jpg', 'LiveTV', 6, 'LiveTV', NULL, 1),
(17, 'Aspirants', 'upload/4524df59b8e408fc35106fce1ddbc496fad69e47ac2f5110d4d61508c753c29e.jpg', 'Shows', 3, 'Shows', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sports_category`
--

CREATE TABLE `sports_category` (
  `id` int(11) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `category_slug` varchar(255) NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `sports_category`
--

INSERT INTO `sports_category` (`id`, `category_name`, `category_slug`, `status`) VALUES
(2, 'Archery', 'archery', 1),
(4, 'Badminton', 'badminton', 1),
(5, 'Car Racing', 'car-racing', 1),
(6, 'Cricket', 'cricket', 1),
(7, 'Football', 'football', 1),
(8, 'Hokey', 'hokey', 1),
(9, 'Khelo India', 'khelo-india', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sports_videos`
--

CREATE TABLE `sports_videos` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `video_access` varchar(255) NOT NULL DEFAULT 'Paid',
  `sports_cat_id` int(11) NOT NULL,
  `video_title` text NOT NULL,
  `date` int(11) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `video_description` text DEFAULT NULL,
  `video_slug` varchar(200) DEFAULT NULL,
  `video_image` varchar(200) DEFAULT NULL,
  `video_type` varchar(255) DEFAULT NULL,
  `video_quality` int(1) DEFAULT NULL,
  `video_url` longtext DEFAULT NULL,
  `video_url_480` longtext DEFAULT NULL,
  `video_url_720` longtext DEFAULT NULL,
  `video_url_1080` longtext DEFAULT NULL,
  `download_enable` int(1) DEFAULT NULL,
  `download_url` varchar(500) DEFAULT NULL,
  `subtitle_on_off` int(1) DEFAULT NULL,
  `subtitle_language1` varchar(255) DEFAULT NULL,
  `subtitle_url1` varchar(500) DEFAULT NULL,
  `subtitle_language2` varchar(255) DEFAULT NULL,
  `subtitle_url2` varchar(255) DEFAULT NULL,
  `subtitle_language3` varchar(255) DEFAULT NULL,
  `subtitle_url3` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_description` varchar(500) DEFAULT NULL,
  `seo_keyword` varchar(500) DEFAULT NULL,
  `views` bigint(20) NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `sports_videos`
--

INSERT INTO `sports_videos` (`id`, `video_access`, `sports_cat_id`, `video_title`, `date`, `duration`, `video_description`, `video_slug`, `video_image`, `video_type`, `video_quality`, `video_url`, `video_url_480`, `video_url_720`, `video_url_1080`, `download_enable`, `download_url`, `subtitle_on_off`, `subtitle_language1`, `subtitle_url1`, `subtitle_language2`, `subtitle_url2`, `subtitle_language3`, `subtitle_url3`, `seo_title`, `seo_description`, `seo_keyword`, `views`, `status`, `created_at`, `updated_at`) VALUES
(1, 'Free', 1, 'ICC t20 Worldcup 2024', 1705968000, '159 min', '<p>ICC t20 Worldcup 2024</p>', 'icc-t20-worldcup-2024', 'upload/t20_WC.jpg', 'Embed', 0, '<iframe width=\"auto\" height=\"auto\" src=\"https://www.youtube.com/embed/quNPe1l2GxM?si=9ZO-LHdxDuQv-UrP\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 8, 1, NULL, '2024-01-24 15:49:03'),
(2, 'Paid', 9, 'Champions Atletico Celebrate in Style', 0, NULL, '<div class=\\\"description\\\">Atletico de Kolkata are crowned the first Hero Indian Super League (ISL) champions. It\\\'s been a long journey, a tiring one, but happiness at the end of it all was clear on the faces of the Kolkata players. They set the ball rolling on October 12 at the Salt Lake Stadium, and finished with a bang in Mumbai on December 20!</div>', 'champions-atletico-celebrate-in-style', 'upload/images/LaLiga-Champions-2021.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(3, 'Paid', 9, 'Jai Ho! A Tokyo Games Special', 1592265600, NULL, '<div class=\\\"description\\\">Catch a special series featuring India\\\'s medal winners at the Tokyo Games 2020, where the Indian contingent picked up a record 7 medals</div>', 'jai-ho-a-tokyo-games-special', 'upload/images/catch_special_series_medals.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(4, 'Free', 9, 'Highlights: Athletics, Day 7', 1581379200, NULL, '<div class=\\\"description\\\">Watch Athletics highlights from Day 7 of Khelo India University Games 2022</div>', 'highlights-athletics-day-7', 'upload/images/Watch_Athletics_Highlights_Khelo_India.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, '2024-01-23 16:47:41'),
(5, 'Paid', 2, 'Japan hammer Dominican Republic 3-0', 1613520000, NULL, '<div class=\\\"description\\\">Japan made easy work of Dominican Republic by winning in three straight sets in the Women\\\'s Volleyball Qualifiers</div>', 'japan-hammer-dominican-republic-3-0', 'upload/images/Volleyball_Olympic_Qualifiers.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(6, 'Paid', 8, '1st Leg: India 4-2 Russia', 1655337600, NULL, '<div class=\\\"description\\\">India romped to a 4-2 win over Russia in Men\\\'s FIH Olympic Qualifiers 2019</div>', '1st-leg-india-4-2-russia', 'upload/images/Russia_Men_FIH_Olympic.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(7, 'Paid', 8, 'Replay: China vs Belgium, 2nd Leg', 1658188800, NULL, '<p>Watch replay of the second leg of the Women\\\'s FIH Olympic Qualifiers match between China and Belgium</p>', 'replay-china-vs-belgium-2nd-leg', 'upload/images/Replay_China_vs_Belgium.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(8, 'Free', 9, 'Warriors 41-41 Yoddhas', 1590364800, NULL, '<p>Bengal Warriors staged a stunning comeback to share the spoils with U.P. Yoddhas in vivo Pro Kabaddi 2022</p>', 'warriors-41-41-yoddhas', 'upload/images/Warriors-41-41-Yoddhas.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, '2024-01-23 16:47:44'),
(9, 'Paid', 4, 'Thalaivas 39-31 Titans', 1592265600, NULL, '<p>Tamil Thalaivas flipped the script on bottom-placed Telugu Titans in a closely-fought Southern Derby in vivo Pro Kabaddi 2022</p>', 'thalaivas-39-31-titans', 'upload/images/Pro_Kabaddi.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(10, 'Paid', 6, 'Ind Thrash Zim, Top Group to Make SF', 1615248000, NULL, '<p>Suryakumar Yadav\\\'s rapid 61* helped India crush Zimbabwe by 71 runs and set up a semi-final clash against England in ICC Men\\\'s T20 World Cup 2022</p>', 'ind-thrash-zim-top-group-to-make-sf', 'upload/images/Ind_Thrash_Zim.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(11, 'Free', 6, 'SL Shatter Afghan\\\'s SF Hopes', 1612915200, NULL, '<p>Sri Lanka knocked out Afghanistan with a six-wicket win and stayed in the hunt for a ICC Men\\\'s T20 World Cup 2022 semi-final spot</p>', 'sl-shatter-afghans-sf-hopes', 'upload/images/SL_Afghan\'s_SF.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, '2024-01-23 16:47:46'),
(12, 'Free', 6, 'Ind vs Eng: All You Need to Know', 1577923200, NULL, '<p>India take on England in the semi-finals of ICC Men\\\'s T20 World Cup 2022 and here\\\'s everything you need to know</p>', 'ind-vs-eng-all-you-need-to-know', 'upload/images/INDIA-vs-ENGLAND.jpg', 'Local', 0, 'upload/files/CONSTANTINE_2.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, '2024-01-23 16:47:48'),
(13, 'Paid', 6, 'India, England Lock Horns in WC Semis', 1580774400, NULL, '<p>India will face a determined England on November 10th at 1:30 PM IST for a spot in the final of the ICC Men\\\'s T20 World Cup 2022</p>', 'india-england-lock-horns-in-wc-semis', 'upload/images/India_England_Lock_Horns.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(14, 'Paid', 2, 'Delhi Half Marathon', 1612828800, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'delhi-half-marathon', 'upload/images/Delhi_Half_Marathon.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(15, 'Paid', 9, 'Highlights: Wrestling, Day 9', 1634601600, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'highlights-wrestling-day-9', 'upload/images/PTI07_31_2022_000281B_0_1200x768.jpg', 'URL', 0, 'http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(16, 'Paid', 8, 'Sentetik Çim Hokey Sahası Nedir', 1658275200, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'sentetik-çim-hokey-sahası-nedir', 'upload/images/sentetik-cim-hokey-sahasi-nedir.jpg', 'URL', 0, 'http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(17, 'Paid', 5, 'Lamborghini Race Cars Ultimte Guide & Full List', 1628035200, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'lamborghini-race-cars-ultimte-guide-full-list', 'upload/images/Lamborghini-Race-Cars.jpg', 'URL', 0, 'http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(18, 'Free', 2, 'Archery Olympic Team', 1676332800, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'archery-olympic-team', 'upload/images/Team-Canada-Steaphanie.jpg', 'URL', 0, 'http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 1, 1, NULL, '2024-01-23 17:35:02'),
(19, 'Paid', 4, 'Badminton Junior World Highlights', 1626220800, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'badminton-junior-world-highlights', 'upload/images/Badminton.jpg', 'URL', 0, 'http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ForBiggerEscapes.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, NULL),
(20, 'Free', 7, 'East Bengal FC 0-1 Chennaiyin FC', 1626825600, NULL, '<p>Smriti Mandhana\\\'s 91 and contrasting half-centuries from Yastika Bhatia (50) and skipper Harmanpreet Kaur (74 not out) put India 1-0 ahead in the three-match ODI series against hosts England in Hove. Having opted to field first, a disciplined bowling effort from India saw England being restricted to 227/7. Mandhana then put on two 90-plus partnerships to help India to a comfortable seven wicket victory, and thereby two ICC Women\\\'s ODI Championship points.</p>', 'east-bengal-fc-0-1-chennaiyin-fc', 'upload/images/East_Bengal_FC.jpg', 'Local', 0, 'upload/files/pexels-nothing-ahead.mp4', NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', 0, 1, NULL, '2024-01-23 16:47:52');

-- --------------------------------------------------------

--
-- Table structure for table `subscription_plan`
--

CREATE TABLE `subscription_plan` (
  `id` int(11) NOT NULL,
  `plan_name` varchar(255) NOT NULL,
  `plan_days` int(11) NOT NULL,
  `plan_duration` varchar(255) NOT NULL,
  `plan_duration_type` varchar(255) NOT NULL,
  `plan_price` decimal(11,2) NOT NULL,
  `plan_device_limit` int(3) NOT NULL DEFAULT 1,
  `ads_on_off` int(1) NOT NULL DEFAULT 0,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `subscription_plan`
--

INSERT INTO `subscription_plan` (`id`, `plan_name`, `plan_days`, `plan_duration`, `plan_duration_type`, `plan_price`, `plan_device_limit`, `ads_on_off`, `status`) VALUES
(1, 'Basic Plan', 7, '7', '1', 10.00, 1, 1, 1),
(2, 'Premium Plan', 30, '1', '30', 29.99, 1, 1, 1),
(3, 'Platinum Plan', 180, '6', '30', 99.00, 1, 0, 1),
(4, 'Diamond Plan', 365, '1', '365', 149.00, 2, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `transaction`
--

CREATE TABLE `transaction` (
  `id` bigint(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `plan_id` int(11) DEFAULT NULL,
  `gateway` varchar(255) NOT NULL,
  `payment_amount` varchar(255) NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `coupon_code` varchar(255) DEFAULT NULL,
  `coupon_percentage` int(255) DEFAULT NULL,
  `date` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `usertype` varchar(255) DEFAULT 'User',
  `login_status` int(1) NOT NULL DEFAULT 0,
  `google_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `user_address` varchar(500) DEFAULT NULL,
  `user_image` varchar(255) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `plan_id` int(11) DEFAULT 0,
  `start_date` int(11) DEFAULT NULL,
  `exp_date` int(11) DEFAULT NULL,
  `plan_amount` varchar(255) NOT NULL DEFAULT '0',
  `confirmation_code` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `session_id` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `usertype`, `login_status`, `google_id`, `facebook_id`, `name`, `email`, `password`, `phone`, `user_address`, `user_image`, `status`, `plan_id`, `start_date`, `exp_date`, `plan_amount`, `confirmation_code`, `remember_token`, `session_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'Admin', 0, NULL, NULL, 'Viavi Webtech', 'admin@admin.com', '$2y$10$EMeDkbAwIXJd7fAX0pWF2OZCHmKuGMwtD3ZUjg9HEOMvkaVl.5Xvm', '9227777522', NULL, 'viavi-webtech-1f2416ecff3faba4159de6b399477081-b.jpg', 1, 2, 0, 2592000, '0.00', NULL, 'NXnnNMpnFxvrOa6UixEdGr4kNNJi6yukriCYHJM1qwrSmqB0oaTJCxEchzT1', 'iXL5Efee1FhfiXQzxPTe2PzEfFqU3seM3b6TzvU7', '2020-03-11 06:16:45', '2024-01-24 17:54:49', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `users_device_history`
--

CREATE TABLE `users_device_history` (
  `id` bigint(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_device_name` varchar(255) NOT NULL,
  `user_session_name` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `watchlist`
--

CREATE TABLE `watchlist` (
  `id` bigint(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `post_type` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `web_banner_ads`
--

CREATE TABLE `web_banner_ads` (
  `id` int(11) NOT NULL,
  `home_top` text DEFAULT NULL,
  `home_bottom` text DEFAULT NULL,
  `list_top` text DEFAULT NULL,
  `list_bottom` text DEFAULT NULL,
  `details_top` text DEFAULT NULL,
  `details_bottom` text DEFAULT NULL,
  `other_page_top` text DEFAULT NULL,
  `other_page_bottom` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Dumping data for table `web_banner_ads`
--

INSERT INTO `web_banner_ads` (`id`, `home_top`, `home_bottom`, `list_top`, `list_bottom`, `details_top`, `details_bottom`, `other_page_top`, `other_page_bottom`) VALUES
(1, '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>', '<a href=\\\"https://1.envato.market/JakrN\\\" target=\\\"_blank\\\"><img src=\\\"https://placehold.co/728x90/F45D4F/FFF/?text=ad+image\\\" alt=\\\"banner_ads\\\" title=\\\"Banner Ads\\\"></a>');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `actor_director`
--
ALTER TABLE `actor_director`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_ads`
--
ALTER TABLE `app_ads`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `channels_list`
--
ALTER TABLE `channels_list`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `channel_category`
--
ALTER TABLE `channel_category`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `coupons`
--
ALTER TABLE `coupons`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `episodes`
--
ALTER TABLE `episodes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type_status_date` (`id`);

--
-- Indexes for table `genres`
--
ALTER TABLE `genres`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `home_sections`
--
ALTER TABLE `home_sections`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `language`
--
ALTER TABLE `language`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `movie_videos`
--
ALTER TABLE `movie_videos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type_status_date` (`id`);

--
-- Indexes for table `pages`
--
ALTER TABLE `pages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `password_resets_email_index` (`email`),
  ADD KEY `password_resets_token_index` (`token`);

--
-- Indexes for table `payment_gateway`
--
ALTER TABLE `payment_gateway`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `payu_transactions`
--
ALTER TABLE `payu_transactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `payu_transactions_transaction_id_unique` (`transaction_id`),
  ADD KEY `payu_transactions_status_index` (`status`),
  ADD KEY `payu_transactions_verified_at_index` (`verified_at`);

--
-- Indexes for table `recently_watched`
--
ALTER TABLE `recently_watched`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `season`
--
ALTER TABLE `season`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `series`
--
ALTER TABLE `series`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `settings_android_app`
--
ALTER TABLE `settings_android_app`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `settings_player`
--
ALTER TABLE `settings_player`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `slider`
--
ALTER TABLE `slider`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sports_category`
--
ALTER TABLE `sports_category`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `sports_videos`
--
ALTER TABLE `sports_videos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type_status_date` (`id`);

--
-- Indexes for table `subscription_plan`
--
ALTER TABLE `subscription_plan`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `transaction`
--
ALTER TABLE `transaction`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `users_device_history`
--
ALTER TABLE `users_device_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `userid` (`user_id`);

--
-- Indexes for table `watchlist`
--
ALTER TABLE `watchlist`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `web_banner_ads`
--
ALTER TABLE `web_banner_ads`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `actor_director`
--
ALTER TABLE `actor_director`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=869;

--
-- AUTO_INCREMENT for table `app_ads`
--
ALTER TABLE `app_ads`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `channels_list`
--
ALTER TABLE `channels_list`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `channel_category`
--
ALTER TABLE `channel_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `coupons`
--
ALTER TABLE `coupons`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `episodes`
--
ALTER TABLE `episodes`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=33;

--
-- AUTO_INCREMENT for table `genres`
--
ALTER TABLE `genres`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `home_sections`
--
ALTER TABLE `home_sections`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `language`
--
ALTER TABLE `language`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `movie_videos`
--
ALTER TABLE `movie_videos`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=38;

--
-- AUTO_INCREMENT for table `pages`
--
ALTER TABLE `pages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `password_resets`
--
ALTER TABLE `password_resets`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_gateway`
--
ALTER TABLE `payment_gateway`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `payu_transactions`
--
ALTER TABLE `payu_transactions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `recently_watched`
--
ALTER TABLE `recently_watched`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `season`
--
ALTER TABLE `season`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=53;

--
-- AUTO_INCREMENT for table `series`
--
ALTER TABLE `series`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=22;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `settings_android_app`
--
ALTER TABLE `settings_android_app`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `settings_player`
--
ALTER TABLE `settings_player`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `slider`
--
ALTER TABLE `slider`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT for table `sports_category`
--
ALTER TABLE `sports_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `sports_videos`
--
ALTER TABLE `sports_videos`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;

--
-- AUTO_INCREMENT for table `subscription_plan`
--
ALTER TABLE `subscription_plan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `transaction`
--
ALTER TABLE `transaction`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `users_device_history`
--
ALTER TABLE `users_device_history`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `watchlist`
--
ALTER TABLE `watchlist`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `web_banner_ads`
--
ALTER TABLE `web_banner_ads`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
 